/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.server;

import java.io.File;
import java.io.IOException;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import javax.ws.rs.core.Application;
import org.apache.cxf.jaxrs.servlet.CXFNonSpringJaxrsServlet;
import org.apache.shiro.web.env.EnvironmentLoaderListener;
import org.apache.shiro.web.servlet.ShiroFilter;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.dep.DependencyResolver;
import org.apache.zeppelin.display.AngularObjectRegistryListener;
import org.apache.zeppelin.interpreter.InterpreterFactory;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterProcessListener;
import org.apache.zeppelin.notebook.JobListenerFactory;
import org.apache.zeppelin.notebook.Notebook;
import org.apache.zeppelin.notebook.NotebookAuthorization;
import org.apache.zeppelin.notebook.repo.NotebookRepo;
import org.apache.zeppelin.notebook.repo.NotebookRepoSync;
import org.apache.zeppelin.rest.ConfigurationsRestApi;
import org.apache.zeppelin.rest.CredentialRestApi;
import org.apache.zeppelin.rest.InterpreterRestApi;
import org.apache.zeppelin.rest.LoginRestApi;
import org.apache.zeppelin.rest.NotebookRestApi;
import org.apache.zeppelin.rest.SecurityRestApi;
import org.apache.zeppelin.rest.ZeppelinRestApi;
import org.apache.zeppelin.scheduler.SchedulerFactory;
import org.apache.zeppelin.search.LuceneSearch;
import org.apache.zeppelin.search.SearchService;
import org.apache.zeppelin.server.CorsFilter;
import org.apache.zeppelin.socket.NotebookServer;
import org.apache.zeppelin.user.Credentials;
import org.apache.zeppelin.utils.SecurityUtils;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.webapp.WebAppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZeppelinServer
extends Application {
    private static final Logger LOG = LoggerFactory.getLogger(ZeppelinServer.class);
    public static Notebook notebook;
    public static Server jettyWebServer;
    public static NotebookServer notebookWsServer;
    private SchedulerFactory schedulerFactory;
    private InterpreterFactory replFactory;
    private NotebookRepo notebookRepo;
    private SearchService notebookIndex;
    private NotebookAuthorization notebookAuthorization;
    private Credentials credentials;
    private DependencyResolver depResolver;

    public ZeppelinServer() throws Exception {
        ZeppelinConfiguration conf = ZeppelinConfiguration.create();
        this.depResolver = new DependencyResolver(conf.getString(ZeppelinConfiguration.ConfVars.ZEPPELIN_INTERPRETER_LOCALREPO));
        this.schedulerFactory = new SchedulerFactory();
        this.replFactory = new InterpreterFactory(conf, (AngularObjectRegistryListener)notebookWsServer, (RemoteInterpreterProcessListener)notebookWsServer, this.depResolver);
        this.notebookRepo = new NotebookRepoSync(conf);
        this.notebookIndex = new LuceneSearch();
        this.notebookAuthorization = new NotebookAuthorization(conf);
        this.credentials = new Credentials(conf.credentialsPersist(), conf.getCredentialsPath());
        notebook = new Notebook(conf, this.notebookRepo, this.schedulerFactory, this.replFactory, (JobListenerFactory)notebookWsServer, this.notebookIndex, this.notebookAuthorization, this.credentials);
    }

    public static void main(String[] args) throws InterruptedException {
        ZeppelinConfiguration conf = ZeppelinConfiguration.create();
        conf.setProperty("args", (Object)args);
        jettyWebServer = ZeppelinServer.setupJettyServer(conf);
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        jettyWebServer.setHandler((Handler)contexts);
        WebAppContext webApp = ZeppelinServer.setupWebAppContext(contexts, conf);
        ZeppelinServer.setupRestApiContextHandler(webApp, conf);
        ZeppelinServer.setupNotebookServer(webApp, conf);
        LOG.info("Starting zeppelin server");
        try {
            jettyWebServer.start();
        }
        catch (Exception e) {
            LOG.error("Error while running jettyServer", (Throwable)e);
            System.exit(-1);
        }
        LOG.info("Done, zeppelin server started");
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                LOG.info("Shutting down Zeppelin Server ... ");
                try {
                    jettyWebServer.stop();
                    notebook.getInterpreterFactory().close();
                    notebook.close();
                }
                catch (Exception e) {
                    LOG.error("Error while stopping servlet container", (Throwable)e);
                }
                LOG.info("Bye");
            }
        });
        if (System.getenv("ZEPPELIN_IDENT_STRING") == null) {
            try {
                System.in.read();
            }
            catch (IOException e) {
                LOG.error("Exception in ZeppelinServer while main ", (Throwable)e);
            }
            System.exit(0);
        }
        jettyWebServer.join();
        notebook.getInterpreterFactory().close();
    }

    private static Server setupJettyServer(ZeppelinConfiguration conf) {
        ServerConnector connector;
        Server server = new Server();
        if (conf.useSsl()) {
            HttpConfiguration httpConfig = new HttpConfiguration();
            httpConfig.setSecureScheme("https");
            httpConfig.setSecurePort(conf.getServerPort());
            httpConfig.setOutputBufferSize(32768);
            HttpConfiguration httpsConfig = new HttpConfiguration(httpConfig);
            SecureRequestCustomizer src = new SecureRequestCustomizer();
            httpsConfig.addCustomizer((HttpConfiguration.Customizer)src);
            connector = new ServerConnector(server, new ConnectionFactory[]{new SslConnectionFactory(ZeppelinServer.getSslContextFactory(conf), HttpVersion.HTTP_1_1.asString()), new HttpConnectionFactory(httpsConfig)});
        } else {
            connector = new ServerConnector(server);
        }
        int timeout = 30000;
        connector.setIdleTimeout((long)timeout);
        connector.setSoLingerTime(-1);
        connector.setHost(conf.getServerAddress());
        connector.setPort(conf.getServerPort());
        server.addConnector((Connector)connector);
        return server;
    }

    private static void setupNotebookServer(WebAppContext webapp, ZeppelinConfiguration conf) {
        notebookWsServer = new NotebookServer();
        String maxTextMessageSize = conf.getWebsocketMaxTextMessageSize();
        ServletHolder servletHolder = new ServletHolder((Servlet)notebookWsServer);
        servletHolder.setInitParameter("maxTextMessageSize", maxTextMessageSize);
        ServletContextHandler cxfContext = new ServletContextHandler(1);
        webapp.addServlet(servletHolder, "/ws/*");
    }

    private static SslContextFactory getSslContextFactory(ZeppelinConfiguration conf) {
        SslContextFactory sslContextFactory = new SslContextFactory();
        sslContextFactory.setKeyStorePath(conf.getKeyStorePath());
        sslContextFactory.setKeyStoreType(conf.getKeyStoreType());
        sslContextFactory.setKeyStorePassword(conf.getKeyStorePassword());
        sslContextFactory.setKeyManagerPassword(conf.getKeyManagerPassword());
        sslContextFactory.setTrustStorePath(conf.getTrustStorePath());
        sslContextFactory.setTrustStoreType(conf.getTrustStoreType());
        sslContextFactory.setTrustStorePassword(conf.getTrustStorePassword());
        sslContextFactory.setNeedClientAuth(conf.useClientAuth());
        return sslContextFactory;
    }

    private static void setupRestApiContextHandler(WebAppContext webapp, ZeppelinConfiguration conf) {
        ServletHolder cxfServletHolder = new ServletHolder((Servlet)new CXFNonSpringJaxrsServlet());
        cxfServletHolder.setInitParameter("javax.ws.rs.Application", ZeppelinServer.class.getName());
        cxfServletHolder.setName("rest");
        cxfServletHolder.setForcedPath("rest");
        webapp.setSessionHandler(new SessionHandler());
        webapp.addServlet(cxfServletHolder, "/api/*");
        webapp.setInitParameter("shiroConfigLocations", new File(conf.getShiroPath()).toURI().toString());
        SecurityUtils.initSecurityManager(conf.getShiroPath());
        webapp.addFilter(ShiroFilter.class, "/api/*", EnumSet.allOf(DispatcherType.class));
        webapp.addEventListener((EventListener)new EnvironmentLoaderListener());
    }

    private static WebAppContext setupWebAppContext(ContextHandlerCollection contexts, ZeppelinConfiguration conf) {
        WebAppContext webApp = new WebAppContext();
        webApp.setContextPath(conf.getServerContextPath());
        File warPath = new File(conf.getString(ZeppelinConfiguration.ConfVars.ZEPPELIN_WAR));
        if (warPath.isDirectory()) {
            webApp.setResourceBase(warPath.getPath());
            webApp.setParentLoaderPriority(true);
        } else {
            webApp.setWar(warPath.getAbsolutePath());
            File warTempDirectory = new File(conf.getRelativeDir(ZeppelinConfiguration.ConfVars.ZEPPELIN_WAR_TEMPDIR));
            warTempDirectory.mkdir();
            LOG.info("ZeppelinServer Webapp path: {}", (Object)warTempDirectory.getPath());
            webApp.setTempDirectory(warTempDirectory);
        }
        webApp.addServlet(new ServletHolder((Servlet)new DefaultServlet()), "/*");
        contexts.addHandler((Handler)webApp);
        webApp.addFilter(new FilterHolder(CorsFilter.class), "/*", EnumSet.allOf(DispatcherType.class));
        return webApp;
    }

    public Set<Class<?>> getClasses() {
        HashSet classes = new HashSet();
        return classes;
    }

    public Set<Object> getSingletons() {
        HashSet<Object> singletons = new HashSet<Object>();
        ZeppelinRestApi root = new ZeppelinRestApi();
        singletons.add(root);
        NotebookRestApi notebookApi = new NotebookRestApi(notebook, notebookWsServer, this.notebookIndex);
        singletons.add(notebookApi);
        InterpreterRestApi interpreterApi = new InterpreterRestApi(this.replFactory);
        singletons.add(interpreterApi);
        CredentialRestApi credentialApi = new CredentialRestApi(this.credentials);
        singletons.add(credentialApi);
        SecurityRestApi securityApi = new SecurityRestApi();
        singletons.add(securityApi);
        LoginRestApi loginRestApi = new LoginRestApi();
        singletons.add(loginRestApi);
        ConfigurationsRestApi settingsApi = new ConfigurationsRestApi(notebook);
        singletons.add(settingsApi);
        return singletons;
    }
}

