/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.socket;

import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.servlet.http.HttpServletRequest;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.display.AngularObject;
import org.apache.zeppelin.display.AngularObjectRegistry;
import org.apache.zeppelin.display.AngularObjectRegistryListener;
import org.apache.zeppelin.interpreter.InterpreterGroup;
import org.apache.zeppelin.interpreter.InterpreterOutput;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.InterpreterSetting;
import org.apache.zeppelin.interpreter.remote.RemoteAngularObjectRegistry;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterProcessListener;
import org.apache.zeppelin.notebook.JobListenerFactory;
import org.apache.zeppelin.notebook.Note;
import org.apache.zeppelin.notebook.Notebook;
import org.apache.zeppelin.notebook.NotebookAuthorization;
import org.apache.zeppelin.notebook.Paragraph;
import org.apache.zeppelin.notebook.ParagraphJobListener;
import org.apache.zeppelin.notebook.socket.Message;
import org.apache.zeppelin.scheduler.Job;
import org.apache.zeppelin.server.ZeppelinServer;
import org.apache.zeppelin.socket.NotebookSocket;
import org.apache.zeppelin.socket.NotebookSocketListener;
import org.apache.zeppelin.socket.NotebookWebSocketCreator;
import org.apache.zeppelin.ticket.TicketContainer;
import org.apache.zeppelin.user.AuthenticationInfo;
import org.apache.zeppelin.utils.SecurityUtils;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;
import org.eclipse.jetty.websocket.servlet.WebSocketServlet;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotebookServer
extends WebSocketServlet
implements NotebookSocketListener,
JobListenerFactory,
AngularObjectRegistryListener,
RemoteInterpreterProcessListener {
    private static final Logger LOG = LoggerFactory.getLogger(NotebookServer.class);
    Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").create();
    final Map<String, List<NotebookSocket>> noteSocketMap = new HashMap<String, List<NotebookSocket>>();
    final Queue<NotebookSocket> connectedSockets = new ConcurrentLinkedQueue<NotebookSocket>();

    private Notebook notebook() {
        return ZeppelinServer.notebook;
    }

    public void configure(WebSocketServletFactory factory) {
        factory.setCreator((WebSocketCreator)new NotebookWebSocketCreator(this));
    }

    public boolean checkOrigin(HttpServletRequest request, String origin) {
        try {
            return SecurityUtils.isValidOrigin(origin, ZeppelinConfiguration.create());
        }
        catch (UnknownHostException e) {
            LOG.error(e.toString(), (Throwable)e);
        }
        catch (URISyntaxException e) {
            LOG.error(e.toString(), (Throwable)e);
        }
        return false;
    }

    public NotebookSocket doWebSocketConnect(HttpServletRequest req, String protocol) {
        return new NotebookSocket(req, protocol, this);
    }

    @Override
    public void onOpen(NotebookSocket conn) {
        LOG.info("New connection from {} : {}", (Object)conn.getRequest().getRemoteAddr(), (Object)conn.getRequest().getRemotePort());
        this.connectedSockets.add(conn);
    }

    @Override
    public void onMessage(NotebookSocket conn, String msg) {
        Notebook notebook = this.notebook();
        try {
            HashSet roles;
            String ticket;
            Message messagereceived = this.deserializeMessage(msg);
            LOG.debug("RECEIVE << " + messagereceived.op);
            LOG.debug("RECEIVE PRINCIPAL << " + messagereceived.principal);
            LOG.debug("RECEIVE TICKET << " + messagereceived.ticket);
            LOG.debug("RECEIVE ROLES << " + messagereceived.roles);
            if (LOG.isTraceEnabled()) {
                LOG.trace("RECEIVE MSG = " + messagereceived);
            }
            if ((ticket = TicketContainer.instance.getTicket(messagereceived.principal)) != null && !ticket.equals(messagereceived.ticket)) {
                throw new Exception("Invalid ticket " + messagereceived.ticket + " != " + ticket);
            }
            ZeppelinConfiguration conf = ZeppelinConfiguration.create();
            boolean allowAnonymous = conf.getBoolean(ZeppelinConfiguration.ConfVars.ZEPPELIN_ANONYMOUS_ALLOWED);
            if (!allowAnonymous && messagereceived.principal.equals("anonymous")) {
                throw new Exception("Anonymous access not allowed ");
            }
            HashSet<String> userAndRoles = new HashSet<String>();
            userAndRoles.add(messagereceived.principal);
            if (!messagereceived.roles.equals("") && (roles = (HashSet)this.gson.fromJson(messagereceived.roles, new TypeToken<HashSet<String>>(){}.getType())) != null) {
                userAndRoles.addAll(roles);
            }
            AuthenticationInfo subject = new AuthenticationInfo(messagereceived.principal);
            switch (messagereceived.op) {
                case LIST_NOTES: {
                    this.unicastNoteList(conn, subject);
                    break;
                }
                case RELOAD_NOTES_FROM_REPO: {
                    this.broadcastReloadedNoteList(subject);
                    break;
                }
                case GET_HOME_NOTE: {
                    this.sendHomeNote(conn, userAndRoles, notebook, messagereceived);
                    break;
                }
                case GET_NOTE: {
                    this.sendNote(conn, userAndRoles, notebook, messagereceived);
                    break;
                }
                case NEW_NOTE: {
                    this.createNote(conn, userAndRoles, notebook, messagereceived);
                    break;
                }
                case DEL_NOTE: {
                    this.removeNote(conn, userAndRoles, notebook, messagereceived);
                    break;
                }
                case CLONE_NOTE: {
                    this.cloneNote(conn, userAndRoles, notebook, messagereceived);
                    break;
                }
                case IMPORT_NOTE: {
                    this.importNote(conn, userAndRoles, notebook, messagereceived);
                    break;
                }
                case COMMIT_PARAGRAPH: {
                    this.updateParagraph(conn, userAndRoles, notebook, messagereceived);
                    break;
                }
                case RUN_PARAGRAPH: {
                    this.runParagraph(conn, userAndRoles, notebook, messagereceived);
                    break;
                }
                case CANCEL_PARAGRAPH: {
                    this.cancelParagraph(conn, userAndRoles, notebook, messagereceived);
                    break;
                }
                case MOVE_PARAGRAPH: {
                    this.moveParagraph(conn, userAndRoles, notebook, messagereceived);
                    break;
                }
                case INSERT_PARAGRAPH: {
                    this.insertParagraph(conn, userAndRoles, notebook, messagereceived);
                    break;
                }
                case PARAGRAPH_REMOVE: {
                    this.removeParagraph(conn, userAndRoles, notebook, messagereceived);
                    break;
                }
                case PARAGRAPH_CLEAR_OUTPUT: {
                    this.clearParagraphOutput(conn, userAndRoles, notebook, messagereceived);
                    break;
                }
                case NOTE_UPDATE: {
                    this.updateNote(conn, userAndRoles, notebook, messagereceived);
                    break;
                }
                case COMPLETION: {
                    this.completion(conn, userAndRoles, notebook, messagereceived);
                    break;
                }
                case PING: {
                    break;
                }
                case ANGULAR_OBJECT_UPDATED: {
                    this.angularObjectUpdated(conn, userAndRoles, notebook, messagereceived);
                    break;
                }
                case ANGULAR_OBJECT_CLIENT_BIND: {
                    this.angularObjectClientBind(conn, userAndRoles, notebook, messagereceived);
                    break;
                }
                case ANGULAR_OBJECT_CLIENT_UNBIND: {
                    this.angularObjectClientUnbind(conn, userAndRoles, notebook, messagereceived);
                    break;
                }
                case LIST_CONFIGURATIONS: {
                    this.sendAllConfigurations(conn, userAndRoles, notebook);
                    break;
                }
                case CHECKPOINT_NOTEBOOK: {
                    this.checkpointNotebook(conn, notebook, messagereceived);
                    break;
                }
            }
        }
        catch (Exception e) {
            LOG.error("Can't handle message", (Throwable)e);
        }
    }

    @Override
    public void onClose(NotebookSocket conn, int code, String reason) {
        LOG.info("Closed connection to {} : {}. ({}) {}", new Object[]{conn.getRequest().getRemoteAddr(), conn.getRequest().getRemotePort(), code, reason});
        this.removeConnectionFromAllNote(conn);
        this.connectedSockets.remove((Object)conn);
    }

    protected Message deserializeMessage(String msg) {
        return (Message)this.gson.fromJson(msg, Message.class);
    }

    protected String serializeMessage(Message m) {
        return this.gson.toJson((Object)m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addConnectionToNote(String noteId, NotebookSocket socket) {
        Map<String, List<NotebookSocket>> map = this.noteSocketMap;
        synchronized (map) {
            this.removeConnectionFromAllNote(socket);
            List<NotebookSocket> socketList = this.noteSocketMap.get(noteId);
            if (socketList == null) {
                socketList = new LinkedList<NotebookSocket>();
                this.noteSocketMap.put(noteId, socketList);
            }
            if (!socketList.contains((Object)socket)) {
                socketList.add(socket);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeConnectionFromNote(String noteId, NotebookSocket socket) {
        Map<String, List<NotebookSocket>> map = this.noteSocketMap;
        synchronized (map) {
            List<NotebookSocket> socketList = this.noteSocketMap.get(noteId);
            if (socketList != null) {
                socketList.remove((Object)socket);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeNote(String noteId) {
        Map<String, List<NotebookSocket>> map = this.noteSocketMap;
        synchronized (map) {
            List<NotebookSocket> list = this.noteSocketMap.remove(noteId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeConnectionFromAllNote(NotebookSocket socket) {
        Map<String, List<NotebookSocket>> map = this.noteSocketMap;
        synchronized (map) {
            Set<String> keys = this.noteSocketMap.keySet();
            for (String noteId : keys) {
                this.removeConnectionFromNote(noteId, socket);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getOpenNoteId(NotebookSocket socket) {
        String id = null;
        Map<String, List<NotebookSocket>> map = this.noteSocketMap;
        synchronized (map) {
            Set<String> keys = this.noteSocketMap.keySet();
            for (String noteId : keys) {
                List<NotebookSocket> sockets = this.noteSocketMap.get(noteId);
                if (!sockets.contains((Object)socket)) continue;
                id = noteId;
            }
        }
        return id;
    }

    private void broadcastToNoteBindedInterpreter(String interpreterGroupId, Message m) {
        Notebook notebook = this.notebook();
        List notes = notebook.getAllNotes();
        for (Note note : notes) {
            List ids = note.getNoteReplLoader().getInterpreters();
            for (String id : ids) {
                if (!id.equals(interpreterGroupId)) continue;
                this.broadcast(note.id(), m);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcast(String noteId, Message m) {
        Map<String, List<NotebookSocket>> map = this.noteSocketMap;
        synchronized (map) {
            List<NotebookSocket> socketLists = this.noteSocketMap.get(noteId);
            if (socketLists == null || socketLists.size() == 0) {
                return;
            }
            LOG.debug("SEND >> " + m.op);
            for (NotebookSocket conn : socketLists) {
                try {
                    conn.send(this.serializeMessage(m));
                }
                catch (IOException e) {
                    LOG.error("socket error", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcastExcept(String noteId, Message m, NotebookSocket exclude) {
        Map<String, List<NotebookSocket>> map = this.noteSocketMap;
        synchronized (map) {
            List<NotebookSocket> socketLists = this.noteSocketMap.get(noteId);
            if (socketLists == null || socketLists.size() == 0) {
                return;
            }
            LOG.debug("SEND >> " + m.op);
            for (NotebookSocket conn : socketLists) {
                if (((Object)((Object)exclude)).equals((Object)conn)) continue;
                try {
                    conn.send(this.serializeMessage(m));
                }
                catch (IOException e) {
                    LOG.error("socket error", (Throwable)e);
                }
            }
        }
    }

    private void broadcastAll(Message m) {
        for (NotebookSocket conn : this.connectedSockets) {
            try {
                conn.send(this.serializeMessage(m));
            }
            catch (IOException e) {
                LOG.error("socket error", (Throwable)e);
            }
        }
    }

    private void unicast(Message m, NotebookSocket conn) {
        try {
            conn.send(this.serializeMessage(m));
        }
        catch (IOException e) {
            LOG.error("socket error", (Throwable)e);
        }
    }

    public List<Map<String, String>> generateNotebooksInfo(boolean needsReload, AuthenticationInfo subject) {
        Notebook notebook = this.notebook();
        ZeppelinConfiguration conf = notebook.getConf();
        String homescreenNotebookId = conf.getString(ZeppelinConfiguration.ConfVars.ZEPPELIN_NOTEBOOK_HOMESCREEN);
        boolean hideHomeScreenNotebookFromList = conf.getBoolean(ZeppelinConfiguration.ConfVars.ZEPPELIN_NOTEBOOK_HOMESCREEN_HIDE);
        if (needsReload) {
            try {
                notebook.reloadAllNotes(subject);
            }
            catch (IOException e) {
                LOG.error("Fail to reload notes from repository", (Throwable)e);
            }
        }
        List notes = notebook.getAllNotes();
        LinkedList<Map<String, String>> notesInfo = new LinkedList<Map<String, String>>();
        for (Note note : notes) {
            HashMap<String, String> info = new HashMap<String, String>();
            if (hideHomeScreenNotebookFromList && note.id().equals(homescreenNotebookId)) continue;
            info.put("id", note.id());
            info.put("name", note.getName());
            notesInfo.add(info);
        }
        return notesInfo;
    }

    public void broadcastNote(Note note) {
        this.broadcast(note.id(), new Message(Message.OP.NOTE).put("note", (Object)note));
    }

    public void broadcastNoteList(AuthenticationInfo subject) {
        List<Map<String, String>> notesInfo = this.generateNotebooksInfo(false, subject);
        this.broadcastAll(new Message(Message.OP.NOTES_INFO).put("notes", notesInfo));
    }

    public void unicastNoteList(NotebookSocket conn, AuthenticationInfo subject) {
        List<Map<String, String>> notesInfo = this.generateNotebooksInfo(false, subject);
        this.unicast(new Message(Message.OP.NOTES_INFO).put("notes", notesInfo), conn);
    }

    public void broadcastReloadedNoteList(AuthenticationInfo subject) {
        List<Map<String, String>> notesInfo = this.generateNotebooksInfo(true, subject);
        this.broadcastAll(new Message(Message.OP.NOTES_INFO).put("notes", notesInfo));
    }

    void permissionError(NotebookSocket conn, String op, String userName, Set<String> userAndRoles, Set<String> allowed) throws IOException {
        LOG.info("Cannot {}. Connection readers {}. Allowed readers {}", new Object[]{op, userAndRoles, allowed});
        conn.send(this.serializeMessage(new Message(Message.OP.AUTH_INFO).put("info", (Object)("Insufficient privileges to " + op + " notebook.\n\n" + "Allowed users or roles: " + allowed.toString() + "\n\n" + "But the user " + userName + " belongs to: " + userAndRoles.toString()))));
    }

    private void sendNote(NotebookSocket conn, HashSet<String> userAndRoles, Notebook notebook, Message fromMessage) throws IOException {
        LOG.info("New operation from {} : {} : {} : {} : {}", new Object[]{conn.getRequest().getRemoteAddr(), conn.getRequest().getRemotePort(), fromMessage.principal, fromMessage.op, fromMessage.get("id")});
        String noteId = (String)fromMessage.get("id");
        if (noteId == null) {
            return;
        }
        Note note = notebook.getNote(noteId);
        NotebookAuthorization notebookAuthorization = notebook.getNotebookAuthorization();
        if (note != null) {
            if (!notebookAuthorization.isReader(noteId, userAndRoles)) {
                this.permissionError(conn, "read", fromMessage.principal, userAndRoles, notebookAuthorization.getReaders(noteId));
                return;
            }
            this.addConnectionToNote(note.id(), conn);
            conn.send(this.serializeMessage(new Message(Message.OP.NOTE).put("note", (Object)note)));
            this.sendAllAngularObjects(note, conn);
        }
    }

    private void sendHomeNote(NotebookSocket conn, HashSet<String> userAndRoles, Notebook notebook, Message fromMessage) throws IOException {
        String noteId = notebook.getConf().getString(ZeppelinConfiguration.ConfVars.ZEPPELIN_NOTEBOOK_HOMESCREEN);
        Note note = null;
        if (noteId != null) {
            note = notebook.getNote(noteId);
        }
        if (note != null) {
            NotebookAuthorization notebookAuthorization = notebook.getNotebookAuthorization();
            if (!notebookAuthorization.isReader(noteId, userAndRoles)) {
                this.permissionError(conn, "read", fromMessage.principal, userAndRoles, notebookAuthorization.getReaders(noteId));
                return;
            }
            this.addConnectionToNote(note.id(), conn);
            conn.send(this.serializeMessage(new Message(Message.OP.NOTE).put("note", (Object)note)));
            this.sendAllAngularObjects(note, conn);
        } else {
            this.removeConnectionFromAllNote(conn);
            conn.send(this.serializeMessage(new Message(Message.OP.NOTE).put("note", null)));
        }
    }

    private void updateNote(NotebookSocket conn, HashSet<String> userAndRoles, Notebook notebook, Message fromMessage) throws SchedulerException, IOException {
        String noteId = (String)fromMessage.get("id");
        String name = (String)fromMessage.get("name");
        Map config = (Map)fromMessage.get("config");
        if (noteId == null) {
            return;
        }
        if (config == null) {
            return;
        }
        NotebookAuthorization notebookAuthorization = notebook.getNotebookAuthorization();
        if (!notebookAuthorization.isWriter(noteId, userAndRoles)) {
            this.permissionError(conn, "update", fromMessage.principal, userAndRoles, notebookAuthorization.getWriters(noteId));
            return;
        }
        Note note = notebook.getNote(noteId);
        if (note != null) {
            boolean cronUpdated = this.isCronUpdated(config, note.getConfig());
            note.setName(name);
            note.setConfig(config);
            if (cronUpdated) {
                notebook.refreshCron(note.id());
            }
            AuthenticationInfo subject = new AuthenticationInfo(fromMessage.principal);
            note.persist(subject);
            this.broadcastNote(note);
            this.broadcastNoteList(subject);
        }
    }

    private boolean isCronUpdated(Map<String, Object> configA, Map<String, Object> configB) {
        boolean cronUpdated = false;
        if (configA.get("cron") != null && configB.get("cron") != null && configA.get("cron").equals(configB.get("cron"))) {
            cronUpdated = true;
        } else if (configA.get("cron") == null && configB.get("cron") == null) {
            cronUpdated = false;
        } else if (configA.get("cron") != null || configB.get("cron") != null) {
            cronUpdated = true;
        }
        return cronUpdated;
    }

    private void createNote(NotebookSocket conn, HashSet<String> userAndRoles, Notebook notebook, Message message) throws IOException {
        AuthenticationInfo subject = new AuthenticationInfo(message.principal);
        Note note = notebook.createNote(subject);
        note.addParagraph();
        if (message != null) {
            String noteName = (String)message.get("name");
            if (noteName == null || noteName.isEmpty()) {
                noteName = "Note " + note.getId();
            }
            note.setName(noteName);
        }
        note.persist(subject);
        this.addConnectionToNote(note.id(), conn);
        conn.send(this.serializeMessage(new Message(Message.OP.NEW_NOTE).put("note", (Object)note)));
        this.broadcastNoteList(subject);
    }

    private void removeNote(NotebookSocket conn, HashSet<String> userAndRoles, Notebook notebook, Message fromMessage) throws IOException {
        String noteId = (String)fromMessage.get("id");
        if (noteId == null) {
            return;
        }
        Note note = notebook.getNote(noteId);
        NotebookAuthorization notebookAuthorization = notebook.getNotebookAuthorization();
        if (!notebookAuthorization.isOwner(noteId, userAndRoles)) {
            this.permissionError(conn, "remove", fromMessage.principal, userAndRoles, notebookAuthorization.getOwners(noteId));
            return;
        }
        AuthenticationInfo subject = new AuthenticationInfo(fromMessage.principal);
        notebook.removeNote(noteId, subject);
        this.removeNote(noteId);
        this.broadcastNoteList(subject);
    }

    private void updateParagraph(NotebookSocket conn, HashSet<String> userAndRoles, Notebook notebook, Message fromMessage) throws IOException {
        String paragraphId = (String)fromMessage.get("id");
        if (paragraphId == null) {
            return;
        }
        Map params = (Map)fromMessage.get("params");
        Map config = (Map)fromMessage.get("config");
        String noteId = this.getOpenNoteId(conn);
        Note note = notebook.getNote(noteId);
        NotebookAuthorization notebookAuthorization = notebook.getNotebookAuthorization();
        AuthenticationInfo subject = new AuthenticationInfo(fromMessage.principal);
        if (!notebookAuthorization.isWriter(noteId, userAndRoles)) {
            this.permissionError(conn, "write", fromMessage.principal, userAndRoles, notebookAuthorization.getWriters(noteId));
            return;
        }
        Paragraph p = note.getParagraph(paragraphId);
        p.settings.setParams(params);
        p.setConfig(config);
        p.setTitle((String)fromMessage.get("title"));
        p.setText((String)fromMessage.get("paragraph"));
        note.persist(subject);
        this.broadcast(note.id(), new Message(Message.OP.PARAGRAPH).put("paragraph", (Object)p));
    }

    private void cloneNote(NotebookSocket conn, HashSet<String> userAndRoles, Notebook notebook, Message fromMessage) throws IOException, CloneNotSupportedException {
        String noteId = this.getOpenNoteId(conn);
        String name = (String)fromMessage.get("name");
        Note newNote = notebook.cloneNote(noteId, name, new AuthenticationInfo(fromMessage.principal));
        AuthenticationInfo subject = new AuthenticationInfo(fromMessage.principal);
        this.addConnectionToNote(newNote.id(), conn);
        conn.send(this.serializeMessage(new Message(Message.OP.NEW_NOTE).put("note", (Object)newNote)));
        this.broadcastNoteList(subject);
    }

    protected Note importNote(NotebookSocket conn, HashSet<String> userAndRoles, Notebook notebook, Message fromMessage) throws IOException {
        Note note = null;
        if (fromMessage != null) {
            String noteName = (String)((Map)fromMessage.get("notebook")).get("name");
            String noteJson = this.gson.toJson(fromMessage.get("notebook"));
            AuthenticationInfo subject = new AuthenticationInfo(fromMessage.principal);
            note = notebook.importNote(noteJson, noteName, subject);
            note.persist(subject);
            this.broadcastNote(note);
            this.broadcastNoteList(subject);
        }
        return note;
    }

    private void removeParagraph(NotebookSocket conn, HashSet<String> userAndRoles, Notebook notebook, Message fromMessage) throws IOException {
        String paragraphId = (String)fromMessage.get("id");
        if (paragraphId == null) {
            return;
        }
        String noteId = this.getOpenNoteId(conn);
        Note note = notebook.getNote(noteId);
        NotebookAuthorization notebookAuthorization = notebook.getNotebookAuthorization();
        AuthenticationInfo subject = new AuthenticationInfo(SecurityUtils.getPrincipal());
        if (!notebookAuthorization.isWriter(noteId, userAndRoles)) {
            this.permissionError(conn, "write", fromMessage.principal, userAndRoles, notebookAuthorization.getWriters(noteId));
            return;
        }
        if (!note.isLastParagraph(paragraphId)) {
            note.removeParagraph(paragraphId);
            note.persist(subject);
            this.broadcastNote(note);
        }
    }

    private void clearParagraphOutput(NotebookSocket conn, HashSet<String> userAndRoles, Notebook notebook, Message fromMessage) throws IOException {
        String paragraphId = (String)fromMessage.get("id");
        if (paragraphId == null) {
            return;
        }
        String noteId = this.getOpenNoteId(conn);
        Note note = notebook.getNote(noteId);
        NotebookAuthorization notebookAuthorization = notebook.getNotebookAuthorization();
        if (!notebookAuthorization.isWriter(noteId, userAndRoles)) {
            this.permissionError(conn, "write", fromMessage.principal, userAndRoles, notebookAuthorization.getWriters(noteId));
            return;
        }
        note.clearParagraphOutput(paragraphId);
        this.broadcastNote(note);
    }

    private void completion(NotebookSocket conn, HashSet<String> userAndRoles, Notebook notebook, Message fromMessage) throws IOException {
        String paragraphId = (String)fromMessage.get("id");
        String buffer = (String)fromMessage.get("buf");
        int cursor = (int)Double.parseDouble(fromMessage.get("cursor").toString());
        Message resp = new Message(Message.OP.COMPLETION_LIST).put("id", (Object)paragraphId);
        if (paragraphId == null) {
            conn.send(this.serializeMessage(resp));
            return;
        }
        Note note = notebook.getNote(this.getOpenNoteId(conn));
        List candidates = note.completion(paragraphId, buffer, cursor);
        resp.put("completions", (Object)candidates);
        conn.send(this.serializeMessage(resp));
    }

    private void angularObjectUpdated(NotebookSocket conn, HashSet<String> userAndRoles, Notebook notebook, Message fromMessage) {
        String noteId = (String)fromMessage.get("noteId");
        String paragraphId = (String)fromMessage.get("paragraphId");
        String interpreterGroupId = (String)fromMessage.get("interpreterGroupId");
        String varName = (String)fromMessage.get("name");
        Object varValue = fromMessage.get("value");
        AngularObject ao = null;
        boolean global = false;
        Note note = notebook.getNote(noteId);
        if (note != null) {
            List settings = note.getNoteReplLoader().getInterpreterSettings();
            for (InterpreterSetting setting : settings) {
                if (setting.getInterpreterGroup(note.id()) == null || !interpreterGroupId.equals(setting.getInterpreterGroup(note.id()).getId())) continue;
                AngularObjectRegistry angularObjectRegistry = setting.getInterpreterGroup(note.id()).getAngularObjectRegistry();
                ao = angularObjectRegistry.get(varName, noteId, paragraphId);
                if (ao == null) {
                    ao = angularObjectRegistry.get(varName, noteId, null);
                    if (ao == null) {
                        ao = angularObjectRegistry.get(varName, null, null);
                        if (ao == null) {
                            LOG.warn("Object {} is not binded", (Object)varName);
                            break;
                        }
                        ao.set(varValue, false);
                        global = true;
                        break;
                    }
                    ao.set(varValue, false);
                    global = false;
                    break;
                }
                ao.set(varValue, false);
                global = false;
                break;
            }
        }
        if (global) {
            for (Note n : notebook.getAllNotes()) {
                List settings = note.getNoteReplLoader().getInterpreterSettings();
                for (InterpreterSetting setting : settings) {
                    if (setting.getInterpreterGroup(n.id()) == null || !interpreterGroupId.equals(setting.getInterpreterGroup(n.id()).getId())) continue;
                    AngularObjectRegistry angularObjectRegistry = setting.getInterpreterGroup(n.id()).getAngularObjectRegistry();
                    this.broadcastExcept(n.id(), new Message(Message.OP.ANGULAR_OBJECT_UPDATE).put("angularObject", (Object)ao).put("interpreterGroupId", (Object)interpreterGroupId).put("noteId", (Object)n.id()).put("paragraphId", (Object)ao.getParagraphId()), conn);
                }
            }
        } else {
            this.broadcastExcept(note.id(), new Message(Message.OP.ANGULAR_OBJECT_UPDATE).put("angularObject", ao).put("interpreterGroupId", (Object)interpreterGroupId).put("noteId", (Object)note.id()).put("paragraphId", (Object)ao.getParagraphId()), conn);
        }
    }

    protected void angularObjectClientBind(NotebookSocket conn, HashSet<String> userAndRoles, Notebook notebook, Message fromMessage) throws Exception {
        String noteId = (String)fromMessage.getType("noteId");
        String varName = (String)fromMessage.getType("name");
        Object varValue = fromMessage.get("value");
        String paragraphId = (String)fromMessage.getType("paragraphId");
        Note note = notebook.getNote(noteId);
        if (paragraphId == null) {
            throw new IllegalArgumentException("target paragraph not specified for angular value bind");
        }
        if (note != null) {
            InterpreterGroup interpreterGroup = this.findInterpreterGroupForParagraph(note, paragraphId);
            AngularObjectRegistry registry = interpreterGroup.getAngularObjectRegistry();
            if (registry instanceof RemoteAngularObjectRegistry) {
                RemoteAngularObjectRegistry remoteRegistry = (RemoteAngularObjectRegistry)registry;
                this.pushAngularObjectToRemoteRegistry(noteId, paragraphId, varName, varValue, remoteRegistry, interpreterGroup.getId(), conn);
            } else {
                this.pushAngularObjectToLocalRepo(noteId, paragraphId, varName, varValue, registry, interpreterGroup.getId(), conn);
            }
        }
    }

    protected void angularObjectClientUnbind(NotebookSocket conn, HashSet<String> userAndRoles, Notebook notebook, Message fromMessage) throws Exception {
        String noteId = (String)fromMessage.getType("noteId");
        String varName = (String)fromMessage.getType("name");
        String paragraphId = (String)fromMessage.getType("paragraphId");
        Note note = notebook.getNote(noteId);
        if (paragraphId == null) {
            throw new IllegalArgumentException("target paragraph not specified for angular value unBind");
        }
        if (note != null) {
            InterpreterGroup interpreterGroup = this.findInterpreterGroupForParagraph(note, paragraphId);
            AngularObjectRegistry registry = interpreterGroup.getAngularObjectRegistry();
            if (registry instanceof RemoteAngularObjectRegistry) {
                RemoteAngularObjectRegistry remoteRegistry = (RemoteAngularObjectRegistry)registry;
                this.removeAngularFromRemoteRegistry(noteId, paragraphId, varName, remoteRegistry, interpreterGroup.getId(), conn);
            } else {
                this.removeAngularObjectFromLocalRepo(noteId, paragraphId, varName, registry, interpreterGroup.getId(), conn);
            }
        }
    }

    private InterpreterGroup findInterpreterGroupForParagraph(Note note, String paragraphId) throws Exception {
        Paragraph paragraph = note.getParagraph(paragraphId);
        if (paragraph == null) {
            throw new IllegalArgumentException("Unknown paragraph with id : " + paragraphId);
        }
        return paragraph.getCurrentRepl().getInterpreterGroup();
    }

    private void pushAngularObjectToRemoteRegistry(String noteId, String paragraphId, String varName, Object varValue, RemoteAngularObjectRegistry remoteRegistry, String interpreterGroupId, NotebookSocket conn) {
        AngularObject ao = remoteRegistry.addAndNotifyRemoteProcess(varName, varValue, noteId, paragraphId);
        this.broadcastExcept(noteId, new Message(Message.OP.ANGULAR_OBJECT_UPDATE).put("angularObject", (Object)ao).put("interpreterGroupId", (Object)interpreterGroupId).put("noteId", (Object)noteId).put("paragraphId", (Object)paragraphId), conn);
    }

    private void removeAngularFromRemoteRegistry(String noteId, String paragraphId, String varName, RemoteAngularObjectRegistry remoteRegistry, String interpreterGroupId, NotebookSocket conn) {
        AngularObject ao = remoteRegistry.removeAndNotifyRemoteProcess(varName, noteId, paragraphId);
        this.broadcastExcept(noteId, new Message(Message.OP.ANGULAR_OBJECT_REMOVE).put("angularObject", (Object)ao).put("interpreterGroupId", (Object)interpreterGroupId).put("noteId", (Object)noteId).put("paragraphId", (Object)paragraphId), conn);
    }

    private void pushAngularObjectToLocalRepo(String noteId, String paragraphId, String varName, Object varValue, AngularObjectRegistry registry, String interpreterGroupId, NotebookSocket conn) {
        AngularObject angularObject = registry.get(varName, noteId, paragraphId);
        if (angularObject == null) {
            angularObject = registry.add(varName, varValue, noteId, paragraphId);
        } else {
            angularObject.set(varValue, true);
        }
        this.broadcastExcept(noteId, new Message(Message.OP.ANGULAR_OBJECT_UPDATE).put("angularObject", (Object)angularObject).put("interpreterGroupId", (Object)interpreterGroupId).put("noteId", (Object)noteId).put("paragraphId", (Object)paragraphId), conn);
    }

    private void removeAngularObjectFromLocalRepo(String noteId, String paragraphId, String varName, AngularObjectRegistry registry, String interpreterGroupId, NotebookSocket conn) {
        AngularObject removed = registry.remove(varName, noteId, paragraphId);
        if (removed != null) {
            this.broadcastExcept(noteId, new Message(Message.OP.ANGULAR_OBJECT_REMOVE).put("angularObject", (Object)removed).put("interpreterGroupId", (Object)interpreterGroupId).put("noteId", (Object)noteId).put("paragraphId", (Object)paragraphId), conn);
        }
    }

    private void moveParagraph(NotebookSocket conn, HashSet<String> userAndRoles, Notebook notebook, Message fromMessage) throws IOException {
        String paragraphId = (String)fromMessage.get("id");
        if (paragraphId == null) {
            return;
        }
        int newIndex = (int)Double.parseDouble(fromMessage.get("index").toString());
        String noteId = this.getOpenNoteId(conn);
        Note note = notebook.getNote(noteId);
        NotebookAuthorization notebookAuthorization = notebook.getNotebookAuthorization();
        AuthenticationInfo subject = new AuthenticationInfo(SecurityUtils.getPrincipal());
        if (!notebookAuthorization.isWriter(noteId, userAndRoles)) {
            this.permissionError(conn, "write", fromMessage.principal, userAndRoles, notebookAuthorization.getWriters(noteId));
            return;
        }
        note.moveParagraph(paragraphId, newIndex);
        note.persist(subject);
        this.broadcastNote(note);
    }

    private void insertParagraph(NotebookSocket conn, HashSet<String> userAndRoles, Notebook notebook, Message fromMessage) throws IOException {
        int index = (int)Double.parseDouble(fromMessage.get("index").toString());
        String noteId = this.getOpenNoteId(conn);
        Note note = notebook.getNote(noteId);
        NotebookAuthorization notebookAuthorization = notebook.getNotebookAuthorization();
        AuthenticationInfo subject = new AuthenticationInfo(SecurityUtils.getPrincipal());
        if (!notebookAuthorization.isWriter(noteId, userAndRoles)) {
            this.permissionError(conn, "write", fromMessage.principal, userAndRoles, notebookAuthorization.getWriters(noteId));
            return;
        }
        note.insertParagraph(index);
        note.persist(subject);
        this.broadcastNote(note);
    }

    private void cancelParagraph(NotebookSocket conn, HashSet<String> userAndRoles, Notebook notebook, Message fromMessage) throws IOException {
        String paragraphId = (String)fromMessage.get("id");
        if (paragraphId == null) {
            return;
        }
        String noteId = this.getOpenNoteId(conn);
        Note note = notebook.getNote(noteId);
        NotebookAuthorization notebookAuthorization = notebook.getNotebookAuthorization();
        if (!notebookAuthorization.isWriter(noteId, userAndRoles)) {
            this.permissionError(conn, "write", fromMessage.principal, userAndRoles, notebookAuthorization.getWriters(noteId));
            return;
        }
        Paragraph p = note.getParagraph(paragraphId);
        p.abort();
    }

    private void runParagraph(NotebookSocket conn, HashSet<String> userAndRoles, Notebook notebook, Message fromMessage) throws IOException {
        block7: {
            String paragraphId = (String)fromMessage.get("id");
            if (paragraphId == null) {
                return;
            }
            String noteId = this.getOpenNoteId(conn);
            Note note = notebook.getNote(noteId);
            NotebookAuthorization notebookAuthorization = notebook.getNotebookAuthorization();
            if (!notebookAuthorization.isWriter(noteId, userAndRoles)) {
                this.permissionError(conn, "write", fromMessage.principal, userAndRoles, notebookAuthorization.getWriters(noteId));
                return;
            }
            Paragraph p = note.getParagraph(paragraphId);
            String text = (String)fromMessage.get("paragraph");
            p.setText(text);
            p.setTitle((String)fromMessage.get("title"));
            if (!fromMessage.principal.equals("anonymous")) {
                AuthenticationInfo authenticationInfo = new AuthenticationInfo(fromMessage.principal, fromMessage.ticket);
                p.setAuthenticationInfo(authenticationInfo);
            } else {
                p.setAuthenticationInfo(new AuthenticationInfo());
            }
            Map params = (Map)fromMessage.get("params");
            p.settings.setParams(params);
            Map config = (Map)fromMessage.get("config");
            p.setConfig(config);
            boolean isTheLastParagraph = note.getLastParagraph().getId().equals(p.getId());
            if (!Strings.isNullOrEmpty((String)text) && isTheLastParagraph) {
                note.addParagraph();
            }
            AuthenticationInfo subject = new AuthenticationInfo(fromMessage.principal);
            note.persist(subject);
            try {
                note.run(paragraphId);
            }
            catch (Exception ex) {
                LOG.error("Exception from run", (Throwable)ex);
                if (p == null) break block7;
                p.setReturn(new InterpreterResult(InterpreterResult.Code.ERROR, ex.getMessage()), (Throwable)ex);
                p.setStatus(Job.Status.ERROR);
                this.broadcast(note.id(), new Message(Message.OP.PARAGRAPH).put("paragraph", (Object)p));
            }
        }
    }

    private void sendAllConfigurations(NotebookSocket conn, HashSet<String> userAndRoles, Notebook notebook) throws IOException {
        ZeppelinConfiguration conf = notebook.getConf();
        Map configurations = conf.dumpConfigurations(conf, new ZeppelinConfiguration.ConfigurationKeyPredicate(){

            public boolean apply(String key) {
                return !key.contains("password") && !key.equals(ZeppelinConfiguration.ConfVars.ZEPPELIN_NOTEBOOK_AZURE_CONNECTION_STRING.getVarName());
            }
        });
        conn.send(this.serializeMessage(new Message(Message.OP.CONFIGURATIONS_INFO).put("configurations", (Object)configurations)));
    }

    private void checkpointNotebook(NotebookSocket conn, Notebook notebook, Message fromMessage) throws IOException {
        String noteId = (String)fromMessage.get("noteId");
        String commitMessage = (String)fromMessage.get("commitMessage");
        AuthenticationInfo subject = new AuthenticationInfo(fromMessage.principal);
        notebook.checkpointNote(noteId, commitMessage, subject);
    }

    public void onOutputAppend(String noteId, String paragraphId, String output) {
        Message msg = new Message(Message.OP.PARAGRAPH_APPEND_OUTPUT).put("noteId", (Object)noteId).put("paragraphId", (Object)paragraphId).put("data", (Object)output);
        Paragraph paragraph = this.notebook().getNote(noteId).getParagraph(paragraphId);
        this.broadcast(noteId, msg);
    }

    public void onOutputUpdated(String noteId, String paragraphId, String output) {
        Message msg = new Message(Message.OP.PARAGRAPH_UPDATE_OUTPUT).put("noteId", (Object)noteId).put("paragraphId", (Object)paragraphId).put("data", (Object)output);
        Paragraph paragraph = this.notebook().getNote(noteId).getParagraph(paragraphId);
        this.broadcast(noteId, msg);
    }

    public ParagraphJobListener getParagraphJobListener(Note note) {
        return new ParagraphListenerImpl(this, note);
    }

    private void sendAllAngularObjects(Note note, NotebookSocket conn) throws IOException {
        List settings = note.getNoteReplLoader().getInterpreterSettings();
        if (settings == null || settings.size() == 0) {
            return;
        }
        for (InterpreterSetting intpSetting : settings) {
            AngularObjectRegistry registry = intpSetting.getInterpreterGroup(note.id()).getAngularObjectRegistry();
            List objects = registry.getAllWithGlobal(note.id());
            for (AngularObject object : objects) {
                conn.send(this.serializeMessage(new Message(Message.OP.ANGULAR_OBJECT_UPDATE).put("angularObject", (Object)object).put("interpreterGroupId", (Object)intpSetting.getInterpreterGroup(note.id()).getId()).put("noteId", (Object)note.id()).put("paragraphId", (Object)object.getParagraphId())));
            }
        }
    }

    public void onAdd(String interpreterGroupId, AngularObject object) {
        this.onUpdate(interpreterGroupId, object);
    }

    public void onUpdate(String interpreterGroupId, AngularObject object) {
        Notebook notebook = this.notebook();
        if (notebook == null) {
            return;
        }
        List notes = notebook.getAllNotes();
        for (Note note : notes) {
            List intpSettings;
            if (object.getNoteId() != null && !note.id().equals(object.getNoteId()) || (intpSettings = note.getNoteReplLoader().getInterpreterSettings()).isEmpty()) continue;
            for (InterpreterSetting setting : intpSettings) {
                if (!setting.getInterpreterGroup(note.id()).getId().equals(interpreterGroupId)) continue;
                this.broadcast(note.id(), new Message(Message.OP.ANGULAR_OBJECT_UPDATE).put("angularObject", (Object)object).put("interpreterGroupId", (Object)interpreterGroupId).put("noteId", (Object)note.id()).put("paragraphId", (Object)object.getParagraphId()));
            }
        }
    }

    public void onRemove(String interpreterGroupId, String name, String noteId, String paragraphId) {
        Notebook notebook = this.notebook();
        List notes = notebook.getAllNotes();
        for (Note note : notes) {
            if (noteId != null && !note.id().equals(noteId)) continue;
            List ids = note.getNoteReplLoader().getInterpreters();
            for (String id : ids) {
                if (!id.equals(interpreterGroupId)) continue;
                this.broadcast(note.id(), new Message(Message.OP.ANGULAR_OBJECT_REMOVE).put("name", (Object)name).put("noteId", (Object)noteId).put("paragraphId", (Object)paragraphId));
            }
        }
    }

    public static class ParagraphListenerImpl
    implements ParagraphJobListener {
        private NotebookServer notebookServer;
        private Note note;

        public ParagraphListenerImpl(NotebookServer notebookServer, Note note) {
            this.notebookServer = notebookServer;
            this.note = note;
        }

        public void onProgressUpdate(Job job, int progress) {
            this.notebookServer.broadcast(this.note.id(), new Message(Message.OP.PROGRESS).put("id", (Object)job.getId()).put("progress", (Object)job.progress()));
        }

        public void beforeStatusChange(Job job, Job.Status before, Job.Status after) {
        }

        public void afterStatusChange(Job job, Job.Status before, Job.Status after) {
            if (after == Job.Status.ERROR && job.getException() != null) {
                LOG.error("Error", job.getException());
            }
            if (job.isTerminated()) {
                LOG.info("Job {} is finished", (Object)job.getId());
                try {
                    this.note.persist(null);
                }
                catch (IOException e) {
                    LOG.error(e.toString(), (Throwable)e);
                }
            }
            this.notebookServer.broadcastNote(this.note);
        }

        public void onOutputAppend(Paragraph paragraph, InterpreterOutput out, String output) {
            Message msg = new Message(Message.OP.PARAGRAPH_APPEND_OUTPUT).put("noteId", (Object)paragraph.getNote().getId()).put("paragraphId", (Object)paragraph.getId()).put("data", (Object)output);
            this.notebookServer.broadcast(paragraph.getNote().getId(), msg);
        }

        public void onOutputUpdate(Paragraph paragraph, InterpreterOutput out, String output) {
            Message msg = new Message(Message.OP.PARAGRAPH_UPDATE_OUTPUT).put("noteId", (Object)paragraph.getNote().getId()).put("paragraphId", (Object)paragraph.getId()).put("data", (Object)output);
            this.notebookServer.broadcast(paragraph.getNote().getId(), msg);
        }
    }
}

