/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.ticket;

import java.util.Calendar;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class TicketContainer {
    private Map<String, Entry> sessions = new ConcurrentHashMap<String, Entry>();
    public static final TicketContainer instance = new TicketContainer();

    public boolean isValid(String principal, String ticket) {
        if ("anonymous".equals(principal) && "anonymous".equals(ticket)) {
            return true;
        }
        Entry entry = this.sessions.get(principal);
        return entry != null && entry.ticket.equals(ticket);
    }

    public synchronized String getTicket(String principal) {
        Entry entry = this.sessions.get(principal);
        String ticket = entry == null ? (principal.equals("anonymous") ? "anonymous" : UUID.randomUUID().toString()) : entry.ticket;
        entry = new Entry(ticket);
        this.sessions.put(principal, entry);
        return ticket;
    }

    private static class Entry {
        public final String ticket;
        public final long lastAccessTime;

        Entry(String ticket) {
            this.ticket = ticket;
            this.lastAccessTime = Calendar.getInstance().getTimeInMillis();
        }
    }
}

