/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.rest;

import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.zeppelin.annotation.ZeppelinApi;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.notebook.Notebook;
import org.apache.zeppelin.server.JsonResponse;

@Path(value="/configurations")
@Produces(value={"application/json"})
public class ConfigurationsRestApi {
    private Notebook notebook;

    public ConfigurationsRestApi() {
    }

    public ConfigurationsRestApi(Notebook notebook) {
        this.notebook = notebook;
    }

    @GET
    @Path(value="all")
    @ZeppelinApi
    public Response getAll() {
        ZeppelinConfiguration conf = this.notebook.getConf();
        Map configurations = conf.dumpConfigurations(conf, new ZeppelinConfiguration.ConfigurationKeyPredicate(){

            public boolean apply(String key) {
                return !key.contains("password") && !key.equals(ZeppelinConfiguration.ConfVars.ZEPPELIN_NOTEBOOK_AZURE_CONNECTION_STRING.getVarName());
            }
        });
        return new JsonResponse<Map>(Response.Status.OK, "", configurations).build();
    }

    @GET
    @Path(value="prefix/{prefix}")
    @ZeppelinApi
    public Response getByPrefix(final @PathParam(value="prefix") String prefix) {
        ZeppelinConfiguration conf = this.notebook.getConf();
        Map configurations = conf.dumpConfigurations(conf, new ZeppelinConfiguration.ConfigurationKeyPredicate(){

            public boolean apply(String key) {
                return !key.contains("password") && !key.equals(ZeppelinConfiguration.ConfVars.ZEPPELIN_NOTEBOOK_AZURE_CONNECTION_STRING.getVarName()) && key.startsWith(prefix);
            }
        });
        return new JsonResponse<Map>(Response.Status.OK, "", configurations).build();
    }
}

