/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.rest;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.shiro.config.Ini;
import org.apache.shiro.realm.jdbc.JdbcRealm;
import org.apache.shiro.realm.ldap.JndiLdapContextFactory;
import org.apache.shiro.realm.ldap.JndiLdapRealm;
import org.apache.shiro.realm.text.IniRealm;
import org.apache.shiro.util.JdbcUtils;
import org.apache.zeppelin.realm.ActiveDirectoryGroupRealm;
import org.apache.zeppelin.realm.LdapRealm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetUserList {
    private static final Logger LOG = LoggerFactory.getLogger(GetUserList.class);

    public List<String> getUserList(IniRealm r) {
        ArrayList<String> userList = new ArrayList<String>();
        Ini.Section getIniUser = r.getIni().get((Object)"users");
        if (getIniUser != null) {
            for (Map.Entry pair : getIniUser.entrySet()) {
                userList.add(pair.getKey().toString().trim());
            }
        }
        return userList;
    }

    public List<String> getRolesList(IniRealm r) {
        ArrayList<String> roleList = new ArrayList<String>();
        Ini.Section getIniRoles = r.getIni().get((Object)"roles");
        if (getIniRoles != null) {
            for (Map.Entry pair : getIniRoles.entrySet()) {
                roleList.add(pair.getKey().toString().trim());
            }
        }
        return roleList;
    }

    public List<String> getUserList(JndiLdapRealm r, String searchText, int numUsersToFetch) {
        ArrayList<String> userList = new ArrayList<String>();
        String userDnTemplate = r.getUserDnTemplate();
        String[] userDn = userDnTemplate.split(",", 2);
        String userDnPrefix = userDn[0].split("=")[0];
        String userDnSuffix = userDn[1];
        JndiLdapContextFactory CF = (JndiLdapContextFactory)r.getContextFactory();
        try {
            LdapContext ctx = CF.getSystemLdapContext();
            SearchControls constraints = new SearchControls();
            constraints.setCountLimit(numUsersToFetch);
            constraints.setSearchScope(2);
            String[] attrIDs = new String[]{userDnPrefix};
            constraints.setReturningAttributes(attrIDs);
            NamingEnumeration<SearchResult> result = ctx.search(userDnSuffix, "(" + userDnPrefix + "=*" + searchText + "*)", constraints);
            while (result.hasMore()) {
                Attributes attrs = result.next().getAttributes();
                if (attrs.get(userDnPrefix) == null) continue;
                String currentUser = attrs.get(userDnPrefix).toString();
                userList.add(currentUser.split(":")[1].trim());
            }
        }
        catch (Exception e) {
            LOG.error("Error retrieving User list from Ldap Realm", (Throwable)e);
        }
        LOG.info("UserList: " + userList);
        return userList;
    }

    public List<String> getUserList(LdapRealm r, String searchText, int numUsersToFetch) {
        ArrayList<String> userList = new ArrayList<String>();
        if (LOG.isDebugEnabled()) {
            LOG.debug("SearchText: " + searchText);
        }
        String userAttribute = r.getUserSearchAttributeName();
        String userSearchRealm = r.getUserSearchBase();
        String userObjectClass = r.getUserObjectClass();
        JndiLdapContextFactory CF = (JndiLdapContextFactory)r.getContextFactory();
        try {
            LdapContext ctx = CF.getSystemLdapContext();
            SearchControls constraints = new SearchControls();
            constraints.setSearchScope(2);
            constraints.setCountLimit(numUsersToFetch);
            String[] attrIDs = new String[]{userAttribute};
            constraints.setReturningAttributes(attrIDs);
            NamingEnumeration<SearchResult> result = ctx.search(userSearchRealm, "(&(objectclass=" + userObjectClass + ")(" + userAttribute + "=*" + searchText + "*))", constraints);
            while (result.hasMore()) {
                String currentUser;
                Attributes attrs = result.next().getAttributes();
                if (attrs.get(userAttribute) == null) continue;
                if (r.getUserLowerCase()) {
                    LOG.debug("userLowerCase true");
                    currentUser = ((String)attrs.get(userAttribute).get()).toLowerCase();
                } else {
                    LOG.debug("userLowerCase false");
                    currentUser = (String)attrs.get(userAttribute).get();
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("CurrentUser: " + currentUser);
                }
                userList.add(currentUser.trim());
            }
        }
        catch (Exception e) {
            LOG.error("Error retrieving User list from Ldap Realm", (Throwable)e);
        }
        return userList;
    }

    public List<String> getRolesList(LdapRealm r) {
        ArrayList<String> roleList = new ArrayList<String>();
        Map<String, String> roles = r.getListRoles();
        if (roles != null) {
            for (Map.Entry<String, String> pair : roles.entrySet()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("RoleKeyValue: " + pair.getKey() + " = " + pair.getValue());
                }
                roleList.add(pair.getKey());
            }
        }
        return roleList;
    }

    public List<String> getUserList(ActiveDirectoryGroupRealm r, String searchText, int numUsersToFetch) {
        List<String> userList = new ArrayList<String>();
        try {
            LdapContext ctx = r.getLdapContextFactory().getSystemLdapContext();
            userList = r.searchForUserName(searchText, ctx, numUsersToFetch);
        }
        catch (Exception e) {
            LOG.error("Error retrieving User list from ActiveDirectory Realm", (Throwable)e);
        }
        return userList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getUserList(JdbcRealm obj) {
        ArrayList<String> userlist = new ArrayList<String>();
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        DataSource dataSource = null;
        String authQuery = "";
        String tablename = "";
        String username = "";
        String userquery = "";
        try {
            dataSource = (DataSource)FieldUtils.readField((Object)obj, (String)"dataSource", (boolean)true);
            authQuery = (String)FieldUtils.readField((Object)obj, (String)"authenticationQuery", (boolean)true);
            LOG.info(authQuery);
            String authQueryLowerCase = authQuery.toLowerCase();
            String[] retval = authQueryLowerCase.split("from", 2);
            if (retval.length >= 2) {
                retval = retval[1].split("with|where", 2);
                tablename = retval[0];
                retval = (retval = retval[1].split("where", 2)).length >= 2 ? retval[1].split("=", 2) : retval[0].split("=", 2);
                username = retval[0];
            }
            if (StringUtils.isBlank((CharSequence)username) || StringUtils.isBlank((CharSequence)tablename)) {
                return userlist;
            }
            userquery = String.format("SELECT %s FROM %s", username, tablename);
        }
        catch (IllegalAccessException e) {
            LOG.error("Error while accessing dataSource for JDBC Realm", (Throwable)e);
            return null;
        }
        try {
            con = dataSource.getConnection();
            ps = con.prepareStatement(userquery);
            rs = ps.executeQuery();
            while (rs.next()) {
                userlist.add(rs.getString(1).trim());
            }
        }
        catch (Exception e) {
            try {
                LOG.error("Error retrieving User list from JDBC Realm", (Throwable)e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeResultSet(rs);
                JdbcUtils.closeStatement(ps);
                JdbcUtils.closeConnection((Connection)con);
                throw throwable;
            }
            JdbcUtils.closeResultSet(rs);
            JdbcUtils.closeStatement((Statement)ps);
            JdbcUtils.closeConnection((Connection)con);
        }
        JdbcUtils.closeResultSet((ResultSet)rs);
        JdbcUtils.closeStatement((Statement)ps);
        JdbcUtils.closeConnection((Connection)con);
        return userlist;
    }
}

