/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.realm;

import com.google.common.base.Joiner;
import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authc.AccountException;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.zeppelin.common.JsonSerializable;
import org.apache.zeppelin.notebook.repo.zeppelinhub.model.UserSessionContainer;
import org.apache.zeppelin.notebook.repo.zeppelinhub.websocket.utils.ZeppelinhubUtils;
import org.apache.zeppelin.service.ServiceContext;
import org.apache.zeppelin.socket.NotebookServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZeppelinHubRealm
extends AuthorizingRealm {
    private static final Logger LOG = LoggerFactory.getLogger(ZeppelinHubRealm.class);
    private static final String DEFAULT_ZEPPELINHUB_URL = "https://www.zeppelinhub.com";
    private static final String USER_LOGIN_API_ENDPOINT = "api/v1/users/login";
    private static final String JSON_CONTENT_TYPE = "application/json";
    private static final String UTF_8_ENCODING = "UTF-8";
    private static final String USER_SESSION_HEADER = "X-session";
    private static final AtomicInteger INSTANCE_COUNT = new AtomicInteger();
    private final HttpClient httpClient;
    private String zeppelinhubUrl;
    private String name;

    public ZeppelinHubRealm() {
        LOG.debug("Init ZeppelinhubRealm");
        this.httpClient = new HttpClient();
        this.name = ((Object)((Object)this)).getClass().getName() + "_" + INSTANCE_COUNT.getAndIncrement();
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authToken) throws AuthenticationException {
        UsernamePasswordToken token = (UsernamePasswordToken)authToken;
        if (StringUtils.isBlank((CharSequence)token.getUsername())) {
            throw new AccountException("Empty usernames are not allowed by this realm.");
        }
        String loginPayload = this.createLoginPayload(token.getUsername(), token.getPassword());
        User user = this.authenticateUser(loginPayload);
        LOG.debug("{} successfully login via ZeppelinHub", (Object)user.login);
        return new SimpleAuthenticationInfo((Object)user.login, (Object)token.getPassword(), this.name);
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        return null;
    }

    protected void onInit() {
        super.onInit();
    }

    public void setZeppelinhubUrl(String url) {
        if (StringUtils.isBlank((CharSequence)url)) {
            LOG.warn("Zeppelinhub url is empty, setting up default url {}", (Object)DEFAULT_ZEPPELINHUB_URL);
            this.zeppelinhubUrl = DEFAULT_ZEPPELINHUB_URL;
        } else {
            this.zeppelinhubUrl = this.isZeppelinHubUrlValid(url) ? url : DEFAULT_ZEPPELINHUB_URL;
            LOG.info("Setting up Zeppelinhub url to {}", (Object)this.zeppelinhubUrl);
        }
    }

    protected User authenticateUser(String requestBody) {
        User account;
        String userSession;
        String responseBody;
        PutMethod put = new PutMethod(Joiner.on((String)"/").join((Object)this.zeppelinhubUrl, (Object)USER_LOGIN_API_ENDPOINT, new Object[0]));
        try {
            put.setRequestEntity((RequestEntity)new StringRequestEntity(requestBody, JSON_CONTENT_TYPE, UTF_8_ENCODING));
            int statusCode = this.httpClient.executeMethod((HttpMethod)put);
            if (statusCode != 200) {
                LOG.error("Cannot login user, HTTP status code is {} instead on 200 (OK)", (Object)statusCode);
                put.releaseConnection();
                throw new AuthenticationException("Couldnt login to ZeppelinHub. Login or password incorrect");
            }
            responseBody = put.getResponseBodyAsString();
            userSession = put.getResponseHeader(USER_SESSION_HEADER).getValue();
            put.releaseConnection();
        }
        catch (IOException e) {
            LOG.error("Cannot login user", (Throwable)e);
            throw new AuthenticationException(e.getMessage());
        }
        try {
            account = User.fromJson(responseBody);
        }
        catch (JsonParseException e) {
            LOG.error("Cannot fromJson ZeppelinHub response to User instance", (Throwable)e);
            throw new AuthenticationException("Cannot login to ZeppelinHub");
        }
        this.onLoginSuccess(account.login, userSession);
        return account;
    }

    protected String createLoginPayload(String login, char[] pwd) {
        StringBuilder sb = new StringBuilder("{\"login\":\"");
        return sb.append(login).append("\", \"password\":\"").append(pwd).append("\"}").toString();
    }

    protected boolean isZeppelinHubUrlValid(String url) {
        boolean valid;
        try {
            new URI(url).toURL();
            valid = true;
        }
        catch (MalformedURLException | URISyntaxException e) {
            LOG.error("Zeppelinhub url is not valid, default ZeppelinHub url will be used.", (Throwable)e);
            valid = false;
        }
        return valid;
    }

    public void onLoginSuccess(String username, String session) {
        UserSessionContainer.instance.setSession(username, session);
        HashSet<String> userAndRoles = new HashSet<String>();
        userAndRoles.add(username);
        ServiceContext context = new ServiceContext(new org.apache.zeppelin.user.AuthenticationInfo(username), userAndRoles);
        try {
            NotebookServer.getInstance().broadcastReloadedNoteList(null, context);
        }
        catch (IOException e) {
            LOG.error("Fail to broadcastReloadedNoteList", (Throwable)e);
        }
        ZeppelinhubUtils.userLoginRoutine((String)username);
    }

    public void onLogout(PrincipalCollection principals) {
        ZeppelinhubUtils.userLogoutRoutine((String)((String)principals.getPrimaryPrincipal()));
    }

    protected static class User
    implements JsonSerializable {
        private static final Gson gson = new Gson();
        public String login;
        public String email;
        public String name;

        protected User() {
        }

        public String toJson() {
            return gson.toJson((Object)this);
        }

        public static User fromJson(String json) {
            return (User)gson.fromJson(json, User.class);
        }
    }
}

