/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.rest;

import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.zeppelin.server.JsonResponse;
import org.apache.zeppelin.service.AuthenticationService;
import org.apache.zeppelin.user.Credentials;
import org.apache.zeppelin.user.UserCredentials;
import org.apache.zeppelin.user.UsernamePassword;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/credential")
@Produces(value={"application/json"})
@Singleton
public class CredentialRestApi {
    Logger logger = LoggerFactory.getLogger(CredentialRestApi.class);
    private Credentials credentials;
    private AuthenticationService authenticationService;
    private Gson gson = new Gson();

    @Inject
    public CredentialRestApi(Credentials credentials, AuthenticationService authenticationService) {
        this.credentials = credentials;
        this.authenticationService = authenticationService;
    }

    @PUT
    public Response putCredentials(String message) throws IOException, IllegalArgumentException {
        Map messageMap = (Map)this.gson.fromJson(message, new TypeToken<Map<String, String>>(){}.getType());
        String entity = (String)messageMap.get("entity");
        String username = (String)messageMap.get("username");
        String password = (String)messageMap.get("password");
        if (Strings.isNullOrEmpty((String)entity) || Strings.isNullOrEmpty((String)username) || Strings.isNullOrEmpty((String)password)) {
            return new JsonResponse(Response.Status.BAD_REQUEST).build();
        }
        String user = this.authenticationService.getPrincipal();
        this.logger.info("Update credentials for user {} entity {}", (Object)user, (Object)entity);
        UserCredentials uc = this.credentials.getUserCredentials(user);
        uc.putUsernamePassword(entity, new UsernamePassword(username, password));
        this.credentials.putUserCredentials(user, uc);
        return new JsonResponse(Response.Status.OK).build();
    }

    @GET
    public Response getCredentials() throws IllegalArgumentException {
        String user = this.authenticationService.getPrincipal();
        this.logger.info("getCredentials credentials for user {} ", (Object)user);
        UserCredentials uc = this.credentials.getUserCredentials(user);
        return new JsonResponse<UserCredentials>(Response.Status.OK, uc).build();
    }

    @DELETE
    public Response removeCredentials() throws IOException, IllegalArgumentException {
        String user = this.authenticationService.getPrincipal();
        this.logger.info("removeCredentials credentials for user {} ", (Object)user);
        UserCredentials uc = this.credentials.removeUserCredentials(user);
        if (uc == null) {
            return new JsonResponse(Response.Status.NOT_FOUND).build();
        }
        return new JsonResponse(Response.Status.OK).build();
    }

    @DELETE
    @Path(value="{entity}")
    public Response removeCredentialEntity(@PathParam(value="entity") String entity) throws IOException, IllegalArgumentException {
        String user = this.authenticationService.getPrincipal();
        this.logger.info("removeCredentialEntity for user {} entity {}", (Object)user, (Object)entity);
        if (!this.credentials.removeCredentialEntity(user, entity)) {
            return new JsonResponse(Response.Status.NOT_FOUND).build();
        }
        return new JsonResponse(Response.Status.OK).build();
    }
}

