/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.rest;

import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.annotation.ZeppelinApi;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.notebook.AuthorizationService;
import org.apache.zeppelin.notebook.Note;
import org.apache.zeppelin.notebook.NoteInfo;
import org.apache.zeppelin.notebook.Notebook;
import org.apache.zeppelin.notebook.Paragraph;
import org.apache.zeppelin.notebook.scheduler.SchedulerService;
import org.apache.zeppelin.rest.AbstractRestApi;
import org.apache.zeppelin.rest.exception.BadRequestException;
import org.apache.zeppelin.rest.exception.ForbiddenException;
import org.apache.zeppelin.rest.exception.NoteNotFoundException;
import org.apache.zeppelin.rest.exception.ParagraphNotFoundException;
import org.apache.zeppelin.rest.message.CronRequest;
import org.apache.zeppelin.rest.message.NewNoteRequest;
import org.apache.zeppelin.rest.message.NewParagraphRequest;
import org.apache.zeppelin.rest.message.RenameNoteRequest;
import org.apache.zeppelin.rest.message.RunParagraphWithParametersRequest;
import org.apache.zeppelin.rest.message.UpdateParagraphRequest;
import org.apache.zeppelin.search.SearchService;
import org.apache.zeppelin.server.JsonResponse;
import org.apache.zeppelin.service.AuthenticationService;
import org.apache.zeppelin.service.JobManagerService;
import org.apache.zeppelin.service.NotebookService;
import org.apache.zeppelin.service.ServiceCallback;
import org.apache.zeppelin.service.ServiceContext;
import org.apache.zeppelin.socket.NotebookServer;
import org.apache.zeppelin.user.AuthenticationInfo;
import org.quartz.CronExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/notebook")
@Produces(value={"application/json"})
@Singleton
public class NotebookRestApi
extends AbstractRestApi {
    private static final Logger LOG = LoggerFactory.getLogger(NotebookRestApi.class);
    private static Gson gson = new Gson();
    private ZeppelinConfiguration zConf;
    private Notebook notebook;
    private NotebookServer notebookServer;
    private SearchService noteSearchService;
    private AuthorizationService authorizationService;
    private NotebookService notebookService;
    private JobManagerService jobManagerService;
    private AuthenticationService authenticationService;
    private SchedulerService schedulerService;

    @Inject
    public NotebookRestApi(Notebook notebook, NotebookServer notebookServer, NotebookService notebookService, SearchService search, AuthorizationService authorizationService, ZeppelinConfiguration zConf, AuthenticationService authenticationService, JobManagerService jobManagerService, SchedulerService schedulerService) {
        super(authenticationService);
        this.notebook = notebook;
        this.notebookServer = notebookServer;
        this.notebookService = notebookService;
        this.jobManagerService = jobManagerService;
        this.noteSearchService = search;
        this.authorizationService = authorizationService;
        this.zConf = zConf;
        this.authenticationService = authenticationService;
        this.schedulerService = schedulerService;
    }

    @GET
    @Path(value="{noteId}/permissions")
    @ZeppelinApi
    public Response getNotePermissions(@PathParam(value="noteId") String noteId) throws IOException {
        this.checkIfUserIsAnon(this.getBlockNotAuthenticatedUserErrorMsg());
        this.checkIfUserCanRead(noteId, "Insufficient privileges you cannot get the list of permissions for this note");
        HashMap<String, Set> permissionsMap = new HashMap<String, Set>();
        permissionsMap.put("owners", this.authorizationService.getOwners(noteId));
        permissionsMap.put("readers", this.authorizationService.getReaders(noteId));
        permissionsMap.put("writers", this.authorizationService.getWriters(noteId));
        permissionsMap.put("runners", this.authorizationService.getRunners(noteId));
        return new JsonResponse(Response.Status.OK, "", permissionsMap).build();
    }

    private String ownerPermissionError(Set<String> current, Set<String> allowed) {
        LOG.info("Cannot change permissions. Connection owners {}. Allowed owners {}", (Object)current.toString(), (Object)allowed.toString());
        return "Insufficient privileges to change permissions.\n\nAllowed owners: " + allowed.toString() + "\n\nUser belongs to: " + current.toString();
    }

    private String getBlockNotAuthenticatedUserErrorMsg() {
        return "Only authenticated user can set the permission.";
    }

    private void checkIfUserIsAnon(String errorMsg) {
        boolean isAuthenticated = this.authenticationService.isAuthenticated();
        if (isAuthenticated && this.authenticationService.getPrincipal().equals("anonymous")) {
            LOG.info("Anonymous user cannot set any permissions for this note.");
            throw new ForbiddenException(errorMsg);
        }
    }

    private void checkIfUserIsOwner(String noteId, String errorMsg) {
        HashSet userAndRoles = Sets.newHashSet();
        userAndRoles.add(this.authenticationService.getPrincipal());
        userAndRoles.addAll(this.authenticationService.getAssociatedRoles());
        if (!this.authorizationService.isOwner((Set)userAndRoles, noteId)) {
            throw new ForbiddenException(errorMsg);
        }
    }

    private void checkIfUserCanWrite(String noteId, String errorMsg) {
        HashSet userAndRoles = Sets.newHashSet();
        userAndRoles.add(this.authenticationService.getPrincipal());
        userAndRoles.addAll(this.authenticationService.getAssociatedRoles());
        if (!this.authorizationService.hasWritePermission((Set)userAndRoles, noteId)) {
            throw new ForbiddenException(errorMsg);
        }
    }

    private void checkIfUserCanRead(String noteId, String errorMsg) {
        HashSet userAndRoles = Sets.newHashSet();
        userAndRoles.add(this.authenticationService.getPrincipal());
        userAndRoles.addAll(this.authenticationService.getAssociatedRoles());
        if (!this.authorizationService.hasReadPermission((Set)userAndRoles, noteId)) {
            throw new ForbiddenException(errorMsg);
        }
    }

    private void checkIfUserCanRun(String noteId, String errorMsg) {
        HashSet userAndRoles = Sets.newHashSet();
        userAndRoles.add(this.authenticationService.getPrincipal());
        userAndRoles.addAll(this.authenticationService.getAssociatedRoles());
        if (!this.authorizationService.hasRunPermission((Set)userAndRoles, noteId)) {
            throw new ForbiddenException(errorMsg);
        }
    }

    private void checkIfNoteIsNotNull(Note note) {
        if (note == null) {
            throw new NoteNotFoundException("note not found");
        }
    }

    private void checkIfNoteSupportsCron(Note note) {
        if (!note.isCronSupported(this.notebook.getConf()).booleanValue()) {
            LOG.error("Cron is not enabled from Zeppelin server");
            throw new ForbiddenException("Cron is not enabled from Zeppelin server");
        }
    }

    private void checkIfParagraphIsNotNull(Paragraph paragraph) {
        if (paragraph == null) {
            throw new ParagraphNotFoundException("paragraph not found");
        }
    }

    @PUT
    @Path(value="{noteId}/permissions")
    @ZeppelinApi
    public Response putNotePermissions(@PathParam(value="noteId") String noteId, String req) throws IOException {
        String principal = this.authenticationService.getPrincipal();
        Set<String> roles = this.authenticationService.getAssociatedRoles();
        HashSet<String> userAndRoles = new HashSet<String>();
        userAndRoles.add(principal);
        userAndRoles.addAll(roles);
        this.checkIfUserIsAnon(this.getBlockNotAuthenticatedUserErrorMsg());
        this.checkIfUserIsOwner(noteId, this.ownerPermissionError(userAndRoles, this.authorizationService.getOwners(noteId)));
        HashMap permMap = (HashMap)gson.fromJson(req, new TypeToken<HashMap<String, HashSet<String>>>(){}.getType());
        Note note = this.notebook.getNote(noteId);
        this.checkIfNoteIsNotNull(note);
        LOG.info("Set permissions {} {} {} {} {} {}", new Object[]{noteId, principal, permMap.get("owners"), permMap.get("readers"), permMap.get("runners"), permMap.get("writers")});
        HashSet readers = (HashSet)permMap.get("readers");
        HashSet runners = (HashSet)permMap.get("runners");
        HashSet owners = (HashSet)permMap.get("owners");
        HashSet writers = (HashSet)permMap.get("writers");
        if (readers != null && !readers.isEmpty()) {
            if (runners.isEmpty()) {
                runners = Sets.newHashSet((Object[])new String[]{this.authenticationService.getPrincipal()});
            }
            if (writers.isEmpty()) {
                writers = Sets.newHashSet((Object[])new String[]{this.authenticationService.getPrincipal()});
            }
            if (owners.isEmpty()) {
                owners = Sets.newHashSet((Object[])new String[]{this.authenticationService.getPrincipal()});
            }
        }
        if (runners != null && !runners.isEmpty()) {
            if (writers.isEmpty()) {
                writers = Sets.newHashSet((Object[])new String[]{this.authenticationService.getPrincipal()});
            }
            if (owners.isEmpty()) {
                owners = Sets.newHashSet((Object[])new String[]{this.authenticationService.getPrincipal()});
            }
        }
        if (writers != null && !writers.isEmpty() && owners.isEmpty()) {
            owners = Sets.newHashSet((Object[])new String[]{this.authenticationService.getPrincipal()});
        }
        this.authorizationService.setReaders(noteId, (Set)readers);
        this.authorizationService.setRunners(noteId, (Set)runners);
        this.authorizationService.setWriters(noteId, (Set)writers);
        this.authorizationService.setOwners(noteId, (Set)owners);
        LOG.debug("After set permissions {} {} {} {}", new Object[]{this.authorizationService.getOwners(noteId), this.authorizationService.getReaders(noteId), this.authorizationService.getRunners(noteId), this.authorizationService.getWriters(noteId)});
        AuthenticationInfo subject = new AuthenticationInfo(this.authenticationService.getPrincipal());
        this.authorizationService.saveNoteAuth(noteId, subject);
        this.notebookServer.broadcastNote(note);
        this.notebookServer.broadcastNoteList(subject, userAndRoles);
        return new JsonResponse(Response.Status.OK).build();
    }

    @GET
    @ZeppelinApi
    public Response getNoteList() throws IOException {
        List<NoteInfo> notesInfo = this.notebookService.listNotesInfo(false, this.getServiceContext(), new AbstractRestApi.RestServiceCallback<List<NoteInfo>>());
        return new JsonResponse<List<NoteInfo>>(Response.Status.OK, "", notesInfo).build();
    }

    @GET
    @Path(value="{noteId}")
    @ZeppelinApi
    public Response getNote(@PathParam(value="noteId") String noteId) throws IOException {
        Note note = this.notebookService.getNote(noteId, this.getServiceContext(), new AbstractRestApi.RestServiceCallback<Note>());
        return new JsonResponse<Note>(Response.Status.OK, "", note).build();
    }

    @GET
    @Path(value="export/{noteId}")
    @ZeppelinApi
    public Response exportNote(@PathParam(value="noteId") String noteId) throws IOException {
        this.checkIfUserCanRead(noteId, "Insufficient privileges you cannot export this note");
        String exportJson = this.notebook.exportNote(noteId);
        return new JsonResponse<String>(Response.Status.OK, "", exportJson).build();
    }

    @POST
    @Path(value="import")
    @ZeppelinApi
    public Response importNote(String noteJson) throws IOException {
        Note note = this.notebookService.importNote(null, noteJson, this.getServiceContext(), new AbstractRestApi.RestServiceCallback<Note>());
        return new JsonResponse<String>(Response.Status.OK, "", note.getId()).build();
    }

    @POST
    @ZeppelinApi
    public Response createNote(String message) throws IOException {
        String user = this.authenticationService.getPrincipal();
        LOG.info("Create new note by JSON {}", (Object)message);
        NewNoteRequest request = NewNoteRequest.fromJson(message);
        Note note = this.notebookService.createNote(request.getName(), this.zConf.getString(ZeppelinConfiguration.ConfVars.ZEPPELIN_INTERPRETER_GROUP_DEFAULT), this.getServiceContext(), new AbstractRestApi.RestServiceCallback<Note>());
        AuthenticationInfo subject = new AuthenticationInfo(this.authenticationService.getPrincipal());
        if (request.getParagraphs() != null) {
            for (NewParagraphRequest paragraphRequest : request.getParagraphs()) {
                Paragraph p = note.addNewParagraph(subject);
                this.initParagraph(p, paragraphRequest, user);
            }
        }
        return new JsonResponse<String>(Response.Status.OK, "", note.getId()).build();
    }

    @DELETE
    @Path(value="{noteId}")
    @ZeppelinApi
    public Response deleteNote(@PathParam(value="noteId") String noteId) throws IOException {
        LOG.info("Delete note {} ", (Object)noteId);
        this.notebookService.removeNote(noteId, this.getServiceContext(), (ServiceCallback<String>)new AbstractRestApi.RestServiceCallback<String>(){

            @Override
            public void onSuccess(String message, ServiceContext context) {
                NotebookRestApi.this.notebookServer.broadcastNoteList(context.getAutheInfo(), context.getUserAndRoles());
            }
        });
        return new JsonResponse<String>(Response.Status.OK, "").build();
    }

    @POST
    @Path(value="{noteId}")
    @ZeppelinApi
    public Response cloneNote(@PathParam(value="noteId") String noteId, String message) throws IOException, IllegalArgumentException {
        LOG.info("clone note by JSON {}", (Object)message);
        this.checkIfUserCanWrite(noteId, "Insufficient privileges you cannot clone this note");
        NewNoteRequest request = NewNoteRequest.fromJson(message);
        String newNoteName = null;
        if (request != null) {
            newNoteName = request.getName();
        }
        final AuthenticationInfo subject = new AuthenticationInfo(this.authenticationService.getPrincipal());
        Note newNote = this.notebookService.cloneNote(noteId, newNoteName, this.getServiceContext(), (ServiceCallback<Note>)new AbstractRestApi.RestServiceCallback<Note>(){

            @Override
            public void onSuccess(Note newNote, ServiceContext context) throws IOException {
                NotebookRestApi.this.notebookServer.broadcastNote(newNote);
                NotebookRestApi.this.notebookServer.broadcastNoteList(subject, context.getUserAndRoles());
            }
        });
        return new JsonResponse<String>(Response.Status.OK, "", newNote.getId()).build();
    }

    @PUT
    @Path(value="{noteId}/rename")
    @ZeppelinApi
    public Response renameNote(@PathParam(value="noteId") String noteId, String message) throws IOException {
        LOG.info("rename note by JSON {}", (Object)message);
        RenameNoteRequest request = (RenameNoteRequest)gson.fromJson(message, RenameNoteRequest.class);
        String newName = request.getName();
        if (newName.isEmpty()) {
            LOG.warn("Trying to rename notebook {} with empty name parameter", (Object)noteId);
            throw new BadRequestException("name can not be empty");
        }
        this.notebookService.renameNote(noteId, request.getName(), false, this.getServiceContext(), (ServiceCallback<Note>)new AbstractRestApi.RestServiceCallback<Note>(){

            @Override
            public void onSuccess(Note note, ServiceContext context) throws IOException {
                NotebookRestApi.this.notebookServer.broadcastNote(note);
                NotebookRestApi.this.notebookServer.broadcastNoteList(context.getAutheInfo(), context.getUserAndRoles());
            }
        });
        return new JsonResponse<String>(Response.Status.OK, "").build();
    }

    @POST
    @Path(value="{noteId}/paragraph")
    @ZeppelinApi
    public Response insertParagraph(@PathParam(value="noteId") String noteId, String message) throws IOException {
        String user = this.authenticationService.getPrincipal();
        LOG.info("insert paragraph {} {}", (Object)noteId, (Object)message);
        Note note = this.notebook.getNote(noteId);
        this.checkIfNoteIsNotNull(note);
        this.checkIfUserCanWrite(noteId, "Insufficient privileges you cannot add paragraph to this note");
        NewParagraphRequest request = NewParagraphRequest.fromJson(message);
        AuthenticationInfo subject = new AuthenticationInfo(user);
        Double indexDouble = request.getIndex();
        Paragraph p = indexDouble == null ? note.addNewParagraph(subject) : note.insertNewParagraph(indexDouble.intValue(), subject);
        this.initParagraph(p, request, user);
        this.notebook.saveNote(note, subject);
        this.notebookServer.broadcastNote(note);
        return new JsonResponse<String>(Response.Status.OK, "", p.getId()).build();
    }

    @GET
    @Path(value="{noteId}/paragraph/{paragraphId}")
    @ZeppelinApi
    public Response getParagraph(@PathParam(value="noteId") String noteId, @PathParam(value="paragraphId") String paragraphId) throws IOException {
        LOG.info("get paragraph {} {}", (Object)noteId, (Object)paragraphId);
        Note note = this.notebook.getNote(noteId);
        this.checkIfNoteIsNotNull(note);
        this.checkIfUserCanRead(noteId, "Insufficient privileges you cannot get this paragraph");
        Paragraph p = note.getParagraph(paragraphId);
        this.checkIfParagraphIsNotNull(p);
        return new JsonResponse<Paragraph>(Response.Status.OK, "", p).build();
    }

    @PUT
    @Path(value="{noteId}/paragraph/{paragraphId}")
    @ZeppelinApi
    public Response updateParagraph(@PathParam(value="noteId") String noteId, @PathParam(value="paragraphId") String paragraphId, String message) throws IOException {
        String user = this.authenticationService.getPrincipal();
        LOG.info("{} will update paragraph {} {}", new Object[]{user, noteId, paragraphId});
        Note note = this.notebook.getNote(noteId);
        this.checkIfNoteIsNotNull(note);
        this.checkIfUserCanWrite(noteId, "Insufficient privileges you cannot update this paragraph");
        Paragraph p = note.getParagraph(paragraphId);
        this.checkIfParagraphIsNotNull(p);
        UpdateParagraphRequest updatedParagraph = (UpdateParagraphRequest)gson.fromJson(message, UpdateParagraphRequest.class);
        p.setText(updatedParagraph.getText());
        if (updatedParagraph.getTitle() != null) {
            p.setTitle(updatedParagraph.getTitle());
        }
        AuthenticationInfo subject = new AuthenticationInfo(user);
        this.notebook.saveNote(note, subject);
        this.notebookServer.broadcastParagraph(note, p);
        return new JsonResponse<String>(Response.Status.OK, "").build();
    }

    @PUT
    @Path(value="{noteId}/paragraph/{paragraphId}/config")
    @ZeppelinApi
    public Response updateParagraphConfig(@PathParam(value="noteId") String noteId, @PathParam(value="paragraphId") String paragraphId, String message) throws IOException {
        String user = this.authenticationService.getPrincipal();
        LOG.info("{} will update paragraph config {} {}", new Object[]{user, noteId, paragraphId});
        Note note = this.notebook.getNote(noteId);
        this.checkIfNoteIsNotNull(note);
        this.checkIfUserCanWrite(noteId, "Insufficient privileges you cannot update this paragraph config");
        Paragraph p = note.getParagraph(paragraphId);
        this.checkIfParagraphIsNotNull(p);
        Map newConfig = (Map)gson.fromJson(message, HashMap.class);
        this.configureParagraph(p, newConfig, user);
        AuthenticationInfo subject = new AuthenticationInfo(user);
        this.notebook.saveNote(note, subject);
        return new JsonResponse<Paragraph>(Response.Status.OK, "", p).build();
    }

    @POST
    @Path(value="{noteId}/paragraph/{paragraphId}/move/{newIndex}")
    @ZeppelinApi
    public Response moveParagraph(@PathParam(value="noteId") String noteId, @PathParam(value="paragraphId") String paragraphId, @PathParam(value="newIndex") String newIndex) throws IOException {
        LOG.info("move paragraph {} {} {}", new Object[]{noteId, paragraphId, newIndex});
        this.notebookService.moveParagraph(noteId, paragraphId, Integer.parseInt(newIndex), this.getServiceContext(), (ServiceCallback<Paragraph>)new AbstractRestApi.RestServiceCallback<Paragraph>(){

            @Override
            public void onSuccess(Paragraph result, ServiceContext context) throws IOException {
                NotebookRestApi.this.notebookServer.broadcastNote(result.getNote());
            }
        });
        return new JsonResponse<String>(Response.Status.OK, "").build();
    }

    @DELETE
    @Path(value="{noteId}/paragraph/{paragraphId}")
    @ZeppelinApi
    public Response deleteParagraph(@PathParam(value="noteId") String noteId, @PathParam(value="paragraphId") String paragraphId) throws IOException {
        LOG.info("delete paragraph {} {}", (Object)noteId, (Object)paragraphId);
        this.notebookService.removeParagraph(noteId, paragraphId, this.getServiceContext(), (ServiceCallback<Paragraph>)new AbstractRestApi.RestServiceCallback<Paragraph>(){

            @Override
            public void onSuccess(Paragraph p, ServiceContext context) throws IOException {
                NotebookRestApi.this.notebookServer.broadcastNote(p.getNote());
            }
        });
        return new JsonResponse<String>(Response.Status.OK, "").build();
    }

    @PUT
    @Path(value="{noteId}/clear")
    @ZeppelinApi
    public Response clearAllParagraphOutput(@PathParam(value="noteId") String noteId) throws IOException {
        LOG.info("clear all paragraph output of note {}", (Object)noteId);
        this.notebookService.clearAllParagraphOutput(noteId, this.getServiceContext(), new AbstractRestApi.RestServiceCallback<Note>());
        return new JsonResponse<String>(Response.Status.OK, "").build();
    }

    @POST
    @Path(value="job/{noteId}")
    @ZeppelinApi
    public Response runNoteJobs(@PathParam(value="noteId") String noteId, @QueryParam(value="waitToFinish") Boolean waitToFinish) throws IOException, IllegalArgumentException {
        boolean blocking = waitToFinish == null || waitToFinish != false;
        LOG.info("run note jobs {} waitToFinish: {}", (Object)noteId, (Object)blocking);
        Note note = this.notebook.getNote(noteId);
        AuthenticationInfo subject = new AuthenticationInfo(this.authenticationService.getPrincipal());
        subject.setRoles(new LinkedList<String>(this.authenticationService.getAssociatedRoles()));
        this.checkIfNoteIsNotNull(note);
        this.checkIfUserCanRun(noteId, "Insufficient privileges you cannot run job for this note");
        try {
            note.runAll(subject, blocking);
        }
        catch (Exception ex) {
            LOG.error("Exception from run", (Throwable)ex);
            return new JsonResponse<String>(Response.Status.EXPECTATION_FAILED, ex.getMessage()).build();
        }
        return new JsonResponse(Response.Status.OK).build();
    }

    @DELETE
    @Path(value="job/{noteId}")
    @ZeppelinApi
    public Response stopNoteJobs(@PathParam(value="noteId") String noteId) throws IOException, IllegalArgumentException {
        LOG.info("stop note jobs {} ", (Object)noteId);
        Note note = this.notebook.getNote(noteId);
        this.checkIfNoteIsNotNull(note);
        this.checkIfUserCanRun(noteId, "Insufficient privileges you cannot stop this job for this note");
        for (Paragraph p : note.getParagraphs()) {
            if (p.isTerminated()) continue;
            p.abort();
        }
        return new JsonResponse(Response.Status.OK).build();
    }

    @GET
    @Path(value="job/{noteId}")
    @ZeppelinApi
    public Response getNoteJobStatus(@PathParam(value="noteId") String noteId) throws IOException, IllegalArgumentException {
        LOG.info("get note job status.");
        Note note = this.notebook.getNote(noteId);
        this.checkIfNoteIsNotNull(note);
        this.checkIfUserCanRead(noteId, "Insufficient privileges you cannot get job status");
        return new JsonResponse<List>(Response.Status.OK, null, note.generateParagraphsInfo()).build();
    }

    @GET
    @Path(value="job/{noteId}/{paragraphId}")
    @ZeppelinApi
    public Response getNoteParagraphJobStatus(@PathParam(value="noteId") String noteId, @PathParam(value="paragraphId") String paragraphId) throws IOException, IllegalArgumentException {
        LOG.info("get note paragraph job status.");
        Note note = this.notebook.getNote(noteId);
        this.checkIfNoteIsNotNull(note);
        this.checkIfUserCanRead(noteId, "Insufficient privileges you cannot get job status");
        Paragraph paragraph = note.getParagraph(paragraphId);
        this.checkIfParagraphIsNotNull(paragraph);
        return new JsonResponse<Map>(Response.Status.OK, null, note.generateSingleParagraphInfo(paragraphId)).build();
    }

    @POST
    @Path(value="job/{noteId}/{paragraphId}")
    @ZeppelinApi
    public Response runParagraph(@PathParam(value="noteId") String noteId, @PathParam(value="paragraphId") String paragraphId, String message) throws IOException, IllegalArgumentException {
        LOG.info("run paragraph job asynchronously {} {} {}", new Object[]{noteId, paragraphId, message});
        Note note = this.notebook.getNote(noteId);
        this.checkIfNoteIsNotNull(note);
        Paragraph paragraph = note.getParagraph(paragraphId);
        this.checkIfParagraphIsNotNull(paragraph);
        HashMap<String, Object> params = new HashMap();
        if (!StringUtils.isEmpty((CharSequence)message)) {
            RunParagraphWithParametersRequest request = RunParagraphWithParametersRequest.fromJson(message);
            params = request.getParams();
        }
        this.notebookService.runParagraph(noteId, paragraphId, paragraph.getTitle(), paragraph.getText(), params, new HashMap<String, Object>(), false, false, this.getServiceContext(), new AbstractRestApi.RestServiceCallback<Paragraph>());
        return new JsonResponse(Response.Status.OK).build();
    }

    @POST
    @Path(value="run/{noteId}/{paragraphId}")
    @ZeppelinApi
    public Response runParagraphSynchronously(@PathParam(value="noteId") String noteId, @PathParam(value="paragraphId") String paragraphId, String message) throws IOException, IllegalArgumentException {
        LOG.info("run paragraph synchronously {} {} {}", new Object[]{noteId, paragraphId, message});
        Note note = this.notebook.getNote(noteId);
        this.checkIfNoteIsNotNull(note);
        Paragraph paragraph = note.getParagraph(paragraphId);
        this.checkIfParagraphIsNotNull(paragraph);
        HashMap<String, Object> params = new HashMap();
        if (!StringUtils.isEmpty((CharSequence)message)) {
            RunParagraphWithParametersRequest request = RunParagraphWithParametersRequest.fromJson(message);
            params = request.getParams();
        }
        if (this.notebookService.runParagraph(noteId, paragraphId, paragraph.getTitle(), paragraph.getText(), params, new HashMap<String, Object>(), false, true, this.getServiceContext(), new AbstractRestApi.RestServiceCallback<Paragraph>())) {
            note = this.notebookService.getNote(noteId, this.getServiceContext(), new AbstractRestApi.RestServiceCallback<Note>());
            Paragraph p = note.getParagraph(paragraphId);
            InterpreterResult result = p.getReturn();
            if (result.code() == InterpreterResult.Code.SUCCESS) {
                return new JsonResponse<InterpreterResult>(Response.Status.OK, result).build();
            }
            return new JsonResponse<InterpreterResult>(Response.Status.INTERNAL_SERVER_ERROR, result).build();
        }
        return new JsonResponse<String>(Response.Status.INTERNAL_SERVER_ERROR, "Fail to run paragraph").build();
    }

    @DELETE
    @Path(value="job/{noteId}/{paragraphId}")
    @ZeppelinApi
    public Response cancelParagraph(@PathParam(value="noteId") String noteId, @PathParam(value="paragraphId") String paragraphId) throws IOException, IllegalArgumentException {
        LOG.info("stop paragraph job {} ", (Object)noteId);
        this.notebookService.cancelParagraph(noteId, paragraphId, this.getServiceContext(), new AbstractRestApi.RestServiceCallback<Paragraph>());
        return new JsonResponse(Response.Status.OK).build();
    }

    @POST
    @Path(value="cron/{noteId}")
    @ZeppelinApi
    public Response registerCronJob(@PathParam(value="noteId") String noteId, String message) throws IOException, IllegalArgumentException {
        LOG.info("Register cron job note={} request cron msg={}", (Object)noteId, (Object)message);
        CronRequest request = CronRequest.fromJson(message);
        Note note = this.notebook.getNote(noteId);
        this.checkIfNoteIsNotNull(note);
        this.checkIfUserCanRun(noteId, "Insufficient privileges you cannot set a cron job for this note");
        this.checkIfNoteSupportsCron(note);
        if (!CronExpression.isValidExpression((String)request.getCronString())) {
            return new JsonResponse<String>(Response.Status.BAD_REQUEST, "wrong cron expressions.").build();
        }
        Map config = note.getConfig();
        config.put("cron", request.getCronString());
        config.put("releaseresource", request.getReleaseResource());
        note.setConfig(config);
        this.schedulerService.refreshCron(note.getId());
        return new JsonResponse(Response.Status.OK).build();
    }

    @DELETE
    @Path(value="cron/{noteId}")
    @ZeppelinApi
    public Response removeCronJob(@PathParam(value="noteId") String noteId) throws IOException, IllegalArgumentException {
        LOG.info("Remove cron job note {}", (Object)noteId);
        Note note = this.notebook.getNote(noteId);
        this.checkIfNoteIsNotNull(note);
        this.checkIfUserIsOwner(noteId, "Insufficient privileges you cannot remove this cron job from this note");
        this.checkIfNoteSupportsCron(note);
        Map config = note.getConfig();
        config.remove("cron");
        config.remove("releaseresource");
        note.setConfig(config);
        this.schedulerService.refreshCron(note.getId());
        return new JsonResponse(Response.Status.OK).build();
    }

    @GET
    @Path(value="cron/{noteId}")
    @ZeppelinApi
    public Response getCronJob(@PathParam(value="noteId") String noteId) throws IOException, IllegalArgumentException {
        LOG.info("Get cron job note {}", (Object)noteId);
        Note note = this.notebook.getNote(noteId);
        this.checkIfNoteIsNotNull(note);
        this.checkIfUserCanRead(noteId, "Insufficient privileges you cannot get cron information");
        this.checkIfNoteSupportsCron(note);
        HashMap response = new HashMap();
        response.put("cron", note.getConfig().get("cron"));
        response.put("releaseResource", note.getConfig().get("releaseresource"));
        return new JsonResponse(Response.Status.OK, response).build();
    }

    @GET
    @Path(value="jobmanager/")
    @ZeppelinApi
    public Response getJobListforNote() throws IOException, IllegalArgumentException {
        LOG.info("Get note jobs for job manager");
        List<JobManagerService.NoteJobInfo> noteJobs = this.jobManagerService.getNoteJobInfoByUnixTime(0L, this.getServiceContext(), new AbstractRestApi.RestServiceCallback<List<JobManagerService.NoteJobInfo>>());
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("lastResponseUnixTime", System.currentTimeMillis());
        response.put("jobs", noteJobs);
        return new JsonResponse(Response.Status.OK, response).build();
    }

    @GET
    @Path(value="jobmanager/{lastUpdateUnixtime}/")
    @ZeppelinApi
    public Response getUpdatedJobListforNote(@PathParam(value="lastUpdateUnixtime") long lastUpdateUnixTime) throws IOException, IllegalArgumentException {
        LOG.info("Get updated note jobs lastUpdateTime {}", (Object)lastUpdateUnixTime);
        List<JobManagerService.NoteJobInfo> noteJobs = this.jobManagerService.getNoteJobInfoByUnixTime(lastUpdateUnixTime, this.getServiceContext(), new AbstractRestApi.RestServiceCallback<List<JobManagerService.NoteJobInfo>>());
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("lastResponseUnixTime", System.currentTimeMillis());
        response.put("jobs", noteJobs);
        return new JsonResponse(Response.Status.OK, response).build();
    }

    @GET
    @Path(value="search")
    @ZeppelinApi
    public Response search(@QueryParam(value="q") String queryTerm) {
        LOG.info("Searching notes for: {}", (Object)queryTerm);
        String principal = this.authenticationService.getPrincipal();
        Set<String> roles = this.authenticationService.getAssociatedRoles();
        HashSet<String> userAndRoles = new HashSet<String>();
        userAndRoles.add(principal);
        userAndRoles.addAll(roles);
        List notesFound = this.noteSearchService.query(queryTerm);
        for (int i = 0; i < notesFound.size(); ++i) {
            String[] ids = ((String)((Map)notesFound.get(i)).get("id")).split("/", 2);
            String noteId = ids[0];
            if (this.authorizationService.isOwner(noteId, userAndRoles) || this.authorizationService.isReader(noteId, userAndRoles) || this.authorizationService.isWriter(noteId, userAndRoles) || this.authorizationService.isRunner(noteId, userAndRoles)) continue;
            notesFound.remove(i);
            --i;
        }
        LOG.info("{} notes found", (Object)notesFound.size());
        return new JsonResponse<List>(Response.Status.OK, notesFound).build();
    }

    private void handleParagraphParams(String message, Note note, Paragraph paragraph) throws IOException {
        RunParagraphWithParametersRequest request;
        Map<String, Object> paramsForUpdating;
        if (!StringUtils.isEmpty((CharSequence)message) && (paramsForUpdating = (request = RunParagraphWithParametersRequest.fromJson(message)).getParams()) != null) {
            paragraph.settings.getParams().putAll(paramsForUpdating);
            AuthenticationInfo subject = new AuthenticationInfo(this.authenticationService.getPrincipal());
            this.notebook.saveNote(note, subject);
        }
    }

    private void initParagraph(Paragraph p, NewParagraphRequest request, String user) {
        LOG.info("Init Paragraph for user {}", (Object)user);
        this.checkIfParagraphIsNotNull(p);
        p.setTitle(request.getTitle());
        p.setText(request.getText());
        HashMap<String, Object> config = request.getConfig();
        if (config != null && !config.isEmpty()) {
            this.configureParagraph(p, config, user);
        }
    }

    private void configureParagraph(Paragraph p, Map<String, Object> newConfig, String user) {
        LOG.info("Configure Paragraph for user {}", (Object)user);
        if (newConfig == null || newConfig.isEmpty()) {
            LOG.warn("{} is trying to update paragraph {} of note {} with empty config", new Object[]{user, p.getId(), p.getNote().getId()});
            throw new BadRequestException("paragraph config cannot be empty");
        }
        Map origConfig = p.getConfig();
        for (Map.Entry<String, Object> entry : newConfig.entrySet()) {
            origConfig.put(entry.getKey(), entry.getValue());
        }
        p.setConfig(origConfig);
    }
}

