/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.rest;

import java.util.HashMap;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.zeppelin.annotation.ZeppelinApi;
import org.apache.zeppelin.server.JsonResponse;
import org.apache.zeppelin.util.Util;

@Path(value="/")
@Singleton
public class ZeppelinRestApi {
    @GET
    public Response getRoot() {
        return Response.ok().build();
    }

    @GET
    @Path(value="version")
    @ZeppelinApi
    public Response getVersion() {
        HashMap<String, String> versionInfo = new HashMap<String, String>();
        versionInfo.put("version", Util.getVersion());
        versionInfo.put("git-commit-id", Util.getGitCommitId());
        versionInfo.put("git-timestamp", Util.getGitTimestamp());
        return new JsonResponse(Response.Status.OK, "Zeppelin version", versionInfo).build();
    }

    @PUT
    @Path(value="log/level/{logLevel}")
    public Response changeRootLogLevel(@Context HttpServletRequest request, @PathParam(value="logLevel") String logLevel) {
        Level level = Level.toLevel((String)logLevel);
        if (logLevel.toLowerCase().equalsIgnoreCase(level.toString().toLowerCase())) {
            Logger.getRootLogger().setLevel(level);
            return new JsonResponse(Response.Status.OK).build();
        }
        return new JsonResponse<String>(Response.Status.NOT_ACCEPTABLE, "Please check LOG level specified. Valid values: DEBUG, ERROR, FATAL, INFO, TRACE, WARN").build();
    }
}

