/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.service;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.inject.Inject;
import jline.internal.Preconditions;
import org.apache.commons.io.FileUtils;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.dep.DependencyResolver;
import org.apache.zeppelin.interpreter.InterpreterSettingManager;
import org.apache.zeppelin.rest.message.InterpreterInstallationRequest;
import org.apache.zeppelin.service.ServiceCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.aether.RepositoryException;

public class InterpreterService {
    private static final String ZEPPELIN_ARTIFACT_PREFIX = "zeppelin-";
    private static final Logger logger = LoggerFactory.getLogger(InterpreterService.class);
    private static final ExecutorService executorService = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat(InterpreterService.class.getSimpleName() + "-").build());
    private final ZeppelinConfiguration conf;
    private final InterpreterSettingManager interpreterSettingManager;

    @Inject
    public InterpreterService(ZeppelinConfiguration conf, InterpreterSettingManager interpreterSettingManager) {
        this.conf = conf;
        this.interpreterSettingManager = interpreterSettingManager;
    }

    public void installInterpreter(final InterpreterInstallationRequest request, final ServiceCallback serviceCallback) throws Exception {
        Preconditions.checkNotNull((Object)request);
        String interpreterName = request.getName();
        Preconditions.checkNotNull((Object)interpreterName);
        Preconditions.checkNotNull((Object)request.getArtifact());
        String interpreterBaseDir = this.conf.getInterpreterDir();
        String localRepoPath = this.conf.getInterpreterLocalRepoPath();
        final DependencyResolver dependencyResolver = new DependencyResolver(localRepoPath);
        String proxyUrl = this.conf.getZeppelinProxyUrl();
        if (null != proxyUrl) {
            String proxyUser = this.conf.getZeppelinProxyUser();
            String proxyPassword = this.conf.getZeppelinProxyPassword();
            try {
                dependencyResolver.setProxy(new URL(proxyUrl), proxyUser, proxyPassword);
            }
            catch (MalformedURLException e) {
                throw new Exception("Url is not valid format", e);
            }
        }
        ArrayList possibleInterpreterDirectories = Lists.newArrayList();
        possibleInterpreterDirectories.add(interpreterName);
        if (interpreterName.startsWith(ZEPPELIN_ARTIFACT_PREFIX)) {
            possibleInterpreterDirectories.add(interpreterName.replace(ZEPPELIN_ARTIFACT_PREFIX, ""));
        } else {
            possibleInterpreterDirectories.add(ZEPPELIN_ARTIFACT_PREFIX + interpreterName);
        }
        for (String pn : possibleInterpreterDirectories) {
            Path testInterpreterDir = Paths.get(interpreterBaseDir, pn);
            if (!Files.exists(testInterpreterDir, new LinkOption[0])) continue;
            throw new Exception("Interpreter " + interpreterName + " already exists with " + pn);
        }
        final Path interpreterDir = Paths.get(interpreterBaseDir, interpreterName);
        try {
            Files.createDirectories(interpreterDir, new FileAttribute[0]);
        }
        catch (Exception e) {
            throw new Exception("Cannot create " + interpreterDir.toString());
        }
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                InterpreterService.this.downloadInterpreter(request, dependencyResolver, interpreterDir, serviceCallback);
            }
        });
    }

    void downloadInterpreter(InterpreterInstallationRequest request, DependencyResolver dependencyResolver, Path interpreterDir, ServiceCallback<String> serviceCallback) {
        block8: {
            try {
                logger.info("Start to download a dependency: {}", (Object)request.getName());
                if (null != serviceCallback) {
                    serviceCallback.onStart("Starting to download " + request.getName() + " interpreter", null);
                }
                dependencyResolver.load(request.getArtifact(), interpreterDir.toFile());
                this.interpreterSettingManager.refreshInterpreterTemplates();
                logger.info("Finish downloading a dependency {} into {}", (Object)request.getName(), (Object)interpreterDir.toString());
                if (null != serviceCallback) {
                    serviceCallback.onSuccess(request.getName() + " downloaded", null);
                }
            }
            catch (IOException | RepositoryException e) {
                logger.error("Error while downloading dependencies", e);
                try {
                    FileUtils.deleteDirectory((File)interpreterDir.toFile());
                }
                catch (IOException e1) {
                    logger.error("Error while removing directory. You should handle it manually: {}", (Object)interpreterDir.toString(), (Object)e1);
                }
                if (null == serviceCallback) break block8;
                try {
                    serviceCallback.onFailure(new Exception("Error while downloading " + request.getName() + " as " + e.getMessage()), null);
                }
                catch (IOException e1) {
                    logger.error("ServiceCallback failure", (Throwable)e1);
                }
            }
        }
    }
}

