/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.service;

import com.google.common.base.Strings;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.display.AngularObject;
import org.apache.zeppelin.display.AngularObjectRegistry;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.InterpreterSetting;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;
import org.apache.zeppelin.notebook.AuthorizationService;
import org.apache.zeppelin.notebook.Note;
import org.apache.zeppelin.notebook.NoteInfo;
import org.apache.zeppelin.notebook.NoteManager;
import org.apache.zeppelin.notebook.Notebook;
import org.apache.zeppelin.notebook.Paragraph;
import org.apache.zeppelin.notebook.repo.NotebookRepoWithVersionControl;
import org.apache.zeppelin.notebook.scheduler.SchedulerService;
import org.apache.zeppelin.notebook.socket.Message;
import org.apache.zeppelin.rest.exception.BadRequestException;
import org.apache.zeppelin.rest.exception.ForbiddenException;
import org.apache.zeppelin.rest.exception.NoteNotFoundException;
import org.apache.zeppelin.rest.exception.ParagraphNotFoundException;
import org.apache.zeppelin.scheduler.Job;
import org.apache.zeppelin.service.ServiceCallback;
import org.apache.zeppelin.service.ServiceContext;
import org.apache.zeppelin.user.AuthenticationInfo;
import org.bitbucket.cowwoc.diffmatchpatch.DiffMatchPatch;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotebookService {
    private static final Logger LOGGER = LoggerFactory.getLogger(NotebookService.class);
    private static final DateTimeFormatter TRASH_CONFLICT_TIMESTAMP_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
    private ZeppelinConfiguration zConf;
    private Notebook notebook;
    private AuthorizationService authorizationService;
    private SchedulerService schedulerService;

    @Inject
    public NotebookService(Notebook notebook, AuthorizationService authorizationService, ZeppelinConfiguration zeppelinConfiguration, SchedulerService schedulerService) {
        this.notebook = notebook;
        this.authorizationService = authorizationService;
        this.zConf = zeppelinConfiguration;
        this.schedulerService = schedulerService;
    }

    public Note getHomeNote(ServiceContext context, ServiceCallback<Note> callback) throws IOException {
        String noteId = this.notebook.getConf().getString(ZeppelinConfiguration.ConfVars.ZEPPELIN_NOTEBOOK_HOMESCREEN);
        Note note = null;
        if (noteId != null && (note = this.notebook.getNote(noteId)) != null && !this.checkPermission(noteId, Permission.READER, Message.OP.GET_HOME_NOTE, context, callback)) {
            return null;
        }
        callback.onSuccess(note, context);
        return note;
    }

    public Note getNote(String noteId, ServiceContext context, ServiceCallback<Note> callback) throws IOException {
        Note note = this.notebook.getNote(noteId);
        if (note == null) {
            callback.onFailure((Exception)((Object)new NoteNotFoundException(noteId)), context);
            return null;
        }
        if (!this.checkPermission(noteId, Permission.READER, Message.OP.GET_NOTE, context, callback)) {
            return null;
        }
        if (note.isPersonalizedMode()) {
            note = note.getUserNote(context.getAutheInfo().getUser());
        }
        callback.onSuccess(note, context);
        return note;
    }

    public Note createNote(String notePath, String defaultInterpreterGroup, ServiceContext context, ServiceCallback<Note> callback) throws IOException {
        if (defaultInterpreterGroup == null) {
            defaultInterpreterGroup = this.zConf.getString(ZeppelinConfiguration.ConfVars.ZEPPELIN_INTERPRETER_GROUP_DEFAULT);
        }
        try {
            Note note = this.notebook.createNote(this.normalizeNotePath(notePath), defaultInterpreterGroup, context.getAutheInfo(), false);
            note.addNewParagraph(context.getAutheInfo());
            this.notebook.saveNote(note, context.getAutheInfo());
            callback.onSuccess(note, context);
            return note;
        }
        catch (IOException e) {
            callback.onFailure(e, context);
            return null;
        }
    }

    String normalizeNotePath(String notePath) throws IOException {
        if (StringUtils.isBlank((CharSequence)notePath)) {
            notePath = "/Untitled Note";
        }
        if (!notePath.startsWith("/")) {
            notePath = "/" + notePath;
        }
        notePath = notePath.replace("\r", " ").replace("\n", " ");
        int pos = notePath.lastIndexOf("/");
        if (notePath.length() - pos > 255) {
            throw new IOException("Note name must be less than 255");
        }
        if (notePath.contains("..")) {
            throw new IOException("Note name can not contain '..'");
        }
        return notePath;
    }

    public void removeNote(String noteId, ServiceContext context, ServiceCallback<String> callback) throws IOException {
        if (this.notebook.getNote(noteId) != null) {
            if (!this.checkPermission(noteId, Permission.OWNER, Message.OP.DEL_NOTE, context, callback)) {
                return;
            }
            this.notebook.removeNote(noteId, context.getAutheInfo());
            callback.onSuccess("Delete note successfully", context);
        } else {
            callback.onFailure((Exception)((Object)new NoteNotFoundException(noteId)), context);
        }
    }

    public List<NoteInfo> listNotesInfo(boolean needsReload, ServiceContext context, ServiceCallback<List<NoteInfo>> callback) throws IOException {
        if (needsReload) {
            try {
                this.notebook.reloadAllNotes(context.getAutheInfo());
            }
            catch (IOException e) {
                LOGGER.error("Fail to reload notes from repository", (Throwable)e);
            }
        }
        List notesInfo = this.notebook.getNotesInfo(noteId -> this.authorizationService.isReader(noteId, context.getUserAndRoles()));
        callback.onSuccess(notesInfo, context);
        return notesInfo;
    }

    public void renameNote(String noteId, String newNotePath, boolean isRelative, ServiceContext context, ServiceCallback<Note> callback) throws IOException {
        if (!this.checkPermission(noteId, Permission.OWNER, Message.OP.NOTE_RENAME, context, callback)) {
            return;
        }
        Note note = this.notebook.getNote(noteId);
        if (note != null) {
            note.setCronSupported(this.notebook.getConf());
            if (isRelative && !note.getParentPath().equals("/")) {
                newNotePath = note.getParentPath() + "/" + newNotePath;
            } else if (!newNotePath.startsWith("/")) {
                newNotePath = "/" + newNotePath;
            }
            this.notebook.moveNote(noteId, newNotePath, context.getAutheInfo());
            callback.onSuccess(note, context);
        } else {
            callback.onFailure((Exception)((Object)new NoteNotFoundException(noteId)), context);
        }
    }

    public Note cloneNote(String noteId, String newNotePath, ServiceContext context, ServiceCallback<Note> callback) throws IOException {
        if (StringUtils.isBlank((CharSequence)newNotePath)) {
            newNotePath = "/Cloned Note_" + noteId;
        }
        try {
            Note newNote = this.notebook.cloneNote(noteId, this.normalizeNotePath(newNotePath), context.getAutheInfo());
            callback.onSuccess(newNote, context);
            return newNote;
        }
        catch (IOException e) {
            callback.onFailure(new IOException("Fail to clone note", e), context);
            return null;
        }
    }

    public Note importNote(String notePath, String noteJson, ServiceContext context, ServiceCallback<Note> callback) throws IOException {
        try {
            Note note = this.notebook.importNote(noteJson, notePath == null ? notePath : this.normalizeNotePath(notePath), context.getAutheInfo());
            callback.onSuccess(note, context);
            return note;
        }
        catch (IOException e) {
            callback.onFailure(new IOException("Fail to import note: " + e.getMessage(), e), context);
            return null;
        }
    }

    public boolean runParagraph(String noteId, String paragraphId, String title, String text, Map<String, Object> params, Map<String, Object> config, boolean failIfDisabled, boolean blocking, ServiceContext context, ServiceCallback<Paragraph> callback) throws IOException {
        LOGGER.info("Start to run paragraph: " + paragraphId + " of note: " + noteId);
        if (!this.checkPermission(noteId, Permission.RUNNER, Message.OP.RUN_PARAGRAPH, context, callback)) {
            return false;
        }
        Note note = this.notebook.getNote(noteId);
        if (note == null) {
            callback.onFailure((Exception)((Object)new NoteNotFoundException(noteId)), context);
            return false;
        }
        Paragraph p = note.getParagraph(paragraphId);
        if (p == null) {
            callback.onFailure((Exception)((Object)new ParagraphNotFoundException(paragraphId)), context);
            return false;
        }
        if (failIfDisabled && !p.isEnabled()) {
            callback.onFailure(new IOException("paragraph is disabled."), context);
            return false;
        }
        p.setText(text);
        p.setTitle(title);
        p.setAuthenticationInfo(context.getAutheInfo());
        if (params != null && !params.isEmpty()) {
            p.settings.setParams(params);
        }
        if (config != null && !config.isEmpty()) {
            p.setConfig(config);
        }
        if (note.isPersonalizedMode()) {
            p = p.getUserParagraph(context.getAutheInfo().getUser());
            p.setText(text);
            p.setTitle(title);
            p.setAuthenticationInfo(context.getAutheInfo());
            if (params != null && !params.isEmpty()) {
                p.settings.setParams(params);
            }
            if (config != null && !config.isEmpty()) {
                p.setConfig(config);
            }
        }
        try {
            this.notebook.saveNote(note, context.getAutheInfo());
            boolean result = note.run(p.getId(), blocking, context.getAutheInfo().getUser());
            callback.onSuccess(p, context);
            return result;
        }
        catch (Exception ex) {
            LOGGER.error("Exception from run", (Throwable)ex);
            p.setReturn(new InterpreterResult(InterpreterResult.Code.ERROR, ex.getMessage()), (Throwable)ex);
            p.setStatus(Job.Status.ERROR);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runAllParagraphs(String noteId, List<Map<String, Object>> paragraphs, ServiceContext context, ServiceCallback<Paragraph> callback) throws IOException {
        block14: {
            if (!this.checkPermission(noteId, Permission.RUNNER, Message.OP.RUN_ALL_PARAGRAPHS, context, callback)) {
                return false;
            }
            Note note = this.notebook.getNote(noteId);
            if (note == null) {
                callback.onFailure((Exception)((Object)new NoteNotFoundException(noteId)), context);
                return false;
            }
            note.setRunning(true);
            try {
                if (paragraphs != null) {
                    for (Map<String, Object> raw : paragraphs) {
                        String paragraphId = (String)raw.get("id");
                        if (paragraphId == null) {
                            LOGGER.warn("No id found in paragraph json: " + raw);
                            continue;
                        }
                        try {
                            String text = (String)raw.get("paragraph");
                            String title = (String)raw.get("title");
                            Map params = (Map)raw.get("params");
                            Map config = (Map)raw.get("config");
                            if (this.runParagraph(noteId, paragraphId, title, text, params, config, false, true, context, callback)) continue;
                            boolean bl = false;
                            return bl;
                        }
                        catch (Exception e) {
                            throw new IOException("Fail to run paragraph json: " + raw);
                        }
                    }
                    break block14;
                }
                try {
                    note.runAll(context.getAutheInfo(), true);
                    boolean bl = true;
                    return bl;
                }
                catch (Exception e) {
                    LOGGER.warn("Fail to run note: " + note.getName(), (Throwable)e);
                    boolean bl = false;
                    note.setRunning(false);
                    return bl;
                }
            }
            finally {
                note.setRunning(false);
            }
        }
        return true;
    }

    public void cancelParagraph(String noteId, String paragraphId, ServiceContext context, ServiceCallback<Paragraph> callback) throws IOException {
        if (!this.checkPermission(noteId, Permission.RUNNER, Message.OP.CANCEL_PARAGRAPH, context, callback)) {
            return;
        }
        Note note = this.notebook.getNote(noteId);
        if (note == null) {
            throw new NoteNotFoundException(noteId);
        }
        Paragraph p = note.getParagraph(paragraphId);
        if (p == null) {
            throw new ParagraphNotFoundException(paragraphId);
        }
        p.abort();
        callback.onSuccess(p, context);
    }

    public void moveParagraph(String noteId, String paragraphId, int newIndex, ServiceContext context, ServiceCallback<Paragraph> callback) throws IOException {
        if (!this.checkPermission(noteId, Permission.WRITER, Message.OP.MOVE_PARAGRAPH, context, callback)) {
            return;
        }
        Note note = this.notebook.getNote(noteId);
        if (note == null) {
            throw new NoteNotFoundException(noteId);
        }
        if (note.getParagraph(paragraphId) == null) {
            throw new ParagraphNotFoundException(paragraphId);
        }
        if (newIndex >= note.getParagraphCount()) {
            callback.onFailure((Exception)((Object)new BadRequestException("newIndex " + newIndex + " is out of bounds")), context);
            return;
        }
        note.moveParagraph(paragraphId, newIndex);
        this.notebook.saveNote(note, context.getAutheInfo());
        callback.onSuccess(note.getParagraph(newIndex), context);
    }

    public void removeParagraph(String noteId, String paragraphId, ServiceContext context, ServiceCallback<Paragraph> callback) throws IOException {
        if (!this.checkPermission(noteId, Permission.WRITER, Message.OP.PARAGRAPH_REMOVE, context, callback)) {
            return;
        }
        Note note = this.notebook.getNote(noteId);
        if (note == null) {
            throw new NoteNotFoundException(noteId);
        }
        if (note.getParagraph(paragraphId) == null) {
            throw new ParagraphNotFoundException(paragraphId);
        }
        Paragraph p = note.removeParagraph(context.getAutheInfo().getUser(), paragraphId);
        this.notebook.saveNote(note, context.getAutheInfo());
        callback.onSuccess(p, context);
    }

    public Paragraph insertParagraph(String noteId, int index, Map<String, Object> config, ServiceContext context, ServiceCallback<Paragraph> callback) throws IOException {
        if (!this.checkPermission(noteId, Permission.WRITER, Message.OP.INSERT_PARAGRAPH, context, callback)) {
            return null;
        }
        Note note = this.notebook.getNote(noteId);
        if (note == null) {
            throw new NoteNotFoundException(noteId);
        }
        Paragraph newPara = note.insertNewParagraph(index, context.getAutheInfo());
        newPara.mergeConfig(config);
        this.notebook.saveNote(note, context.getAutheInfo());
        callback.onSuccess(newPara, context);
        return newPara;
    }

    public void restoreNote(String noteId, ServiceContext context, ServiceCallback<Note> callback) throws IOException {
        if (!this.checkPermission(noteId, Permission.WRITER, Message.OP.RESTORE_NOTE, context, callback)) {
            return;
        }
        Note note = this.notebook.getNote(noteId);
        if (note == null) {
            callback.onFailure((Exception)((Object)new NoteNotFoundException(noteId)), context);
            return;
        }
        if (!note.getPath().startsWith("/" + NoteManager.TRASH_FOLDER)) {
            callback.onFailure(new IOException("Can not restore this note " + note.getPath() + " as it is not in trash folder"), context);
            return;
        }
        try {
            String destNotePath = note.getPath().replace("/" + NoteManager.TRASH_FOLDER, "");
            this.notebook.moveNote(noteId, destNotePath, context.getAutheInfo());
            callback.onSuccess(note, context);
        }
        catch (IOException e) {
            callback.onFailure(new IOException("Fail to restore note: " + noteId, e), context);
        }
    }

    public void restoreFolder(String folderPath, ServiceContext context, ServiceCallback<Void> callback) throws IOException {
        if (!folderPath.startsWith("/" + NoteManager.TRASH_FOLDER)) {
            callback.onFailure(new IOException("Can not restore this folder: " + folderPath + " as it is not in trash folder"), context);
            return;
        }
        try {
            String destFolderPath = folderPath.replace("/" + NoteManager.TRASH_FOLDER, "");
            this.notebook.moveFolder(folderPath, destFolderPath, context.getAutheInfo());
            callback.onSuccess(null, context);
        }
        catch (IOException e) {
            callback.onFailure(new IOException("Fail to restore folder: " + folderPath, e), context);
        }
    }

    public void restoreAll(ServiceContext context, ServiceCallback callback) throws IOException {
        try {
            this.notebook.restoreAll(context.getAutheInfo());
            callback.onSuccess(null, context);
        }
        catch (IOException e) {
            callback.onFailure(new IOException("Fail to restore all", e), context);
        }
    }

    public void updateParagraph(String noteId, String paragraphId, String title, String text, Map<String, Object> params, Map<String, Object> config, ServiceContext context, ServiceCallback<Paragraph> callback) throws IOException {
        if (!this.checkPermission(noteId, Permission.WRITER, Message.OP.COMMIT_PARAGRAPH, context, callback)) {
            return;
        }
        Note note = this.notebook.getNote(noteId);
        if (note == null) {
            callback.onFailure((Exception)((Object)new NoteNotFoundException(noteId)), context);
            return;
        }
        Paragraph p = note.getParagraph(paragraphId);
        if (p == null) {
            callback.onFailure((Exception)((Object)new ParagraphNotFoundException(paragraphId)), context);
            return;
        }
        p.settings.setParams(params);
        p.setConfig(config);
        p.setTitle(title);
        p.setText(text);
        if (note.isPersonalizedMode()) {
            p = p.getUserParagraph(context.getAutheInfo().getUser());
            p.settings.setParams(params);
            p.setConfig(config);
            p.setTitle(title);
            p.setText(text);
        }
        this.notebook.saveNote(note, context.getAutheInfo());
        callback.onSuccess(p, context);
    }

    public void clearParagraphOutput(String noteId, String paragraphId, ServiceContext context, ServiceCallback<Paragraph> callback) throws IOException {
        if (!this.checkPermission(noteId, Permission.WRITER, Message.OP.PARAGRAPH_CLEAR_OUTPUT, context, callback)) {
            return;
        }
        Note note = this.notebook.getNote(noteId);
        if (note == null) {
            callback.onFailure((Exception)((Object)new NoteNotFoundException(noteId)), context);
            return;
        }
        Paragraph p = note.getParagraph(paragraphId);
        if (p == null) {
            callback.onFailure((Exception)((Object)new ParagraphNotFoundException(paragraphId)), context);
            return;
        }
        Paragraph returnedParagraph = null;
        if (note.isPersonalizedMode()) {
            returnedParagraph = note.clearPersonalizedParagraphOutput(paragraphId, context.getAutheInfo().getUser());
        } else {
            note.clearParagraphOutput(paragraphId);
            returnedParagraph = note.getParagraph(paragraphId);
        }
        callback.onSuccess(returnedParagraph, context);
    }

    public void clearAllParagraphOutput(String noteId, ServiceContext context, ServiceCallback<Note> callback) throws IOException {
        if (!this.checkPermission(noteId, Permission.WRITER, Message.OP.PARAGRAPH_CLEAR_ALL_OUTPUT, context, callback)) {
            return;
        }
        Note note = this.notebook.getNote(noteId);
        if (note == null) {
            callback.onFailure((Exception)((Object)new NoteNotFoundException(noteId)), context);
            return;
        }
        note.clearAllParagraphOutput();
        this.notebook.saveNote(note, context.getAutheInfo());
        callback.onSuccess(note, context);
    }

    public void updateNote(String noteId, String name, Map<String, Object> config, ServiceContext context, ServiceCallback<Note> callback) throws IOException {
        if (!this.checkPermission(noteId, Permission.WRITER, Message.OP.NOTE_UPDATE, context, callback)) {
            return;
        }
        Note note = this.notebook.getNote(noteId);
        if (note == null) {
            callback.onFailure((Exception)((Object)new NoteNotFoundException(noteId)), context);
            return;
        }
        if (!((Boolean)note.getConfig().get("isZeppelinNotebookCronEnable")).booleanValue() && config.get("cron") != null) {
            config.remove("cron");
        }
        boolean cronUpdated = this.isCronUpdated(config, note.getConfig());
        note.setName(name);
        note.setConfig(config);
        if (cronUpdated) {
            this.schedulerService.refreshCron(note.getId());
        }
        this.notebook.saveNote(note, context.getAutheInfo());
        callback.onSuccess(note, context);
    }

    private boolean isCronUpdated(Map<String, Object> configA, Map<String, Object> configB) {
        boolean cronUpdated = false;
        if (configA.get("cron") != null && configB.get("cron") != null && configA.get("cron").equals(configB.get("cron"))) {
            cronUpdated = true;
        } else if (configA.get("cron") == null && configB.get("cron") == null) {
            cronUpdated = false;
        } else if (configA.get("cron") != null || configB.get("cron") != null) {
            cronUpdated = true;
        }
        return cronUpdated;
    }

    public void saveNoteForms(String noteId, Map<String, Object> noteParams, ServiceContext context, ServiceCallback<Note> callback) throws IOException {
        if (!this.checkPermission(noteId, Permission.WRITER, Message.OP.SAVE_NOTE_FORMS, context, callback)) {
            return;
        }
        Note note = this.notebook.getNote(noteId);
        if (note == null) {
            callback.onFailure((Exception)((Object)new NoteNotFoundException(noteId)), context);
            return;
        }
        note.setNoteParams(noteParams);
        this.notebook.saveNote(note, context.getAutheInfo());
        callback.onSuccess(note, context);
    }

    public void removeNoteForms(String noteId, String formName, ServiceContext context, ServiceCallback<Note> callback) throws IOException {
        Note note = this.notebook.getNote(noteId);
        if (note == null) {
            callback.onFailure((Exception)((Object)new NoteNotFoundException(noteId)), context);
            return;
        }
        if (!this.checkPermission(noteId, Permission.WRITER, Message.OP.REMOVE_NOTE_FORMS, context, callback)) {
            return;
        }
        note.getNoteForms().remove(formName);
        note.getNoteParams().remove(formName);
        this.notebook.saveNote(note, context.getAutheInfo());
        callback.onSuccess(note, context);
    }

    public NotebookRepoWithVersionControl.Revision checkpointNote(String noteId, String commitMessage, ServiceContext context, ServiceCallback<NotebookRepoWithVersionControl.Revision> callback) throws IOException {
        Note note = this.notebook.getNote(noteId);
        if (note == null) {
            callback.onFailure((Exception)((Object)new NoteNotFoundException(noteId)), context);
            return null;
        }
        if (!this.checkPermission(noteId, Permission.WRITER, Message.OP.REMOVE_NOTE_FORMS, context, callback)) {
            return null;
        }
        NotebookRepoWithVersionControl.Revision revision = this.notebook.checkpointNote(noteId, note.getPath(), commitMessage, context.getAutheInfo());
        callback.onSuccess(revision, context);
        return revision;
    }

    public List<NotebookRepoWithVersionControl.Revision> listRevisionHistory(String noteId, ServiceContext context, ServiceCallback<List<NotebookRepoWithVersionControl.Revision>> callback) throws IOException {
        Note note = this.notebook.getNote(noteId);
        if (note == null) {
            callback.onFailure((Exception)((Object)new NoteNotFoundException(noteId)), context);
            return null;
        }
        List revisions = this.notebook.listRevisionHistory(noteId, note.getPath(), context.getAutheInfo());
        callback.onSuccess(revisions, context);
        return revisions;
    }

    public Note setNoteRevision(String noteId, String revisionId, ServiceContext context, ServiceCallback<Note> callback) throws IOException {
        Note note = this.notebook.getNote(noteId);
        if (note == null) {
            callback.onFailure((Exception)((Object)new NoteNotFoundException(noteId)), context);
            return null;
        }
        if (!this.checkPermission(noteId, Permission.WRITER, Message.OP.SET_NOTE_REVISION, context, callback)) {
            return null;
        }
        try {
            Note resultNote = this.notebook.setNoteRevision(noteId, note.getPath(), revisionId, context.getAutheInfo());
            callback.onSuccess(resultNote, context);
            return resultNote;
        }
        catch (Exception e) {
            callback.onFailure(new IOException("Fail to set given note revision", e), context);
            return null;
        }
    }

    public void getNotebyRevision(String noteId, String revisionId, ServiceContext context, ServiceCallback<Note> callback) throws IOException {
        Note note = this.notebook.getNote(noteId);
        if (note == null) {
            callback.onFailure((Exception)((Object)new NoteNotFoundException(noteId)), context);
            return;
        }
        if (!this.checkPermission(noteId, Permission.READER, Message.OP.NOTE_REVISION, context, callback)) {
            return;
        }
        Note revisionNote = this.notebook.getNoteByRevision(noteId, note.getPath(), revisionId, context.getAutheInfo());
        callback.onSuccess(revisionNote, context);
    }

    public void getNoteByRevisionForCompare(String noteId, String revisionId, ServiceContext context, ServiceCallback<Note> callback) throws IOException {
        Note note = this.notebook.getNote(noteId);
        if (note == null) {
            callback.onFailure((Exception)((Object)new NoteNotFoundException(noteId)), context);
            return;
        }
        if (!this.checkPermission(noteId, Permission.READER, Message.OP.NOTE_REVISION_FOR_COMPARE, context, callback)) {
            return;
        }
        Note revisionNote = null;
        revisionNote = revisionId.equals("Head") ? note : this.notebook.getNoteByRevision(noteId, note.getPath(), revisionId, context.getAutheInfo());
        callback.onSuccess(revisionNote, context);
    }

    public List<InterpreterCompletion> completion(String noteId, String paragraphId, String buffer, int cursor, ServiceContext context, ServiceCallback<List<InterpreterCompletion>> callback) throws IOException {
        Note note = this.notebook.getNote(noteId);
        if (note == null) {
            callback.onFailure((Exception)((Object)new NoteNotFoundException(noteId)), context);
            return null;
        }
        if (!this.checkPermission(noteId, Permission.WRITER, Message.OP.COMPLETION, context, callback)) {
            return null;
        }
        try {
            List completions = note.completion(paragraphId, buffer, cursor, context.getAutheInfo());
            callback.onSuccess(completions, context);
            return completions;
        }
        catch (RuntimeException e) {
            callback.onFailure(new IOException("Fail to get completion", e), context);
            return null;
        }
    }

    public void getEditorSetting(String noteId, String magic, ServiceContext context, ServiceCallback<Map<String, Object>> callback) throws IOException {
        Note note = this.notebook.getNote(noteId);
        if (note == null) {
            callback.onFailure((Exception)((Object)new NoteNotFoundException(noteId)), context);
            return;
        }
        try {
            Map settings = this.notebook.getInterpreterSettingManager().getEditorSetting(magic, noteId);
            callback.onSuccess(settings, context);
        }
        catch (Exception e) {
            callback.onFailure(new IOException("Fail to getEditorSetting", e), context);
            return;
        }
    }

    public void updatePersonalizedMode(String noteId, boolean isPersonalized, ServiceContext context, ServiceCallback<Note> callback) throws IOException {
        Note note = this.notebook.getNote(noteId);
        if (note == null) {
            callback.onFailure((Exception)((Object)new NoteNotFoundException(noteId)), context);
            return;
        }
        if (!this.checkPermission(noteId, Permission.WRITER, Message.OP.UPDATE_PERSONALIZED_MODE, context, callback)) {
            return;
        }
        note.setPersonalizedMode(Boolean.valueOf(isPersonalized));
        this.notebook.saveNote(note, context.getAutheInfo());
        callback.onSuccess(note, context);
    }

    public void moveNoteToTrash(String noteId, ServiceContext context, ServiceCallback<Note> callback) throws IOException {
        Note note = this.notebook.getNote(noteId);
        if (note == null) {
            callback.onFailure((Exception)((Object)new NoteNotFoundException(noteId)), context);
            return;
        }
        if (!this.checkPermission(noteId, Permission.OWNER, Message.OP.MOVE_NOTE_TO_TRASH, context, callback)) {
            return;
        }
        String destNotePath = "/" + NoteManager.TRASH_FOLDER + note.getPath();
        if (this.notebook.containsNote(destNotePath)) {
            destNotePath = destNotePath + " " + TRASH_CONFLICT_TIMESTAMP_FORMATTER.print((ReadableInstant)new DateTime());
        }
        this.notebook.moveNote(noteId, destNotePath, context.getAutheInfo());
        callback.onSuccess(note, context);
    }

    public void moveFolderToTrash(String folderPath, ServiceContext context, ServiceCallback<Void> callback) throws IOException {
        LOGGER.info("Move folder " + folderPath + " to trash");
        String destFolderPath = "/" + NoteManager.TRASH_FOLDER + "/" + folderPath;
        if (this.notebook.containsNote(destFolderPath)) {
            destFolderPath = destFolderPath + " " + TRASH_CONFLICT_TIMESTAMP_FORMATTER.print((ReadableInstant)new DateTime());
        }
        this.notebook.moveFolder("/" + folderPath, destFolderPath, context.getAutheInfo());
        callback.onSuccess(null, context);
    }

    public void emptyTrash(ServiceContext context, ServiceCallback<Void> callback) throws IOException {
        try {
            this.notebook.emptyTrash(context.getAutheInfo());
            callback.onSuccess(null, context);
        }
        catch (IOException e) {
            callback.onFailure(e, context);
        }
    }

    public List<NoteInfo> removeFolder(String folderPath, ServiceContext context, ServiceCallback<List<NoteInfo>> callback) throws IOException {
        try {
            this.notebook.removeFolder(folderPath, context.getAutheInfo());
            List notesInfo = this.notebook.getNotesInfo(noteId -> this.authorizationService.isReader(noteId, context.getUserAndRoles()));
            callback.onSuccess(notesInfo, context);
            return notesInfo;
        }
        catch (IOException e) {
            callback.onFailure(e, context);
            return null;
        }
    }

    public List<NoteInfo> renameFolder(String folderPath, String newFolderPath, ServiceContext context, ServiceCallback<List<NoteInfo>> callback) throws IOException {
        try {
            this.notebook.moveFolder(this.normalizeNotePath(folderPath), this.normalizeNotePath(newFolderPath), context.getAutheInfo());
            List notesInfo = this.notebook.getNotesInfo(noteId -> this.authorizationService.isReader(noteId, context.getUserAndRoles()));
            callback.onSuccess(notesInfo, context);
            return notesInfo;
        }
        catch (IOException e) {
            callback.onFailure(e, context);
            return null;
        }
    }

    public void spell(String noteId, Message message, ServiceContext context, ServiceCallback<Paragraph> callback) throws IOException {
        try {
            if (!this.checkPermission(noteId, Permission.RUNNER, Message.OP.RUN_PARAGRAPH_USING_SPELL, context, callback)) {
                return;
            }
            String paragraphId = (String)message.get("id");
            if (paragraphId == null) {
                return;
            }
            String text = (String)message.get("paragraph");
            String title = (String)message.get("title");
            Job.Status status = Job.Status.valueOf((String)((String)message.get("status")));
            Map params = (Map)message.get("params");
            Map config = (Map)message.get("config");
            Note note = this.notebook.getNote(noteId);
            Paragraph p = this.setParagraphUsingMessage(note, message, paragraphId, text, title, params, config);
            p.setResult((InterpreterResult)message.get("results"));
            p.setErrorMessage((String)message.get("errorMessage"));
            p.setStatusWithoutNotification(status);
            String dateStarted = (String)message.get("dateStarted");
            String dateFinished = (String)message.get("dateFinished");
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX");
            try {
                p.setDateStarted(df.parse(dateStarted));
            }
            catch (ParseException e) {
                LOGGER.error("Failed parse dateStarted", (Throwable)e);
            }
            try {
                p.setDateFinished(df.parse(dateFinished));
            }
            catch (ParseException e) {
                LOGGER.error("Failed parse dateFinished", (Throwable)e);
            }
            this.addNewParagraphIfLastParagraphIsExecuted(note, p);
            this.notebook.saveNote(note, context.getAutheInfo());
            callback.onSuccess(p, context);
        }
        catch (IOException e) {
            callback.onFailure(new IOException("Fail to run spell", e), context);
        }
    }

    private void addNewParagraphIfLastParagraphIsExecuted(Note note, Paragraph p) {
        boolean isTheLastParagraph = note.isLastParagraph(p.getId());
        if (!Strings.isNullOrEmpty((String)p.getText()) && !Strings.isNullOrEmpty((String)p.getScriptText()) && isTheLastParagraph) {
            note.addNewParagraph(p.getAuthenticationInfo());
        }
    }

    private Paragraph setParagraphUsingMessage(Note note, Message fromMessage, String paragraphId, String text, String title, Map<String, Object> params, Map<String, Object> config) {
        Paragraph p = note.getParagraph(paragraphId);
        p.setText(text);
        p.setTitle(title);
        AuthenticationInfo subject = new AuthenticationInfo(fromMessage.principal, fromMessage.roles, fromMessage.ticket);
        p.setAuthenticationInfo(subject);
        p.settings.setParams(params);
        p.setConfig(config);
        if (note.isPersonalizedMode()) {
            p = note.getParagraph(paragraphId);
            p.setText(text);
            p.setTitle(title);
            p.setAuthenticationInfo(subject);
            p.settings.setParams(params);
            p.setConfig(config);
        }
        return p;
    }

    public void updateAngularObject(String noteId, String paragraphId, String interpreterGroupId, String varName, Object varValue, ServiceContext context, ServiceCallback<AngularObject> callback) throws IOException {
        String user = context.getAutheInfo().getUser();
        AngularObject ao = null;
        boolean global = false;
        Note note = this.notebook.getNote(noteId);
        if (note != null) {
            List settings = note.getBindedInterpreterSettings(new ArrayList<String>(context.getUserAndRoles()));
            for (InterpreterSetting setting : settings) {
                if (setting.getInterpreterGroup(user, note.getId()) == null || !interpreterGroupId.equals(setting.getInterpreterGroup(user, note.getId()).getId())) continue;
                AngularObjectRegistry angularObjectRegistry = setting.getInterpreterGroup(user, note.getId()).getAngularObjectRegistry();
                ao = angularObjectRegistry.get(varName, noteId, paragraphId);
                if (ao == null) {
                    ao = angularObjectRegistry.get(varName, noteId, null);
                    if (ao == null) {
                        ao = angularObjectRegistry.get(varName, null, null);
                        if (ao == null) {
                            LOGGER.warn("Object {} is not binded", (Object)varName);
                            break;
                        }
                        ao.set(varValue, false);
                        global = true;
                        break;
                    }
                    ao.set(varValue, false);
                    global = false;
                    break;
                }
                ao.set(varValue, false);
                global = false;
                break;
            }
        }
        callback.onSuccess(ao, context);
    }

    public void patchParagraph(String noteId, String paragraphId, String patchText, ServiceContext context, ServiceCallback<String> callback) throws IOException {
        try {
            if (!this.checkPermission(noteId, Permission.WRITER, Message.OP.PATCH_PARAGRAPH, context, callback)) {
                return;
            }
            Note note = this.notebook.getNote(noteId);
            if (note == null) {
                return;
            }
            Paragraph p = note.getParagraph(paragraphId);
            if (p == null) {
                return;
            }
            DiffMatchPatch dmp = new DiffMatchPatch();
            LinkedList patches = null;
            try {
                patches = (LinkedList)dmp.patchFromText(patchText);
            }
            catch (ClassCastException e) {
                LOGGER.error("Failed to parse patches", (Throwable)e);
            }
            if (patches == null) {
                return;
            }
            String paragraphText = p.getText() == null ? "" : p.getText();
            paragraphText = (String)dmp.patchApply(patches, paragraphText)[0];
            p.setText(paragraphText);
            callback.onSuccess(patchText, context);
        }
        catch (IOException e) {
            callback.onFailure(new IOException("Fail to patch", e), context);
        }
    }

    private <T> boolean checkPermission(String noteId, Permission permission, Message.OP op, ServiceContext context, ServiceCallback<T> callback) throws IOException {
        boolean isAllowed = false;
        Set allowed = null;
        switch (permission) {
            case READER: {
                isAllowed = this.authorizationService.isReader(noteId, context.getUserAndRoles());
                allowed = this.authorizationService.getReaders(noteId);
                break;
            }
            case WRITER: {
                isAllowed = this.authorizationService.isWriter(noteId, context.getUserAndRoles());
                allowed = this.authorizationService.getWriters(noteId);
                break;
            }
            case RUNNER: {
                isAllowed = this.authorizationService.isRunner(noteId, context.getUserAndRoles());
                allowed = this.authorizationService.getRunners(noteId);
                break;
            }
            case OWNER: {
                isAllowed = this.authorizationService.isOwner(noteId, context.getUserAndRoles());
                allowed = this.authorizationService.getOwners(noteId);
            }
        }
        if (isAllowed) {
            return true;
        }
        String errorMsg = "Insufficient privileges to " + (Object)((Object)permission) + " note.\nAllowed users or roles: " + allowed + "\nBut the user " + context.getAutheInfo().getUser() + " belongs to: " + context.getUserAndRoles();
        callback.onFailure((Exception)((Object)new ForbiddenException(errorMsg)), context);
        return false;
    }

    static enum Permission {
        READER,
        WRITER,
        RUNNER,
        OWNER;

    }
}

