/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.socket;

import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.thrift.TException;
import org.apache.zeppelin.cluster.ClusterManagerServer;
import org.apache.zeppelin.cluster.event.ClusterEvent;
import org.apache.zeppelin.cluster.event.ClusterEventListener;
import org.apache.zeppelin.cluster.event.ClusterMessage;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.display.AngularObject;
import org.apache.zeppelin.display.AngularObjectRegistry;
import org.apache.zeppelin.display.AngularObjectRegistryListener;
import org.apache.zeppelin.display.GUI;
import org.apache.zeppelin.display.Input;
import org.apache.zeppelin.helium.ApplicationEventListener;
import org.apache.zeppelin.helium.HeliumPackage;
import org.apache.zeppelin.interpreter.InterpreterGroup;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.InterpreterSetting;
import org.apache.zeppelin.interpreter.remote.RemoteAngularObjectRegistry;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterProcessListener;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;
import org.apache.zeppelin.interpreter.thrift.ParagraphInfo;
import org.apache.zeppelin.interpreter.thrift.ServiceException;
import org.apache.zeppelin.jupyter.JupyterUtil;
import org.apache.zeppelin.notebook.AuthorizationService;
import org.apache.zeppelin.notebook.Note;
import org.apache.zeppelin.notebook.NoteEventListener;
import org.apache.zeppelin.notebook.NoteInfo;
import org.apache.zeppelin.notebook.Notebook;
import org.apache.zeppelin.notebook.NotebookImportDeserializer;
import org.apache.zeppelin.notebook.Paragraph;
import org.apache.zeppelin.notebook.ParagraphJobListener;
import org.apache.zeppelin.notebook.repo.NotebookRepoWithVersionControl;
import org.apache.zeppelin.notebook.socket.Message;
import org.apache.zeppelin.rest.exception.ForbiddenException;
import org.apache.zeppelin.scheduler.Job;
import org.apache.zeppelin.service.ConfigurationService;
import org.apache.zeppelin.service.JobManagerService;
import org.apache.zeppelin.service.NotebookService;
import org.apache.zeppelin.service.ServiceCallback;
import org.apache.zeppelin.service.ServiceContext;
import org.apache.zeppelin.service.SimpleServiceCallback;
import org.apache.zeppelin.socket.ConnectionManager;
import org.apache.zeppelin.socket.NotebookSocket;
import org.apache.zeppelin.socket.NotebookSocketListener;
import org.apache.zeppelin.socket.NotebookWebSocketCreator;
import org.apache.zeppelin.ticket.TicketContainer;
import org.apache.zeppelin.types.InterpreterSettingsList;
import org.apache.zeppelin.user.AuthenticationInfo;
import org.apache.zeppelin.util.IdHashes;
import org.apache.zeppelin.utils.CorsUtils;
import org.apache.zeppelin.utils.TestUtils;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;
import org.eclipse.jetty.websocket.servlet.WebSocketServlet;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;
import org.glassfish.hk2.api.ServiceLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject
public class NotebookServer
extends WebSocketServlet
implements NotebookSocketListener,
AngularObjectRegistryListener,
RemoteInterpreterProcessListener,
ApplicationEventListener,
ParagraphJobListener,
NoteEventListener,
ClusterEventListener {
    private Boolean collaborativeModeEnable = ZeppelinConfiguration.create().isZeppelinNotebookCollaborativeModeEnable();
    private static final Logger LOG = LoggerFactory.getLogger(NotebookServer.class);
    private static Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").registerTypeAdapter(Date.class, (Object)new NotebookImportDeserializer()).setPrettyPrinting().registerTypeAdapterFactory((TypeAdapterFactory)Input.TypeAdapterFactory).create();
    private static AtomicReference<NotebookServer> self = new AtomicReference();
    private ExecutorService executorService = Executors.newFixedThreadPool(10);
    private Provider<Notebook> notebookProvider;
    private Provider<NotebookService> notebookServiceProvider;
    private Provider<AuthorizationService> authorizationServiceProvider;
    private Provider<ConfigurationService> configurationServiceProvider;
    private Provider<JobManagerService> jobManagerServiceProvider;
    private Provider<ConnectionManager> connectionManagerProvider;

    public NotebookServer() {
        self.set(this);
        LOG.info("NotebookServer instantiated: {}", (Object)this);
    }

    @Inject
    public void setServiceLocator(ServiceLocator serviceLocator) {
        LOG.info("Injected ServiceLocator: {}", (Object)serviceLocator);
    }

    @Inject
    public void setNotebook(Provider<Notebook> notebookProvider) {
        this.notebookProvider = notebookProvider;
        LOG.info("Injected NotebookProvider");
    }

    @Inject
    public void setNotebookService(Provider<NotebookService> notebookServiceProvider) {
        this.notebookServiceProvider = notebookServiceProvider;
        LOG.info("Injected NotebookServiceProvider");
    }

    @Inject
    public void setAuthorizationServiceProvider(Provider<AuthorizationService> authorizationServiceProvider) {
        this.authorizationServiceProvider = authorizationServiceProvider;
        LOG.info("Injected NotebookAuthorizationServiceProvider");
    }

    @Inject
    public void setConnectionManagerProvider(Provider<ConnectionManager> connectionManagerProvider) {
        this.connectionManagerProvider = connectionManagerProvider;
        LOG.info("Injected ConnectionManagerProvider");
    }

    @Inject
    public void setConfigurationService(Provider<ConfigurationService> configurationServiceProvider) {
        this.configurationServiceProvider = configurationServiceProvider;
    }

    @Inject
    public void setJobManagerService(Provider<JobManagerService> jobManagerServiceProvider) {
        this.jobManagerServiceProvider = jobManagerServiceProvider;
    }

    public static NotebookServer getInstance() {
        return TestUtils.getInstance(NotebookServer.class);
    }

    public Notebook getNotebook() {
        return (Notebook)this.notebookProvider.get();
    }

    public ConnectionManager getConnectionManager() {
        return (ConnectionManager)this.connectionManagerProvider.get();
    }

    public NotebookService getNotebookService() {
        return (NotebookService)this.notebookServiceProvider.get();
    }

    public ConfigurationService getConfigurationService() {
        return (ConfigurationService)this.configurationServiceProvider.get();
    }

    public synchronized JobManagerService getJobManagerService() {
        return (JobManagerService)this.jobManagerServiceProvider.get();
    }

    public AuthorizationService getNotebookAuthorizationService() {
        return (AuthorizationService)this.authorizationServiceProvider.get();
    }

    public void configure(WebSocketServletFactory factory) {
        factory.setCreator((WebSocketCreator)new NotebookWebSocketCreator(this));
    }

    public boolean checkOrigin(HttpServletRequest request, String origin) {
        try {
            return CorsUtils.isValidOrigin(origin, ZeppelinConfiguration.create());
        }
        catch (URISyntaxException | UnknownHostException e) {
            LOG.error(e.toString(), (Throwable)e);
            return false;
        }
    }

    @Override
    public void onOpen(NotebookSocket conn) {
        LOG.info("New connection from {}", (Object)conn);
        this.getConnectionManager().addConnection(conn);
    }

    @Override
    public void onMessage(NotebookSocket conn, String msg) {
        try {
            Note note;
            String ticket;
            Message messagereceived = this.deserializeMessage(msg);
            if (messagereceived.op != Message.OP.PING) {
                LOG.debug("RECEIVE: " + messagereceived.op + ", RECEIVE PRINCIPAL: " + messagereceived.principal + ", RECEIVE TICKET: " + messagereceived.ticket + ", RECEIVE ROLES: " + messagereceived.roles + ", RECEIVE DATA: " + messagereceived.data);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("RECEIVE MSG = " + messagereceived);
            }
            if (!((ticket = TicketContainer.instance.getTicket(messagereceived.principal)) == null || messagereceived.ticket != null && ticket.equals(messagereceived.ticket))) {
                if (StringUtils.isEmpty((CharSequence)messagereceived.ticket)) {
                    LOG.debug("{} message: invalid ticket {} != {}", new Object[]{messagereceived.op, messagereceived.ticket, ticket});
                } else if (!messagereceived.op.equals((Object)Message.OP.PING)) {
                    conn.send(this.serializeMessage(new Message(Message.OP.SESSION_LOGOUT).put("info", (Object)"Your ticket is invalid possibly due to server restart. Please login again.")));
                }
                return;
            }
            ZeppelinConfiguration conf = ZeppelinConfiguration.create();
            boolean allowAnonymous = conf.isAnonymousAllowed();
            if (!allowAnonymous && messagereceived.principal.equals("anonymous")) {
                LOG.warn("Anonymous access not allowed.");
                return;
            }
            if (Message.isDisabledForRunningNotes((Message.OP)messagereceived.op) && (note = this.getNotebook().getNote((String)messagereceived.get("noteId"))) != null && note.isRunning()) {
                throw new Exception("Note is now running sequentially. Can not be performed: " + messagereceived.op);
            }
            if (StringUtils.isEmpty((CharSequence)conn.getUser())) {
                this.getConnectionManager().addUserConnection(messagereceived.principal, conn);
            }
            switch (messagereceived.op) {
                case LIST_NOTES: {
                    this.listNotesInfo(conn, messagereceived);
                    break;
                }
                case RELOAD_NOTES_FROM_REPO: {
                    this.broadcastReloadedNoteList(conn, this.getServiceContext(messagereceived));
                    break;
                }
                case GET_HOME_NOTE: {
                    this.getHomeNote(conn, messagereceived);
                    break;
                }
                case GET_NOTE: {
                    this.getNote(conn, messagereceived);
                    break;
                }
                case NEW_NOTE: {
                    this.createNote(conn, messagereceived);
                    break;
                }
                case DEL_NOTE: {
                    this.deleteNote(conn, messagereceived);
                    break;
                }
                case REMOVE_FOLDER: {
                    this.removeFolder(conn, messagereceived);
                    break;
                }
                case MOVE_NOTE_TO_TRASH: {
                    this.moveNoteToTrash(conn, messagereceived);
                    break;
                }
                case MOVE_FOLDER_TO_TRASH: {
                    this.moveFolderToTrash(conn, messagereceived);
                    break;
                }
                case EMPTY_TRASH: {
                    this.emptyTrash(conn, messagereceived);
                    break;
                }
                case RESTORE_FOLDER: {
                    this.restoreFolder(conn, messagereceived);
                    break;
                }
                case RESTORE_NOTE: {
                    this.restoreNote(conn, messagereceived);
                    break;
                }
                case RESTORE_ALL: {
                    this.restoreAll(conn, messagereceived);
                    break;
                }
                case CLONE_NOTE: {
                    this.cloneNote(conn, messagereceived);
                    break;
                }
                case IMPORT_NOTE: {
                    this.importNote(conn, messagereceived);
                    break;
                }
                case CONVERT_NOTE_NBFORMAT: {
                    this.convertNote(conn, messagereceived);
                    break;
                }
                case COMMIT_PARAGRAPH: {
                    this.updateParagraph(conn, messagereceived);
                    break;
                }
                case RUN_PARAGRAPH: {
                    this.runParagraph(conn, messagereceived);
                    break;
                }
                case PARAGRAPH_EXECUTED_BY_SPELL: {
                    this.broadcastSpellExecution(conn, messagereceived);
                    break;
                }
                case RUN_ALL_PARAGRAPHS: {
                    this.runAllParagraphs(conn, messagereceived);
                    break;
                }
                case CANCEL_PARAGRAPH: {
                    this.cancelParagraph(conn, messagereceived);
                    break;
                }
                case MOVE_PARAGRAPH: {
                    this.moveParagraph(conn, messagereceived);
                    break;
                }
                case INSERT_PARAGRAPH: {
                    this.insertParagraph(conn, messagereceived);
                    break;
                }
                case COPY_PARAGRAPH: {
                    this.copyParagraph(conn, messagereceived);
                    break;
                }
                case PARAGRAPH_REMOVE: {
                    this.removeParagraph(conn, messagereceived);
                    break;
                }
                case PARAGRAPH_CLEAR_OUTPUT: {
                    this.clearParagraphOutput(conn, messagereceived);
                    break;
                }
                case PARAGRAPH_CLEAR_ALL_OUTPUT: {
                    this.clearAllParagraphOutput(conn, messagereceived);
                    break;
                }
                case NOTE_UPDATE: {
                    this.updateNote(conn, messagereceived);
                    break;
                }
                case NOTE_RENAME: {
                    this.renameNote(conn, messagereceived);
                    break;
                }
                case FOLDER_RENAME: {
                    this.renameFolder(conn, messagereceived);
                    break;
                }
                case UPDATE_PERSONALIZED_MODE: {
                    this.updatePersonalizedMode(conn, messagereceived);
                    break;
                }
                case COMPLETION: {
                    this.completion(conn, messagereceived);
                    break;
                }
                case PING: {
                    break;
                }
                case ANGULAR_OBJECT_UPDATED: {
                    this.angularObjectUpdated(conn, messagereceived);
                    break;
                }
                case ANGULAR_OBJECT_CLIENT_BIND: {
                    this.angularObjectClientBind(conn, messagereceived);
                    break;
                }
                case ANGULAR_OBJECT_CLIENT_UNBIND: {
                    this.angularObjectClientUnbind(conn, messagereceived);
                    break;
                }
                case LIST_CONFIGURATIONS: {
                    this.sendAllConfigurations(conn, messagereceived);
                    break;
                }
                case CHECKPOINT_NOTE: {
                    this.checkpointNote(conn, messagereceived);
                    break;
                }
                case LIST_REVISION_HISTORY: {
                    this.listRevisionHistory(conn, messagereceived);
                    break;
                }
                case SET_NOTE_REVISION: {
                    this.setNoteRevision(conn, messagereceived);
                    break;
                }
                case NOTE_REVISION: {
                    this.getNoteByRevision(conn, messagereceived);
                    break;
                }
                case NOTE_REVISION_FOR_COMPARE: {
                    this.getNoteByRevisionForCompare(conn, messagereceived);
                    break;
                }
                case LIST_NOTE_JOBS: {
                    this.unicastNoteJobInfo(conn, messagereceived);
                    break;
                }
                case UNSUBSCRIBE_UPDATE_NOTE_JOBS: {
                    this.unsubscribeNoteJobInfo(conn);
                    break;
                }
                case GET_INTERPRETER_BINDINGS: {
                    this.getInterpreterBindings(conn, messagereceived);
                    break;
                }
                case SAVE_INTERPRETER_BINDINGS: {
                    this.saveInterpreterBindings(conn, messagereceived);
                    break;
                }
                case EDITOR_SETTING: {
                    this.getEditorSetting(conn, messagereceived);
                    break;
                }
                case GET_INTERPRETER_SETTINGS: {
                    this.getInterpreterSettings(conn, messagereceived);
                    break;
                }
                case WATCHER: {
                    this.getConnectionManager().switchConnectionToWatcher(conn);
                    break;
                }
                case SAVE_NOTE_FORMS: {
                    this.saveNoteForms(conn, messagereceived);
                    break;
                }
                case REMOVE_NOTE_FORMS: {
                    this.removeNoteForms(conn, messagereceived);
                    break;
                }
                case PATCH_PARAGRAPH: {
                    this.patchParagraph(conn, messagereceived);
                    break;
                }
            }
        }
        catch (Exception e) {
            LOG.error("Can't handle message: " + msg, (Throwable)e);
            try {
                conn.send(this.serializeMessage(new Message(Message.OP.ERROR_INFO).put("info", (Object)e.getMessage())));
            }
            catch (IOException iox) {
                LOG.error("Fail to send error info", (Throwable)iox);
            }
        }
    }

    @Override
    public void onClose(NotebookSocket conn, int code, String reason) {
        LOG.info("Closed connection to {} ({}) {}", new Object[]{conn, code, reason});
        this.getConnectionManager().removeConnection(conn);
        this.getConnectionManager().removeConnectionFromAllNote(conn);
        this.getConnectionManager().removeUserConnection(conn.getUser(), conn);
    }

    protected Message deserializeMessage(String msg) {
        return (Message)gson.fromJson(msg, Message.class);
    }

    protected String serializeMessage(Message m) {
        return gson.toJson((Object)m);
    }

    public void broadcast(Message m) {
        this.getConnectionManager().broadcast(m);
    }

    public void unicastNoteJobInfo(final NotebookSocket conn, Message fromMessage) throws IOException {
        this.getConnectionManager().addNoteConnection(JobManagerServiceType.JOB_MANAGER_PAGE.getKey(), conn);
        this.getJobManagerService().getNoteJobInfoByUnixTime(0L, this.getServiceContext(fromMessage), (ServiceCallback<List<JobManagerService.NoteJobInfo>>)new WebSocketServiceCallback<List<JobManagerService.NoteJobInfo>>(conn){

            @Override
            public void onSuccess(List<JobManagerService.NoteJobInfo> notesJobInfo, ServiceContext context) throws IOException {
                super.onSuccess(notesJobInfo, context);
                HashMap<String, Object> response = new HashMap<String, Object>();
                response.put("lastResponseUnixTime", System.currentTimeMillis());
                response.put("jobs", notesJobInfo);
                conn.send(NotebookServer.this.serializeMessage(new Message(Message.OP.LIST_NOTE_JOBS).put("noteJobs", response)));
            }

            @Override
            public void onFailure(Exception ex, ServiceContext context) throws IOException {
                LOG.warn(ex.getMessage());
            }
        });
    }

    public void broadcastUpdateNoteJobInfo(long lastUpdateUnixTime) throws IOException {
        this.getJobManagerService().getNoteJobInfoByUnixTime(lastUpdateUnixTime, null, (ServiceCallback<List<JobManagerService.NoteJobInfo>>)new WebSocketServiceCallback<List<JobManagerService.NoteJobInfo>>(null){

            @Override
            public void onSuccess(List<JobManagerService.NoteJobInfo> notesJobInfo, ServiceContext context) throws IOException {
                super.onSuccess(notesJobInfo, context);
                HashMap<String, Object> response = new HashMap<String, Object>();
                response.put("lastResponseUnixTime", System.currentTimeMillis());
                response.put("jobs", notesJobInfo);
                NotebookServer.this.getConnectionManager().broadcast(JobManagerServiceType.JOB_MANAGER_PAGE.getKey(), new Message(Message.OP.LIST_UPDATE_NOTE_JOBS).put("noteRunningJobs", response));
            }

            @Override
            public void onFailure(Exception ex, ServiceContext context) throws IOException {
                LOG.warn(ex.getMessage());
            }
        });
    }

    public void unsubscribeNoteJobInfo(NotebookSocket conn) {
        this.getConnectionManager().removeNoteConnection(JobManagerServiceType.JOB_MANAGER_PAGE.getKey(), conn);
    }

    public void getInterpreterBindings(NotebookSocket conn, Message fromMessage) throws IOException {
        ArrayList<InterpreterSettingsList> settingList = new ArrayList<InterpreterSettingsList>();
        ServiceContext context = this.getServiceContext(fromMessage);
        String noteId = (String)fromMessage.data.get("noteId");
        Note note = this.getNotebook().getNote(noteId);
        if (note != null) {
            List bindedSettings = note.getBindedInterpreterSettings(new ArrayList<String>(context.getUserAndRoles()));
            for (InterpreterSetting setting : bindedSettings) {
                settingList.add(new InterpreterSettingsList(setting.getId(), setting.getName(), setting.getInterpreterInfos(), true));
            }
        }
        conn.send(this.serializeMessage(new Message(Message.OP.INTERPRETER_BINDINGS).put("interpreterBindings", settingList)));
    }

    public void saveInterpreterBindings(NotebookSocket conn, Message fromMessage) throws IOException {
        ArrayList<InterpreterSettingsList> settingList = new ArrayList<InterpreterSettingsList>();
        String noteId = (String)fromMessage.data.get("noteId");
        ServiceContext context = this.getServiceContext(fromMessage);
        Note note = this.getNotebook().getNote(noteId);
        if (note != null) {
            List settingIdList = (List)gson.fromJson(String.valueOf(fromMessage.data.get("selectedSettingIds")), new TypeToken<ArrayList<String>>(){}.getType());
            if (!settingIdList.isEmpty()) {
                note.setDefaultInterpreterGroup((String)settingIdList.get(0));
                this.getNotebook().saveNote(note, new AuthenticationInfo(fromMessage.principal, fromMessage.roles, fromMessage.ticket));
            }
            List bindedSettings = note.getBindedInterpreterSettings(new ArrayList<String>(context.getUserAndRoles()));
            for (InterpreterSetting setting : bindedSettings) {
                settingList.add(new InterpreterSettingsList(setting.getId(), setting.getName(), setting.getInterpreterInfos(), true));
            }
        }
        conn.send(this.serializeMessage(new Message(Message.OP.INTERPRETER_BINDINGS).put("interpreterBindings", settingList)));
    }

    public void broadcastNote(Note note) {
        this.inlineBroadcastNote(note);
        this.broadcastClusterEvent(ClusterEvent.BROADCAST_NOTE, note);
    }

    private void inlineBroadcastNote(Note note) {
        Message message = new Message(Message.OP.NOTE).put("note", (Object)note);
        this.getConnectionManager().broadcast(note.getId(), message);
    }

    private void inlineBroadcastParagraph(Note note, Paragraph p) {
        this.broadcastNoteForms(note);
        if (note.isPersonalizedMode()) {
            this.broadcastParagraphs(p.getUserParagraphMap(), p);
        } else {
            Message message = new Message(Message.OP.PARAGRAPH).put("paragraph", (Object)p);
            this.getConnectionManager().broadcast(note.getId(), message);
        }
    }

    public void broadcastParagraph(Note note, Paragraph p) {
        this.inlineBroadcastParagraph(note, p);
        this.broadcastClusterEvent(ClusterEvent.BROADCAST_PARAGRAPH, note, p);
    }

    private void inlineBroadcastParagraphs(Map<String, Paragraph> userParagraphMap, Paragraph defaultParagraph) {
        if (null != userParagraphMap) {
            for (String user : userParagraphMap.keySet()) {
                Message message = new Message(Message.OP.PARAGRAPH).put("paragraph", (Object)userParagraphMap.get(user));
                this.getConnectionManager().multicastToUser(user, message);
            }
        }
    }

    private void broadcastParagraphs(Map<String, Paragraph> userParagraphMap, Paragraph defaultParagraph) {
        this.inlineBroadcastParagraphs(userParagraphMap, defaultParagraph);
        this.broadcastClusterEvent(ClusterEvent.BROADCAST_PARAGRAPHS, userParagraphMap, defaultParagraph);
    }

    private void inlineBroadcastNewParagraph(Note note, Paragraph para) {
        LOG.info("Broadcasting paragraph on run call instead of note.");
        int paraIndex = note.getParagraphs().indexOf(para);
        Message message = new Message(Message.OP.PARAGRAPH_ADDED).put("paragraph", (Object)para).put("index", (Object)paraIndex);
        this.getConnectionManager().broadcast(note.getId(), message);
    }

    private void broadcastNewParagraph(Note note, Paragraph para) {
        this.inlineBroadcastNewParagraph(note, para);
        this.broadcastClusterEvent(ClusterEvent.BROADCAST_NEW_PARAGRAPH, note, para);
    }

    public void inlineBroadcastNoteList(AuthenticationInfo subject, Set<String> userAndRoles) {
        if (subject == null) {
            subject = new AuthenticationInfo("");
        }
        AuthorizationService authorizationService = this.getNotebookAuthorizationService();
        List notesInfo = this.getNotebook().getNotesInfo(noteId -> authorizationService.isReader(noteId, userAndRoles));
        Message message = new Message(Message.OP.NOTES_INFO).put("notes", (Object)notesInfo);
        this.getConnectionManager().multicastToUser(subject.getUser(), message);
        this.getConnectionManager().broadcastNoteListExcept(notesInfo, subject);
    }

    public void broadcastNoteList(AuthenticationInfo subject, Set<String> userAndRoles) {
        this.inlineBroadcastNoteList(subject, userAndRoles);
        this.broadcastClusterEvent(ClusterEvent.BROADCAST_NOTE_LIST, subject, userAndRoles);
    }

    private void broadcastClusterEvent(ClusterEvent event, Object ... objects) {
        ZeppelinConfiguration conf = ZeppelinConfiguration.create();
        if (!conf.isClusterMode()) {
            return;
        }
        ClusterMessage clusterMessage = new ClusterMessage(event);
        for (Object object : objects) {
            Gson gson;
            String json = "";
            if (object instanceof AuthenticationInfo) {
                json = ((AuthenticationInfo)object).toJson();
                clusterMessage.put("AuthenticationInfo", json);
                continue;
            }
            if (object instanceof Note) {
                json = ((Note)object).toJson();
                clusterMessage.put("Note", json);
                continue;
            }
            if (object instanceof Paragraph) {
                json = ((Paragraph)object).toJson();
                clusterMessage.put("Paragraph", json);
                continue;
            }
            if (object instanceof Set) {
                gson = new Gson();
                json = gson.toJson(object);
                clusterMessage.put("Set<String>", json);
                continue;
            }
            if (object instanceof Map) {
                gson = new Gson();
                json = gson.toJson(object);
                clusterMessage.put("Map<String, Paragraph>", json);
                continue;
            }
            LOG.error("Unknown object type!");
        }
        String msg = ClusterMessage.serializeMessage((ClusterMessage)clusterMessage);
        ClusterManagerServer.getInstance((ZeppelinConfiguration)conf).broadcastClusterEvent(ClusterManagerServer.CLUSTER_NOTE_EVENT_TOPIC, msg);
    }

    public void onClusterEvent(String msg) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onClusterEvent : {}", (Object)msg);
        }
        ClusterMessage message = ClusterMessage.deserializeMessage((String)msg);
        Note note = null;
        Paragraph paragraph = null;
        Set userAndRoles = null;
        Map userParagraphMap = null;
        AuthenticationInfo authenticationInfo = null;
        for (Map.Entry entry : message.getData().entrySet()) {
            Gson gson;
            String key = (String)entry.getKey();
            String json = (String)entry.getValue();
            if (StringUtils.equals((CharSequence)key, (CharSequence)"AuthenticationInfo")) {
                authenticationInfo = AuthenticationInfo.fromJson((String)json);
                continue;
            }
            if (StringUtils.equals((CharSequence)key, (CharSequence)"Note")) {
                try {
                    note = Note.fromJson((String)json);
                }
                catch (IOException e) {
                    LOG.warn("Fail to parse note json", (Throwable)e);
                }
                continue;
            }
            if (StringUtils.equals((CharSequence)key, (CharSequence)"Paragraph")) {
                paragraph = Paragraph.fromJson((String)json);
                continue;
            }
            if (StringUtils.equals((CharSequence)key, (CharSequence)"Set<String>")) {
                gson = new Gson();
                userAndRoles = (Set)gson.fromJson(json, new TypeToken<Set<String>>(){}.getType());
                continue;
            }
            if (StringUtils.equals((CharSequence)key, (CharSequence)"Map<String, Paragraph>")) {
                gson = new Gson();
                userParagraphMap = (Map)gson.fromJson(json, new TypeToken<Map<String, Paragraph>>(){}.getType());
                continue;
            }
            LOG.error("Unknown key:{}, json:{}!" + key, (Object)json);
        }
        switch (message.clusterEvent) {
            case BROADCAST_NOTE: {
                this.inlineBroadcastNote(note);
                break;
            }
            case BROADCAST_NOTE_LIST: {
                try {
                    this.getNotebook().reloadAllNotes(authenticationInfo);
                    this.inlineBroadcastNoteList(authenticationInfo, userAndRoles);
                }
                catch (IOException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
                break;
            }
            case BROADCAST_PARAGRAPH: {
                this.inlineBroadcastParagraph(note, paragraph);
                break;
            }
            case BROADCAST_PARAGRAPHS: {
                this.inlineBroadcastParagraphs(userParagraphMap, paragraph);
                break;
            }
            case BROADCAST_NEW_PARAGRAPH: {
                this.inlineBroadcastNewParagraph(note, paragraph);
                break;
            }
            default: {
                LOG.error("Unknown clusterEvent:{}, msg:{} ", (Object)message.clusterEvent, (Object)msg);
            }
        }
    }

    public void listNotesInfo(final NotebookSocket conn, Message message) throws IOException {
        this.getNotebookService().listNotesInfo(false, this.getServiceContext(message), (ServiceCallback<List<NoteInfo>>)new WebSocketServiceCallback<List<NoteInfo>>(conn){

            @Override
            public void onSuccess(List<NoteInfo> notesInfo, ServiceContext context) throws IOException {
                super.onSuccess(notesInfo, context);
                NotebookServer.this.getConnectionManager().unicast(new Message(Message.OP.NOTES_INFO).put("notes", notesInfo), conn);
            }
        });
    }

    public void broadcastReloadedNoteList(NotebookSocket conn, ServiceContext context) throws IOException {
        this.getNotebookService().listNotesInfo(true, context, (ServiceCallback<List<NoteInfo>>)new WebSocketServiceCallback<List<NoteInfo>>(conn){

            @Override
            public void onSuccess(List<NoteInfo> notesInfo, ServiceContext context) throws IOException {
                super.onSuccess(notesInfo, context);
                NotebookServer.this.getConnectionManager().multicastToUser(context.getAutheInfo().getUser(), new Message(Message.OP.NOTES_INFO).put("notes", notesInfo));
                NotebookServer.this.getConnectionManager().broadcastNoteListExcept(notesInfo, context.getAutheInfo());
            }
        });
    }

    void permissionError(NotebookSocket conn, String op, String userName, Set<String> userAndRoles, Set<String> allowed) throws IOException {
        LOG.info("Cannot {}. Connection readers {}. Allowed readers {}", new Object[]{op, userAndRoles, allowed});
        conn.send(this.serializeMessage(new Message(Message.OP.AUTH_INFO).put("info", (Object)("Insufficient privileges to " + op + " note.\n\nAllowed users or roles: " + allowed.toString() + "\n\nBut the user " + userName + " belongs to: " + userAndRoles.toString()))));
    }

    private boolean hasParagraphWriterPermission(NotebookSocket conn, Notebook notebook, String noteId, Set<String> userAndRoles, String principal, String op) throws IOException {
        AuthorizationService authorizationService = this.getNotebookAuthorizationService();
        if (!authorizationService.isWriter(noteId, userAndRoles)) {
            this.permissionError(conn, op, principal, userAndRoles, authorizationService.getOwners(noteId));
            return false;
        }
        return true;
    }

    private void getNote(final NotebookSocket conn, Message fromMessage) throws IOException {
        String noteId = (String)fromMessage.get("id");
        if (noteId == null) {
            return;
        }
        this.getNotebookService().getNote(noteId, this.getServiceContext(fromMessage), (ServiceCallback<Note>)new WebSocketServiceCallback<Note>(conn){

            @Override
            public void onSuccess(Note note, ServiceContext context) throws IOException {
                NotebookServer.this.getConnectionManager().addNoteConnection(note.getId(), conn);
                conn.send(NotebookServer.this.serializeMessage(new Message(Message.OP.NOTE).put("note", (Object)note)));
                NotebookServer.this.updateAngularObjectRegistry(conn, note);
                NotebookServer.this.sendAllAngularObjects(note, context.getAutheInfo().getUser(), conn);
            }
        });
    }

    private void updateAngularObjectRegistry(NotebookSocket conn, Note note) {
        for (Paragraph paragraph : note.getParagraphs()) {
            InterpreterGroup interpreterGroup = null;
            try {
                interpreterGroup = this.findInterpreterGroupForParagraph(note, paragraph.getId());
            }
            catch (Exception e) {
                LOG.warn(e.getMessage(), (Throwable)e);
            }
            if (null == interpreterGroup) {
                return;
            }
            RemoteAngularObjectRegistry registry = (RemoteAngularObjectRegistry)interpreterGroup.getAngularObjectRegistry();
            List angularObjects = note.getAngularObjects(interpreterGroup.getId());
            for (AngularObject ao : angularObjects) {
                if (!StringUtils.equals((CharSequence)ao.getNoteId(), (CharSequence)note.getId()) || !StringUtils.equals((CharSequence)ao.getParagraphId(), (CharSequence)paragraph.getId())) continue;
                this.pushAngularObjectToRemoteRegistry(ao.getNoteId(), ao.getParagraphId(), ao.getName(), ao.get(), registry, interpreterGroup.getId(), conn);
            }
        }
    }

    private void getHomeNote(final NotebookSocket conn, Message fromMessage) throws IOException {
        this.getNotebookService().getHomeNote(this.getServiceContext(fromMessage), (ServiceCallback<Note>)new WebSocketServiceCallback<Note>(conn){

            @Override
            public void onSuccess(Note note, ServiceContext context) throws IOException {
                super.onSuccess(note, context);
                if (note != null) {
                    NotebookServer.this.getConnectionManager().addNoteConnection(note.getId(), conn);
                    conn.send(NotebookServer.this.serializeMessage(new Message(Message.OP.NOTE).put("note", (Object)note)));
                    NotebookServer.this.sendAllAngularObjects(note, context.getAutheInfo().getUser(), conn);
                } else {
                    NotebookServer.this.getConnectionManager().removeConnectionFromAllNote(conn);
                    conn.send(NotebookServer.this.serializeMessage(new Message(Message.OP.NOTE).put("note", null)));
                }
            }
        });
    }

    private void updateNote(NotebookSocket conn, Message fromMessage) throws IOException {
        String noteId = (String)fromMessage.get("id");
        final String name = (String)fromMessage.get("name");
        final Map config = (Map)fromMessage.get("config");
        if (noteId == null) {
            return;
        }
        if (config == null) {
            return;
        }
        this.getNotebookService().updateNote(noteId, name, config, this.getServiceContext(fromMessage), (ServiceCallback<Note>)new WebSocketServiceCallback<Note>(conn){

            @Override
            public void onSuccess(Note note, ServiceContext context) throws IOException {
                NotebookServer.this.getConnectionManager().broadcast(note.getId(), new Message(Message.OP.NOTE_UPDATED).put("name", (Object)name).put("config", (Object)config).put("info", (Object)note.getInfo()));
                NotebookServer.this.broadcastNoteList(context.getAutheInfo(), context.getUserAndRoles());
            }
        });
    }

    private void updatePersonalizedMode(NotebookSocket conn, Message fromMessage) throws IOException {
        String noteId = (String)fromMessage.get("id");
        String personalized = (String)fromMessage.get("personalized");
        boolean isPersonalized = personalized.equals("true");
        this.getNotebookService().updatePersonalizedMode(noteId, isPersonalized, this.getServiceContext(fromMessage), (ServiceCallback<Note>)new WebSocketServiceCallback<Note>(conn){

            @Override
            public void onSuccess(Note note, ServiceContext context) throws IOException {
                super.onSuccess(note, context);
                NotebookServer.this.getConnectionManager().broadcastNote(note);
            }
        });
    }

    private void renameNote(NotebookSocket conn, Message fromMessage) throws IOException {
        String noteId = (String)fromMessage.get("id");
        String name = (String)fromMessage.get("name");
        boolean isRelativePath = false;
        if (fromMessage.get("relative") != null) {
            isRelativePath = (Boolean)fromMessage.get("relative");
        }
        if (noteId == null) {
            return;
        }
        this.getNotebookService().renameNote(noteId, name, isRelativePath, this.getServiceContext(fromMessage), (ServiceCallback<Note>)new WebSocketServiceCallback<Note>(conn){

            @Override
            public void onSuccess(Note note, ServiceContext context) throws IOException {
                super.onSuccess(note, context);
                NotebookServer.this.broadcastNote(note);
                NotebookServer.this.broadcastNoteList(context.getAutheInfo(), context.getUserAndRoles());
            }
        });
    }

    private void renameFolder(NotebookSocket conn, Message fromMessage) throws IOException {
        String oldFolderId = (String)fromMessage.get("id");
        String newFolderId = (String)fromMessage.get("name");
        this.getNotebookService().renameFolder(oldFolderId, newFolderId, this.getServiceContext(fromMessage), (ServiceCallback<List<NoteInfo>>)new WebSocketServiceCallback<List<NoteInfo>>(conn){

            @Override
            public void onSuccess(List<NoteInfo> result, ServiceContext context) throws IOException {
                super.onSuccess(result, context);
                NotebookServer.this.broadcastNoteList(context.getAutheInfo(), context.getUserAndRoles());
            }
        });
    }

    private void createNote(final NotebookSocket conn, Message message) throws IOException {
        String noteName = (String)message.get("name");
        String defaultInterpreterGroup = (String)message.get("defaultInterpreterGroup");
        this.getNotebookService().createNote(noteName, defaultInterpreterGroup, this.getServiceContext(message), (ServiceCallback<Note>)new WebSocketServiceCallback<Note>(conn){

            @Override
            public void onSuccess(Note note, ServiceContext context) throws IOException {
                super.onSuccess(note, context);
                NotebookServer.this.getConnectionManager().addNoteConnection(note.getId(), conn);
                conn.send(NotebookServer.this.serializeMessage(new Message(Message.OP.NEW_NOTE).put("note", (Object)note)));
                NotebookServer.this.broadcastNoteList(context.getAutheInfo(), context.getUserAndRoles());
            }

            @Override
            public void onFailure(Exception ex, ServiceContext context) throws IOException {
                super.onFailure(ex, context);
                conn.send(NotebookServer.this.serializeMessage(new Message(Message.OP.ERROR_INFO).put("info", (Object)("Failed to create note.\n" + ExceptionUtils.getMessage((Throwable)ex)))));
            }
        });
    }

    private void deleteNote(NotebookSocket conn, Message fromMessage) throws IOException {
        final String noteId = (String)fromMessage.get("id");
        this.getNotebookService().removeNote(noteId, this.getServiceContext(fromMessage), (ServiceCallback<String>)new WebSocketServiceCallback<String>(conn){

            @Override
            public void onSuccess(String message, ServiceContext context) throws IOException {
                super.onSuccess(message, context);
                NotebookServer.this.getConnectionManager().removeNoteConnection(noteId);
                NotebookServer.this.broadcastNoteList(context.getAutheInfo(), context.getUserAndRoles());
            }
        });
    }

    private void removeFolder(NotebookSocket conn, Message fromMessage) throws IOException {
        String folderPath = (String)fromMessage.get("id");
        folderPath = "/" + folderPath;
        this.getNotebookService().removeFolder(folderPath, this.getServiceContext(fromMessage), (ServiceCallback<List<NoteInfo>>)new WebSocketServiceCallback<List<NoteInfo>>(conn){

            @Override
            public void onSuccess(List<NoteInfo> notesInfo, ServiceContext context) throws IOException {
                super.onSuccess(notesInfo, context);
                for (NoteInfo noteInfo : notesInfo) {
                    NotebookServer.this.getConnectionManager().removeNoteConnection(noteInfo.getId());
                }
                NotebookServer.this.broadcastNoteList(context.getAutheInfo(), context.getUserAndRoles());
            }
        });
    }

    private void moveNoteToTrash(NotebookSocket conn, Message fromMessage) throws IOException {
        String noteId = (String)fromMessage.get("id");
        this.getNotebookService().moveNoteToTrash(noteId, this.getServiceContext(fromMessage), (ServiceCallback<Note>)new WebSocketServiceCallback<Note>(conn){

            @Override
            public void onSuccess(Note note, ServiceContext context) throws IOException {
                super.onSuccess(note, context);
                NotebookServer.this.broadcastNote(note);
                NotebookServer.this.broadcastNoteList(context.getAutheInfo(), context.getUserAndRoles());
            }
        });
    }

    private void moveFolderToTrash(NotebookSocket conn, Message fromMessage) throws IOException {
        String folderPath = (String)fromMessage.get("id");
        this.getNotebookService().moveFolderToTrash(folderPath, this.getServiceContext(fromMessage), (ServiceCallback<Void>)new WebSocketServiceCallback<Void>(conn){

            @Override
            public void onSuccess(Void result, ServiceContext context) throws IOException {
                super.onSuccess(result, context);
                NotebookServer.this.broadcastNoteList(context.getAutheInfo(), context.getUserAndRoles());
            }
        });
    }

    private void restoreNote(NotebookSocket conn, Message fromMessage) throws IOException {
        String noteId = (String)fromMessage.get("id");
        this.getNotebookService().restoreNote(noteId, this.getServiceContext(fromMessage), (ServiceCallback<Note>)new WebSocketServiceCallback<Note>(conn){

            @Override
            public void onSuccess(Note note, ServiceContext context) throws IOException {
                super.onSuccess(note, context);
                NotebookServer.this.broadcastNote(note);
                NotebookServer.this.broadcastNoteList(context.getAutheInfo(), context.getUserAndRoles());
            }
        });
    }

    private void restoreFolder(NotebookSocket conn, Message fromMessage) throws IOException {
        String folderPath = (String)fromMessage.get("id");
        folderPath = "/" + folderPath;
        this.getNotebookService().restoreFolder(folderPath, this.getServiceContext(fromMessage), new WebSocketServiceCallback(conn){

            @Override
            public void onSuccess(Object result, ServiceContext context) throws IOException {
                super.onSuccess(result, context);
                NotebookServer.this.broadcastNoteList(context.getAutheInfo(), context.getUserAndRoles());
            }
        });
    }

    private void restoreAll(NotebookSocket conn, Message fromMessage) throws IOException {
        this.getNotebookService().restoreAll(this.getServiceContext(fromMessage), new WebSocketServiceCallback(conn){

            @Override
            public void onSuccess(Object result, ServiceContext context) throws IOException {
                super.onSuccess(result, context);
                NotebookServer.this.broadcastNoteList(context.getAutheInfo(), context.getUserAndRoles());
            }
        });
    }

    private void emptyTrash(NotebookSocket conn, Message fromMessage) throws IOException {
        this.getNotebookService().emptyTrash(this.getServiceContext(fromMessage), new WebSocketServiceCallback(conn){

            @Override
            public void onSuccess(Object result, ServiceContext context) throws IOException {
                super.onSuccess(result, context);
                NotebookServer.this.broadcastNoteList(context.getAutheInfo(), context.getUserAndRoles());
            }
        });
    }

    private void updateParagraph(NotebookSocket conn, Message fromMessage) throws IOException {
        final String paragraphId = (String)fromMessage.get("id");
        String noteId = this.getConnectionManager().getAssociatedNoteId(conn);
        if (noteId == null) {
            noteId = (String)fromMessage.get("noteId");
        }
        String title = (String)fromMessage.get("title");
        String text = (String)fromMessage.get("paragraph");
        Map params = (Map)fromMessage.get("params");
        Map config = (Map)fromMessage.get("config");
        this.getNotebookService().updateParagraph(noteId, paragraphId, title, text, params, config, this.getServiceContext(fromMessage), (ServiceCallback<Paragraph>)new WebSocketServiceCallback<Paragraph>(conn){

            @Override
            public void onSuccess(Paragraph p, ServiceContext context) throws IOException {
                super.onSuccess(p, context);
                if (p.getNote().isPersonalizedMode()) {
                    Map userParagraphMap = p.getNote().getParagraph(paragraphId).getUserParagraphMap();
                    NotebookServer.this.broadcastParagraphs(userParagraphMap, p);
                } else {
                    NotebookServer.this.broadcastParagraph(p.getNote(), p);
                }
            }
        });
    }

    private void patchParagraph(final NotebookSocket conn, Message fromMessage) throws IOException {
        if (!this.collaborativeModeEnable.booleanValue()) {
            return;
        }
        final String paragraphId = (String)fromMessage.getType("id", LOG);
        if (paragraphId == null) {
            return;
        }
        String noteId = this.getConnectionManager().getAssociatedNoteId(conn);
        if (noteId == null && (noteId = (String)fromMessage.getType("noteId", LOG)) == null) {
            return;
        }
        final String noteId2 = noteId;
        String patchText = (String)fromMessage.getType("patch", LOG);
        if (patchText == null) {
            return;
        }
        this.getNotebookService().patchParagraph(noteId, paragraphId, patchText, this.getServiceContext(fromMessage), (ServiceCallback<String>)new WebSocketServiceCallback<String>(conn){

            @Override
            public void onSuccess(String result, ServiceContext context) throws IOException {
                super.onSuccess(result, context);
                Message message = new Message(Message.OP.PATCH_PARAGRAPH).put("patch", (Object)result).put("paragraphId", (Object)paragraphId);
                NotebookServer.this.getConnectionManager().broadcastExcept(noteId2, message, conn);
            }
        });
    }

    private void cloneNote(final NotebookSocket conn, Message fromMessage) throws IOException {
        String noteId = this.getConnectionManager().getAssociatedNoteId(conn);
        String name = (String)fromMessage.get("name");
        this.getNotebookService().cloneNote(noteId, name, this.getServiceContext(fromMessage), (ServiceCallback<Note>)new WebSocketServiceCallback<Note>(conn){

            @Override
            public void onSuccess(Note newNote, ServiceContext context) throws IOException {
                super.onSuccess(newNote, context);
                NotebookServer.this.getConnectionManager().addNoteConnection(newNote.getId(), conn);
                conn.send(NotebookServer.this.serializeMessage(new Message(Message.OP.NEW_NOTE).put("note", (Object)newNote)));
                NotebookServer.this.broadcastNoteList(context.getAutheInfo(), context.getUserAndRoles());
            }
        });
    }

    private void clearAllParagraphOutput(NotebookSocket conn, Message fromMessage) throws IOException {
        String noteId = (String)fromMessage.get("id");
        this.getNotebookService().clearAllParagraphOutput(noteId, this.getServiceContext(fromMessage), (ServiceCallback<Note>)new WebSocketServiceCallback<Note>(conn){

            @Override
            public void onSuccess(Note note, ServiceContext context) throws IOException {
                super.onSuccess(note, context);
                NotebookServer.this.broadcastNote(note);
            }
        });
    }

    protected void convertNote(NotebookSocket conn, Message fromMessage) throws IOException {
        String noteId = fromMessage.get("noteId").toString();
        Note note = this.getNotebook().getNote(noteId);
        if (note == null) {
            throw new IOException("No such note: " + noteId);
        }
        Message resp = new Message(Message.OP.CONVERTED_NOTE_NBFORMAT).put("nbformat", (Object)new JupyterUtil().getNbformat(note.toJson())).put("name", fromMessage.get("name"));
        conn.send(this.serializeMessage(resp));
    }

    protected Note importNote(NotebookSocket conn, Message fromMessage) throws IOException {
        String noteJson = null;
        String noteName = (String)((Map)fromMessage.get("note")).get("name");
        noteJson = ((Map)fromMessage.get("note")).get("cells") == null ? gson.toJson(fromMessage.get("note")) : new JupyterUtil().getJson(gson.toJson(fromMessage.get("note")), IdHashes.generateId(), "%python", "%md");
        Note note = this.getNotebookService().importNote(noteName, noteJson, this.getServiceContext(fromMessage), (ServiceCallback<Note>)new WebSocketServiceCallback<Note>(conn){

            @Override
            public void onSuccess(Note note, ServiceContext context) throws IOException {
                super.onSuccess(note, context);
                try {
                    NotebookServer.this.broadcastNote(note);
                    NotebookServer.this.broadcastNoteList(context.getAutheInfo(), context.getUserAndRoles());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        });
        return note;
    }

    private void removeParagraph(NotebookSocket conn, Message fromMessage) throws IOException {
        String paragraphId = (String)fromMessage.get("id");
        String noteId = this.getConnectionManager().getAssociatedNoteId(conn);
        this.getNotebookService().removeParagraph(noteId, paragraphId, this.getServiceContext(fromMessage), (ServiceCallback<Paragraph>)new WebSocketServiceCallback<Paragraph>(conn){

            @Override
            public void onSuccess(Paragraph p, ServiceContext context) throws IOException {
                super.onSuccess(p, context);
                NotebookServer.this.getConnectionManager().broadcast(p.getNote().getId(), new Message(Message.OP.PARAGRAPH_REMOVED).put("id", (Object)p.getId()));
            }
        });
    }

    private void clearParagraphOutput(NotebookSocket conn, Message fromMessage) throws IOException {
        String paragraphId = (String)fromMessage.get("id");
        String noteId = this.getConnectionManager().getAssociatedNoteId(conn);
        this.getNotebookService().clearParagraphOutput(noteId, paragraphId, this.getServiceContext(fromMessage), (ServiceCallback<Paragraph>)new WebSocketServiceCallback<Paragraph>(conn){

            @Override
            public void onSuccess(Paragraph p, ServiceContext context) throws IOException {
                super.onSuccess(p, context);
                if (p.getNote().isPersonalizedMode()) {
                    NotebookServer.this.getConnectionManager().unicastParagraph(p.getNote(), p, context.getAutheInfo().getUser());
                } else {
                    NotebookServer.this.broadcastParagraph(p.getNote(), p);
                }
            }
        });
    }

    private void completion(final NotebookSocket conn, Message fromMessage) throws IOException {
        String noteId = this.getConnectionManager().getAssociatedNoteId(conn);
        final String paragraphId = (String)fromMessage.get("id");
        String buffer = (String)fromMessage.get("buf");
        int cursor = (int)Double.parseDouble(fromMessage.get("cursor").toString());
        this.getNotebookService().completion(noteId, paragraphId, buffer, cursor, this.getServiceContext(fromMessage), (ServiceCallback<List<InterpreterCompletion>>)new WebSocketServiceCallback<List<InterpreterCompletion>>(conn){

            @Override
            public void onSuccess(List<InterpreterCompletion> completions, ServiceContext context) throws IOException {
                super.onSuccess(completions, context);
                Message resp = new Message(Message.OP.COMPLETION_LIST).put("id", (Object)paragraphId);
                resp.put("completions", completions);
                conn.send(NotebookServer.this.serializeMessage(resp));
            }

            @Override
            public void onFailure(Exception ex, ServiceContext context) throws IOException {
                super.onFailure(ex, context);
                Message resp = new Message(Message.OP.COMPLETION_LIST).put("id", (Object)paragraphId);
                resp.put("completions", new ArrayList());
                conn.send(NotebookServer.this.serializeMessage(resp));
            }
        });
    }

    private void angularObjectUpdated(final NotebookSocket conn, Message fromMessage) throws IOException {
        final String noteId = (String)fromMessage.get("noteId");
        String paragraphId = (String)fromMessage.get("paragraphId");
        final String interpreterGroupId = (String)fromMessage.get("interpreterGroupId");
        String varName = (String)fromMessage.get("name");
        Object varValue = fromMessage.get("value");
        String user = fromMessage.principal;
        this.getNotebookService().updateAngularObject(noteId, paragraphId, interpreterGroupId, varName, varValue, this.getServiceContext(fromMessage), (ServiceCallback<AngularObject>)new WebSocketServiceCallback<AngularObject>(conn){

            @Override
            public void onSuccess(AngularObject ao, ServiceContext context) throws IOException {
                super.onSuccess(ao, context);
                NotebookServer.this.getConnectionManager().broadcastExcept(noteId, new Message(Message.OP.ANGULAR_OBJECT_UPDATE).put("angularObject", (Object)ao).put("interpreterGroupId", (Object)interpreterGroupId).put("noteId", (Object)noteId).put("paragraphId", (Object)ao.getParagraphId()), conn);
                Note note = NotebookServer.this.getNotebook().getNote(noteId);
                note.addOrUpdateAngularObject(interpreterGroupId, ao);
            }
        });
    }

    protected void angularObjectClientBind(NotebookSocket conn, Message fromMessage) throws Exception {
        String noteId = (String)fromMessage.getType("noteId");
        String varName = (String)fromMessage.getType("name");
        Object varValue = fromMessage.get("value");
        String paragraphId = (String)fromMessage.getType("paragraphId");
        Note note = this.getNotebook().getNote(noteId);
        if (paragraphId == null) {
            throw new IllegalArgumentException("target paragraph not specified for angular value bind");
        }
        if (note != null) {
            InterpreterGroup interpreterGroup = this.findInterpreterGroupForParagraph(note, paragraphId);
            RemoteAngularObjectRegistry registry = (RemoteAngularObjectRegistry)interpreterGroup.getAngularObjectRegistry();
            AngularObject ao = this.pushAngularObjectToRemoteRegistry(noteId, paragraphId, varName, varValue, registry, interpreterGroup.getId(), conn);
            note.addOrUpdateAngularObject(interpreterGroup.getId(), ao);
        }
    }

    protected void angularObjectClientUnbind(NotebookSocket conn, Message fromMessage) throws Exception {
        String noteId = (String)fromMessage.getType("noteId");
        String varName = (String)fromMessage.getType("name");
        String paragraphId = (String)fromMessage.getType("paragraphId");
        Note note = this.getNotebook().getNote(noteId);
        if (paragraphId == null) {
            throw new IllegalArgumentException("target paragraph not specified for angular value unBind");
        }
        if (note != null) {
            InterpreterGroup interpreterGroup = this.findInterpreterGroupForParagraph(note, paragraphId);
            RemoteAngularObjectRegistry registry = (RemoteAngularObjectRegistry)interpreterGroup.getAngularObjectRegistry();
            AngularObject ao = this.removeAngularFromRemoteRegistry(noteId, paragraphId, varName, registry, interpreterGroup.getId(), conn);
            note.deleteAngularObject(interpreterGroup.getId(), ao);
        }
    }

    private InterpreterGroup findInterpreterGroupForParagraph(Note note, String paragraphId) throws Exception {
        Paragraph paragraph = note.getParagraph(paragraphId);
        if (paragraph == null) {
            throw new IllegalArgumentException("Unknown paragraph with id : " + paragraphId);
        }
        return paragraph.getBindedInterpreter().getInterpreterGroup();
    }

    private AngularObject pushAngularObjectToRemoteRegistry(String noteId, String paragraphId, String varName, Object varValue, RemoteAngularObjectRegistry remoteRegistry, String interpreterGroupId, NotebookSocket conn) {
        AngularObject ao = remoteRegistry.addAndNotifyRemoteProcess(varName, varValue, noteId, paragraphId);
        this.getConnectionManager().broadcastExcept(noteId, new Message(Message.OP.ANGULAR_OBJECT_UPDATE).put("angularObject", (Object)ao).put("interpreterGroupId", (Object)interpreterGroupId).put("noteId", (Object)noteId).put("paragraphId", (Object)paragraphId), conn);
        return ao;
    }

    private AngularObject removeAngularFromRemoteRegistry(String noteId, String paragraphId, String varName, RemoteAngularObjectRegistry remoteRegistry, String interpreterGroupId, NotebookSocket conn) {
        AngularObject ao = remoteRegistry.removeAndNotifyRemoteProcess(varName, noteId, paragraphId);
        this.getConnectionManager().broadcastExcept(noteId, new Message(Message.OP.ANGULAR_OBJECT_REMOVE).put("angularObject", (Object)ao).put("interpreterGroupId", (Object)interpreterGroupId).put("noteId", (Object)noteId).put("paragraphId", (Object)paragraphId), conn);
        return ao;
    }

    private void moveParagraph(NotebookSocket conn, Message fromMessage) throws IOException {
        final String paragraphId = (String)fromMessage.get("id");
        final int newIndex = (int)Double.parseDouble(fromMessage.get("index").toString());
        String noteId = this.getConnectionManager().getAssociatedNoteId(conn);
        this.getNotebookService().moveParagraph(noteId, paragraphId, newIndex, this.getServiceContext(fromMessage), (ServiceCallback<Paragraph>)new WebSocketServiceCallback<Paragraph>(conn){

            @Override
            public void onSuccess(Paragraph result, ServiceContext context) throws IOException {
                super.onSuccess(result, context);
                NotebookServer.this.getConnectionManager().broadcast(result.getNote().getId(), new Message(Message.OP.PARAGRAPH_MOVED).put("id", (Object)paragraphId).put("index", (Object)newIndex));
            }
        });
    }

    private String insertParagraph(NotebookSocket conn, Message fromMessage) throws IOException {
        int index = (int)Double.parseDouble(fromMessage.get("index").toString());
        String noteId = this.getConnectionManager().getAssociatedNoteId(conn);
        Map config = fromMessage.get("config") != null ? (Map)fromMessage.get("config") : new HashMap();
        Paragraph newPara = this.getNotebookService().insertParagraph(noteId, index, config, this.getServiceContext(fromMessage), (ServiceCallback<Paragraph>)new WebSocketServiceCallback<Paragraph>(conn){

            @Override
            public void onSuccess(Paragraph p, ServiceContext context) throws IOException {
                super.onSuccess(p, context);
                NotebookServer.this.broadcastNewParagraph(p.getNote(), p);
            }
        });
        return newPara.getId();
    }

    private void copyParagraph(NotebookSocket conn, Message fromMessage) throws IOException {
        String newParaId = this.insertParagraph(conn, fromMessage);
        if (newParaId == null) {
            return;
        }
        fromMessage.put("id", (Object)newParaId);
        this.updateParagraph(conn, fromMessage);
    }

    private void cancelParagraph(NotebookSocket conn, Message fromMessage) throws IOException {
        String paragraphId = (String)fromMessage.get("id");
        String noteId = this.getConnectionManager().getAssociatedNoteId(conn);
        this.getNotebookService().cancelParagraph(noteId, paragraphId, this.getServiceContext(fromMessage), new WebSocketServiceCallback<Paragraph>(conn));
    }

    private void runAllParagraphs(NotebookSocket conn, Message fromMessage) throws IOException {
        String noteId = (String)fromMessage.get("noteId");
        List paragraphs = (List)gson.fromJson(String.valueOf(fromMessage.data.get("paragraphs")), new TypeToken<List<Map<String, Object>>>(){}.getType());
        this.getNotebookService().runAllParagraphs(noteId, paragraphs, this.getServiceContext(fromMessage), new WebSocketServiceCallback<Paragraph>(conn));
    }

    private void broadcastSpellExecution(final NotebookSocket conn, Message fromMessage) throws IOException {
        String noteId = this.getConnectionManager().getAssociatedNoteId(conn);
        this.getNotebookService().spell(noteId, fromMessage, this.getServiceContext(fromMessage), (ServiceCallback<Paragraph>)new WebSocketServiceCallback<Paragraph>(conn){

            @Override
            public void onSuccess(Paragraph p, ServiceContext context) throws IOException {
                super.onSuccess(p, context);
                NotebookServer.this.getConnectionManager().broadcastExcept(p.getNote().getId(), new Message(Message.OP.RUN_PARAGRAPH_USING_SPELL).put("paragraph", (Object)p), conn);
            }
        });
    }

    private void runParagraph(NotebookSocket conn, Message fromMessage) throws IOException {
        final String paragraphId = (String)fromMessage.get("id");
        String noteId = this.getConnectionManager().getAssociatedNoteId(conn);
        String text = (String)fromMessage.get("paragraph");
        String title = (String)fromMessage.get("title");
        Map params = (Map)fromMessage.get("params");
        Map config = (Map)fromMessage.get("config");
        this.getNotebookService().runParagraph(noteId, paragraphId, title, text, params, config, false, false, this.getServiceContext(fromMessage), (ServiceCallback<Paragraph>)new WebSocketServiceCallback<Paragraph>(conn){

            @Override
            public void onSuccess(Paragraph p, ServiceContext context) throws IOException {
                super.onSuccess(p, context);
                if (p.getNote().isPersonalizedMode()) {
                    Paragraph p2 = p.getNote().clearPersonalizedParagraphOutput(paragraphId, context.getAutheInfo().getUser());
                    NotebookServer.this.getConnectionManager().unicastParagraph(p.getNote(), p2, context.getAutheInfo().getUser());
                }
                boolean isTheLastParagraph = p.getNote().isLastParagraph(paragraphId);
                if (!Strings.isNullOrEmpty((String)p.getText()) && !Strings.isNullOrEmpty((String)p.getScriptText()) && isTheLastParagraph) {
                    Paragraph newPara = p.getNote().addNewParagraph(p.getAuthenticationInfo());
                    NotebookServer.this.broadcastNewParagraph(p.getNote(), newPara);
                }
            }
        });
    }

    private void sendAllConfigurations(final NotebookSocket conn, Message message) throws IOException {
        this.getConfigurationService().getAllProperties(this.getServiceContext(message), (ServiceCallback<Map<String, String>>)new WebSocketServiceCallback<Map<String, String>>(conn){

            @Override
            public void onSuccess(Map<String, String> properties, ServiceContext context) throws IOException {
                super.onSuccess(properties, context);
                properties.put("isRevisionSupported", String.valueOf(NotebookServer.this.getNotebook().isRevisionSupported()));
                conn.send(NotebookServer.this.serializeMessage(new Message(Message.OP.CONFIGURATIONS_INFO).put("configurations", properties)));
            }
        });
    }

    private void checkpointNote(final NotebookSocket conn, Message fromMessage) throws IOException {
        final String noteId = (String)fromMessage.get("noteId");
        String commitMessage = (String)fromMessage.get("commitMessage");
        this.getNotebookService().checkpointNote(noteId, commitMessage, this.getServiceContext(fromMessage), (ServiceCallback<NotebookRepoWithVersionControl.Revision>)new WebSocketServiceCallback<NotebookRepoWithVersionControl.Revision>(conn){

            @Override
            public void onSuccess(NotebookRepoWithVersionControl.Revision revision, ServiceContext context) throws IOException {
                super.onSuccess(revision, context);
                if (!NotebookRepoWithVersionControl.Revision.isEmpty((NotebookRepoWithVersionControl.Revision)revision)) {
                    List revisions = NotebookServer.this.getNotebook().listRevisionHistory(noteId, NotebookServer.this.getNotebook().getNote(noteId).getPath(), context.getAutheInfo());
                    conn.send(NotebookServer.this.serializeMessage(new Message(Message.OP.LIST_REVISION_HISTORY).put("revisionList", (Object)revisions)));
                } else {
                    conn.send(NotebookServer.this.serializeMessage(new Message(Message.OP.ERROR_INFO).put("info", (Object)"Couldn't checkpoint note revision: possibly no changes found or storage doesn't support versioning. Please check the logs for more details.")));
                }
            }
        });
    }

    private void listRevisionHistory(final NotebookSocket conn, Message fromMessage) throws IOException {
        String noteId = (String)fromMessage.get("noteId");
        this.getNotebookService().listRevisionHistory(noteId, this.getServiceContext(fromMessage), (ServiceCallback<List<NotebookRepoWithVersionControl.Revision>>)new WebSocketServiceCallback<List<NotebookRepoWithVersionControl.Revision>>(conn){

            @Override
            public void onSuccess(List<NotebookRepoWithVersionControl.Revision> revisions, ServiceContext context) throws IOException {
                super.onSuccess(revisions, context);
                conn.send(NotebookServer.this.serializeMessage(new Message(Message.OP.LIST_REVISION_HISTORY).put("revisionList", revisions)));
            }
        });
    }

    private void setNoteRevision(final NotebookSocket conn, Message fromMessage) throws IOException {
        final String noteId = (String)fromMessage.get("noteId");
        String revisionId = (String)fromMessage.get("revisionId");
        this.getNotebookService().setNoteRevision(noteId, revisionId, this.getServiceContext(fromMessage), (ServiceCallback<Note>)new WebSocketServiceCallback<Note>(conn){

            @Override
            public void onSuccess(Note note, ServiceContext context) throws IOException {
                super.onSuccess(note, context);
                Note reloadedNote = NotebookServer.this.getNotebook().loadNoteFromRepo(noteId, context.getAutheInfo());
                conn.send(NotebookServer.this.serializeMessage(new Message(Message.OP.SET_NOTE_REVISION).put("status", (Object)true)));
                NotebookServer.this.broadcastNote(reloadedNote);
            }
        });
    }

    private void getNoteByRevision(final NotebookSocket conn, Message fromMessage) throws IOException {
        final String noteId = (String)fromMessage.get("noteId");
        final String revisionId = (String)fromMessage.get("revisionId");
        this.getNotebookService().getNotebyRevision(noteId, revisionId, this.getServiceContext(fromMessage), (ServiceCallback<Note>)new WebSocketServiceCallback<Note>(conn){

            @Override
            public void onSuccess(Note note, ServiceContext context) throws IOException {
                super.onSuccess(note, context);
                conn.send(NotebookServer.this.serializeMessage(new Message(Message.OP.NOTE_REVISION).put("noteId", (Object)noteId).put("revisionId", (Object)revisionId).put("note", (Object)note)));
            }
        });
    }

    private void getNoteByRevisionForCompare(final NotebookSocket conn, Message fromMessage) throws IOException {
        final String noteId = (String)fromMessage.get("noteId");
        final String revisionId = (String)fromMessage.get("revisionId");
        final String position = (String)fromMessage.get("position");
        this.getNotebookService().getNoteByRevisionForCompare(noteId, revisionId, this.getServiceContext(fromMessage), (ServiceCallback<Note>)new WebSocketServiceCallback<Note>(conn){

            @Override
            public void onSuccess(Note note, ServiceContext context) throws IOException {
                super.onSuccess(note, context);
                conn.send(NotebookServer.this.serializeMessage(new Message(Message.OP.NOTE_REVISION_FOR_COMPARE).put("noteId", (Object)noteId).put("revisionId", (Object)revisionId).put("position", (Object)position).put("note", (Object)note)));
            }
        });
    }

    public void onOutputAppend(String noteId, String paragraphId, int index, String output) {
        Message msg = new Message(Message.OP.PARAGRAPH_APPEND_OUTPUT).put("noteId", (Object)noteId).put("paragraphId", (Object)paragraphId).put("index", (Object)index).put("data", (Object)output);
        this.getConnectionManager().broadcast(noteId, msg);
    }

    public void onOutputUpdated(String noteId, String paragraphId, int index, InterpreterResult.Type type, String output) {
        Message msg = new Message(Message.OP.PARAGRAPH_UPDATE_OUTPUT).put("noteId", (Object)noteId).put("paragraphId", (Object)paragraphId).put("index", (Object)index).put("type", (Object)type).put("data", (Object)output);
        try {
            Note note = this.getNotebook().getNote(noteId);
            if (note == null) {
                LOG.warn("Note " + noteId + " note found");
                return;
            }
            Paragraph paragraph = note.getParagraph(paragraphId);
            paragraph.updateOutputBuffer(index, type, output);
            if (note.isPersonalizedMode()) {
                String user = note.getParagraph(paragraphId).getUser();
                if (null != user) {
                    this.getConnectionManager().multicastToUser(user, msg);
                }
            } else {
                this.getConnectionManager().broadcast(noteId, msg);
            }
        }
        catch (IOException e) {
            LOG.warn("Fail to call onOutputUpdated", (Throwable)e);
        }
    }

    public void onOutputClear(String noteId, String paragraphId) {
        try {
            Note note = this.getNotebook().getNote(noteId);
            if (note == null) {
                LOG.warn("Note {} doesn't existed, it maybe deleted.", (Object)noteId);
            } else {
                note.clearParagraphOutput(paragraphId);
                Paragraph paragraph = note.getParagraph(paragraphId);
                this.broadcastParagraph(note, paragraph);
            }
        }
        catch (IOException e) {
            LOG.warn("Fail to call onOutputClear", (Throwable)e);
        }
    }

    public void onOutputAppend(String noteId, String paragraphId, int index, String appId, String output) {
        Message msg = new Message(Message.OP.APP_APPEND_OUTPUT).put("noteId", (Object)noteId).put("paragraphId", (Object)paragraphId).put("index", (Object)index).put("appId", (Object)appId).put("data", (Object)output);
        this.getConnectionManager().broadcast(noteId, msg);
    }

    public void onOutputUpdated(String noteId, String paragraphId, int index, String appId, InterpreterResult.Type type, String output) {
        Message msg = new Message(Message.OP.APP_UPDATE_OUTPUT).put("noteId", (Object)noteId).put("paragraphId", (Object)paragraphId).put("index", (Object)index).put("type", (Object)type).put("appId", (Object)appId).put("data", (Object)output);
        this.getConnectionManager().broadcast(noteId, msg);
    }

    public void onLoad(String noteId, String paragraphId, String appId, HeliumPackage pkg) {
        Message msg = new Message(Message.OP.APP_LOAD).put("noteId", (Object)noteId).put("paragraphId", (Object)paragraphId).put("appId", (Object)appId).put("pkg", (Object)pkg);
        this.getConnectionManager().broadcast(noteId, msg);
    }

    public void onStatusChange(String noteId, String paragraphId, String appId, String status) {
        Message msg = new Message(Message.OP.APP_STATUS_CHANGE).put("noteId", (Object)noteId).put("paragraphId", (Object)paragraphId).put("appId", (Object)appId).put("status", (Object)status);
        this.getConnectionManager().broadcast(noteId, msg);
    }

    public void runParagraphs(String noteId, List<Integer> paragraphIndices, List<String> paragraphIds, String curParagraphId) throws IOException {
        final Note note = this.getNotebook().getNote(noteId);
        final ArrayList<String> toBeRunParagraphIds = new ArrayList<String>();
        if (note == null) {
            throw new IOException("Not existed noteId: " + noteId);
        }
        if (!paragraphIds.isEmpty() && !paragraphIndices.isEmpty()) {
            throw new IOException("Can not specify paragraphIds and paragraphIndices together");
        }
        if (paragraphIds != null && !paragraphIds.isEmpty()) {
            for (String paragraphId : paragraphIds) {
                if (note.getParagraph(paragraphId) == null) {
                    throw new IOException("Not existed paragraphId: " + paragraphId);
                }
                if (paragraphId.equals(curParagraphId)) continue;
                toBeRunParagraphIds.add(paragraphId);
            }
        }
        if (paragraphIndices != null && !paragraphIndices.isEmpty()) {
            Iterator<Object> iterator = paragraphIndices.iterator();
            while (iterator.hasNext()) {
                int paragraphIndex = (Integer)iterator.next();
                if (note.getParagraph(paragraphIndex) == null) {
                    throw new IOException("Not existed paragraphIndex: " + paragraphIndex);
                }
                if (note.getParagraph(paragraphIndex).getId().equals(curParagraphId)) continue;
                toBeRunParagraphIds.add(note.getParagraph(paragraphIndex).getId());
            }
        }
        if (paragraphIds.isEmpty() && paragraphIndices.isEmpty()) {
            for (Paragraph paragraph : note.getParagraphs()) {
                if (paragraph.getId().equals(curParagraphId)) continue;
                toBeRunParagraphIds.add(paragraph.getId());
            }
        }
        Runnable runThread = new Runnable(){

            @Override
            public void run() {
                for (String paragraphId : toBeRunParagraphIds) {
                    note.run(paragraphId, true);
                }
            }
        };
        this.executorService.submit(runThread);
    }

    public void onParagraphRemove(Paragraph p) {
        try {
            this.getJobManagerService().getNoteJobInfoByUnixTime(System.currentTimeMillis() - 5000L, null, new JobManagerServiceCallback());
        }
        catch (IOException e) {
            LOG.warn("can not broadcast for job manager: " + e.getMessage(), (Throwable)e);
        }
    }

    public void onNoteRemove(Note note, AuthenticationInfo subject) {
        try {
            this.broadcastUpdateNoteJobInfo(System.currentTimeMillis() - 5000L);
        }
        catch (IOException e) {
            LOG.warn("can not broadcast for job manager: " + e.getMessage(), (Throwable)e);
        }
        try {
            this.getJobManagerService().removeNoteJobInfo(note.getId(), null, new JobManagerServiceCallback());
        }
        catch (IOException e) {
            LOG.warn("can not broadcast for job manager: " + e.getMessage(), (Throwable)e);
        }
    }

    public void onParagraphCreate(Paragraph p) {
        try {
            this.getJobManagerService().getNoteJobInfo(p.getNote().getId(), null, new JobManagerServiceCallback());
        }
        catch (IOException e) {
            LOG.warn("can not broadcast for job manager: " + e.getMessage(), (Throwable)e);
        }
    }

    public void onParagraphUpdate(Paragraph p) throws IOException {
    }

    public void onNoteCreate(Note note, AuthenticationInfo subject) {
        try {
            this.getJobManagerService().getNoteJobInfo(note.getId(), null, new JobManagerServiceCallback());
        }
        catch (IOException e) {
            LOG.warn("can not broadcast for job manager: " + e.getMessage(), (Throwable)e);
        }
    }

    public void onNoteUpdate(Note note, AuthenticationInfo subject) throws IOException {
    }

    public void onParagraphStatusChange(Paragraph p, Job.Status status) {
        try {
            this.getJobManagerService().getNoteJobInfo(p.getNote().getId(), null, new JobManagerServiceCallback());
        }
        catch (IOException e) {
            LOG.warn("can not broadcast for job manager: " + e.getMessage(), (Throwable)e);
        }
    }

    public void onProgressUpdate(Paragraph p, int progress) {
        this.getConnectionManager().broadcast(p.getNote().getId(), new Message(Message.OP.PROGRESS).put("id", (Object)p.getId()).put("progress", (Object)progress));
    }

    public void onStatusChange(Paragraph p, Job.Status before, Job.Status after) {
        if (after == Job.Status.ERROR && p.getException() != null) {
            LOG.error("Error", p.getException());
        }
        if (p.isTerminated()) {
            if (p.getStatus() == Job.Status.FINISHED) {
                LOG.info("Job {} is finished successfully, status: {}", (Object)p.getId(), (Object)p.getStatus());
            } else {
                LOG.warn("Job {} is finished, status: {}, exception: {}, result: {}", new Object[]{p.getId(), p.getStatus(), p.getException(), p.getReturn()});
            }
            try {
                if (this.getNotebook().getNote(p.getNote().getId()) == null) {
                    LOG.warn("Note {} doesn't existed.", (Object)p.getNote().getId());
                } else {
                    this.getNotebook().saveNote(p.getNote(), p.getAuthenticationInfo());
                }
            }
            catch (IOException e) {
                LOG.error(e.toString(), (Throwable)e);
            }
        }
        p.setStatusToUserParagraph(p.getStatus());
        this.broadcastParagraph(p.getNote(), p);
        try {
            this.broadcastUpdateNoteJobInfo(System.currentTimeMillis() - 5000L);
        }
        catch (IOException e) {
            LOG.error("can not broadcast for job manager {}", (Throwable)e);
        }
    }

    public void checkpointOutput(String noteId, String paragraphId) {
        try {
            Note note = this.getNotebook().getNote(noteId);
            note.getParagraph(paragraphId).checkpointOutput();
        }
        catch (IOException e) {
            LOG.warn("Fail to save note: " + noteId, (Throwable)e);
        }
    }

    public void noteRunningStatusChange(String noteId, boolean newStatus) {
        this.getConnectionManager().broadcast(noteId, new Message(Message.OP.NOTE_RUNNING_STATUS).put("status", (Object)newStatus));
    }

    private void sendAllAngularObjects(Note note, String user, NotebookSocket conn) throws IOException {
        List settings = this.getNotebook().getBindedInterpreterSettings(note.getId());
        if (settings == null || settings.size() == 0) {
            return;
        }
        for (InterpreterSetting intpSetting : settings) {
            if (intpSetting.getInterpreterGroup(user, note.getId()) == null) continue;
            AngularObjectRegistry registry = intpSetting.getInterpreterGroup(user, note.getId()).getAngularObjectRegistry();
            List objects = registry.getAllWithGlobal(note.getId());
            for (AngularObject object : objects) {
                conn.send(this.serializeMessage(new Message(Message.OP.ANGULAR_OBJECT_UPDATE).put("angularObject", (Object)object).put("interpreterGroupId", (Object)intpSetting.getInterpreterGroup(user, note.getId()).getId()).put("noteId", (Object)note.getId()).put("paragraphId", (Object)object.getParagraphId())));
            }
        }
    }

    public void onAdd(String interpreterGroupId, AngularObject object) {
        this.onUpdate(interpreterGroupId, object);
    }

    public void onUpdate(String interpreterGroupId, AngularObject object) {
        if (this.getNotebook() == null) {
            return;
        }
        List notes = this.getNotebook().getAllNotes();
        for (Note note : notes) {
            List intpSettings;
            if (object.getNoteId() != null && !note.getId().equals(object.getNoteId()) || (intpSettings = note.getBindedInterpreterSettings(new ArrayList(this.getNotebookAuthorizationService().getOwners(note.getId())))).isEmpty()) continue;
            this.getConnectionManager().broadcast(note.getId(), new Message(Message.OP.ANGULAR_OBJECT_UPDATE).put("angularObject", (Object)object).put("interpreterGroupId", (Object)interpreterGroupId).put("noteId", (Object)note.getId()).put("paragraphId", (Object)object.getParagraphId()));
        }
    }

    public void onRemove(String interpreterGroupId, String name, String noteId, String paragraphId) {
        List notes = this.getNotebook().getAllNotes();
        block0: for (Note note : notes) {
            if (noteId != null && !note.getId().equals(noteId)) continue;
            List settingIds = this.getNotebook().getInterpreterSettingManager().getSettingIds();
            for (String id : settingIds) {
                if (!interpreterGroupId.contains(id)) continue;
                this.getConnectionManager().broadcast(note.getId(), new Message(Message.OP.ANGULAR_OBJECT_REMOVE).put("name", (Object)name).put("noteId", (Object)noteId).put("paragraphId", (Object)paragraphId));
                continue block0;
            }
        }
    }

    private void getEditorSetting(final NotebookSocket conn, Message fromMessage) throws IOException {
        final String paragraphId = (String)fromMessage.get("paragraphId");
        String magic = (String)fromMessage.get("magic");
        String noteId = this.getConnectionManager().getAssociatedNoteId(conn);
        this.getNotebookService().getEditorSetting(noteId, magic, this.getServiceContext(fromMessage), (ServiceCallback<Map<String, Object>>)new WebSocketServiceCallback<Map<String, Object>>(conn){

            @Override
            public void onSuccess(Map<String, Object> settings, ServiceContext context) throws IOException {
                super.onSuccess(settings, context);
                Message resp = new Message(Message.OP.EDITOR_SETTING);
                resp.put("paragraphId", (Object)paragraphId);
                resp.put("editor", settings);
                conn.send(NotebookServer.this.serializeMessage(resp));
            }

            @Override
            public void onFailure(Exception ex, ServiceContext context) throws IOException {
                LOG.warn(ex.getMessage());
            }
        });
    }

    private void getInterpreterSettings(NotebookSocket conn, Message message) throws IOException {
        ServiceContext context = this.getServiceContext(message);
        List allSettings = this.getNotebook().getInterpreterSettingManager().get();
        ArrayList<InterpreterSetting> result = new ArrayList<InterpreterSetting>();
        for (InterpreterSetting setting : allSettings) {
            if (!setting.isUserAuthorized(new ArrayList<String>(context.getUserAndRoles()))) continue;
            result.add(setting);
        }
        conn.send(this.serializeMessage(new Message(Message.OP.INTERPRETER_SETTINGS).put("interpreterSettings", result)));
    }

    public void onParaInfosReceived(String noteId, String paragraphId, String interpreterSettingId, Map<String, String> metaInfos) {
        try {
            Paragraph paragraph;
            Note note = this.getNotebook().getNote(noteId);
            if (note != null && (paragraph = note.getParagraph(paragraphId)) != null) {
                InterpreterSetting setting = this.getNotebook().getInterpreterSettingManager().get(interpreterSettingId);
                String label = metaInfos.get("label");
                String tooltip = metaInfos.get("tooltip");
                List<String> keysToRemove = Arrays.asList("noteId", "paraId", "label", "tooltip");
                for (String removeKey : keysToRemove) {
                    metaInfos.remove(removeKey);
                }
                paragraph.updateRuntimeInfos(label, tooltip, metaInfos, setting.getGroup(), setting.getId());
                this.getConnectionManager().broadcast(note.getId(), new Message(Message.OP.PARAS_INFO).put("id", (Object)paragraphId).put("infos", (Object)paragraph.getRuntimeInfos()));
            }
        }
        catch (IOException e) {
            LOG.warn("Fail to call onParaInfosReceived", (Throwable)e);
        }
    }

    public List<ParagraphInfo> getParagraphList(String user, String noteId) throws TException, IOException {
        Notebook notebook = this.getNotebook();
        Note note = notebook.getNote(noteId);
        if (null == note) {
            throw new ServiceException("Not found this note : " + noteId);
        }
        HashSet<String> userAndRoles = new HashSet<String>();
        userAndRoles.add(user);
        AuthorizationService notebookAuthorization = this.getNotebookAuthorizationService();
        boolean isAllowed = notebookAuthorization.isReader(noteId, userAndRoles);
        Set allowed = notebookAuthorization.getReaders(noteId);
        if (!isAllowed) {
            String errorMsg = "Insufficient privileges to READER note. Allowed users or roles: " + allowed;
            throw new ServiceException(errorMsg);
        }
        ArrayList<ParagraphInfo> paragraphInfos = new ArrayList<ParagraphInfo>();
        List paragraphs = note.getParagraphs();
        for (Paragraph paragraph : paragraphs) {
            ParagraphInfo paraInfo = new ParagraphInfo();
            paraInfo.setNoteId(noteId);
            paraInfo.setParagraphId(paragraph.getId());
            paraInfo.setParagraphTitle(paragraph.getTitle());
            paraInfo.setParagraphText(paragraph.getText());
            paragraphInfos.add(paraInfo);
        }
        return paragraphInfos;
    }

    private void broadcastNoteForms(Note note) {
        GUI formsSettings = new GUI();
        formsSettings.setForms(note.getNoteForms());
        formsSettings.setParams(note.getNoteParams());
        this.getConnectionManager().broadcast(note.getId(), new Message(Message.OP.SAVE_NOTE_FORMS).put("formsData", (Object)formsSettings));
    }

    private void saveNoteForms(NotebookSocket conn, Message fromMessage) throws IOException {
        String noteId = (String)fromMessage.get("noteId");
        Map noteParams = (Map)fromMessage.get("noteParams");
        this.getNotebookService().saveNoteForms(noteId, noteParams, this.getServiceContext(fromMessage), (ServiceCallback<Note>)new WebSocketServiceCallback<Note>(conn){

            @Override
            public void onSuccess(Note note, ServiceContext context) throws IOException {
                NotebookServer.this.broadcastNoteForms(note);
            }
        });
    }

    private void removeNoteForms(NotebookSocket conn, Message fromMessage) throws IOException {
        String noteId = (String)fromMessage.get("noteId");
        String formName = (String)fromMessage.get("formName");
        this.getNotebookService().removeNoteForms(noteId, formName, this.getServiceContext(fromMessage), (ServiceCallback<Note>)new WebSocketServiceCallback<Note>(conn){

            @Override
            public void onSuccess(Note note, ServiceContext context) throws IOException {
                NotebookServer.this.broadcastNoteForms(note);
            }
        });
    }

    @ManagedAttribute
    public Set<String> getConnectedUsers() {
        return this.getConnectionManager().getConnectedUsers();
    }

    @ManagedOperation
    public void sendMessage(String message) {
        Message m = new Message(Message.OP.NOTICE);
        m.data.put("notice", message);
        this.getConnectionManager().broadcast(m);
    }

    private ServiceContext getServiceContext(Message message) {
        HashSet roles;
        AuthenticationInfo authInfo = new AuthenticationInfo(message.principal, message.roles, message.ticket);
        HashSet<String> userAndRoles = new HashSet<String>();
        userAndRoles.add(message.principal);
        if (message.roles != null && !message.roles.equals("") && (roles = (HashSet)gson.fromJson(message.roles, new TypeToken<HashSet<String>>(){}.getType())) != null) {
            userAndRoles.addAll(roles);
        }
        return new ServiceContext(authInfo, userAndRoles);
    }

    public class WebSocketServiceCallback<T>
    extends SimpleServiceCallback<T> {
        private NotebookSocket conn;

        WebSocketServiceCallback(NotebookSocket conn) {
            this.conn = conn;
        }

        @Override
        public void onFailure(Exception ex, ServiceContext context) throws IOException {
            super.onFailure(ex, context);
            if (ex instanceof ForbiddenException) {
                Type type = new TypeToken<Map<String, String>>(){}.getType();
                Map jsonObject = (Map)gson.fromJson(((ForbiddenException)((Object)ex)).getResponse().getEntity().toString(), type);
                this.conn.send(NotebookServer.this.serializeMessage(new Message(Message.OP.AUTH_INFO).put("info", jsonObject.get("message"))));
            } else {
                String message = ex.getMessage();
                if (ex.getCause() != null) {
                    message = message + ", cause: " + ex.getCause().getMessage();
                }
                this.conn.send(NotebookServer.this.serializeMessage(new Message(Message.OP.ERROR_INFO).put("info", (Object)message)));
            }
        }
    }

    private class JobManagerServiceCallback
    extends SimpleServiceCallback<List<JobManagerService.NoteJobInfo>> {
        private JobManagerServiceCallback() {
        }

        @Override
        public void onSuccess(List<JobManagerService.NoteJobInfo> notesJobInfo, ServiceContext context) throws IOException {
            super.onSuccess(notesJobInfo, context);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("lastResponseUnixTime", System.currentTimeMillis());
            response.put("jobs", notesJobInfo);
            NotebookServer.this.getConnectionManager().broadcast(JobManagerServiceType.JOB_MANAGER_PAGE.getKey(), new Message(Message.OP.LIST_UPDATE_NOTE_JOBS).put("noteRunningJobs", response));
        }
    }

    protected static enum JobManagerServiceType {
        JOB_MANAGER_PAGE("JOB_MANAGER_PAGE");

        private String serviceTypeKey;

        private JobManagerServiceType(String serviceType) {
            this.serviceTypeKey = serviceType;
        }

        String getKey() {
            return this.serviceTypeKey;
        }
    }
}

