/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.utils;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import org.apache.zeppelin.server.ZeppelinServer;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.ServiceLocatorFactory;

public class TestUtils {
    public static <T> T getInstance(Class<T> clazz) {
        TestUtils.checkCalledByTestMethod();
        return TestUtils.getInstance(ZeppelinServer.sharedServiceLocator, clazz);
    }

    public static void clearInstances() {
        TestUtils.checkCalledByTestMethod();
        ServiceLocatorFactory.getInstance().destroy("shared-locator");
    }

    static <T> T getInstance(ServiceLocator serviceLocator, Class<T> clazz) {
        return (T)serviceLocator.getService(clazz, new Annotation[0]);
    }

    static void checkCalledByTestMethod() {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        if (Arrays.stream(stackTraceElements).noneMatch(stackTraceElement -> stackTraceElement.getClassName().contains("Test"))) {
            throw new RuntimeException("This method shouldn't be used in production");
        }
    }
}

