/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.thrift.TException;
import org.apache.thrift.TProcessor;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.display.AngularObject;
import org.apache.zeppelin.helium.ApplicationEventListener;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.InterpreterSettingManager;
import org.apache.zeppelin.interpreter.ManagedInterpreterGroup;
import org.apache.zeppelin.interpreter.remote.AppendOutputRunner;
import org.apache.zeppelin.interpreter.remote.InvokeResourceMethodEventMessage;
import org.apache.zeppelin.interpreter.remote.RemoteAngularObject;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterProcess;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterProcessListener;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterUtils;
import org.apache.zeppelin.interpreter.thrift.AppOutputAppendEvent;
import org.apache.zeppelin.interpreter.thrift.AppOutputUpdateEvent;
import org.apache.zeppelin.interpreter.thrift.AppStatusUpdateEvent;
import org.apache.zeppelin.interpreter.thrift.InterpreterRPCException;
import org.apache.zeppelin.interpreter.thrift.LibraryMetadata;
import org.apache.zeppelin.interpreter.thrift.OutputAppendEvent;
import org.apache.zeppelin.interpreter.thrift.OutputUpdateAllEvent;
import org.apache.zeppelin.interpreter.thrift.OutputUpdateEvent;
import org.apache.zeppelin.interpreter.thrift.ParagraphInfo;
import org.apache.zeppelin.interpreter.thrift.RegisterInfo;
import org.apache.zeppelin.interpreter.thrift.RemoteInterpreterEventService;
import org.apache.zeppelin.interpreter.thrift.RemoteInterpreterResultMessage;
import org.apache.zeppelin.interpreter.thrift.RunParagraphsEvent;
import org.apache.zeppelin.interpreter.thrift.WebUrlInfo;
import org.apache.zeppelin.notebook.Note;
import org.apache.zeppelin.resource.RemoteResource;
import org.apache.zeppelin.resource.Resource;
import org.apache.zeppelin.resource.ResourceId;
import org.apache.zeppelin.resource.ResourcePool;
import org.apache.zeppelin.resource.ResourceSet;
import org.apache.zeppelin.user.AuthenticationInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteInterpreterEventServer
implements RemoteInterpreterEventService.Iface {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteInterpreterEventServer.class);
    private static final Gson GSON = new Gson();
    private String portRange;
    private int port;
    private String host;
    private ZeppelinConfiguration zConf;
    private TThreadPoolServer thriftServer;
    private InterpreterSettingManager interpreterSettingManager;
    private final ScheduledExecutorService appendService = Executors.newSingleThreadScheduledExecutor();
    private ScheduledFuture<?> appendFuture;
    private AppendOutputRunner runner;
    private final RemoteInterpreterProcessListener listener;
    private final ApplicationEventListener appListener;

    public RemoteInterpreterEventServer(ZeppelinConfiguration zConf, InterpreterSettingManager interpreterSettingManager) {
        this.zConf = zConf;
        this.portRange = zConf.getZeppelinServerRPCPortRange();
        this.interpreterSettingManager = interpreterSettingManager;
        this.listener = interpreterSettingManager.getRemoteInterpreterProcessListener();
        this.appListener = interpreterSettingManager.getAppEventListener();
    }

    public void start() throws IOException {
        Thread startingThread = new Thread(){

            @Override
            public void run() {
                try (TServerSocket tSocket = new TServerSocket(RemoteInterpreterUtils.findAvailablePort((String)RemoteInterpreterEventServer.this.portRange));){
                    RemoteInterpreterEventServer.this.port = tSocket.getServerSocket().getLocalPort();
                    RemoteInterpreterEventServer.this.host = RemoteInterpreterUtils.findAvailableHostAddress();
                    LOGGER.info("InterpreterEventServer is starting at {}:{}", (Object)RemoteInterpreterEventServer.this.host, (Object)RemoteInterpreterEventServer.this.port);
                    RemoteInterpreterEventService.Processor processor = new RemoteInterpreterEventService.Processor((RemoteInterpreterEventService.Iface)RemoteInterpreterEventServer.this);
                    RemoteInterpreterEventServer.this.thriftServer = new TThreadPoolServer((TThreadPoolServer.Args)new TThreadPoolServer.Args((TServerTransport)tSocket).processor((TProcessor)processor));
                    RemoteInterpreterEventServer.this.thriftServer.serve();
                }
                catch (IOException | TTransportException e) {
                    throw new RuntimeException("Fail to create TServerSocket", e);
                }
                LOGGER.info("ThriftServer-Thread finished");
            }
        };
        startingThread.start();
        long start = System.currentTimeMillis();
        while (!(System.currentTimeMillis() - start >= 30000L || this.thriftServer != null && this.thriftServer.isServing())) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }
        if (this.thriftServer != null && !this.thriftServer.isServing()) {
            throw new IOException("Fail to start InterpreterEventServer in 30 seconds.");
        }
        LOGGER.info("RemoteInterpreterEventServer is started");
        this.runner = new AppendOutputRunner(this.listener);
        this.appendFuture = this.appendService.scheduleWithFixedDelay(this.runner, 0L, AppendOutputRunner.BUFFER_TIME_MS, TimeUnit.MILLISECONDS);
    }

    public void stop() {
        if (this.thriftServer != null) {
            this.thriftServer.stop();
        }
        if (this.appendFuture != null) {
            this.appendFuture.cancel(true);
        }
        this.appendService.shutdownNow();
        LOGGER.info("RemoteInterpreterEventServer is stopped");
    }

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public void registerInterpreterProcess(RegisterInfo registerInfo) throws InterpreterRPCException, TException {
        ManagedInterpreterGroup interpreterGroup = this.interpreterSettingManager.getInterpreterGroupById(registerInfo.getInterpreterGroupId());
        if (interpreterGroup == null) {
            LOGGER.warn("Unable to register interpreter process, because no such interpreterGroup: {}", (Object)registerInfo.getInterpreterGroupId());
            return;
        }
        RemoteInterpreterProcess interpreterProcess = interpreterGroup.getInterpreterProcess();
        if (interpreterProcess == null) {
            LOGGER.warn("Unable to register interpreter process, because no interpreter process associated with interpreterGroup: {}", (Object)registerInfo.getInterpreterGroupId());
            return;
        }
        LOGGER.info("Register interpreter process: {}:{}, interpreterGroup: {}", new Object[]{registerInfo.getHost(), registerInfo.getPort(), registerInfo.getInterpreterGroupId()});
        interpreterProcess.processStarted(registerInfo.port, registerInfo.host);
    }

    public void unRegisterInterpreterProcess(String intpGroupId) throws InterpreterRPCException, TException {
        LOGGER.info("Unregister interpreter process: {}", (Object)intpGroupId);
        ManagedInterpreterGroup interpreterGroup = this.interpreterSettingManager.getInterpreterGroupById(intpGroupId);
        if (interpreterGroup == null) {
            LOGGER.warn("Unable to unregister interpreter process because no such interpreterGroup: {}", (Object)intpGroupId);
            return;
        }
        interpreterGroup.close();
        this.interpreterSettingManager.removeInterpreterGroup(intpGroupId);
    }

    public void sendWebUrl(WebUrlInfo weburlInfo) throws InterpreterRPCException, TException {
        ManagedInterpreterGroup interpreterGroup = this.interpreterSettingManager.getInterpreterGroupById(weburlInfo.getInterpreterGroupId());
        if (interpreterGroup == null) {
            LOGGER.warn("Unable to sendWebUrl, because no such interpreterGroup: {}", (Object)weburlInfo.getInterpreterGroupId());
            return;
        }
        interpreterGroup.setWebUrl(weburlInfo.getWeburl());
    }

    public void appendOutput(OutputAppendEvent event) throws InterpreterRPCException, TException {
        if (event.getAppId() == null) {
            this.runner.appendBuffer(event.getNoteId(), event.getParagraphId(), event.getIndex(), event.getData());
        } else {
            this.appListener.onOutputAppend(event.getNoteId(), event.getParagraphId(), event.getIndex(), event.getAppId(), event.getData());
        }
    }

    public void updateOutput(OutputUpdateEvent event) throws InterpreterRPCException, TException {
        if (event.getAppId() == null) {
            this.listener.onOutputUpdated(event.getNoteId(), event.getParagraphId(), event.getIndex(), InterpreterResult.Type.valueOf((String)event.getType()), event.getData());
        } else {
            this.appListener.onOutputUpdated(event.getNoteId(), event.getParagraphId(), event.getIndex(), event.getAppId(), InterpreterResult.Type.valueOf((String)event.getType()), event.getData());
        }
    }

    public void updateAllOutput(OutputUpdateAllEvent event) throws InterpreterRPCException, TException {
        this.listener.onOutputClear(event.getNoteId(), event.getParagraphId());
        for (int i = 0; i < event.getMsg().size(); ++i) {
            RemoteInterpreterResultMessage msg = (RemoteInterpreterResultMessage)event.getMsg().get(i);
            this.listener.onOutputUpdated(event.getNoteId(), event.getParagraphId(), i, InterpreterResult.Type.valueOf((String)msg.getType()), msg.getData());
        }
    }

    public void appendAppOutput(AppOutputAppendEvent event) throws InterpreterRPCException, TException {
        this.appListener.onOutputAppend(event.noteId, event.paragraphId, event.index, event.appId, event.data);
    }

    public void updateAppOutput(AppOutputUpdateEvent event) throws InterpreterRPCException, TException {
        this.appListener.onOutputUpdated(event.noteId, event.paragraphId, event.index, event.appId, InterpreterResult.Type.valueOf((String)event.type), event.data);
    }

    public void updateAppStatus(AppStatusUpdateEvent event) throws InterpreterRPCException, TException {
        this.appListener.onStatusChange(event.noteId, event.paragraphId, event.appId, event.status);
    }

    public void checkpointOutput(String noteId, String paragraphId) throws InterpreterRPCException, TException {
        this.listener.checkpointOutput(noteId, paragraphId);
    }

    public void runParagraphs(RunParagraphsEvent event) throws InterpreterRPCException, TException {
        try {
            this.listener.runParagraphs(event.getNoteId(), event.getParagraphIndices(), event.getParagraphIds(), event.getCurParagraphId());
            if (InterpreterContext.get() != null) {
                LOGGER.info("complete runParagraphs.{} {}", (Object)InterpreterContext.get().getParagraphId(), (Object)event);
            } else {
                LOGGER.info("complete runParagraphs.{}", (Object)event);
            }
        }
        catch (IOException e) {
            throw new InterpreterRPCException(e.toString());
        }
    }

    public void addAngularObject(String intpGroupId, String json) throws InterpreterRPCException, TException {
        LOGGER.debug("Add AngularObject, interpreterGroupId: {}, json: {}", (Object)intpGroupId, (Object)json);
        AngularObject angularObject = AngularObject.fromJson((String)json);
        ManagedInterpreterGroup interpreterGroup = this.interpreterSettingManager.getInterpreterGroupById(intpGroupId);
        if (interpreterGroup == null) {
            LOGGER.warn("Invalid InterpreterGroupId: {}", (Object)intpGroupId);
            return;
        }
        interpreterGroup.getAngularObjectRegistry().add(angularObject.getName(), angularObject.get(), angularObject.getNoteId(), angularObject.getParagraphId());
        if (angularObject.getNoteId() != null) {
            try {
                Note note = this.interpreterSettingManager.getNotebook().getNote(angularObject.getNoteId());
                if (note != null) {
                    note.addOrUpdateAngularObject(intpGroupId, angularObject);
                    this.interpreterSettingManager.getNotebook().saveNote(note, AuthenticationInfo.ANONYMOUS);
                }
            }
            catch (IOException e) {
                LOGGER.error("Fail to get note: {}", (Object)angularObject.getNoteId());
            }
        }
    }

    public void updateAngularObject(String intpGroupId, String json) throws InterpreterRPCException, TException {
        AngularObject angularObject = AngularObject.fromJson((String)json);
        ManagedInterpreterGroup interpreterGroup = this.interpreterSettingManager.getInterpreterGroupById(intpGroupId);
        if (interpreterGroup == null) {
            throw new InterpreterRPCException("Invalid InterpreterGroupId: " + intpGroupId);
        }
        AngularObject localAngularObject = interpreterGroup.getAngularObjectRegistry().get(angularObject.getName(), angularObject.getNoteId(), angularObject.getParagraphId());
        if (localAngularObject instanceof RemoteAngularObject) {
            ((RemoteAngularObject)localAngularObject).set(angularObject.get(), true, false);
        } else {
            localAngularObject.set(angularObject.get());
        }
        if (angularObject.getNoteId() != null) {
            try {
                Note note = this.interpreterSettingManager.getNotebook().getNote(angularObject.getNoteId());
                if (note != null) {
                    note.addOrUpdateAngularObject(intpGroupId, angularObject);
                    this.interpreterSettingManager.getNotebook().saveNote(note, AuthenticationInfo.ANONYMOUS);
                }
            }
            catch (IOException e) {
                LOGGER.error("Fail to get note: {}", (Object)angularObject.getNoteId());
            }
        }
    }

    public void removeAngularObject(String intpGroupId, String noteId, String paragraphId, String name) throws InterpreterRPCException, TException {
        ManagedInterpreterGroup interpreterGroup = this.interpreterSettingManager.getInterpreterGroupById(intpGroupId);
        if (interpreterGroup == null) {
            throw new InterpreterRPCException("Invalid InterpreterGroupId: " + intpGroupId);
        }
        interpreterGroup.getAngularObjectRegistry().remove(name, noteId, paragraphId);
        if (noteId != null) {
            try {
                Note note = this.interpreterSettingManager.getNotebook().getNote(noteId);
                note.deleteAngularObject(intpGroupId, noteId, paragraphId, name);
            }
            catch (IOException e) {
                LOGGER.warn("Fail to get note: {}", (Object)noteId, (Object)e);
            }
        }
    }

    public void sendParagraphInfo(String intpGroupId, String json) throws InterpreterRPCException, TException {
        ManagedInterpreterGroup interpreterGroup = this.interpreterSettingManager.getInterpreterGroupById(intpGroupId);
        if (interpreterGroup == null) {
            throw new InterpreterRPCException("Invalid InterpreterGroupId: " + intpGroupId);
        }
        Map paraInfos = (Map)GSON.fromJson(json, new TypeToken<Map<String, String>>(){}.getType());
        String noteId = (String)paraInfos.get("noteId");
        String paraId = (String)paraInfos.get("paraId");
        String settingId = interpreterGroup.getInterpreterSetting().getId();
        if (noteId != null && paraId != null && settingId != null) {
            this.listener.onParaInfosReceived(noteId, paraId, settingId, paraInfos);
        }
    }

    public List<String> getAllResources(String intpGroupId) throws InterpreterRPCException, TException {
        ResourceSet resourceSet = this.getAllResourcePoolExcept(intpGroupId);
        LinkedList<String> resourceList = new LinkedList<String>();
        for (Resource r : resourceSet) {
            resourceList.add(r.toJson());
        }
        return resourceList;
    }

    public ByteBuffer getResource(String resourceIdJson) throws InterpreterRPCException, TException {
        ByteBuffer obj;
        ResourceId resourceId = ResourceId.fromJson((String)resourceIdJson);
        Object o = this.getResource(resourceId);
        if (o == null) {
            obj = ByteBuffer.allocate(0);
        } else {
            try {
                obj = Resource.serializeObject((Object)o);
            }
            catch (IOException e) {
                throw new InterpreterRPCException(e.toString());
            }
        }
        return obj;
    }

    public ByteBuffer invokeMethod(String intpGroupId, String invokeMethodJson) throws InterpreterRPCException, TException {
        InvokeResourceMethodEventMessage invokeMethodMessage = InvokeResourceMethodEventMessage.fromJson((String)invokeMethodJson);
        Object ret = this.invokeResourceMethod(intpGroupId, invokeMethodMessage);
        ByteBuffer obj = null;
        if (ret == null) {
            obj = ByteBuffer.allocate(0);
        } else {
            try {
                obj = Resource.serializeObject((Object)ret);
            }
            catch (IOException e) {
                LOGGER.error("invokeMethod failed", (Throwable)e);
            }
        }
        return obj;
    }

    public List<ParagraphInfo> getParagraphList(String user, String noteId) throws InterpreterRPCException, TException {
        LOGGER.info("get paragraph list from remote interpreter noteId: {}, user = {}", (Object)noteId, (Object)user);
        if (user != null && noteId != null) {
            List<ParagraphInfo> paragraphInfos = null;
            try {
                paragraphInfos = this.listener.getParagraphList(user, noteId);
            }
            catch (IOException e) {
                throw new InterpreterRPCException(e.toString());
            }
            return paragraphInfos;
        }
        LOGGER.error("user or noteId is null!");
        return Collections.emptyList();
    }

    private Object invokeResourceMethod(String intpGroupId, InvokeResourceMethodEventMessage message) {
        ResourceId resourceId = message.resourceId;
        ManagedInterpreterGroup intpGroup = this.interpreterSettingManager.getInterpreterGroupById(resourceId.getResourcePoolId());
        if (intpGroup == null) {
            return null;
        }
        RemoteInterpreterProcess remoteInterpreterProcess = intpGroup.getRemoteInterpreterProcess();
        if (remoteInterpreterProcess == null) {
            ResourcePool localPool = intpGroup.getResourcePool();
            if (localPool != null) {
                Resource res = localPool.get(resourceId.getName());
                if (res != null) {
                    try {
                        return res.invokeMethod(message.methodName, message.getParamTypes(), message.params, message.returnResourceName);
                    }
                    catch (Exception e) {
                        LOGGER.error(e.getMessage(), (Throwable)e);
                        return null;
                    }
                }
                LOGGER.error("Can't invoke method {} on null object", (Object)message.methodName);
                return null;
            }
            LOGGER.error("no resource pool");
            return null;
        }
        if (remoteInterpreterProcess.isRunning()) {
            ByteBuffer res = (ByteBuffer)remoteInterpreterProcess.callRemoteFunction(client -> client.resourceInvokeMethod(resourceId.getNoteId(), resourceId.getParagraphId(), resourceId.getName(), message.toJson()));
            try {
                return Resource.deserializeObject((ByteBuffer)res);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                return null;
            }
        }
        return null;
    }

    private Object getResource(ResourceId resourceId) {
        ManagedInterpreterGroup intpGroup = this.interpreterSettingManager.getInterpreterGroupById(resourceId.getResourcePoolId());
        if (intpGroup == null) {
            return null;
        }
        RemoteInterpreterProcess remoteInterpreterProcess = intpGroup.getRemoteInterpreterProcess();
        ByteBuffer buffer = (ByteBuffer)remoteInterpreterProcess.callRemoteFunction(client -> client.resourceGet(resourceId.getNoteId(), resourceId.getParagraphId(), resourceId.getName()));
        try {
            return Resource.deserializeObject((ByteBuffer)buffer);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private ResourceSet getAllResourcePoolExcept(String interpreterGroupId) {
        ResourceSet resourceSet = new ResourceSet();
        for (ManagedInterpreterGroup intpGroup : this.interpreterSettingManager.getAllInterpreterGroup()) {
            if (intpGroup.getId().equals(interpreterGroupId)) continue;
            RemoteInterpreterProcess remoteInterpreterProcess = intpGroup.getRemoteInterpreterProcess();
            if (remoteInterpreterProcess == null) {
                ResourcePool localPool = intpGroup.getResourcePool();
                if (localPool == null) continue;
                resourceSet.addAll((Collection)localPool.getAll());
                continue;
            }
            if (!remoteInterpreterProcess.isRunning()) continue;
            List resourceList = (List)remoteInterpreterProcess.callRemoteFunction(client -> client.resourcePoolGetAll());
            for (String res : resourceList) {
                resourceSet.add((Object)RemoteResource.fromJson((String)res));
            }
        }
        return resourceSet;
    }

    public void updateParagraphConfig(String noteId, String paragraphId, Map<String, String> config) throws InterpreterRPCException, TException {
        try {
            Note note = this.interpreterSettingManager.getNotebook().getNote(noteId);
            note.getParagraph(paragraphId).updateConfig(config);
            this.interpreterSettingManager.getNotebook().saveNote(note, AuthenticationInfo.ANONYMOUS);
        }
        catch (Exception e) {
            LOGGER.error("Fail to updateParagraphConfig", (Throwable)e);
        }
    }

    public List<LibraryMetadata> getAllLibraryMetadatas(String interpreter) throws TException {
        if (StringUtils.isBlank((CharSequence)interpreter)) {
            LOGGER.warn("Interpreter is blank");
            return Collections.emptyList();
        }
        File interpreterLocalRepo = new File(this.zConf.getAbsoluteDir(ZeppelinConfiguration.ConfVars.ZEPPELIN_DEP_LOCALREPO) + File.separator + interpreter);
        if (!interpreterLocalRepo.exists()) {
            LOGGER.warn("Local interpreter repository {} for interpreter {} doesn't exists", (Object)interpreterLocalRepo, (Object)interpreter);
            return Collections.emptyList();
        }
        if (!interpreterLocalRepo.isDirectory()) {
            LOGGER.warn("Local interpreter repository {} is no folder", (Object)interpreterLocalRepo);
            return Collections.emptyList();
        }
        Collection files = FileUtils.listFiles((File)interpreterLocalRepo, (String[])new String[]{"jar"}, (boolean)false);
        ArrayList<LibraryMetadata> metaDatas = new ArrayList<LibraryMetadata>(files.size());
        for (File file : files) {
            try {
                metaDatas.add(new LibraryMetadata(file.getName(), FileUtils.checksumCRC32((File)file)));
            }
            catch (IOException e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
            }
        }
        return metaDatas;
    }

    public ByteBuffer getLibrary(String interpreter, String libraryName) throws TException {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{interpreter, libraryName})) {
            LOGGER.warn("Interpreter \"{}\" or libraryName \"{}\" is blank", (Object)interpreter, (Object)libraryName);
            return null;
        }
        File library = new File(this.zConf.getAbsoluteDir(ZeppelinConfiguration.ConfVars.ZEPPELIN_DEP_LOCALREPO) + File.separator + interpreter + File.separator + libraryName);
        if (!library.exists()) {
            LOGGER.warn("Library {} doesn't exists", (Object)library);
            return null;
        }
        try {
            return ByteBuffer.wrap(FileUtils.readFileToByteArray((File)library));
        }
        catch (IOException e) {
            LOGGER.error("Unable to read library {}", (Object)library, (Object)e);
            return null;
        }
    }
}

