/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.launcher;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.exec.environment.EnvironmentUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.interpreter.InterpreterOption;
import org.apache.zeppelin.interpreter.InterpreterRunner;
import org.apache.zeppelin.interpreter.launcher.InterpreterClient;
import org.apache.zeppelin.interpreter.launcher.InterpreterLaunchContext;
import org.apache.zeppelin.interpreter.launcher.InterpreterLauncher;
import org.apache.zeppelin.interpreter.recovery.RecoveryStorage;
import org.apache.zeppelin.interpreter.remote.ExecRemoteInterpreterProcess;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterRunningProcess;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardInterpreterLauncher
extends InterpreterLauncher {
    private static final Logger LOGGER = LoggerFactory.getLogger(StandardInterpreterLauncher.class);

    public StandardInterpreterLauncher(ZeppelinConfiguration zConf, RecoveryStorage recoveryStorage) {
        super(zConf, recoveryStorage);
    }

    public InterpreterClient launchDirectly(InterpreterLaunchContext context) throws IOException {
        LOGGER.info("Launching new interpreter process of {}", (Object)context.getInterpreterSettingGroup());
        this.properties = context.getProperties();
        InterpreterOption option = context.getOption();
        InterpreterRunner runner = context.getRunner();
        String groupName = context.getInterpreterSettingGroup();
        String name = context.getInterpreterSettingName();
        int connectTimeout = this.getConnectTimeout();
        int connectionPoolSize = this.getConnectPoolSize();
        if (option.isExistingProcess()) {
            return new RemoteInterpreterRunningProcess(context.getInterpreterSettingName(), context.getInterpreterGroupId(), connectTimeout, connectionPoolSize, context.getIntpEventServerHost(), context.getIntpEventServerPort(), option.getHost(), option.getPort(), false);
        }
        String localRepoPath = this.zConf.getInterpreterLocalRepoPath() + File.separator + context.getInterpreterSettingId();
        return new ExecRemoteInterpreterProcess(context.getIntpEventServerPort(), context.getIntpEventServerHost(), this.zConf.getInterpreterPortRange(), this.zConf.getInterpreterDir() + "/" + groupName, localRepoPath, this.buildEnvFromProperties(context), connectTimeout, connectionPoolSize, name, context.getInterpreterGroupId(), option.isUserImpersonate(), runner != null ? runner.getPath() : this.zConf.getInterpreterRemoteRunnerPath());
    }

    public Map<String, String> buildEnvFromProperties(InterpreterLaunchContext context) throws IOException {
        Map env = EnvironmentUtils.getProcEnvironment();
        for (Map.Entry<Object, Object> entry : context.getProperties().entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!RemoteInterpreterUtils.isEnvString((String)key) || StringUtils.isBlank((CharSequence)value)) continue;
            env.put(key, value);
        }
        env.put("INTERPRETER_GROUP_ID", context.getInterpreterGroupId());
        return env;
    }
}

