/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.recovery;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.interpreter.InterpreterSetting;
import org.apache.zeppelin.interpreter.InterpreterSettingManager;
import org.apache.zeppelin.interpreter.launcher.InterpreterClient;
import org.apache.zeppelin.interpreter.recovery.RecoveryStorage;
import org.apache.zeppelin.interpreter.recovery.RecoveryUtils;
import org.apache.zeppelin.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalRecoveryStorage
extends RecoveryStorage {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalRecoveryStorage.class);
    private InterpreterSettingManager interpreterSettingManager;
    private File recoveryDir;

    public LocalRecoveryStorage(ZeppelinConfiguration zConf) {
        super(zConf);
    }

    public LocalRecoveryStorage(ZeppelinConfiguration zConf, InterpreterSettingManager interpreterSettingManager) throws IOException {
        super(zConf);
        this.recoveryDir = new File(zConf.getRecoveryDir());
        LOGGER.info("Using folder {} to store recovery data", (Object)this.recoveryDir);
        if (!this.recoveryDir.exists()) {
            org.apache.commons.io.FileUtils.forceMkdir((File)this.recoveryDir);
        }
        if (!this.recoveryDir.isDirectory()) {
            throw new IOException("Recovery dir " + this.recoveryDir.getAbsolutePath() + " is not a directory");
        }
        this.interpreterSettingManager = interpreterSettingManager;
    }

    public void onInterpreterClientStart(InterpreterClient client) throws IOException {
        this.save(client.getInterpreterSettingName());
    }

    public void onInterpreterClientStop(InterpreterClient client) throws IOException {
        this.save(client.getInterpreterSettingName());
    }

    public Map<String, InterpreterClient> restore() throws IOException {
        File[] recoveryFiles;
        HashMap<String, InterpreterClient> clients = new HashMap<String, InterpreterClient>();
        for (File recoveryFile : recoveryFiles = this.recoveryDir.listFiles(file -> file.getName().endsWith(".recovery"))) {
            String fileName = recoveryFile.getName();
            String interpreterSettingName = fileName.substring(0, fileName.length() - ".recovery".length());
            String recoveryData = FileUtils.readFromFile(recoveryFile);
            clients.putAll(RecoveryUtils.restoreFromRecoveryData(recoveryData, interpreterSettingName, this.interpreterSettingManager, this.zConf));
        }
        return clients;
    }

    private void save(String interpreterSettingName) throws IOException {
        InterpreterSetting interpreterSetting = this.interpreterSettingManager.getInterpreterSettingByName(interpreterSettingName);
        String recoveryData = RecoveryUtils.getRecoveryData(interpreterSetting);
        LOGGER.debug("Updating recovery data of {}: {}", (Object)interpreterSettingName, (Object)recoveryData);
        File recoveryFile = new File(this.recoveryDir, interpreterSettingName + ".recovery");
        FileUtils.atomicWriteToFile(recoveryData, recoveryFile);
    }
}

