/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.remote;

import com.google.gson.Gson;
import java.util.List;
import org.apache.zeppelin.display.AngularObject;
import org.apache.zeppelin.display.AngularObjectRegistry;
import org.apache.zeppelin.display.AngularObjectRegistryListener;
import org.apache.zeppelin.interpreter.ManagedInterpreterGroup;
import org.apache.zeppelin.interpreter.remote.RemoteAngularObject;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterProcess;

public class RemoteAngularObjectRegistry
extends AngularObjectRegistry {
    private static final Gson GSON = new Gson();
    private ManagedInterpreterGroup interpreterGroup;

    public RemoteAngularObjectRegistry(String interpreterId, AngularObjectRegistryListener listener, ManagedInterpreterGroup interpreterGroup) {
        super(interpreterId, listener);
        this.interpreterGroup = interpreterGroup;
    }

    private RemoteInterpreterProcess getRemoteInterpreterProcess() {
        return this.interpreterGroup.getRemoteInterpreterProcess();
    }

    public AngularObject addAndNotifyRemoteProcess(String name, Object o, String noteId, String paragraphId) {
        RemoteInterpreterProcess remoteInterpreterProcess = this.getRemoteInterpreterProcess();
        if (null == remoteInterpreterProcess || !remoteInterpreterProcess.isRunning()) {
            return super.add(name, o, noteId, paragraphId, true);
        }
        remoteInterpreterProcess.callRemoteFunction(client -> {
            client.angularObjectAdd(name, noteId, paragraphId, GSON.toJson(o));
            return null;
        });
        return super.add(name, o, noteId, paragraphId, true);
    }

    public AngularObject removeAndNotifyRemoteProcess(String name, String noteId, String paragraphId) {
        RemoteInterpreterProcess remoteInterpreterProcess = this.getRemoteInterpreterProcess();
        if (remoteInterpreterProcess == null || !remoteInterpreterProcess.isRunning()) {
            return super.remove(name, noteId, paragraphId);
        }
        remoteInterpreterProcess.callRemoteFunction(client -> {
            client.angularObjectRemove(name, noteId, paragraphId);
            return null;
        });
        return super.remove(name, noteId, paragraphId);
    }

    public void removeAllAndNotifyRemoteProcess(String noteId, String paragraphId) {
        List all = this.getAll(noteId, paragraphId);
        for (AngularObject ao : all) {
            this.removeAndNotifyRemoteProcess(ao.getName(), noteId, paragraphId);
        }
    }

    protected AngularObject createNewAngularObject(String name, Object o, String noteId, String paragraphId) {
        return new RemoteAngularObject(name, o, noteId, paragraphId, this.interpreterGroup, this.getAngularObjectListener());
    }
}

