/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.notebook;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.cluster.ClusterManagerServer;
import org.apache.zeppelin.cluster.event.ClusterEvent;
import org.apache.zeppelin.cluster.event.ClusterEventListener;
import org.apache.zeppelin.cluster.event.ClusterMessage;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.notebook.NoteAuth;
import org.apache.zeppelin.notebook.NoteManager;
import org.apache.zeppelin.notebook.NotebookAuthorizationInfoSaving;
import org.apache.zeppelin.storage.ConfigStorage;
import org.apache.zeppelin.user.AuthenticationInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizationService
implements ClusterEventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthorizationService.class);
    private static final Set<String> EMPTY_SET = new HashSet<String>();
    private ZeppelinConfiguration conf;
    private ConfigStorage configStorage;
    private Map<String, Set<String>> userRoles = new HashMap<String, Set<String>>();
    private Map<String, NoteAuth> notesAuth = new HashMap<String, NoteAuth>();

    @Inject
    public AuthorizationService(NoteManager noteManager, ZeppelinConfiguration conf) {
        this.conf = conf;
        try {
            this.configStorage = ConfigStorage.getInstance(conf);
            NotebookAuthorizationInfoSaving authorizationInfoSaving = this.configStorage.loadNotebookAuthorization();
            if (authorizationInfoSaving != null) {
                for (Map.Entry entry : authorizationInfoSaving.authInfo.entrySet()) {
                    String noteId = (String)entry.getKey();
                    Map permissions = (Map)entry.getValue();
                    this.notesAuth.put(noteId, new NoteAuth(noteId, permissions));
                }
            }
            for (String string : noteManager.getNotesInfo().keySet()) {
                if (this.notesAuth.containsKey(string)) continue;
                this.notesAuth.put(string, new NoteAuth(string));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Fail to create ConfigStorage", e);
        }
    }

    public void createNoteAuth(String noteId, AuthenticationInfo subject) throws IOException {
        NoteAuth noteAuth = new NoteAuth(noteId, subject);
        this.notesAuth.put(noteId, noteAuth);
    }

    public void cloneNoteMeta(String noteId, String sourceNoteId, AuthenticationInfo subject) throws IOException {
        NoteAuth noteAuth = new NoteAuth(noteId, subject);
        this.notesAuth.put(noteId, noteAuth);
    }

    public void saveNoteAuth(String noteId, AuthenticationInfo subject) throws IOException {
        this.configStorage.save(new NotebookAuthorizationInfoSaving(this.notesAuth));
    }

    public void removeNoteAuth(String noteId) throws IOException {
        this.notesAuth.remove(noteId);
    }

    private Set<String> normalizeUsers(Set<String> users) {
        HashSet<String> returnUser = new HashSet<String>();
        for (String user : users) {
            if (user.trim().isEmpty()) continue;
            returnUser.add(user.trim());
        }
        return returnUser;
    }

    public void setOwners(String noteId, Set<String> entities) throws IOException {
        this.setOwners(noteId, entities, true);
    }

    public void setReaders(String noteId, Set<String> entities) throws IOException {
        this.setReaders(noteId, entities, true);
    }

    public void setWriters(String noteId, Set<String> entities) throws IOException {
        this.setWriters(noteId, entities, true);
    }

    public void setRunners(String noteId, Set<String> entities) throws IOException {
        this.setRunners(noteId, entities, true);
    }

    public void setRoles(String user, Set<String> roles) {
        this.setRoles(user, roles, true);
    }

    public void clearPermission(String noteId) throws IOException {
        this.clearPermission(noteId, true);
    }

    public void setOwners(String noteId, Set<String> entities, boolean broadcast) throws IOException {
        entities = this.normalizeUsers(entities);
        NoteAuth noteAuth = this.notesAuth.get(noteId);
        if (noteAuth == null) {
            throw new IOException("No noteAuth found for noteId: " + noteId);
        }
        noteAuth.setOwners(entities);
        if (broadcast) {
            this.broadcastClusterEvent(ClusterEvent.SET_OWNERS_PERMISSIONS, noteId, null, entities);
        }
    }

    public void setReaders(String noteId, Set<String> entities, boolean broadcast) throws IOException {
        entities = this.normalizeUsers(entities);
        NoteAuth noteAuth = this.notesAuth.get(noteId);
        if (noteAuth == null) {
            throw new IOException("No noteAuth found for noteId: " + noteId);
        }
        noteAuth.setReaders(entities);
        if (broadcast) {
            this.broadcastClusterEvent(ClusterEvent.SET_READERS_PERMISSIONS, noteId, null, entities);
        }
    }

    public void setRunners(String noteId, Set<String> entities, boolean broadcast) throws IOException {
        entities = this.normalizeUsers(entities);
        NoteAuth noteAuth = this.notesAuth.get(noteId);
        if (noteAuth == null) {
            throw new IOException("No noteAuth found for noteId: " + noteId);
        }
        noteAuth.setRunners(entities);
        if (broadcast) {
            this.broadcastClusterEvent(ClusterEvent.SET_RUNNERS_PERMISSIONS, noteId, null, entities);
        }
    }

    public void setWriters(String noteId, Set<String> entities, boolean broadcast) throws IOException {
        entities = this.normalizeUsers(entities);
        NoteAuth noteAuth = this.notesAuth.get(noteId);
        if (noteAuth == null) {
            throw new IOException("No noteAuth found for noteId: " + noteId);
        }
        noteAuth.setWriters(entities);
        if (broadcast) {
            this.broadcastClusterEvent(ClusterEvent.SET_WRITERS_PERMISSIONS, noteId, null, entities);
        }
    }

    public void setRoles(String user, Set<String> roles, boolean broadcast) {
        if (StringUtils.isBlank((CharSequence)user)) {
            LOGGER.warn("Setting roles for empty user");
            return;
        }
        roles = this.normalizeUsers(roles);
        this.userRoles.put(user, roles);
        if (broadcast) {
            this.broadcastClusterEvent(ClusterEvent.SET_ROLES, null, user, roles);
        }
    }

    public void clearPermission(String noteId, boolean broadcast) throws IOException {
        NoteAuth noteAuth = this.notesAuth.get(noteId);
        if (noteAuth == null) {
            throw new IOException("No noteAuth found for noteId: " + noteId);
        }
        noteAuth.setReaders(Sets.newHashSet());
        noteAuth.setRunners(Sets.newHashSet());
        noteAuth.setWriters(Sets.newHashSet());
        noteAuth.setOwners(Sets.newHashSet());
        if (broadcast) {
            this.broadcastClusterEvent(ClusterEvent.CLEAR_PERMISSION, noteId, null, null);
        }
    }

    public Set<String> getOwners(String noteId) {
        NoteAuth noteAuth = this.notesAuth.get(noteId);
        if (noteAuth == null) {
            LOGGER.warn("No noteAuth found for noteId: {}", (Object)noteId);
            return EMPTY_SET;
        }
        return noteAuth.getOwners();
    }

    public Set<String> getReaders(String noteId) {
        NoteAuth noteAuth = this.notesAuth.get(noteId);
        if (noteAuth == null) {
            LOGGER.warn("No noteAuth found for noteId: {}", (Object)noteId);
            return EMPTY_SET;
        }
        return noteAuth.getReaders();
    }

    public Set<String> getRunners(String noteId) {
        NoteAuth noteAuth = this.notesAuth.get(noteId);
        if (noteAuth == null) {
            LOGGER.warn("No noteAuth found for noteId: {}", (Object)noteId);
            return EMPTY_SET;
        }
        return noteAuth.getRunners();
    }

    public Set<String> getWriters(String noteId) {
        NoteAuth noteAuth = this.notesAuth.get(noteId);
        if (noteAuth == null) {
            LOGGER.warn("No noteAuth found for noteId: {}", (Object)noteId);
            return EMPTY_SET;
        }
        return noteAuth.getWriters();
    }

    public Set<String> getRoles(String user) {
        return this.userRoles.getOrDefault(user, Sets.newHashSet());
    }

    public boolean isOwner(String noteId, Set<String> entities) {
        return this.isMember(entities, this.getOwners(noteId)) || this.isAdmin(entities);
    }

    public boolean isWriter(String noteId, Set<String> entities) {
        return this.isMember(entities, this.getWriters(noteId)) || this.isMember(entities, this.getOwners(noteId)) || this.isAdmin(entities);
    }

    public boolean isReader(String noteId, Set<String> entities) {
        return this.isMember(entities, this.getReaders(noteId)) || this.isMember(entities, this.getOwners(noteId)) || this.isMember(entities, this.getWriters(noteId)) || this.isMember(entities, this.getRunners(noteId)) || this.isAdmin(entities);
    }

    public boolean isRunner(String noteId, Set<String> entities) {
        return this.isMember(entities, this.getRunners(noteId)) || this.isMember(entities, this.getWriters(noteId)) || this.isMember(entities, this.getOwners(noteId)) || this.isAdmin(entities);
    }

    private boolean isAdmin(Set<String> entities) {
        String adminRole = this.conf.getString(ZeppelinConfiguration.ConfVars.ZEPPELIN_OWNER_ROLE);
        if (StringUtils.isBlank((CharSequence)adminRole)) {
            return false;
        }
        return entities.contains(adminRole);
    }

    private boolean isMember(Set<String> a, Set<String> b) {
        HashSet<String> intersection = new HashSet<String>(b);
        intersection.retainAll(a);
        return b.isEmpty() || intersection.size() > 0;
    }

    public boolean isOwner(Set<String> userAndRoles, String noteId) {
        if (this.conf.isAnonymousAllowed()) {
            LOGGER.debug("Zeppelin runs in anonymous mode, everybody is owner");
            return true;
        }
        if (userAndRoles == null) {
            return false;
        }
        return this.isOwner(noteId, userAndRoles);
    }

    public boolean hasWritePermission(Set<String> userAndRoles, String noteId) {
        if (this.conf.isAnonymousAllowed()) {
            LOGGER.debug("Zeppelin runs in anonymous mode, everybody is writer");
            return true;
        }
        if (userAndRoles == null) {
            return false;
        }
        return this.isWriter(noteId, userAndRoles);
    }

    public boolean hasReadPermission(Set<String> userAndRoles, String noteId) {
        if (this.conf.isAnonymousAllowed()) {
            LOGGER.debug("Zeppelin runs in anonymous mode, everybody is reader");
            return true;
        }
        if (userAndRoles == null) {
            return false;
        }
        return this.isReader(noteId, userAndRoles);
    }

    public boolean hasRunPermission(Set<String> userAndRoles, String noteId) {
        if (this.conf.isAnonymousAllowed()) {
            LOGGER.debug("Zeppelin runs in anonymous mode, everybody is reader");
            return true;
        }
        if (userAndRoles == null) {
            return false;
        }
        return this.isRunner(noteId, userAndRoles);
    }

    public boolean isPublic() {
        return this.conf.isNotebookPublic();
    }

    public void onClusterEvent(String msg) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("onClusterEvent : {}", (Object)msg);
        }
        ClusterMessage message = ClusterMessage.deserializeMessage((String)msg);
        String noteId = message.get("noteId");
        String user = message.get("user");
        String jsonSet = message.get("set");
        Gson gson = new Gson();
        Set set = (Set)gson.fromJson(jsonSet, new TypeToken<Set<String>>(){}.getType());
        try {
            switch (message.clusterEvent) {
                case SET_READERS_PERMISSIONS: {
                    this.setReaders(noteId, set, false);
                    break;
                }
                case SET_WRITERS_PERMISSIONS: {
                    this.setWriters(noteId, set, false);
                    break;
                }
                case SET_OWNERS_PERMISSIONS: {
                    this.setOwners(noteId, set, false);
                    break;
                }
                case SET_RUNNERS_PERMISSIONS: {
                    this.setRunners(noteId, set, false);
                    break;
                }
                case SET_ROLES: {
                    this.setRoles(user, set, false);
                    break;
                }
                case CLEAR_PERMISSION: {
                    this.clearPermission(noteId, false);
                    break;
                }
                default: {
                    LOGGER.error("Unknown clusterEvent:{}, msg:{} ", (Object)message.clusterEvent, (Object)msg);
                    break;
                }
            }
        }
        catch (IOException e) {
            LOGGER.warn("Fail to broadcast msg", (Throwable)e);
        }
    }

    private void broadcastClusterEvent(ClusterEvent event, String noteId, String user, Set<String> set) {
        if (!this.conf.isClusterMode()) {
            return;
        }
        ClusterMessage message = new ClusterMessage(event);
        message.put("noteId", noteId);
        message.put("user", user);
        Gson gson = new Gson();
        String json = gson.toJson(set, new TypeToken<Set<String>>(){}.getType());
        message.put("set", json);
        String msg = ClusterMessage.serializeMessage((ClusterMessage)message);
        ClusterManagerServer.getInstance((ZeppelinConfiguration)this.conf).broadcastClusterEvent(ClusterManagerServer.CLUSTER_AUTH_EVENT_TOPIC, msg);
    }
}

