/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.notebook;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.common.JsonSerializable;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.display.AngularObject;
import org.apache.zeppelin.display.AngularObjectRegistry;
import org.apache.zeppelin.display.Input;
import org.apache.zeppelin.interpreter.ExecutionContext;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterFactory;
import org.apache.zeppelin.interpreter.InterpreterNotFoundException;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.InterpreterSetting;
import org.apache.zeppelin.interpreter.InterpreterSettingManager;
import org.apache.zeppelin.interpreter.ManagedInterpreterGroup;
import org.apache.zeppelin.interpreter.remote.RemoteAngularObject;
import org.apache.zeppelin.interpreter.remote.RemoteAngularObjectRegistry;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;
import org.apache.zeppelin.notebook.ApplicationState;
import org.apache.zeppelin.notebook.NoteEventListener;
import org.apache.zeppelin.notebook.NoteInfo;
import org.apache.zeppelin.notebook.NotebookImportDeserializer;
import org.apache.zeppelin.notebook.Paragraph;
import org.apache.zeppelin.notebook.ParagraphJobListener;
import org.apache.zeppelin.notebook.exception.CorruptedNoteException;
import org.apache.zeppelin.notebook.utility.IdHashes;
import org.apache.zeppelin.scheduler.ExecutorFactory;
import org.apache.zeppelin.scheduler.Job;
import org.apache.zeppelin.user.AuthenticationInfo;
import org.apache.zeppelin.user.Credentials;
import org.apache.zeppelin.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Note
implements JsonSerializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(Note.class);
    private static final ExclusionStrategy NOTE_GSON_EXCLUSION_STRATEGY = new NoteJsonExclusionStrategy(ZeppelinConfiguration.create());
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().setDateFormat("yyyy-MM-dd HH:mm:ss.SSS").registerTypeAdapter(Date.class, (Object)new NotebookImportDeserializer()).registerTypeAdapterFactory((TypeAdapterFactory)Input.TypeAdapterFactory).setExclusionStrategies(new ExclusionStrategy[]{NOTE_GSON_EXCLUSION_STRATEGY}).create();
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH-mm-ss");
    private CopyOnWriteArrayList<Paragraph> paragraphs = new CopyOnWriteArrayList();
    private String name = "";
    private String id;
    private String defaultInterpreterGroup;
    private String version;
    private Map<String, Object> noteParams = new LinkedHashMap<String, Object>();
    private Map<String, Input> noteForms = new LinkedHashMap<String, Input>();
    private Map<String, List<AngularObject>> angularObjects = new HashMap<String, List<AngularObject>>();
    private Map<String, Object> config = new HashMap<String, Object>();
    private Map<String, Object> info = new HashMap<String, Object>();
    private String path;
    private transient boolean loaded = false;
    private transient boolean saved = false;
    private transient boolean removed = false;
    private transient InterpreterFactory interpreterFactory;
    private transient InterpreterSettingManager interpreterSettingManager;
    private transient ParagraphJobListener paragraphJobListener;
    private transient List<NoteEventListener> noteEventListeners = new ArrayList<NoteEventListener>();
    private transient Credentials credentials;
    private transient ZeppelinConfiguration zConf = ZeppelinConfiguration.create();

    public Note() {
        this.generateId();
    }

    public Note(String path, String defaultInterpreterGroup, InterpreterFactory factory, InterpreterSettingManager interpreterSettingManager, ParagraphJobListener paragraphJobListener, Credentials credentials, List<NoteEventListener> noteEventListener) {
        this.setPath(path);
        this.defaultInterpreterGroup = defaultInterpreterGroup;
        this.interpreterFactory = factory;
        this.interpreterSettingManager = interpreterSettingManager;
        this.paragraphJobListener = paragraphJobListener;
        this.noteEventListeners = noteEventListener;
        this.credentials = credentials;
        this.version = Util.getVersion();
        this.generateId();
        this.setCronSupported(this.zConf);
    }

    public Note(NoteInfo noteInfo) {
        this.id = noteInfo.getId();
        this.setPath(noteInfo.getPath());
    }

    public String getPath() {
        return this.path;
    }

    public String getParentPath() {
        int pos = this.path.lastIndexOf(47);
        if (pos == 0) {
            return "/";
        }
        return this.path.substring(0, pos);
    }

    private String getName(String path) {
        int pos = path.lastIndexOf(47);
        return path.substring(pos + 1);
    }

    private void generateId() {
        this.id = IdHashes.generateId();
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    public void unLoad() {
        if (this.isRunning() || this.isParagraphRunning()) {
            LOGGER.warn("Unable to unload note because it is in RUNNING");
        } else {
            this.setLoaded(false);
            this.paragraphs = null;
            this.config = null;
            this.info = null;
            this.noteForms = null;
            this.noteParams = null;
            this.angularObjects = null;
        }
    }

    public boolean isParagraphRunning() {
        if (this.paragraphs != null) {
            for (Paragraph p : this.paragraphs) {
                if (!p.isRunning()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isPersonalizedMode() {
        Object v = this.getConfig().get("personalizedMode");
        return null != v && "true".equals(v);
    }

    public void setPersonalizedMode(Boolean value) {
        String valueString = value != false ? "true" : "false";
        this.config.put("personalizedMode", valueString);
        this.clearUserParagraphs(value);
    }

    private void clearUserParagraphs(boolean isPersonalized) {
        if (!isPersonalized) {
            for (Paragraph p : this.paragraphs) {
                p.clearUserParagraphs();
            }
        }
    }

    public String getId() {
        return this.id;
    }

    @VisibleForTesting
    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setPath(String path) {
        this.path = !path.startsWith("/") ? "/" + path : path;
        this.name = this.getName(path);
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getDefaultInterpreterGroup() {
        if (StringUtils.isBlank((CharSequence)this.defaultInterpreterGroup)) {
            this.defaultInterpreterGroup = ZeppelinConfiguration.create().getString(ZeppelinConfiguration.ConfVars.ZEPPELIN_INTERPRETER_GROUP_DEFAULT);
        }
        return this.defaultInterpreterGroup;
    }

    public void setDefaultInterpreterGroup(String defaultInterpreterGroup) {
        this.defaultInterpreterGroup = defaultInterpreterGroup;
    }

    public Map<String, Object> getNoteParams() {
        return this.noteParams;
    }

    public void setNoteParams(Map<String, Object> noteParams) {
        this.noteParams = noteParams;
    }

    public Map<String, Input> getNoteForms() {
        return this.noteForms;
    }

    public void setNoteForms(Map<String, Input> noteForms) {
        this.noteForms = noteForms;
    }

    public void setName(String name) {
        this.name = name;
        if (this.path == null) {
            this.path = name.startsWith("/") ? name : "/" + name;
        } else {
            int pos = this.path.lastIndexOf(47);
            this.path = this.path.substring(0, pos + 1) + this.name;
        }
    }

    public InterpreterFactory getInterpreterFactory() {
        return this.interpreterFactory;
    }

    public void setInterpreterFactory(InterpreterFactory interpreterFactory) {
        this.interpreterFactory = interpreterFactory;
    }

    void setInterpreterSettingManager(InterpreterSettingManager interpreterSettingManager) {
        this.interpreterSettingManager = interpreterSettingManager;
    }

    InterpreterSettingManager getInterpreterSettingManager() {
        return this.interpreterSettingManager;
    }

    void setParagraphJobListener(ParagraphJobListener paragraphJobListener) {
        this.paragraphJobListener = paragraphJobListener;
    }

    public boolean isCronSupported(ZeppelinConfiguration config) {
        if (config.isZeppelinNotebookCronEnable()) {
            config.getZeppelinNotebookCronFolders();
            if (StringUtils.isBlank((CharSequence)config.getZeppelinNotebookCronFolders())) {
                return true;
            }
            for (String folder : config.getZeppelinNotebookCronFolders().split(",")) {
                if (!this.path.startsWith(folder)) continue;
                return true;
            }
        }
        return false;
    }

    public void setCronSupported(ZeppelinConfiguration config) {
        this.getConfig().put("isZeppelinNotebookCronEnable", this.isCronSupported(config));
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    Map<String, List<AngularObject>> getAngularObjects() {
        return this.angularObjects;
    }

    public List<AngularObject> getAngularObjects(String intpGroupId) {
        if (!this.angularObjects.containsKey(intpGroupId)) {
            return new ArrayList<AngularObject>();
        }
        return this.angularObjects.get(intpGroupId);
    }

    public void addOrUpdateAngularObject(String intpGroupId, AngularObject angularObject) {
        List<Object> angularObjectList;
        if (!this.angularObjects.containsKey(intpGroupId)) {
            angularObjectList = new ArrayList();
            this.angularObjects.put(intpGroupId, angularObjectList);
        } else {
            angularObjectList = this.angularObjects.get(intpGroupId);
            Iterator<Object> iter = angularObjectList.iterator();
            while (iter.hasNext()) {
                String noteId = "";
                String paragraphId = "";
                String name = "";
                Object object = iter.next();
                if (object instanceof AngularObject) {
                    AngularObject ao = (AngularObject)object;
                    noteId = ao.getNoteId();
                    paragraphId = ao.getParagraphId();
                    name = ao.getName();
                } else {
                    if (!(object instanceof RemoteAngularObject)) continue;
                    RemoteAngularObject rao = (RemoteAngularObject)((Object)object);
                    noteId = rao.getNoteId();
                    paragraphId = rao.getParagraphId();
                    name = rao.getName();
                }
                if (!StringUtils.equals((CharSequence)noteId, (CharSequence)angularObject.getNoteId()) || !StringUtils.equals((CharSequence)paragraphId, (CharSequence)angularObject.getParagraphId()) || !StringUtils.equals((CharSequence)name, (CharSequence)angularObject.getName())) continue;
                iter.remove();
            }
        }
        angularObjectList.add(angularObject);
    }

    public void deleteAngularObject(String intpGroupId, String noteId, String paragraphId, String name) {
        if (this.angularObjects.containsKey(intpGroupId)) {
            List<AngularObject> angularObjectList = this.angularObjects.get(intpGroupId);
            Iterator<AngularObject> iter = angularObjectList.iterator();
            while (iter.hasNext()) {
                String noteIdCandidate = "";
                String paragraphIdCandidate = "";
                String nameCandidate = "";
                AngularObject object = iter.next();
                if (object instanceof AngularObject) {
                    AngularObject ao = object;
                    noteIdCandidate = ao.getNoteId();
                    paragraphIdCandidate = ao.getParagraphId();
                    nameCandidate = ao.getName();
                } else {
                    if (!(object instanceof RemoteAngularObject)) continue;
                    RemoteAngularObject rao = (RemoteAngularObject)object;
                    noteIdCandidate = rao.getNoteId();
                    paragraphIdCandidate = rao.getParagraphId();
                    nameCandidate = rao.getName();
                }
                if (!StringUtils.equals((CharSequence)noteId, (CharSequence)noteIdCandidate) || !StringUtils.equals((CharSequence)paragraphId, (CharSequence)paragraphIdCandidate) || !StringUtils.equals((CharSequence)name, (CharSequence)nameCandidate)) continue;
                iter.remove();
            }
        }
    }

    public Paragraph addNewParagraph(AuthenticationInfo authenticationInfo) {
        return this.insertNewParagraph(this.paragraphs.size(), authenticationInfo);
    }

    void addCloneParagraph(Paragraph srcParagraph, AuthenticationInfo subject) {
        Paragraph newParagraph = new Paragraph(srcParagraph.getId(), this, this.paragraphJobListener);
        HashMap<String, Object> config = new HashMap<String, Object>(srcParagraph.getConfig());
        Map param = srcParagraph.settings.getParams();
        Map form = srcParagraph.settings.getForms();
        LOGGER.debug("srcParagraph user: {}", (Object)srcParagraph.getUser());
        newParagraph.setAuthenticationInfo(subject);
        newParagraph.setConfig(config);
        newParagraph.settings.setParams(param);
        newParagraph.settings.setForms(form);
        newParagraph.setText(srcParagraph.getText());
        newParagraph.setTitle(srcParagraph.getTitle());
        LOGGER.debug("newParagraph user: {}", (Object)newParagraph.getUser());
        try {
            String resultJson = GSON.toJson((Object)srcParagraph.getReturn());
            InterpreterResult result = InterpreterResult.fromJson((String)resultJson);
            newParagraph.setReturn(result, null);
        }
        catch (Exception e) {
            LOGGER.warn("Paragraph {} has a result with exception. {}", (Object)srcParagraph.getId(), (Object)e.getMessage());
        }
        this.paragraphs.add(newParagraph);
        try {
            this.fireParagraphCreateEvent(newParagraph);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void fireParagraphCreateEvent(Paragraph p) throws IOException {
        for (NoteEventListener listener : this.noteEventListeners) {
            listener.onParagraphCreate(p);
        }
    }

    public void fireParagraphRemoveEvent(Paragraph p) throws IOException {
        for (NoteEventListener listener : this.noteEventListeners) {
            listener.onParagraphRemove(p);
        }
    }

    public void fireParagraphUpdateEvent(Paragraph p) throws IOException {
        for (NoteEventListener listener : this.noteEventListeners) {
            listener.onParagraphUpdate(p);
        }
    }

    public Paragraph insertNewParagraph(int index, AuthenticationInfo authenticationInfo) {
        Paragraph paragraph = new Paragraph(this, this.paragraphJobListener);
        if (null != this.interpreterSettingManager) {
            Map<String, Object> config = this.interpreterSettingManager.getConfigSetting(this.defaultInterpreterGroup);
            paragraph.setConfig(config);
        }
        paragraph.setAuthenticationInfo(authenticationInfo);
        this.setParagraphMagic(paragraph, index);
        this.insertParagraph(paragraph, index);
        return paragraph;
    }

    public void addParagraph(Paragraph paragraph) {
        this.insertParagraph(paragraph, this.paragraphs.size());
    }

    private void insertParagraph(Paragraph paragraph, int index) {
        this.paragraphs.add(index, paragraph);
        try {
            this.fireParagraphCreateEvent(paragraph);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Paragraph removeParagraph(String user, String paragraphId) {
        this.removeAllAngularObjectInParagraph(user, paragraphId);
        this.interpreterSettingManager.removeResourcesBelongsToParagraph(this.getId(), paragraphId);
        for (Paragraph p : this.paragraphs) {
            if (!p.getId().equals(paragraphId)) continue;
            this.paragraphs.remove(p);
            try {
                this.fireParagraphRemoveEvent(p);
            }
            catch (IOException e) {
                LOGGER.error("Fail to fire ParagraphRemoveEvent", (Throwable)e);
            }
            return p;
        }
        return null;
    }

    public void clearParagraphOutputFields(Paragraph p) {
        p.setReturn(null, null);
        p.cleanRuntimeInfos();
        p.cleanOutputBuffer();
    }

    public Paragraph clearPersonalizedParagraphOutput(String paragraphId, String user) {
        for (Paragraph p : this.paragraphs) {
            if (!p.getId().equals(paragraphId)) continue;
            p = p.getUserParagraphMap().get(user);
            this.clearParagraphOutputFields(p);
            return p;
        }
        return null;
    }

    public Paragraph clearParagraphOutput(String paragraphId) {
        for (Paragraph p : this.paragraphs) {
            if (!p.getId().equals(paragraphId)) continue;
            this.clearParagraphOutputFields(p);
            return p;
        }
        return null;
    }

    public void clearAllParagraphOutput() {
        for (Paragraph p : this.paragraphs) {
            p.setReturn(null, null);
        }
    }

    public void moveParagraph(String paragraphId, int index) {
        this.moveParagraph(paragraphId, index, false);
    }

    public void moveParagraph(String paragraphId, int index, boolean throwWhenIndexIsOutOfBound) {
        Paragraph p = null;
        if (index < 0 || index >= this.paragraphs.size()) {
            if (throwWhenIndexIsOutOfBound) {
                throw new IndexOutOfBoundsException("paragraph size is " + this.paragraphs.size() + " , index is " + index);
            }
            return;
        }
        for (int i = 0; i < this.paragraphs.size(); ++i) {
            if (!this.paragraphs.get(i).getId().equals(paragraphId)) continue;
            int oldIndex = i;
            if (oldIndex == index) {
                return;
            }
            p = this.paragraphs.remove(i);
        }
        if (p != null) {
            this.paragraphs.add(index, p);
        }
    }

    public boolean isLastParagraph(String paragraphId) {
        if (!this.paragraphs.isEmpty()) {
            return paragraphId.equals(this.paragraphs.get(this.paragraphs.size() - 1).getId());
        }
        return true;
    }

    public int getParagraphCount() {
        return this.paragraphs.size();
    }

    public Paragraph getParagraph(String paragraphId) {
        for (Paragraph p : this.paragraphs) {
            if (!p.getId().equals(paragraphId)) continue;
            return p;
        }
        return null;
    }

    public Paragraph getParagraph(int index) {
        return this.paragraphs.get(index);
    }

    public Paragraph getLastParagraph() {
        return this.paragraphs.get(this.paragraphs.size() - 1);
    }

    private void setParagraphMagic(Paragraph p, int index) {
        String replName;
        if (!this.paragraphs.isEmpty() && p.isValidInterpreter(replName = index == 0 ? this.paragraphs.get(0).getIntpText() : this.paragraphs.get(index - 1).getIntpText()) && StringUtils.isNotEmpty((CharSequence)replName)) {
            p.setText("%" + replName + "\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAll(AuthenticationInfo authInfo, boolean blocking, boolean isolated, Map<String, Object> params) throws Exception {
        if (this.isRunning()) {
            throw new Exception("Unable to run note:" + this.id + " because it is still in RUNNING state.");
        }
        this.setIsolatedMode(isolated);
        this.setRunning(true);
        this.setStartTime(DATE_TIME_FORMATTER.format(LocalDateTime.now()));
        if (blocking) {
            try {
                this.runAllSync(authInfo, isolated, params);
            }
            finally {
                this.setRunning(false);
                this.setIsolatedMode(false);
                this.clearStartTime();
            }
        } else {
            ExecutorFactory.singleton().getNoteJobExecutor().submit(() -> {
                try {
                    this.runAllSync(authInfo, isolated, params);
                }
                catch (Exception e) {
                    LOGGER.warn("Fail to run note: {}", (Object)this.id, (Object)e);
                }
                finally {
                    this.setRunning(false);
                    this.setIsolatedMode(false);
                    this.clearStartTime();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void runAllSync(AuthenticationInfo authInfo, boolean isolated, Map<String, Object> params) throws Exception {
        try {
            for (Paragraph p : this.getParagraphs()) {
                if (!p.isEnabled()) continue;
                p.setAuthenticationInfo(authInfo);
                Map originalParams = p.settings.getParams();
                try {
                    Interpreter interpreter;
                    if (params != null && !params.isEmpty()) {
                        p.settings.setParams(params);
                    }
                    if ((interpreter = p.getBindedInterpreter()) != null) {
                        interpreter.setProperty(".execution.mode", "note");
                        interpreter.setProperty(".noteId", this.id);
                    }
                    if (this.run(p.getId(), true)) continue;
                    LOGGER.warn("Skip running the remain notes because paragraph {} fails", (Object)p.getId());
                    return;
                }
                catch (InterpreterNotFoundException interpreter) {}
                continue;
                finally {
                    p.settings.setParams(originalParams);
                }
            }
            if (!isolated) return;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (isolated) {
                LOGGER.info("Releasing interpreters used by this note: {}", (Object)this.id);
                for (InterpreterSetting setting : this.getUsedInterpreterSettings()) {
                    setting.closeInterpreters(this.getExecutionContext());
                    for (Paragraph p : this.paragraphs) {
                        p.setInterpreter(null);
                    }
                }
            }
        }
        LOGGER.info("Releasing interpreters used by this note: {}", (Object)this.id);
        for (InterpreterSetting setting : this.getUsedInterpreterSettings()) {
            setting.closeInterpreters(this.getExecutionContext());
            for (Paragraph p : this.paragraphs) {
                p.setInterpreter(null);
            }
        }
        return;
    }

    public boolean run(String paragraphId) {
        return this.run(paragraphId, false);
    }

    public boolean run(String paragraphId, boolean blocking) {
        return this.run(paragraphId, null, blocking, null);
    }

    public boolean run(String paragraphId, String interpreterGroupId, boolean blocking, String ctxUser) {
        Paragraph p = this.getParagraph(paragraphId);
        if (this.isPersonalizedMode() && ctxUser != null) {
            p = p.getUserParagraph(ctxUser);
        }
        p.setListener(this.paragraphJobListener);
        return p.execute(interpreterGroupId, blocking);
    }

    public boolean haveRunningOrPendingParagraphs() {
        for (Paragraph p : this.paragraphs) {
            Job.Status status = p.getStatus();
            if (!status.isRunning() && !status.isPending()) continue;
            return true;
        }
        return false;
    }

    public boolean isTrash() {
        return this.path.startsWith("/~Trash");
    }

    public List<InterpreterCompletion> completion(String paragraphId, String buffer, int cursor, AuthenticationInfo authInfo) {
        Paragraph p = this.getParagraph(paragraphId);
        p.setListener(this.paragraphJobListener);
        p.setAuthenticationInfo(authInfo);
        return p.completion(buffer, cursor);
    }

    public CopyOnWriteArrayList<Paragraph> getParagraphs() {
        return this.paragraphs;
    }

    private void snapshotAngularObjectRegistry(String user) {
        this.angularObjects = new HashMap<String, List<AngularObject>>();
        List<InterpreterSetting> settings = this.getBindedInterpreterSettings(Lists.newArrayList((Object[])new String[]{user}));
        if (settings == null || settings.size() == 0) {
            return;
        }
        for (InterpreterSetting setting : settings) {
            ManagedInterpreterGroup intpGroup = setting.getInterpreterGroup(this.getExecutionContext());
            if (intpGroup == null) continue;
            AngularObjectRegistry registry = intpGroup.getAngularObjectRegistry();
            this.angularObjects.put(intpGroup.getId(), registry.getAllWithGlobal(this.id));
        }
    }

    private void removeAllAngularObjectInParagraph(String user, String paragraphId) {
        this.angularObjects = new HashMap<String, List<AngularObject>>();
        List<InterpreterSetting> settings = this.getBindedInterpreterSettings(Lists.newArrayList((Object[])new String[]{user}));
        if (settings == null || settings.isEmpty()) {
            return;
        }
        for (InterpreterSetting setting : settings) {
            List<ApplicationState> appStates;
            if (setting.getInterpreterGroup(this.getExecutionContext()) == null) continue;
            ManagedInterpreterGroup intpGroup = setting.getInterpreterGroup(this.getExecutionContext());
            AngularObjectRegistry registry = intpGroup.getAngularObjectRegistry();
            if (registry instanceof RemoteAngularObjectRegistry) {
                ((RemoteAngularObjectRegistry)registry).removeAllAndNotifyRemoteProcess(this.id, paragraphId);
                appStates = this.getParagraph(paragraphId).getAllApplicationStates();
                if (appStates == null) continue;
                for (ApplicationState app : appStates) {
                    ((RemoteAngularObjectRegistry)registry).removeAllAndNotifyRemoteProcess(this.id, app.getId());
                }
                continue;
            }
            registry.removeAll(this.id, paragraphId);
            appStates = this.getParagraph(paragraphId).getAllApplicationStates();
            if (appStates == null) continue;
            for (ApplicationState app : appStates) {
                registry.removeAll(this.id, app.getId());
            }
        }
    }

    public List<InterpreterSetting> getBindedInterpreterSettings(List<String> userAndRoles) {
        LinkedHashSet<InterpreterSetting> settings = new LinkedHashSet<InterpreterSetting>();
        InterpreterSetting defaultIntpSetting = this.interpreterSettingManager.getByName(this.getDefaultInterpreterGroup());
        if (defaultIntpSetting != null) {
            settings.add(defaultIntpSetting);
        }
        if (defaultIntpSetting != null) {
            for (InterpreterSetting intpSetting : this.interpreterSettingManager.get()) {
                if (!intpSetting.getGroup().equals(defaultIntpSetting.getGroup()) || !intpSetting.isUserAuthorized(userAndRoles)) continue;
                settings.add(intpSetting);
            }
        }
        for (Paragraph p : this.getParagraphs()) {
            try {
                Interpreter intp = p.getBindedInterpreter();
                InterpreterSetting interpreterSetting = ((ManagedInterpreterGroup)intp.getInterpreterGroup()).getInterpreterSetting();
                if (!interpreterSetting.isUserAuthorized(userAndRoles)) continue;
                settings.add(interpreterSetting);
            }
            catch (InterpreterNotFoundException interpreterNotFoundException) {}
        }
        return new ArrayList<InterpreterSetting>(settings);
    }

    public List<InterpreterSetting> getUsedInterpreterSettings() {
        HashSet<InterpreterSetting> settings = new HashSet<InterpreterSetting>();
        for (Paragraph p : this.getParagraphs()) {
            Interpreter intp = p.getInterpreter();
            if (intp == null) continue;
            settings.add(((ManagedInterpreterGroup)intp.getInterpreterGroup()).getInterpreterSetting());
        }
        return new ArrayList<InterpreterSetting>(settings);
    }

    public Note getUserNote(String user) {
        Note newNote = new Note();
        newNote.name = this.getName();
        newNote.id = this.getId();
        newNote.config = this.getConfig();
        newNote.angularObjects = this.getAngularObjects();
        for (Paragraph p : this.paragraphs) {
            Paragraph newParagraph = p.getUserParagraph(user);
            if (null == newParagraph) {
                newParagraph = p.cloneParagraphForUser(user);
            }
            newNote.paragraphs.add(newParagraph);
        }
        return newNote;
    }

    public Map<String, Object> getConfig() {
        if (this.config == null) {
            this.config = new HashMap<String, Object>();
        }
        return this.config;
    }

    public void setConfig(Map<String, Object> config) {
        this.config = config;
    }

    public Map<String, Object> getInfo() {
        if (this.info == null) {
            this.info = new HashMap<String, Object>();
        }
        return this.info;
    }

    public void setInfo(Map<String, Object> info) {
        this.info = info;
    }

    public void setRunning(boolean runStatus) {
        Map<String, Object> infoMap = this.getInfo();
        boolean oldStatus = (Boolean)infoMap.getOrDefault("isRunning", false);
        if (oldStatus != runStatus) {
            infoMap.put("isRunning", runStatus);
            if (this.paragraphJobListener != null) {
                this.paragraphJobListener.noteRunningStatusChange(this.id, runStatus);
            }
        }
    }

    public void setIsolatedMode(boolean isolatedMode) {
        this.info.put("inIsolatedMode", isolatedMode);
    }

    public boolean isIsolatedMode() {
        if (this.info == null) {
            return false;
        }
        return Boolean.parseBoolean(this.info.getOrDefault("inIsolatedMode", "false").toString());
    }

    public void setStartTime(String startTime) {
        this.info.put("startTime", startTime);
    }

    public String getStartTime() {
        if (this.info == null) {
            return null;
        }
        return this.info.getOrDefault("startTime", "").toString();
    }

    public void clearStartTime() {
        this.info.remove("startTime");
    }

    public boolean isRunning() {
        return (Boolean)this.getInfo().getOrDefault("isRunning", false);
    }

    public String toString() {
        if (this.path != null) {
            return this.path;
        }
        return "/" + this.name;
    }

    public String toJson() {
        return GSON.toJson((Object)this);
    }

    public static Note fromJson(String noteId, String json) throws IOException {
        try {
            Note note = (Note)GSON.fromJson(json, Note.class);
            Note.convertOldInput(note);
            note.info.remove("isRunning");
            note.postProcessParagraphs();
            return note;
        }
        catch (Exception e) {
            LOGGER.error("Fail to parse note json: {}", (Object)e.toString());
            throw new CorruptedNoteException(noteId, "Fail to parse note json: " + json, e);
        }
    }

    public void postProcessParagraphs() {
        for (Paragraph p : this.paragraphs) {
            List<ApplicationState> appStates;
            p.parseText();
            p.setNote(this);
            p.setAuthenticationInfo(AuthenticationInfo.ANONYMOUS);
            if (p.getStatus() == Job.Status.PENDING) {
                p.setStatus(Job.Status.ABORT);
            }
            if (p.getStatus() == Job.Status.RUNNING && !this.zConf.isRecoveryEnabled()) {
                p.setStatus(Job.Status.ABORT);
            }
            if ((appStates = p.getAllApplicationStates()) == null) continue;
            for (ApplicationState app : appStates) {
                if (app.getStatus() == ApplicationState.Status.ERROR) continue;
                app.setStatus(ApplicationState.Status.UNLOADED);
            }
        }
    }

    private static void convertOldInput(Note note) {
        for (Paragraph p : note.paragraphs) {
            p.settings.convertOldInput();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Note note = (Note)o;
        if (this.paragraphs != null ? !this.paragraphs.equals(note.paragraphs) : note.paragraphs != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(note.id) : note.id != null) {
            return false;
        }
        if (this.angularObjects != null ? !this.angularObjects.equals(note.angularObjects) : note.angularObjects != null) {
            return false;
        }
        if (this.config != null ? !this.config.equals(note.config) : note.config != null) {
            return false;
        }
        return this.info != null ? this.info.equals(note.info) : note.info == null;
    }

    public int hashCode() {
        int result = this.paragraphs != null ? this.paragraphs.hashCode() : 0;
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.angularObjects != null ? this.angularObjects.hashCode() : 0);
        result = 31 * result + (this.config != null ? this.config.hashCode() : 0);
        result = 31 * result + (this.info != null ? this.info.hashCode() : 0);
        return result;
    }

    @VisibleForTesting
    public static Gson getGSON() {
        return GSON;
    }

    public void setNoteEventListeners(List<NoteEventListener> noteEventListeners) {
        this.noteEventListeners = noteEventListeners;
    }

    public void setSaved(boolean saved) {
        this.saved = saved;
    }

    public boolean isSaved() {
        return this.saved;
    }

    public void setRemoved(boolean removed) {
        this.removed = removed;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public ExecutionContext getExecutionContext() {
        ExecutionContext executionContext = new ExecutionContext();
        executionContext.setNoteId(this.id);
        executionContext.setDefaultInterpreterGroup(this.defaultInterpreterGroup);
        executionContext.setInIsolatedMode(this.isIsolatedMode());
        executionContext.setStartTime(this.getStartTime());
        return executionContext;
    }

    private static class NoteJsonExclusionStrategy
    implements ExclusionStrategy {
        private Set<String> noteExcludeFields = new HashSet<String>();
        private Set<String> paragraphExcludeFields = new HashSet<String>();

        public NoteJsonExclusionStrategy(ZeppelinConfiguration zConf) {
            String[] excludeFields;
            for (String field : excludeFields = zConf.getNoteFileExcludedFields()) {
                if (field.startsWith("Paragraph")) {
                    this.paragraphExcludeFields.add(field.substring(10));
                    continue;
                }
                this.noteExcludeFields.add(field);
            }
        }

        public boolean shouldSkipField(FieldAttributes field) {
            if (field.getName().equals("path")) {
                return true;
            }
            if (field.getDeclaringClass().equals(Paragraph.class)) {
                return this.paragraphExcludeFields.contains(field.getName());
            }
            return this.noteExcludeFields.contains(field.getName());
        }

        public boolean shouldSkipClass(Class<?> aClass) {
            return false;
        }
    }
}

