/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.notebook;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.user.AuthenticationInfo;

public class NoteAuth {
    private static Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private String noteId;
    private Set<String> readers = new HashSet<String>();
    private Set<String> writers = new HashSet<String>();
    private Set<String> runners = new HashSet<String>();
    private Set<String> owners = new HashSet<String>();

    public NoteAuth(String noteId) {
        this(noteId, AuthenticationInfo.ANONYMOUS);
    }

    public NoteAuth(String noteId, AuthenticationInfo subject) {
        this.noteId = noteId;
        this.initPermissions(subject);
    }

    public NoteAuth(String noteId, Map<String, Set<String>> permissions) {
        this.noteId = noteId;
        this.readers = permissions.getOrDefault("readers", Sets.newHashSet());
        this.writers = permissions.getOrDefault("writers", Sets.newHashSet());
        this.runners = permissions.getOrDefault("runners", Sets.newHashSet());
        this.owners = permissions.getOrDefault("owners", Sets.newHashSet());
    }

    public void initPermissions(AuthenticationInfo subject) {
        if (!AuthenticationInfo.isAnonymous((AuthenticationInfo)subject)) {
            if (ZeppelinConfiguration.create().isNotebookPublic()) {
                this.owners.add(this.checkCaseAndConvert(subject.getUser()));
            } else {
                this.owners.add(this.checkCaseAndConvert(subject.getUser()));
                this.readers.add(this.checkCaseAndConvert(subject.getUser()));
                this.writers.add(this.checkCaseAndConvert(subject.getUser()));
                this.runners.add(this.checkCaseAndConvert(subject.getUser()));
            }
        }
    }

    public String getNoteId() {
        return this.noteId;
    }

    public void setOwners(Set<String> entities) {
        this.owners = this.checkCaseAndConvert(entities);
    }

    public void setReaders(Set<String> entities) {
        this.readers = this.checkCaseAndConvert(entities);
    }

    public void setWriters(Set<String> entities) {
        this.writers = this.checkCaseAndConvert(entities);
    }

    public void setRunners(Set<String> entities) {
        this.runners = this.checkCaseAndConvert(entities);
    }

    public Set<String> getOwners() {
        return this.owners;
    }

    public Set<String> getReaders() {
        return this.readers;
    }

    public Set<String> getWriters() {
        return this.writers;
    }

    public Set<String> getRunners() {
        return this.runners;
    }

    private Set<String> checkCaseAndConvert(Set<String> entities) {
        if (ZeppelinConfiguration.create().isUsernameForceLowerCase()) {
            HashSet<String> set2 = new HashSet<String>();
            for (String name : entities) {
                set2.add(name.toLowerCase());
            }
            return set2;
        }
        return entities;
    }

    private String checkCaseAndConvert(String entity) {
        if (ZeppelinConfiguration.create().isUsernameForceLowerCase()) {
            return entity.toLowerCase();
        }
        return entity;
    }

    public Map<String, Set<String>> toMap() {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        map.put("readers", this.readers);
        map.put("writers", this.writers);
        map.put("runners", this.runners);
        map.put("owners", this.owners);
        return map;
    }

    public String toJson() {
        return gson.toJson((Object)this);
    }

    public static NoteAuth fromJson(String json) {
        return (NoteAuth)gson.fromJson(json, NoteAuth.class);
    }
}

