/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.notebook;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.zeppelin.common.JsonSerializable;
import org.apache.zeppelin.display.AngularObject;
import org.apache.zeppelin.display.AngularObjectRegistry;
import org.apache.zeppelin.display.GUI;
import org.apache.zeppelin.display.Input;
import org.apache.zeppelin.helium.HeliumPackage;
import org.apache.zeppelin.interpreter.ExecutionContext;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterNotFoundException;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.InterpreterResultMessage;
import org.apache.zeppelin.interpreter.InterpreterSetting;
import org.apache.zeppelin.interpreter.ManagedInterpreterGroup;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreter;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;
import org.apache.zeppelin.notebook.ApplicationState;
import org.apache.zeppelin.notebook.CredentialInjector;
import org.apache.zeppelin.notebook.Note;
import org.apache.zeppelin.notebook.ParagraphRuntimeInfo;
import org.apache.zeppelin.notebook.ParagraphTextParser;
import org.apache.zeppelin.resource.ResourcePool;
import org.apache.zeppelin.scheduler.Job;
import org.apache.zeppelin.scheduler.JobListener;
import org.apache.zeppelin.scheduler.JobWithProgressPoller;
import org.apache.zeppelin.user.AuthenticationInfo;
import org.apache.zeppelin.user.Credentials;
import org.apache.zeppelin.user.UserCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Paragraph
extends JobWithProgressPoller<InterpreterResult>
implements Cloneable,
JsonSerializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(Paragraph.class);
    private String title;
    private String text;
    private String user;
    private Date dateUpdated;
    private int progress;
    private Map<String, Object> config = new HashMap<String, Object>();
    public GUI settings = new GUI();
    private InterpreterResult results;
    private final List<ApplicationState> apps = new LinkedList<ApplicationState>();
    private transient String intpText;
    private transient String scriptText;
    private transient Interpreter interpreter;
    private transient String interpreterGroupId;
    private transient Note note;
    private transient AuthenticationInfo subject;
    private transient Map<String, Paragraph> userParagraphMap = new HashMap<String, Paragraph>();
    private transient Map<String, String> localProperties = new HashMap<String, String>();
    private Map<String, ParagraphRuntimeInfo> runtimeInfos = new HashMap<String, ParagraphRuntimeInfo>();
    private transient List<InterpreterResultMessage> outputBuffer = new ArrayList<InterpreterResultMessage>();

    @VisibleForTesting
    Paragraph() {
        super(Paragraph.generateId(), null);
    }

    public Paragraph(String paragraphId, Note note, JobListener listener) {
        super(paragraphId, Paragraph.generateId(), listener);
        this.note = note;
    }

    public Paragraph(Note note, JobListener listener) {
        super(Paragraph.generateId(), listener);
        this.note = note;
    }

    public Paragraph(Paragraph p2) {
        super(p2.getId(), null);
        this.note = p2.note;
        this.settings.setParams((Map)Maps.newHashMap((Map)p2.settings.getParams()));
        this.settings.setForms((Map)Maps.newLinkedHashMap((Map)p2.settings.getForms()));
        this.setConfig(Maps.newHashMap(p2.getConfig()));
        this.setAuthenticationInfo(p2.getAuthenticationInfo());
        this.title = p2.title;
        this.text = p2.text;
        this.results = p2.results;
        this.setStatus(p2.getStatus());
    }

    private static String generateId() {
        return "paragraph_" + System.currentTimeMillis() + "_" + Math.abs(new SecureRandom().nextInt());
    }

    public Map<String, Paragraph> getUserParagraphMap() {
        return this.userParagraphMap;
    }

    public Paragraph getUserParagraph(String user) {
        if (!this.userParagraphMap.containsKey(user)) {
            this.cloneParagraphForUser(user);
        }
        return this.userParagraphMap.get(user);
    }

    public void setResult(InterpreterResult result) {
        this.results = result;
    }

    public Paragraph cloneParagraphForUser(String user) {
        Paragraph p = new Paragraph(this);
        p.status = Job.Status.READY;
        this.addUser(p, user);
        return p;
    }

    private void setIntpText(String newIntptext) {
        this.intpText = newIntptext;
    }

    public void clearUserParagraphs() {
        this.userParagraphMap.clear();
    }

    public void addUser(Paragraph p, String user) {
        this.userParagraphMap.put(user, p);
    }

    public String getUser() {
        return this.user;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String newText) {
        this.text = newText;
        this.dateUpdated = new Date();
        this.parseText();
    }

    public void parseText() {
        if (this.text != null) {
            ParagraphTextParser.ParseResult result = ParagraphTextParser.parse(this.text);
            this.localProperties = result.getLocalProperties();
            this.setIntpText(result.getIntpText());
            this.scriptText = result.getScriptText();
        }
    }

    public AuthenticationInfo getAuthenticationInfo() {
        return this.subject;
    }

    public void setAuthenticationInfo(AuthenticationInfo subject) {
        this.subject = subject;
        if (subject != null) {
            this.user = subject.getUser();
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getIntpText() {
        return this.intpText;
    }

    public String getScriptText() {
        return this.scriptText;
    }

    public void setNote(Note note) {
        this.note = note;
    }

    public Note getNote() {
        return this.note;
    }

    public Map<String, String> getLocalProperties() {
        return this.localProperties;
    }

    public boolean isEnabled() {
        Boolean enabled = (Boolean)this.config.get("enabled");
        return enabled == null || enabled != false;
    }

    public Interpreter getBindedInterpreter() throws InterpreterNotFoundException {
        ExecutionContext executionContext = this.note.getExecutionContext();
        executionContext.setUser(this.user);
        executionContext.setInterpreterGroupId(this.interpreterGroupId);
        return this.note.getInterpreterFactory().getInterpreter(this.intpText, executionContext);
    }

    @VisibleForTesting
    public void setInterpreter(Interpreter interpreter) {
        this.interpreter = interpreter;
    }

    public Interpreter getInterpreter() {
        return this.interpreter;
    }

    public List<InterpreterCompletion> completion(String buffer, int cursor) {
        this.setText(buffer);
        try {
            this.interpreter = this.getBindedInterpreter();
        }
        catch (InterpreterNotFoundException e) {
            LOGGER.debug("Unable to get completion because there's no interpreter bind to it", (Throwable)e);
            return new ArrayList<InterpreterCompletion>();
        }
        cursor = this.calculateCursorPosition(buffer, cursor);
        InterpreterContext interpreterContext = this.getInterpreterContext();
        try {
            return this.interpreter.completion(this.scriptText, cursor, interpreterContext);
        }
        catch (InterpreterException e) {
            LOGGER.warn("Fail to get completion", (Throwable)e);
            return new ArrayList<InterpreterCompletion>();
        }
    }

    public int calculateCursorPosition(String buffer, int cursor) {
        if (this.scriptText.isEmpty()) {
            return 0;
        }
        int startPos = this.intpText == null ? 0 : this.intpText.length();
        int countCharactersBeforeScript = buffer.indexOf(this.scriptText, startPos);
        if (countCharactersBeforeScript > 0) {
            cursor -= countCharactersBeforeScript;
        }
        return cursor;
    }

    public InterpreterResult getReturn() {
        return this.results;
    }

    public int progress() {
        try {
            if (this.interpreter != null) {
                this.progress = this.interpreter.getProgress(this.getInterpreterContext());
                return this.progress;
            }
            return 0;
        }
        catch (InterpreterException e) {
            throw new RuntimeException("Fail to get progress", e);
        }
    }

    public Map<String, Object> info() {
        return null;
    }

    public boolean shouldSkipRunParagraph() {
        boolean checkEmptyConfig = (Boolean)this.config.getOrDefault(InterpreterSetting.PARAGRAPH_CONFIG_CHECK_EMTPY, true);
        return checkEmptyConfig && Strings.isNullOrEmpty((String)this.scriptText) && this.localProperties.isEmpty();
    }

    public boolean execute(boolean blocking) {
        return this.execute(null, blocking);
    }

    public boolean execute(String interpreterGroupId, boolean blocking) {
        try {
            this.interpreterGroupId = interpreterGroupId;
            this.interpreter = this.getBindedInterpreter();
            InterpreterSetting interpreterSetting = ((ManagedInterpreterGroup)this.interpreter.getInterpreterGroup()).getInterpreterSetting();
            Map<String, Object> config = interpreterSetting.getConfig(this.interpreter.getClassName());
            this.mergeConfig(config);
            this.setResult(null);
            this.cleanOutputBuffer();
            this.cleanRuntimeInfos();
            this.setStatus(Job.Status.PENDING);
            if (this.shouldSkipRunParagraph()) {
                LOGGER.info("Skip to run blank paragraph. {}", (Object)this.getId());
                this.setStatus(Job.Status.FINISHED);
                return true;
            }
            if (!this.isEnabled()) {
                LOGGER.info("Skip disabled paragraph. {}", (Object)this.getId());
                this.setStatus(Job.Status.FINISHED);
                return true;
            }
            this.setAuthenticationInfo(this.getAuthenticationInfo());
            this.interpreter.getScheduler().submit((Job)this);
            if (blocking) {
                while (!this.getStatus().isCompleted()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
                return this.getStatus() == Job.Status.FINISHED;
            }
            return true;
        }
        catch (InterpreterNotFoundException e) {
            InterpreterResult intpResult = new InterpreterResult(InterpreterResult.Code.ERROR, String.format("Interpreter %s not found", this.intpText));
            this.setReturn(intpResult, e);
            this.setStatus(Job.Status.ERROR);
            return false;
        }
        catch (Throwable e) {
            InterpreterResult intpResult = new InterpreterResult(InterpreterResult.Code.ERROR, "Unexpected exception: " + ExceptionUtils.getStackTrace((Throwable)e));
            this.setReturn(intpResult, e);
            this.setStatus(Job.Status.ERROR);
            return false;
        }
    }

    public void setStatus(Job.Status status) {
        super.setStatus(status);
        if (status.isCompleted()) {
            this.interpreterGroupId = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InterpreterResult jobRun() throws Throwable {
        try {
            InterpreterResult ret;
            block26: {
                UserCredentials creds;
                if (this.localProperties.getOrDefault("isRecover", "false").equals("false")) {
                    this.runtimeInfos.clear();
                }
                this.interpreter = this.getBindedInterpreter();
                if (this.interpreter == null) {
                    LOGGER.error("Can not find interpreter name " + this.intpText);
                    throw new RuntimeException("Can not find interpreter for " + this.intpText);
                }
                LOGGER.info("Run paragraph [paragraph_id: {}, interpreter: {}, note_id: {}, user: {}]", new Object[]{this.getId(), this.interpreter.getClassName(), this.note.getId(), this.subject.getUser()});
                InterpreterSetting interpreterSetting = ((ManagedInterpreterGroup)this.interpreter.getInterpreterGroup()).getInterpreterSetting();
                if (interpreterSetting.getStatus() != InterpreterSetting.Status.READY) {
                    String message = String.format("Interpreter Setting '%s' is not ready, its status is %s", new Object[]{interpreterSetting.getName(), interpreterSetting.getStatus()});
                    LOGGER.error(message);
                    throw new RuntimeException(message);
                }
                if (this.user != null && this.subject != null && !interpreterSetting.isUserAuthorized(this.subject.getUsersAndRoles())) {
                    String msg = String.format("%s has no permission for %s", this.subject.getUser(), this.intpText);
                    LOGGER.error(msg);
                    InterpreterResult interpreterResult = new InterpreterResult(InterpreterResult.Code.ERROR, msg);
                    return interpreterResult;
                }
                for (Paragraph p : this.userParagraphMap.values()) {
                    p.setText(this.getText());
                }
                String script = this.scriptText;
                String form = this.localProperties.getOrDefault("form", this.interpreter.getFormType().name());
                if (form.equalsIgnoreCase("simple")) {
                    LinkedHashMap inputs = Input.extractSimpleQueryForm((String)script, (boolean)false);
                    LinkedHashMap noteInputs = Input.extractSimpleQueryForm((String)script, (boolean)true);
                    AngularObjectRegistry angularRegistry = this.interpreter.getInterpreterGroup().getAngularObjectRegistry();
                    String scriptBody = this.extractVariablesFromAngularRegistry(script, inputs, angularRegistry);
                    this.settings.setForms((Map)inputs);
                    if (!noteInputs.isEmpty()) {
                        if (!this.note.getNoteForms().isEmpty()) {
                            Map<String, Input> currentNoteForms = this.note.getNoteForms();
                            for (String s : noteInputs.keySet()) {
                                if (currentNoteForms.containsKey(s)) continue;
                                currentNoteForms.put(s, (Input)noteInputs.get(s));
                            }
                        } else {
                            this.note.setNoteForms(noteInputs);
                        }
                    }
                    script = Input.getSimpleQuery(this.note.getNoteParams(), (String)scriptBody, (boolean)true);
                    script = Input.getSimpleQuery((Map)this.settings.getParams(), (String)script, (boolean)false);
                } else {
                    this.settings.clear();
                }
                LOGGER.debug("RUN : " + script);
                try {
                    InterpreterContext context = this.getInterpreterContext();
                    InterpreterContext.set((InterpreterContext)context);
                    String injectPropStr = this.interpreter.getProperty("injectCredentials", "false");
                    injectPropStr = context.getStringLocalProperty("injectCredentials", injectPropStr);
                    boolean shouldInjectCredentials = Boolean.parseBoolean(injectPropStr);
                    ret = null;
                    if (shouldInjectCredentials) {
                        creds = context.getAuthenticationInfo().getUserCredentials();
                        CredentialInjector credinjector = new CredentialInjector(creds);
                        String code = credinjector.replaceCredentials(script);
                        ret = this.interpreter.interpret(code, context);
                        ret = credinjector.hidePasswords(ret);
                    } else {
                        ret = this.interpreter.interpret(script, context);
                    }
                    if (this.interpreter.getFormType() == Interpreter.FormType.NATIVE) {
                        this.note.setNoteParams(context.getNoteGui().getParams());
                        this.note.setNoteForms(context.getNoteGui().getForms());
                    }
                    if (InterpreterResult.Code.KEEP_PREVIOUS_RESULT != ret.code()) break block26;
                    creds = this.getReturn();
                }
                catch (Throwable throwable) {
                    try {
                        InterpreterContext.remove();
                        throw throwable;
                    }
                    catch (Exception e) {
                        InterpreterResult interpreterResult = new InterpreterResult(InterpreterResult.Code.ERROR, ExceptionUtils.getStackTrace((Throwable)e));
                        return interpreterResult;
                    }
                }
                InterpreterContext.remove();
                return creds;
            }
            Paragraph p = this.getUserParagraph(this.getUser());
            if (null != p) {
                p.setResult(ret);
                p.settings.setParams(this.settings.getParams());
            }
            InterpreterResult interpreterResult = ret;
            InterpreterContext.remove();
            return interpreterResult;
        }
        finally {
            this.localProperties.remove("isRecover");
        }
    }

    protected boolean jobAbort() {
        if (this.interpreter == null) {
            return true;
        }
        try {
            this.interpreter.cancel(this.getInterpreterContext());
        }
        catch (InterpreterException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    private InterpreterContext getInterpreterContext() {
        AngularObjectRegistry registry = null;
        ResourcePool resourcePool = null;
        String replName = null;
        if (this.interpreter != null) {
            registry = this.interpreter.getInterpreterGroup().getAngularObjectRegistry();
            resourcePool = this.interpreter.getInterpreterGroup().getResourcePool();
            InterpreterSetting interpreterSetting = ((ManagedInterpreterGroup)this.interpreter.getInterpreterGroup()).getInterpreterSetting();
            replName = interpreterSetting.getName();
        }
        Credentials credentials = this.note.getCredentials();
        if (this.subject != null) {
            UserCredentials userCredentials;
            try {
                userCredentials = credentials.getUserCredentials(this.subject.getUser());
            }
            catch (IOException e) {
                LOGGER.warn("Unable to get Usercredentials. Working with empty UserCredentials", (Throwable)e);
                userCredentials = new UserCredentials();
            }
            this.subject.setUserCredentials(userCredentials);
        }
        return InterpreterContext.builder().setNoteId(this.note.getId()).setNoteName(this.note.getName()).setParagraphId(this.getId()).setReplName(replName).setParagraphTitle(this.title).setParagraphText(this.text).setAuthenticationInfo(this.subject).setLocalProperties(this.localProperties).setConfig(this.config).setGUI(this.settings).setNoteGUI(this.getNoteGui()).setAngularObjectRegistry(registry).setResourcePool(resourcePool).build();
    }

    public void setStatusToUserParagraph(Job.Status status) {
        String user = this.getUser();
        if (null != user) {
            this.getUserParagraph(this.getUser()).setStatus(status);
        }
    }

    public Map<String, Object> getConfig() {
        return this.config;
    }

    public void setConfig(Map<String, Object> config) {
        this.config = Maps.newHashMap(config);
    }

    public void mergeConfig(Map<String, Object> newConfig) {
        this.config.putAll(newConfig);
    }

    public void updateConfig(Map<String, String> newConfig) {
        this.config.putAll(newConfig);
    }

    public void setReturn(InterpreterResult value, Throwable t) {
        this.setResult(value);
        this.setException(t);
    }

    private String getApplicationId(HeliumPackage pkg) {
        return "app_" + this.getNote().getId() + "-" + this.getId() + pkg.getName().replaceAll("\\.", "_");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationState createOrGetApplicationState(HeliumPackage pkg) {
        List<ApplicationState> list = this.apps;
        synchronized (list) {
            for (ApplicationState as : this.apps) {
                if (!as.equals(pkg)) continue;
                return as;
            }
            String appId = this.getApplicationId(pkg);
            ApplicationState appState = new ApplicationState(appId, pkg);
            this.apps.add(appState);
            return appState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationState getApplicationState(String appId) {
        List<ApplicationState> list = this.apps;
        synchronized (list) {
            for (ApplicationState as : this.apps) {
                if (!as.getId().equals(appId)) continue;
                return as;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ApplicationState> getAllApplicationStates() {
        List<ApplicationState> list = this.apps;
        synchronized (list) {
            return new LinkedList<ApplicationState>(this.apps);
        }
    }

    String extractVariablesFromAngularRegistry(String scriptBody, Map<String, Input> inputs, AngularObjectRegistry angularRegistry) {
        String noteId = this.getNote().getId();
        String paragraphId = this.getId();
        HashSet<String> keys = new HashSet<String>(inputs.keySet());
        for (String varName : keys) {
            AngularObject paragraphScoped = angularRegistry.get(varName, noteId, paragraphId);
            AngularObject noteScoped = angularRegistry.get(varName, noteId, null);
            AngularObject angularObject = paragraphScoped != null ? paragraphScoped : noteScoped;
            if (angularObject == null) continue;
            inputs.remove(varName);
            String pattern = "[$][{]\\s*" + varName + "\\s*(?:=[^}]+)?[}]";
            scriptBody = scriptBody.replaceAll(pattern, angularObject.get().toString());
        }
        return scriptBody;
    }

    public boolean isValidInterpreter(String replName) {
        try {
            ExecutionContext executionContext = this.note.getExecutionContext();
            executionContext.setUser(this.user);
            executionContext.setInterpreterGroupId(this.interpreterGroupId);
            return this.note.getInterpreterFactory().getInterpreter(replName, executionContext) != null;
        }
        catch (InterpreterNotFoundException e) {
            return false;
        }
    }

    public void updateRuntimeInfos(String label, String tooltip, Map<String, String> infos, String group, String intpSettingId) {
        if (this.runtimeInfos == null) {
            this.runtimeInfos = new HashMap<String, ParagraphRuntimeInfo>();
        }
        if (infos != null) {
            for (String key : infos.keySet()) {
                ParagraphRuntimeInfo info = this.runtimeInfos.get(key);
                if (info == null) {
                    info = new ParagraphRuntimeInfo(key, label, tooltip, group, intpSettingId);
                    this.runtimeInfos.put(key, info);
                }
                info.addValue(infos);
            }
        }
    }

    public Map<String, ParagraphRuntimeInfo> getRuntimeInfos() {
        return this.runtimeInfos;
    }

    public void cleanRuntimeInfos() {
        this.runtimeInfos.clear();
    }

    public void cleanOutputBuffer() {
        this.outputBuffer.clear();
    }

    public void checkpointOutput() {
        LOGGER.info("Checkpoint Paragraph output for paragraph: " + this.getId());
        this.results = new InterpreterResult(InterpreterResult.Code.SUCCESS);
        for (InterpreterResultMessage buffer : this.outputBuffer) {
            this.results.add(buffer);
        }
    }

    @VisibleForTesting
    public void waitUntilFinished() throws Exception {
        while (!this.isTerminated()) {
            LOGGER.debug("Wait for paragraph to be finished");
            Thread.sleep(1000L);
        }
    }

    @VisibleForTesting
    public void waitUntilRunning() throws Exception {
        while (!this.isRunning()) {
            LOGGER.debug("Wait for paragraph to be running");
            Thread.sleep(1000L);
        }
    }

    private GUI getNoteGui() {
        GUI gui = new GUI();
        gui.setParams(this.note.getNoteParams());
        gui.setForms(this.note.getNoteForms());
        return gui;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Paragraph paragraph = (Paragraph)o;
        if (this.title != null ? !this.title.equals(paragraph.title) : paragraph.title != null) {
            return false;
        }
        if (this.text != null ? !this.text.equals(paragraph.text) : paragraph.text != null) {
            return false;
        }
        if (this.user != null ? !this.user.equals(paragraph.user) : paragraph.user != null) {
            return false;
        }
        if (this.dateUpdated != null ? !this.dateUpdated.equals(paragraph.dateUpdated) : paragraph.dateUpdated != null) {
            return false;
        }
        if (this.config != null ? !this.config.equals(paragraph.config) : paragraph.config != null) {
            return false;
        }
        if (this.settings != null ? !this.settings.equals((Object)paragraph.settings) : paragraph.settings != null) {
            return false;
        }
        return this.results != null ? this.results.equals(paragraph.results) : paragraph.results == null;
    }

    public int hashCode() {
        int result1 = super.hashCode();
        result1 = 31 * result1 + (this.title != null ? this.title.hashCode() : 0);
        result1 = 31 * result1 + (this.text != null ? this.text.hashCode() : 0);
        result1 = 31 * result1 + (this.user != null ? this.user.hashCode() : 0);
        result1 = 31 * result1 + (this.dateUpdated != null ? this.dateUpdated.hashCode() : 0);
        result1 = 31 * result1 + (this.config != null ? this.config.hashCode() : 0);
        result1 = 31 * result1 + (this.settings != null ? this.settings.hashCode() : 0);
        result1 = 31 * result1 + (this.results != null ? this.results.hashCode() : 0);
        return result1;
    }

    public String toJson() {
        return Note.getGSON().toJson((Object)this);
    }

    public static Paragraph fromJson(String json) {
        return (Paragraph)Note.getGSON().fromJson(json, Paragraph.class);
    }

    public void updateOutputBuffer(int index, InterpreterResult.Type type, String output) {
        InterpreterResultMessage interpreterResultMessage = new InterpreterResultMessage(type, output);
        if (this.outputBuffer.size() == index) {
            this.outputBuffer.add(interpreterResultMessage);
        } else if (this.outputBuffer.size() > index) {
            this.outputBuffer.set(index, interpreterResultMessage);
        } else {
            LOGGER.warn("Get output of index: " + index + ", but there's only " + this.outputBuffer.size() + " output in outputBuffer");
        }
    }

    public void recover() {
        try {
            LOGGER.info("Recovering paragraph: " + this.getId());
            this.interpreter = this.getBindedInterpreter();
            InterpreterSetting interpreterSetting = ((ManagedInterpreterGroup)this.interpreter.getInterpreterGroup()).getInterpreterSetting();
            Map<String, Object> config = interpreterSetting.getConfig(this.interpreter.getClassName());
            this.mergeConfig(config);
            if (this.shouldSkipRunParagraph()) {
                LOGGER.info("Skip to run blank paragraph. {}", (Object)this.getId());
                this.setStatus(Job.Status.FINISHED);
                return;
            }
            this.setStatus(Job.Status.READY);
            this.localProperties.put("isRecover", "true");
            for (List sessions : this.interpreter.getInterpreterGroup().values()) {
                for (Interpreter intp : sessions) {
                    if (!(intp instanceof RemoteInterpreter)) continue;
                    ((RemoteInterpreter)intp).setOpened(true);
                }
            }
            if (this.getConfig().get("enabled") == null || ((Boolean)this.getConfig().get("enabled")).booleanValue()) {
                this.setAuthenticationInfo(this.getAuthenticationInfo());
                this.interpreter.getScheduler().submit((Job)this);
            }
        }
        catch (InterpreterNotFoundException e) {
            InterpreterResult intpResult = new InterpreterResult(InterpreterResult.Code.ERROR, String.format("Interpreter %s not found", this.intpText));
            this.setReturn(intpResult, e);
            this.setStatus(Job.Status.ERROR);
        }
        catch (Throwable e) {
            InterpreterResult intpResult = new InterpreterResult(InterpreterResult.Code.ERROR, "Unexpected exception: " + ExceptionUtils.getStackTrace((Throwable)e));
            this.setReturn(intpResult, e);
            this.setStatus(Job.Status.ERROR);
        }
    }
}

