/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.notebook.repo;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.NameScope;
import org.apache.commons.vfs2.Selectors;
import org.apache.commons.vfs2.VFS;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.notebook.Note;
import org.apache.zeppelin.notebook.OldNoteInfo;
import org.apache.zeppelin.notebook.repo.NotebookRepoSettingsInfo;
import org.apache.zeppelin.notebook.repo.OldNotebookRepo;
import org.apache.zeppelin.user.AuthenticationInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OldVFSNotebookRepo
implements OldNotebookRepo {
    private static final Logger LOG = LoggerFactory.getLogger(OldVFSNotebookRepo.class);
    private FileSystemManager fsManager;
    private URI filesystemRoot;
    protected ZeppelinConfiguration conf;

    @Override
    public void init(ZeppelinConfiguration conf) throws IOException {
        this.conf = conf;
        this.setNotebookDirectory(conf.getNotebookDir());
    }

    protected void setNotebookDirectory(String notebookDirPath) throws IOException {
        try {
            LOG.info("Using notebookDir: {}", (Object)notebookDirPath);
            this.filesystemRoot = this.conf.isWindowsPath(notebookDirPath) ? new File(notebookDirPath).toURI() : new URI(notebookDirPath);
        }
        catch (URISyntaxException e1) {
            throw new IOException(e1);
        }
        if (this.filesystemRoot.getScheme() == null) {
            File f = new File(this.conf.getAbsoluteDir(this.filesystemRoot.getPath()));
            this.filesystemRoot = f.toURI();
        }
        this.fsManager = VFS.getManager();
        FileObject file = this.fsManager.resolveFile(this.filesystemRoot.getPath());
        if (!file.exists()) {
            LOG.info("Notebook dir doesn't exist, create on is {}.", (Object)file.getName());
            file.createFolder();
        }
    }

    private String getNotebookDirPath() {
        return this.filesystemRoot.getPath();
    }

    private String getPath(String path) {
        if (path == null || path.trim().length() == 0) {
            return this.filesystemRoot.toString();
        }
        if (path.startsWith("/")) {
            return this.filesystemRoot.toString() + path;
        }
        return this.filesystemRoot.toString() + "/" + path;
    }

    private boolean isDirectory(FileObject fo) throws IOException {
        if (fo == null) {
            return false;
        }
        return fo.getType() == FileType.FOLDER;
    }

    @Override
    public List<OldNoteInfo> list(AuthenticationInfo subject) throws IOException {
        FileObject rootDir = this.getRootDir();
        FileObject[] children = rootDir.getChildren();
        LinkedList<OldNoteInfo> infos = new LinkedList<OldNoteInfo>();
        for (FileObject f : children) {
            String fileName = f.getName().getBaseName();
            if (f.isHidden() || fileName.startsWith(".") || fileName.startsWith("#") || fileName.startsWith("~") || !this.isDirectory(f)) continue;
            OldNoteInfo info = null;
            try {
                info = this.getNoteInfo(f);
                if (info == null) continue;
                infos.add(info);
            }
            catch (Exception e) {
                LOG.error("Can't read note {}", (Object)f.getName());
            }
        }
        return infos;
    }

    private Note getNote(FileObject noteDir) throws IOException {
        if (!this.isDirectory(noteDir)) {
            throw new IOException(noteDir.getName().toString() + " is not a directory");
        }
        FileObject noteJson = noteDir.resolveFile("note.json", NameScope.CHILD);
        if (!noteJson.exists()) {
            throw new IOException(noteJson.getName().toString() + " not found");
        }
        FileContent content = noteJson.getContent();
        InputStream ins = content.getInputStream();
        String json = IOUtils.toString((InputStream)ins, (String)this.conf.getString(ZeppelinConfiguration.ConfVars.ZEPPELIN_ENCODING));
        ins.close();
        return Note.fromJson(null, json);
    }

    private OldNoteInfo getNoteInfo(FileObject noteDir) throws IOException {
        Note note = this.getNote(noteDir);
        return new OldNoteInfo(note);
    }

    @Override
    public Note get(String noteId, AuthenticationInfo subject) throws IOException {
        FileObject rootDir = this.fsManager.resolveFile(this.getPath("/"));
        FileObject noteDir = rootDir.resolveFile(noteId, NameScope.CHILD);
        return this.getNote(noteDir);
    }

    protected FileObject getRootDir() throws IOException {
        FileObject rootDir = this.fsManager.resolveFile(this.getPath("/"));
        if (!rootDir.exists()) {
            throw new IOException("Root path does not exists");
        }
        if (!this.isDirectory(rootDir)) {
            throw new IOException("Root path is not a directory");
        }
        return rootDir;
    }

    @Override
    public synchronized void save(Note note, AuthenticationInfo subject) throws IOException {
        LOG.info("Saving note: {}", (Object)note.getId());
        String json = note.toJson();
        FileObject rootDir = this.getRootDir();
        FileObject noteDir = rootDir.resolveFile(note.getId(), NameScope.CHILD);
        if (!noteDir.exists()) {
            noteDir.createFolder();
        }
        if (!this.isDirectory(noteDir)) {
            throw new IOException(noteDir.getName().toString() + " is not a directory");
        }
        FileObject noteJson = noteDir.resolveFile(".note.json", NameScope.CHILD);
        OutputStream out = noteJson.getContent().getOutputStream(false);
        out.write(json.getBytes(this.conf.getString(ZeppelinConfiguration.ConfVars.ZEPPELIN_ENCODING)));
        out.close();
        noteJson.moveTo(noteDir.resolveFile("note.json", NameScope.CHILD));
    }

    @Override
    public void remove(String noteId, AuthenticationInfo subject) throws IOException {
        FileObject rootDir = this.fsManager.resolveFile(this.getPath("/"));
        FileObject noteDir = rootDir.resolveFile(noteId, NameScope.CHILD);
        if (!noteDir.exists()) {
            return;
        }
        if (!this.isDirectory(noteDir)) {
            throw new IOException("Can not remove " + noteDir.getName().toString());
        }
        noteDir.delete(Selectors.SELECT_SELF_AND_CHILDREN);
    }

    @Override
    public void close() {
    }

    @Override
    public List<NotebookRepoSettingsInfo> getSettings(AuthenticationInfo subject) {
        NotebookRepoSettingsInfo repoSetting = NotebookRepoSettingsInfo.newInstance();
        ArrayList<NotebookRepoSettingsInfo> settings = new ArrayList<NotebookRepoSettingsInfo>();
        repoSetting.name = "Notebook Path";
        repoSetting.type = NotebookRepoSettingsInfo.Type.INPUT;
        repoSetting.value = Collections.emptyList();
        repoSetting.selected = this.getNotebookDirPath();
        settings.add(repoSetting);
        return settings;
    }

    @Override
    public void updateSettings(Map<String, String> settings, AuthenticationInfo subject) {
        if (settings == null || settings.isEmpty()) {
            LOG.error("Cannot update {} with empty settings", (Object)this.getClass().getName());
            return;
        }
        String newNotebookDirectotyPath = "";
        if (settings.containsKey("Notebook Path")) {
            newNotebookDirectotyPath = settings.get("Notebook Path");
        }
        if (StringUtils.isBlank((CharSequence)newNotebookDirectotyPath)) {
            LOG.error("Notebook path is invalid");
            return;
        }
        LOG.warn("{} will change notebook dir from {} to {}", new Object[]{subject.getUser(), this.getNotebookDirPath(), newNotebookDirectotyPath});
        try {
            this.setNotebookDirectory(newNotebookDirectotyPath);
        }
        catch (IOException e) {
            LOG.error("Cannot update notebook directory", (Throwable)e);
        }
    }
}

