/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.notebook.repo.zeppelinhub.rest;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.apache.zeppelin.notebook.repo.zeppelinhub.model.Instance;
import org.apache.zeppelin.notebook.repo.zeppelinhub.rest.HttpProxyClient;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.client.util.InputStreamResponseListener;
import org.eclipse.jetty.client.util.StringContentProvider;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZeppelinhubRestApiHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ZeppelinhubRestApiHandler.class);
    public static final String ZEPPELIN_TOKEN_HEADER = "X-Zeppelin-Token";
    private static final String USER_SESSION_HEADER = "X-User-Session";
    private static final String DEFAULT_API_PATH = "/api/v1/zeppelin";
    private static boolean PROXY_ON = false;
    private static HttpProxyClient proxyClient;
    private final HttpClient client;
    private String zepelinhubUrl;

    public static ZeppelinhubRestApiHandler newInstance(String zeppelinhubUrl) {
        return new ZeppelinhubRestApiHandler(zeppelinhubUrl);
    }

    private ZeppelinhubRestApiHandler(String zeppelinhubUrl) {
        this.zepelinhubUrl = zeppelinhubUrl + DEFAULT_API_PATH + "/";
        this.readProxyConf();
        this.client = this.getAsyncClient();
        try {
            this.client.start();
        }
        catch (Exception e) {
            LOG.error("Cannot initialize ZeppelinHub REST async client", (Throwable)e);
        }
    }

    private void readProxyConf() {
        String proxyHostString;
        String string = proxyHostString = StringUtils.isBlank((CharSequence)System.getenv("https_proxy")) ? System.getenv("HTTPS_PROXY") : System.getenv("https_proxy");
        if (StringUtils.isBlank((CharSequence)proxyHostString)) {
            String string2 = proxyHostString = StringUtils.isBlank((CharSequence)System.getenv("http_proxy")) ? System.getenv("HTTP_PROXY") : System.getenv("http_proxy");
        }
        if (!StringUtils.isBlank((CharSequence)proxyHostString)) {
            URI uri = null;
            try {
                uri = new URI(proxyHostString);
            }
            catch (URISyntaxException e) {
                LOG.warn("Proxy uri doesn't follow correct syntax", (Throwable)e);
            }
            if (uri != null) {
                PROXY_ON = true;
                proxyClient = HttpProxyClient.newInstance(uri);
            }
        }
    }

    private HttpClient getAsyncClient() {
        SslContextFactory sslContextFactory = new SslContextFactory();
        HttpClient httpClient = new HttpClient(sslContextFactory);
        httpClient.setFollowRedirects(false);
        httpClient.setMaxConnectionsPerDestination(100);
        return httpClient;
    }

    public List<Instance> getInstances(String ticket) throws IOException {
        String data;
        Response response;
        InputStreamResponseListener listener = new InputStreamResponseListener();
        String url = this.zepelinhubUrl + "instances";
        Request request = this.client.newRequest(url).header(USER_SESSION_HEADER, ticket);
        request.send((Response.CompleteListener)listener);
        try {
            response = listener.get(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            LOG.error("Cannot perform request to ZeppelinHub", (Throwable)e);
            throw new IOException("Cannot perform  GET request to ZeppelinHub", e);
        }
        int code = response.getStatus();
        if (code == 200) {
            try (InputStream responseContent = listener.getInputStream();){
                data = IOUtils.toString((InputStream)responseContent, (String)"UTF-8");
            }
        } else {
            LOG.error("ZeppelinHub GET {} returned with status {} ", (Object)url, (Object)code);
            throw new IOException("Cannot perform  GET request to ZeppelinHub");
        }
        Type listType = new TypeToken<ArrayList<Instance>>(){}.getType();
        return (List)new Gson().fromJson(data, listType);
    }

    public String get(String token, String argument) throws IOException {
        if (StringUtils.isBlank((CharSequence)token)) {
            return "";
        }
        String url = this.zepelinhubUrl + argument;
        if (PROXY_ON) {
            return this.sendToZeppelinHubViaProxy((HttpRequestBase)new HttpGet(url), "", token, true);
        }
        return this.sendToZeppelinHub(HttpMethod.GET, url, "", token, true);
    }

    public String putWithResponseBody(String token, String url, String json) throws IOException {
        if (StringUtils.isBlank((CharSequence)url) || StringUtils.isBlank((CharSequence)json)) {
            LOG.error("Empty note, cannot send it to zeppelinHub");
            throw new IOException("Cannot send emtpy note to zeppelinHub");
        }
        if (PROXY_ON) {
            return this.sendToZeppelinHubViaProxy((HttpRequestBase)new HttpPut(this.zepelinhubUrl + url), json, token, true);
        }
        return this.sendToZeppelinHub(HttpMethod.PUT, this.zepelinhubUrl + url, json, token, true);
    }

    public void put(String token, String jsonNote) throws IOException {
        if (StringUtils.isBlank((CharSequence)jsonNote)) {
            LOG.error("Cannot save empty note/string to ZeppelinHub");
            return;
        }
        if (PROXY_ON) {
            this.sendToZeppelinHubViaProxy((HttpRequestBase)new HttpPut(this.zepelinhubUrl), jsonNote, token, false);
        } else {
            this.sendToZeppelinHub(HttpMethod.PUT, this.zepelinhubUrl, jsonNote, token, false);
        }
    }

    public void del(String token, String argument) throws IOException {
        if (StringUtils.isBlank((CharSequence)argument)) {
            LOG.error("Cannot delete empty note from ZeppelinHub");
            return;
        }
        if (PROXY_ON) {
            this.sendToZeppelinHubViaProxy((HttpRequestBase)new HttpDelete(this.zepelinhubUrl + argument), "", token, false);
        } else {
            this.sendToZeppelinHub(HttpMethod.DELETE, this.zepelinhubUrl + argument, "", token, false);
        }
    }

    private String sendToZeppelinHubViaProxy(HttpRequestBase request, String json, String token, boolean withResponse) throws IOException {
        StringEntity content;
        request.setHeader(ZEPPELIN_TOKEN_HEADER, token);
        if (request.getMethod().equals("POST")) {
            HttpPost post = (HttpPost)request;
            content = new StringEntity(json, "application/json;charset=UTF-8");
            post.setEntity((HttpEntity)content);
        }
        if (request.getMethod().equals("PUT")) {
            HttpPut put = (HttpPut)request;
            content = new StringEntity(json, "application/json;charset=UTF-8");
            put.setEntity((HttpEntity)content);
        }
        String body = "";
        if (proxyClient != null) {
            body = proxyClient.sendToZeppelinHub(request, withResponse);
        } else {
            LOG.warn("Proxy client request was submitted while not correctly initialized");
        }
        return body;
    }

    private String sendToZeppelinHub(HttpMethod method, String url, String json, String token, boolean withResponse) throws IOException {
        Request request = this.client.newRequest(url).method(method).header(ZEPPELIN_TOKEN_HEADER, token);
        if ((method.equals((Object)HttpMethod.PUT) || method.equals((Object)HttpMethod.POST)) && !StringUtils.isBlank((CharSequence)json)) {
            request.content((ContentProvider)new StringContentProvider(json, "UTF-8"), "application/json;charset=UTF-8");
        }
        return withResponse ? this.sendToZeppelinHub(request) : this.sendToZeppelinHubWithoutResponseBody(request);
    }

    private String sendToZeppelinHubWithoutResponseBody(Request request) throws IOException {
        request.send(new Response.CompleteListener(){

            public void onComplete(Result result) {
                Request req = result.getRequest();
                LOG.info("ZeppelinHub {} {} returned with status {}: {}", new Object[]{req.getMethod(), req.getURI(), result.getResponse().getStatus(), result.getResponse().getReason()});
            }
        });
        return "";
    }

    private String sendToZeppelinHub(Request request) throws IOException {
        String data;
        Response response;
        InputStreamResponseListener listener = new InputStreamResponseListener();
        request.send((Response.CompleteListener)listener);
        try {
            response = listener.get(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            String method = request.getMethod();
            LOG.error("Cannot perform {} request to ZeppelinHub", (Object)method, (Object)e);
            throw new IOException("Cannot perform " + method + " request to ZeppelinHub", e);
        }
        int code = response.getStatus();
        if (code == 200) {
            try (InputStream responseContent = listener.getInputStream();){
                data = IOUtils.toString((InputStream)responseContent, (String)"UTF-8");
            }
        } else {
            String method = response.getRequest().getMethod();
            String url = response.getRequest().getURI().toString();
            LOG.error("ZeppelinHub {} {} returned with status {} ", new Object[]{method, url, code});
            throw new IOException("Cannot perform " + method + " request to ZeppelinHub");
        }
        return data;
    }

    public void close() {
        try {
            this.client.stop();
            if (proxyClient != null) {
                proxyClient.stop();
            }
        }
        catch (Exception e) {
            LOG.info("Couldn't stop ZeppelinHub client properly", (Throwable)e);
        }
    }
}

