/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.notebook.repo.zeppelinhub.websocket.listener;

import org.apache.zeppelin.notebook.repo.zeppelinhub.websocket.ZeppelinClient;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZeppelinWebsocket
implements WebSocketListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZeppelinWebsocket.class);
    public Session connection;
    public String noteId;

    public ZeppelinWebsocket(String noteId) {
        this.noteId = noteId;
    }

    public void onWebSocketBinary(byte[] arg0, int arg1, int arg2) {
    }

    public void onWebSocketClose(int code, String message) {
        LOGGER.info("Zeppelin connection closed with code: {}, message: {}", (Object)code, (Object)message);
        ZeppelinClient.getInstance().removeNoteConnection(this.noteId);
    }

    public void onWebSocketConnect(Session session) {
        LOGGER.info("Zeppelin connection opened");
        this.connection = session;
    }

    public void onWebSocketError(Throwable e) {
        LOGGER.warn("Zeppelin socket connection error ", e);
        ZeppelinClient.getInstance().removeNoteConnection(this.noteId);
    }

    public void onWebSocketText(String data) {
        LOGGER.debug("Zeppelin client received Message: {}", (Object)data);
        try {
            ZeppelinClient zeppelinClient = ZeppelinClient.getInstance();
            if (zeppelinClient != null) {
                zeppelinClient.handleMsgFromZeppelin(data, this.noteId);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to send message to ZeppelinHub: {}", (Object)e.toString());
        }
    }
}

