/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.notebook.repo.zeppelinhub.websocket.utils;

import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.common.Message;
import org.apache.zeppelin.notebook.repo.zeppelinhub.model.UserTokenContainer;
import org.apache.zeppelin.notebook.repo.zeppelinhub.websocket.ZeppelinhubClient;
import org.apache.zeppelin.notebook.repo.zeppelinhub.websocket.protocol.ZeppelinHubOp;
import org.apache.zeppelin.notebook.repo.zeppelinhub.websocket.protocol.ZeppelinhubMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZeppelinhubUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZeppelinhubUtils.class);

    public static String liveMessage(String token) {
        if (StringUtils.isBlank((CharSequence)token)) {
            LOGGER.error("Cannot create Live message: token is null or empty");
            return ZeppelinhubMessage.EMPTY.toJson();
        }
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("token", token);
        return ZeppelinhubMessage.newMessage((Object)ZeppelinHubOp.LIVE, data, new HashMap<String, String>()).toJson();
    }

    public static String deadMessage(String token) {
        if (StringUtils.isBlank((CharSequence)token)) {
            LOGGER.error("Cannot create Dead message: token is null or empty");
            return ZeppelinhubMessage.EMPTY.toJson();
        }
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("token", token);
        return ZeppelinhubMessage.newMessage((Object)ZeppelinHubOp.DEAD, data, new HashMap<String, String>()).toJson();
    }

    public static String pingMessage(String token) {
        if (StringUtils.isBlank((CharSequence)token)) {
            LOGGER.error("Cannot create Ping message: token is null or empty");
            return ZeppelinhubMessage.EMPTY.toJson();
        }
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("token", token);
        return ZeppelinhubMessage.newMessage((Object)ZeppelinHubOp.PING, data, new HashMap<String, String>()).toJson();
    }

    public static ZeppelinHubOp toZeppelinHubOp(String text) {
        ZeppelinHubOp hubOp = null;
        try {
            hubOp = ZeppelinHubOp.valueOf(text);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return hubOp;
    }

    public static boolean isZeppelinHubOp(String text) {
        return ZeppelinhubUtils.toZeppelinHubOp(text) != null;
    }

    public static Message.OP toZeppelinOp(String text) {
        Message.OP zeppelinOp = null;
        try {
            zeppelinOp = Message.OP.valueOf((String)text);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return zeppelinOp;
    }

    public static boolean isZeppelinOp(String text) {
        return ZeppelinhubUtils.toZeppelinOp(text) != null;
    }

    public static void userLoginRoutine(String username) {
        LOGGER.debug("Executing user login routine");
        String token = UserTokenContainer.getInstance().getUserToken(username);
        UserTokenContainer.getInstance().setUserToken(username, token);
        String msg = ZeppelinhubUtils.liveMessage(token);
        ZeppelinhubClient.getInstance().send(msg, token);
    }

    public static void userLogoutRoutine(String username) {
        LOGGER.debug("Executing user logout routine");
        String token = UserTokenContainer.getInstance().removeUserToken(username);
        String msg = ZeppelinhubUtils.deadMessage(token);
        ZeppelinhubClient.getInstance().send(msg, token);
        ZeppelinhubClient.getInstance().removeSession(token);
    }

    public static void userSwitchTokenRoutine(String username, String originToken, String targetToken) {
        String offMsg = ZeppelinhubUtils.deadMessage(originToken);
        ZeppelinhubClient.getInstance().send(offMsg, originToken);
        ZeppelinhubClient.getInstance().removeSession(originToken);
        String onMsg = ZeppelinhubUtils.liveMessage(targetToken);
        ZeppelinhubClient.getInstance().send(onMsg, targetToken);
    }
}

