/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.notebook.scheduler;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.notebook.Note;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CronJobListener
implements JobListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(CronJobListener.class);
    private Map<JobExecutionContext, Timer.Sample> cronJobTimerSamples = new HashMap<JobExecutionContext, Timer.Sample>();

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public void jobToBeExecuted(JobExecutionContext context) {
        JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
        Note note = (Note)jobDataMap.get((Object)"note");
        LOGGER.info("Start cron job of note: {}", (Object)note.getId());
        this.cronJobTimerSamples.put(context, Timer.start((MeterRegistry)Metrics.globalRegistry));
    }

    public void jobExecutionVetoed(JobExecutionContext context) {
        JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
        Note note = (Note)jobDataMap.get((Object)"note");
        LOGGER.info("vetoed cron job of note: {}", (Object)note.getId());
    }

    public void jobWasExecuted(JobExecutionContext context, JobExecutionException jobException) {
        JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
        Note note = (Note)jobDataMap.get((Object)"note");
        String result = StringUtils.defaultString((String)context.getResult().toString(), (String)"unknown");
        LOGGER.info("cron job of noteId {} executed with result {}", (Object)note.getId(), (Object)result);
        Timer.Sample sample = this.cronJobTimerSamples.remove(context);
        if (sample != null) {
            Tag noteId = Tag.of((String)"nodeid", (String)note.getId());
            Tag name = Tag.of((String)"name", (String)StringUtils.defaultString((String)note.getName(), (String)"unknown"));
            Tag statusTag = Tag.of((String)"result", (String)result);
            sample.stop(Metrics.timer((String)"cronjob", (Iterable)Tags.of((Tag[])new Tag[]{noteId, name, statusTag})));
        } else {
            LOGGER.warn("No Timer.Sample for NoteId {} found", (Object)note.getId());
        }
    }
}

