/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.notebook.scheduler;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.notebook.Note;
import org.apache.zeppelin.notebook.Notebook;
import org.apache.zeppelin.notebook.scheduler.CronJob;
import org.apache.zeppelin.notebook.scheduler.CronJobListener;
import org.apache.zeppelin.notebook.scheduler.SchedulerService;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.JobListener;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.matchers.GroupMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuartzSchedulerService
implements SchedulerService {
    private static final Logger LOGGER = LoggerFactory.getLogger(QuartzSchedulerService.class);
    private final ZeppelinConfiguration zeppelinConfiguration;
    private final Notebook notebook;
    private final Scheduler scheduler;
    private final Thread loadingNotesThread;

    @Inject
    public QuartzSchedulerService(ZeppelinConfiguration zeppelinConfiguration, Notebook notebook) throws SchedulerException {
        this.zeppelinConfiguration = zeppelinConfiguration;
        this.notebook = notebook;
        this.scheduler = this.getScheduler();
        this.scheduler.getListenerManager().addJobListener((JobListener)new CronJobListener());
        this.scheduler.start();
        this.loadingNotesThread = new Thread(() -> {
            LOGGER.info("Starting init cronjobs");
            notebook.getNotesInfo().stream().forEach(entry -> {
                try {
                    if (!this.refreshCron(entry.getId())) {
                        try {
                            LOGGER.debug("Unload note: {}", (Object)entry.getId());
                            notebook.getNote(entry.getId()).unLoad();
                        }
                        catch (Exception e) {
                            LOGGER.warn("Fail to unload note: {}", (Object)entry.getId(), (Object)e);
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Fail to refresh cron for note: {}", (Object)entry.getId());
                }
            });
            LOGGER.info("Complete init cronjobs");
        });
        this.loadingNotesThread.setName("Init CronJob Thread");
        this.loadingNotesThread.setDaemon(true);
        this.loadingNotesThread.start();
    }

    private Scheduler getScheduler() throws SchedulerException {
        return new StdSchedulerFactory().getScheduler();
    }

    @VisibleForTesting
    public void waitForFinishInit() {
        try {
            this.loadingNotesThread.join();
        }
        catch (InterruptedException e) {
            LOGGER.warn("Unexpected exception", (Throwable)e);
        }
    }

    @Override
    public boolean refreshCron(String noteId) {
        this.removeCron(noteId);
        Note note = null;
        try {
            note = this.notebook.getNote(noteId);
        }
        catch (IOException e) {
            LOGGER.warn("Skip refresh cron of note: {} because fail to get it", (Object)noteId, (Object)e);
            return false;
        }
        if (note == null) {
            LOGGER.warn("Skip refresh cron of note: {} because there's no such note", (Object)noteId);
            return false;
        }
        if (note.isTrash()) {
            LOGGER.warn("Skip refresh cron of note: {} because it is in trash", (Object)noteId);
            return false;
        }
        Map<String, Object> config = note.getConfig();
        if (config == null) {
            LOGGER.warn("Skip refresh cron of note: {} because its config is empty.", (Object)noteId);
            return false;
        }
        if (!note.isCronSupported(this.zeppelinConfiguration)) {
            LOGGER.warn("Skip refresh cron of note {} because its cron is not enabled.", (Object)noteId);
            return false;
        }
        String cronExpr = (String)note.getConfig().get("cron");
        if (cronExpr == null || cronExpr.trim().length() == 0) {
            LOGGER.warn("Skip refresh cron of note {} because its cron expression is empty.", (Object)noteId);
            return false;
        }
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put("note", (Object)note);
        JobDetail newJob = JobBuilder.newJob(CronJob.class).withIdentity(noteId, "note").setJobData(jobDataMap).build();
        Map<String, Object> info = note.getInfo();
        info.put("cron", null);
        CronTrigger trigger = null;
        try {
            trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity("trigger_" + noteId, "note").withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpr)).forJob(noteId, "note").build();
        }
        catch (Exception e) {
            LOGGER.error("Fail to create cron trigger for note: {}", (Object)note.getName(), (Object)e);
            info.put("cron", e.getMessage());
            return false;
        }
        try {
            LOGGER.info("Trigger cron for note: {}, with cron expression: {}", (Object)note.getName(), (Object)cronExpr);
            this.scheduler.scheduleJob(newJob, (Trigger)trigger);
            return true;
        }
        catch (SchedulerException e) {
            LOGGER.error("Fail to schedule cron job for note: {}", (Object)note.getName(), (Object)e);
            info.put("cron", "Scheduler Exception");
            return false;
        }
    }

    @Override
    public Set<?> getJobs() {
        try {
            return this.scheduler.getJobKeys(GroupMatcher.anyGroup());
        }
        catch (SchedulerException e) {
            LOGGER.error("Error while getting jobKeys", (Throwable)e);
            return Collections.emptySet();
        }
    }

    private void removeCron(String id) {
        try {
            this.scheduler.deleteJob(new JobKey(id, "note"));
        }
        catch (SchedulerException e) {
            LOGGER.error("Can't remove quertz {}", (Object)id, (Object)e);
        }
    }
}

