/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.ticket;

import com.google.common.collect.Sets;
import java.util.Calendar;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TicketContainer {
    private static final Logger LOGGER = LoggerFactory.getLogger(TicketContainer.class);
    public static final Entry ANONYMOUS_ENTRY = new Entry("anonymous", "anonymous", Sets.newHashSet());
    private Map<String, Entry> sessions = new ConcurrentHashMap<String, Entry>();
    public static final TicketContainer instance = new TicketContainer();

    public boolean isValid(String principal, String ticket) {
        if ("anonymous".equals(principal) && "anonymous".equals(ticket)) {
            return true;
        }
        Entry entry = this.sessions.get(principal);
        return entry != null && entry.ticket.equals(ticket);
    }

    public synchronized Entry getTicketEntry(String principal, Set<String> roles) {
        Entry entry = this.sessions.get(principal);
        if (entry == null) {
            String ticket = principal.equals("anonymous") ? "anonymous" : UUID.randomUUID().toString();
            entry = new Entry(ticket, principal, roles);
            this.sessions.put(principal, entry);
        }
        return entry;
    }

    public synchronized String getTicket(String principal, Set<String> roles) {
        Entry entry = this.sessions.get(principal);
        String ticket = entry == null ? (principal.equals("anonymous") ? "anonymous" : UUID.randomUUID().toString()) : entry.ticket;
        entry = new Entry(ticket, principal, roles);
        this.sessions.put(principal, entry);
        return ticket;
    }

    public Entry getTicketEntry(String ticket) {
        if ("anonymous".equals(ticket)) {
            return ANONYMOUS_ENTRY;
        }
        return this.sessions.get(ticket);
    }

    public synchronized void removeTicket(String principal) {
        try {
            if (this.sessions.get(principal) != null) {
                this.sessions.remove(principal);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error removing ticket", (Throwable)e);
        }
    }

    public static class Entry {
        private final String ticket;
        private final String principal;
        private final Set<String> roles;
        public final long lastAccessTime;

        Entry(String ticket, String principal, Set<String> roles) {
            this.ticket = ticket;
            this.principal = principal;
            this.roles = roles;
            this.lastAccessTime = Calendar.getInstance().getTimeInMillis();
        }

        public String getTicket() {
            return this.ticket;
        }

        public String getPrincipal() {
            return this.principal;
        }

        public Set<String> getRoles() {
            return this.roles;
        }
    }
}

