/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.conf;

import java.net.MalformedURLException;
import java.util.List;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class ZeppelinConfigurationTest {
    @BeforeAll
    public static void clearSystemVariables() {
        ZeppelinConfiguration.reset();
    }

    @AfterEach
    public void cleanup() {
        ZeppelinConfiguration.reset();
    }

    @Test
    public void getAllowedOrigins2Test() throws MalformedURLException {
        ZeppelinConfiguration conf = ZeppelinConfiguration.create((String)"test-zeppelin-site2.xml");
        List origins = conf.getAllowedOrigins();
        Assertions.assertEquals((int)2, (int)origins.size());
        Assertions.assertEquals((Object)"http://onehost:8080", origins.get(0));
        Assertions.assertEquals((Object)"http://otherhost.com", origins.get(1));
    }

    @Test
    public void getAllowedOrigins1Test() throws MalformedURLException {
        ZeppelinConfiguration conf = ZeppelinConfiguration.create((String)"test-zeppelin-site1.xml");
        List origins = conf.getAllowedOrigins();
        Assertions.assertEquals((int)1, (int)origins.size());
        Assertions.assertEquals((Object)"http://onehost:8080", origins.get(0));
    }

    @Test
    public void getAllowedOriginsNoneTest() throws MalformedURLException {
        ZeppelinConfiguration conf = ZeppelinConfiguration.create((String)"zeppelin-test-site.xml");
        List origins = conf.getAllowedOrigins();
        Assertions.assertEquals((int)1, (int)origins.size());
    }

    @Test
    public void isWindowsPathTestTrue() {
        ZeppelinConfiguration conf = ZeppelinConfiguration.create((String)"zeppelin-test-site.xml");
        Boolean isIt = conf.isWindowsPath("c:\\test\\file.txt");
        Assertions.assertTrue((boolean)isIt);
    }

    @Test
    public void isWindowsPathTestFalse() {
        ZeppelinConfiguration conf = ZeppelinConfiguration.create((String)"zeppelin-test-site.xml");
        Boolean isIt = conf.isWindowsPath("~/test/file.xml");
        Assertions.assertFalse((boolean)isIt);
    }

    @Test
    public void isPathWithSchemeTestTrue() {
        ZeppelinConfiguration conf = ZeppelinConfiguration.create((String)"zeppelin-test-site.xml");
        Boolean isIt = conf.isPathWithScheme("hdfs://hadoop.example.com/zeppelin/notebook");
        Assertions.assertTrue((boolean)isIt);
    }

    @Test
    public void isPathWithSchemeTestFalse() {
        ZeppelinConfiguration conf = ZeppelinConfiguration.create((String)"zeppelin-test-site.xml");
        Boolean isIt = conf.isPathWithScheme("~/test/file.xml");
        Assertions.assertFalse((boolean)isIt);
    }

    @Test
    public void isPathWithInvalidSchemeTest() {
        ZeppelinConfiguration conf = ZeppelinConfiguration.create((String)"zeppelin-test-site.xml");
        Boolean isIt = conf.isPathWithScheme("c:\\test\\file.txt");
        Assertions.assertFalse((boolean)isIt);
    }

    @Test
    public void getNotebookDirTest() {
        ZeppelinConfiguration conf = ZeppelinConfiguration.create((String)"zeppelin-test-site.xml");
        String notebookLocation = conf.getNotebookDir();
        Assertions.assertTrue((boolean)notebookLocation.endsWith("notebook"));
    }

    @Test
    public void isNotebookPublicTest() {
        ZeppelinConfiguration conf = ZeppelinConfiguration.create((String)"zeppelin-test-site.xml");
        boolean isIt = conf.isNotebookPublic();
        Assertions.assertTrue((boolean)isIt);
    }

    @Test
    public void getPathTest() {
        ZeppelinConfiguration conf = ZeppelinConfiguration.create((String)"zeppelin-test-site.xml");
        conf.setProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_HOME.getVarName(), "/usr/lib/zeppelin");
        Assertions.assertEquals((Object)"/usr/lib/zeppelin", (Object)conf.getZeppelinHome());
        Assertions.assertEquals((Object)"/usr/lib/zeppelin/conf", (Object)conf.getConfDir());
    }

    @Test
    public void getConfigFSPath() {
        ZeppelinConfiguration conf = ZeppelinConfiguration.create((String)"zeppelin-test-site.xml");
        conf.setProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_HOME.getVarName(), "/usr/lib/zeppelin");
        conf.setProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_CONFIG_FS_DIR.getVarName(), "conf");
        Assertions.assertEquals((Object)"/usr/lib/zeppelin/conf", (Object)conf.getConfigFSDir(true));
        conf.setProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_CONFIG_STORAGE_CLASS.getVarName(), "org.apache.zeppelin.storage.FileSystemConfigStorage");
        Assertions.assertEquals((Object)"conf", (Object)conf.getConfigFSDir(false));
    }

    @Test
    public void checkParseException() {
        ZeppelinConfiguration conf = ZeppelinConfiguration.create((String)"zeppelin-test-site.xml");
        conf.setProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_PORT.getVarName(), "luke skywalker");
        Assertions.assertEquals((int)8080, (int)conf.getServerPort());
        conf.setProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_PORT.getVarName(), "12345");
        Assertions.assertEquals((int)12345, (int)conf.getServerPort());
    }
}

