/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.helium;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.helium.ApplicationEventListener;
import org.apache.zeppelin.helium.ApplicationException;
import org.apache.zeppelin.helium.HeliumApplicationFactory;
import org.apache.zeppelin.helium.HeliumPackage;
import org.apache.zeppelin.helium.HeliumTestApplication;
import org.apache.zeppelin.helium.HeliumType;
import org.apache.zeppelin.interpreter.AbstractInterpreterTest;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterNotFoundException;
import org.apache.zeppelin.interpreter.InterpreterResultMessage;
import org.apache.zeppelin.interpreter.InterpreterSetting;
import org.apache.zeppelin.notebook.ApplicationState;
import org.apache.zeppelin.notebook.AuthorizationService;
import org.apache.zeppelin.notebook.Note;
import org.apache.zeppelin.notebook.NoteEventListener;
import org.apache.zeppelin.notebook.NoteManager;
import org.apache.zeppelin.notebook.Notebook;
import org.apache.zeppelin.notebook.Paragraph;
import org.apache.zeppelin.notebook.repo.NotebookRepo;
import org.apache.zeppelin.user.AuthenticationInfo;
import org.apache.zeppelin.user.Credentials;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class HeliumApplicationFactoryTest
extends AbstractInterpreterTest {
    private NotebookRepo notebookRepo;
    private Notebook notebook;
    private HeliumApplicationFactory heliumAppFactory;
    private AuthenticationInfo anonymous;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        for (InterpreterSetting interpreterSetting : this.interpreterSettingManager.get()) {
            interpreterSetting.setAppEventListener((ApplicationEventListener)this.heliumAppFactory);
        }
        AuthorizationService authorizationService = (AuthorizationService)Mockito.mock(AuthorizationService.class);
        this.notebookRepo = (NotebookRepo)Mockito.mock(NotebookRepo.class);
        this.notebook = new Notebook(this.conf, authorizationService, this.notebookRepo, new NoteManager(this.notebookRepo, ZeppelinConfiguration.create()), this.interpreterFactory, this.interpreterSettingManager, new Credentials());
        this.heliumAppFactory = new HeliumApplicationFactory(this.notebook, null);
        this.notebook.addNotebookEventListener((NoteEventListener)this.heliumAppFactory);
        this.anonymous = new AuthenticationInfo("anonymous");
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    @Disabled
    public void testLoadRunUnloadApplication() throws IOException, ApplicationException, InterruptedException {
        HeliumPackage pkg1 = new HeliumPackage(HeliumType.APPLICATION, "name1", "desc1", "", HeliumTestApplication.class.getName(), (String[][])new String[0][], "", "");
        String note1Id = this.notebook.createNote("note1", this.anonymous);
        Note note1 = (Note)this.notebook.processNote(note1Id, note1Tmp -> note1Tmp);
        Paragraph p1 = note1.addNewParagraph(AuthenticationInfo.ANONYMOUS);
        p1.setText("%mock1 job");
        p1.setAuthenticationInfo(this.anonymous);
        note1.run(p1.getId());
        while (!p1.isTerminated() || p1.getReturn() == null) {
            Thread.yield();
        }
        Assertions.assertEquals((Object)"repl1: job", (Object)((InterpreterResultMessage)p1.getReturn().message().get(0)).getData());
        Assertions.assertEquals((int)0, (int)p1.getAllApplicationStates().size());
        String appId = this.heliumAppFactory.loadAndRun(pkg1, p1);
        Assertions.assertEquals((int)1, (int)p1.getAllApplicationStates().size());
        ApplicationState app = p1.getApplicationState(appId);
        Thread.sleep(500L);
        Assertions.assertEquals((Object)"Hello world 1", (Object)app.getOutput());
        this.heliumAppFactory.run(p1, appId);
        Thread.sleep(500L);
        Assertions.assertEquals((Object)"Hello world 2", (Object)app.getOutput());
        this.heliumAppFactory.unload(p1, appId);
        this.notebook.removeNote(note1.getId(), this.anonymous);
    }

    @Test
    @Disabled
    public void testUnloadOnParagraphRemove() throws IOException {
        HeliumPackage pkg1 = new HeliumPackage(HeliumType.APPLICATION, "name1", "desc1", "", HeliumTestApplication.class.getName(), (String[][])new String[0][], "", "");
        String note1Id = this.notebook.createNote("note1", this.anonymous);
        Note note1 = (Note)this.notebook.processNote(note1Id, note1Tmp -> note1Tmp);
        Paragraph p1 = note1.addNewParagraph(AuthenticationInfo.ANONYMOUS);
        p1.setText("%mock1 job");
        p1.setAuthenticationInfo(this.anonymous);
        note1.run(p1.getId());
        while (!p1.isTerminated() || p1.getReturn() == null) {
            Thread.yield();
        }
        Assertions.assertEquals((int)0, (int)p1.getAllApplicationStates().size());
        String appId = this.heliumAppFactory.loadAndRun(pkg1, p1);
        ApplicationState app = p1.getApplicationState(appId);
        while (app.getStatus() != ApplicationState.Status.LOADED) {
            Thread.yield();
        }
        note1.removeParagraph("user", p1.getId());
        Assertions.assertEquals((Object)ApplicationState.Status.UNLOADED, (Object)app.getStatus());
        this.notebook.removeNote(note1.getId(), this.anonymous);
    }

    @Test
    @Disabled
    public void testUnloadOnInterpreterUnbind() throws IOException {
        HeliumPackage pkg1 = new HeliumPackage(HeliumType.APPLICATION, "name1", "desc1", "", HeliumTestApplication.class.getName(), (String[][])new String[0][], "", "");
        String note1Id = this.notebook.createNote("note1", this.anonymous);
        Note note1 = (Note)this.notebook.processNote(note1Id, note1Tmp -> note1Tmp);
        Paragraph p1 = note1.addNewParagraph(AuthenticationInfo.ANONYMOUS);
        p1.setText("%mock1 job");
        p1.setAuthenticationInfo(this.anonymous);
        note1.run(p1.getId());
        while (!p1.isTerminated() || p1.getReturn() == null) {
            Thread.yield();
        }
        Assertions.assertEquals((int)0, (int)p1.getAllApplicationStates().size());
        String appId = this.heliumAppFactory.loadAndRun(pkg1, p1);
        ApplicationState app = p1.getApplicationState(appId);
        while (app.getStatus() != ApplicationState.Status.LOADED) {
            Thread.yield();
        }
        Assertions.assertEquals((Object)ApplicationState.Status.UNLOADED, (Object)app.getStatus());
        this.notebook.removeNote(note1.getId(), this.anonymous);
    }

    @Test
    @Disabled
    public void testInterpreterUnbindOfNullReplParagraph() throws IOException {
        String note1Id = this.notebook.createNote("note1", this.anonymous);
        Note note1 = (Note)this.notebook.processNote(note1Id, note1Tmp -> note1Tmp);
        Paragraph p1 = note1.addNewParagraph(AuthenticationInfo.ANONYMOUS);
        p1.setText("%fake ");
        try {
            p1.getBindedInterpreter();
            Assertions.fail((String)"Should throw InterpreterNotFoundException");
        }
        catch (InterpreterNotFoundException interpreterNotFoundException) {
            // empty catch block
        }
        this.notebook.removeNote(note1.getId(), this.anonymous);
    }

    @Test
    @Disabled
    public void testUnloadOnInterpreterRestart() throws IOException, InterpreterException {
        HeliumPackage pkg1 = new HeliumPackage(HeliumType.APPLICATION, "name1", "desc1", "", HeliumTestApplication.class.getName(), (String[][])new String[0][], "", "");
        String note1Id = this.notebook.createNote("note1", this.anonymous);
        Note note1 = (Note)this.notebook.processNote(note1Id, note1Tmp -> note1Tmp);
        String mock1IntpSettingId = null;
        for (InterpreterSetting setting : note1.getBindedInterpreterSettings(new ArrayList())) {
            if (!setting.getName().equals("mock1")) continue;
            mock1IntpSettingId = setting.getId();
            break;
        }
        Paragraph p1 = note1.addNewParagraph(AuthenticationInfo.ANONYMOUS);
        p1.setText("%mock1 job");
        p1.setAuthenticationInfo(this.anonymous);
        note1.run(p1.getId());
        while (!p1.isTerminated() || p1.getReturn() == null) {
            Thread.yield();
        }
        Assertions.assertEquals((int)0, (int)p1.getAllApplicationStates().size());
        String appId = this.heliumAppFactory.loadAndRun(pkg1, p1);
        ApplicationState app = p1.getApplicationState(appId);
        while (app.getStatus() != ApplicationState.Status.LOADED) {
            Thread.yield();
        }
        while (!"Hello world 1".equals(app.getOutput())) {
            Thread.yield();
        }
        this.interpreterSettingManager.restart(mock1IntpSettingId);
        while (app.getStatus() == ApplicationState.Status.LOADED) {
            Thread.yield();
        }
        Assertions.assertEquals((Object)ApplicationState.Status.UNLOADED, (Object)app.getStatus());
        this.notebook.removeNote(note1.getId(), this.anonymous);
    }
}

