/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.helium;

import com.github.eirslett.maven.plugins.frontend.lib.InstallationException;
import com.github.eirslett.maven.plugins.frontend.lib.TaskRunnerException;
import com.google.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedList;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.helium.HeliumBundleFactory;
import org.apache.zeppelin.helium.HeliumPackage;
import org.apache.zeppelin.helium.HeliumType;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class HeliumBundleFactoryTest {
    private HeliumBundleFactory hbf;
    private File nodeInstallationDir;
    private String zeppelinHomePath;

    @BeforeEach
    public void setUp() throws InstallationException, TaskRunnerException, IOException {
        this.zeppelinHomePath = System.getProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_HOME.getVarName());
        System.setProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_HOME.getVarName(), "../");
        ZeppelinConfiguration conf = ZeppelinConfiguration.create();
        this.nodeInstallationDir = new File(conf.getAbsoluteDir(ZeppelinConfiguration.ConfVars.ZEPPELIN_DEP_LOCALREPO), "helium-bundle");
        this.hbf = new HeliumBundleFactory(conf);
        this.hbf.installNodeAndNpm();
        this.hbf.copyFrameworkModulesToInstallPath(true);
    }

    @AfterEach
    public void tearDown() throws IOException {
        if (null != this.zeppelinHomePath) {
            System.setProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_HOME.getVarName(), this.zeppelinHomePath);
        }
    }

    @Test
    public void testInstallNpm() throws InstallationException {
        Assertions.assertTrue((boolean)new File(this.nodeInstallationDir, "/node/npm").isFile());
        Assertions.assertTrue((boolean)new File(this.nodeInstallationDir, "/node/node").isFile());
        Assertions.assertTrue((boolean)new File(this.nodeInstallationDir, "/node/yarn/dist/bin/yarn").isFile());
    }

    @Test
    public void downloadPackage() throws TaskRunnerException {
        HeliumPackage pkg = new HeliumPackage(HeliumType.VISUALIZATION, "lodash", "lodash", "lodash@3.9.3", "", null, "license", "icon");
        this.hbf.install(pkg);
        System.out.println(new File(this.nodeInstallationDir, "/node_modules/lodash"));
        Assertions.assertTrue((boolean)new File(this.nodeInstallationDir, "/node_modules/lodash").isDirectory());
    }

    @Test
    public void bundlePackage() throws IOException, TaskRunnerException {
        HeliumPackage pkg = new HeliumPackage(HeliumType.VISUALIZATION, "zeppelin-bubblechart", "zeppelin-bubblechart", "zeppelin-bubblechart@0.0.3", "", null, "license", "icon");
        File bundle = this.hbf.buildPackage(pkg, true, true);
        Assertions.assertTrue((boolean)bundle.isFile());
        long lastModified = bundle.lastModified();
        bundle = this.hbf.buildPackage(pkg, false, true);
        Assertions.assertEquals((long)lastModified, (long)bundle.lastModified());
    }

    @Test
    public void bundleLocalPackage() throws IOException, TaskRunnerException {
        URL res = Resources.getResource((String)"helium/webpack.config.js");
        String resDir = new File(res.getFile()).getParent();
        String localPkg = resDir + "/../../../src/test/resources/helium/vis1";
        HeliumPackage pkg = new HeliumPackage(HeliumType.VISUALIZATION, "vis1", "vis1", localPkg, "", null, "license", "fa fa-coffee");
        File bundle = this.hbf.buildPackage(pkg, true, true);
        Assertions.assertTrue((boolean)bundle.isFile());
    }

    public void bundleErrorPropagation() throws IOException, TaskRunnerException {
        URL res = Resources.getResource((String)"helium/webpack.config.js");
        String resDir = new File(res.getFile()).getParent();
        String localPkg = resDir + "/../../../src/test/resources/helium/vis2";
        HeliumPackage pkg = new HeliumPackage(HeliumType.VISUALIZATION, "vis2", "vis2", localPkg, "", null, "license", "fa fa-coffee");
        File bundle = null;
        try {
            bundle = this.hbf.buildPackage(pkg, true, true);
            Assertions.assertTrue((boolean)false);
        }
        catch (IOException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("error in the package"));
        }
        Assertions.assertNull((Object)bundle);
    }

    @Test
    public void switchVersion() throws IOException, TaskRunnerException {
        URL res = Resources.getResource((String)"helium/webpack.config.js");
        String resDir = new File(res.getFile()).getParent();
        HeliumPackage pkgV1 = new HeliumPackage(HeliumType.VISUALIZATION, "zeppelin-bubblechart", "zeppelin-bubblechart", "zeppelin-bubblechart@0.0.3", "", null, "license", "icon");
        HeliumPackage pkgV2 = new HeliumPackage(HeliumType.VISUALIZATION, "zeppelin-bubblechart", "zeppelin-bubblechart", "zeppelin-bubblechart@0.0.1", "", null, "license", "icon");
        LinkedList<HeliumPackage> pkgsV1 = new LinkedList<HeliumPackage>();
        pkgsV1.add(pkgV1);
        LinkedList<HeliumPackage> pkgsV2 = new LinkedList<HeliumPackage>();
        pkgsV2.add(pkgV2);
        File bundle1 = this.hbf.buildPackage(pkgV1, true, true);
        File bundle2 = this.hbf.buildPackage(pkgV2, true, true);
        Assertions.assertNotSame((Object)bundle1.lastModified(), (Object)bundle2.lastModified());
    }
}

