/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.helium;

import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.zeppelin.helium.HeliumLocalRegistry;
import org.apache.zeppelin.helium.HeliumPackage;
import org.apache.zeppelin.helium.HeliumType;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class HeliumLocalRegistryTest {
    private File tmpDir;

    @BeforeEach
    public void setUp() throws Exception {
        this.tmpDir = new File(System.getProperty("java.io.tmpdir") + "/ZeppelinLTest_" + System.currentTimeMillis());
        this.tmpDir.mkdirs();
    }

    @AfterEach
    public void tearDown() throws IOException {
        FileUtils.deleteDirectory((File)this.tmpDir);
    }

    @Test
    public void testGetAllPackage() throws IOException {
        File r1Path = new File(this.tmpDir, "r1");
        HeliumLocalRegistry r1 = new HeliumLocalRegistry("r1", r1Path.getAbsolutePath());
        Assertions.assertEquals((int)0, (int)r1.getAll().size());
        Gson gson = new Gson();
        HeliumPackage pkg1 = new HeliumPackage(HeliumType.APPLICATION, "app1", "desc1", "artifact1", "classname1", (String[][])new String[0][], "license", "");
        FileUtils.writeStringToFile((File)new File(r1Path, "pkg1.json"), (String)gson.toJson((Object)pkg1));
        Assertions.assertEquals((int)1, (int)r1.getAll().size());
    }
}

