/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.helium;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.helium.HeliumOnlineRegistry;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class HeliumOnlineRegistryTest {
    private static final String IP = "192.168.65.17";
    private static final String TIMEOUT = "2000";
    private File tmpDir;

    @BeforeEach
    public void setUp() throws Exception {
        this.tmpDir = new File(System.getProperty("java.io.tmpdir") + "/ZeppelinLTest_" + System.currentTimeMillis());
    }

    @AfterEach
    public void tearDown() throws IOException {
        FileUtils.deleteDirectory((File)this.tmpDir);
    }

    @Test
    public void zeppelinNotebookS3TimeoutPropertyTest() throws IOException {
        System.setProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_NOTEBOOK_S3_TIMEOUT.getVarName(), TIMEOUT);
        System.setProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_NOTEBOOK_S3_ENDPOINT.getVarName(), IP);
        HeliumOnlineRegistry heliumOnlineRegistry = new HeliumOnlineRegistry("https://192.168.65.17", "https://192.168.65.17", this.tmpDir);
        long start = System.currentTimeMillis();
        heliumOnlineRegistry.getAll();
        long processTime = System.currentTimeMillis() - start;
        long basicTimeout = Long.valueOf(ZeppelinConfiguration.ConfVars.ZEPPELIN_NOTEBOOK_S3_TIMEOUT.getStringValue());
        Assertions.assertTrue((basicTimeout > processTime ? 1 : 0) != 0, (String)String.format("Wrong timeout during connection: expected %s, actual is about %d", TIMEOUT, processTime));
    }
}

