/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.helium;

import com.github.eirslett.maven.plugins.frontend.lib.TaskRunnerException;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import org.apache.commons.io.FileUtils;
import org.apache.zeppelin.helium.Helium;
import org.apache.zeppelin.helium.HeliumPackage;
import org.apache.zeppelin.helium.HeliumRegistry;
import org.apache.zeppelin.helium.HeliumTestRegistry;
import org.apache.zeppelin.helium.HeliumType;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class HeliumTest {
    private File tmpDir;
    private File localRegistryPath;

    @BeforeEach
    public void setUp() throws Exception {
        this.tmpDir = new File(System.getProperty("java.io.tmpdir") + "/ZeppelinLTest_" + System.currentTimeMillis());
        this.tmpDir.mkdirs();
        this.localRegistryPath = new File(this.tmpDir, "helium");
        this.localRegistryPath.mkdirs();
    }

    @AfterEach
    public void tearDown() throws IOException {
        FileUtils.deleteDirectory((File)this.tmpDir);
    }

    @Test
    public void testSaveLoadConf() throws IOException, URISyntaxException, TaskRunnerException {
        File heliumConf = new File(this.tmpDir, "helium.conf");
        Helium helium = new Helium(heliumConf.getAbsolutePath(), this.localRegistryPath.getAbsolutePath(), null, null, null, null);
        Assertions.assertFalse((boolean)heliumConf.exists());
        helium.saveConfig();
        Assertions.assertTrue((boolean)heliumConf.exists());
        Helium heliumRestored = new Helium(heliumConf.getAbsolutePath(), this.localRegistryPath.getAbsolutePath(), null, null, null, null);
    }

    @Test
    public void testRestoreRegistryInstances() throws IOException, URISyntaxException, TaskRunnerException {
        File heliumConf = new File(this.tmpDir, "helium.conf");
        Helium helium = new Helium(heliumConf.getAbsolutePath(), this.localRegistryPath.getAbsolutePath(), null, null, null, null);
        HeliumTestRegistry registry1 = new HeliumTestRegistry("r1", "r1");
        HeliumTestRegistry registry2 = new HeliumTestRegistry("r2", "r2");
        helium.addRegistry((HeliumRegistry)registry1);
        helium.addRegistry((HeliumRegistry)registry2);
        registry1.add(new HeliumPackage(HeliumType.APPLICATION, "name1", "desc1", "artifact1", "className1", (String[][])new String[0][], "", ""));
        registry2.add(new HeliumPackage(HeliumType.APPLICATION, "name2", "desc2", "artifact2", "className2", (String[][])new String[0][], "", ""));
        Assertions.assertEquals((int)2, (int)helium.getAllPackageInfo().size());
    }

    @Test
    public void testRefresh() throws IOException, URISyntaxException, TaskRunnerException {
        File heliumConf = new File(this.tmpDir, "helium.conf");
        Helium helium = new Helium(heliumConf.getAbsolutePath(), this.localRegistryPath.getAbsolutePath(), null, null, null, null);
        HeliumTestRegistry registry1 = new HeliumTestRegistry("r1", "r1");
        helium.addRegistry((HeliumRegistry)registry1);
        registry1.add(new HeliumPackage(HeliumType.APPLICATION, "name1", "desc1", "artifact1", "className1", (String[][])new String[0][], "", ""));
        Assertions.assertEquals((int)1, (int)helium.getAllPackageInfo().size());
        registry1.add(new HeliumPackage(HeliumType.APPLICATION, "name2", "desc2", "artifact2", "className2", (String[][])new String[0][], "", ""));
        Assertions.assertEquals((int)2, (int)helium.getAllPackageInfo(true, null).size());
    }
}

