/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.display.AngularObjectRegistryListener;
import org.apache.zeppelin.helium.ApplicationEventListener;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterFactory;
import org.apache.zeppelin.interpreter.InterpreterSettingManager;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterProcessListener;
import org.apache.zeppelin.notebook.AuthorizationService;
import org.apache.zeppelin.notebook.Note;
import org.apache.zeppelin.notebook.NoteManager;
import org.apache.zeppelin.notebook.Notebook;
import org.apache.zeppelin.notebook.repo.InMemoryNotebookRepo;
import org.apache.zeppelin.notebook.repo.NotebookRepo;
import org.apache.zeppelin.user.Credentials;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractInterpreterTest {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractInterpreterTest.class);
    protected InterpreterSettingManager interpreterSettingManager;
    protected InterpreterFactory interpreterFactory;
    protected Notebook notebook;
    protected File zeppelinHome;
    protected File interpreterDir;
    protected File confDir;
    protected File notebookDir;
    protected ZeppelinConfiguration conf;

    @BeforeEach
    public void setUp() throws Exception {
        this.zeppelinHome = new File("..");
        LOGGER.info("ZEPPELIN_HOME: " + this.zeppelinHome.getAbsolutePath());
        this.interpreterDir = new File(this.zeppelinHome, "interpreter_" + this.getClass().getSimpleName());
        this.confDir = new File(this.zeppelinHome, "conf_" + this.getClass().getSimpleName());
        this.notebookDir = new File(this.zeppelinHome, "notebook_" + this.getClass().getSimpleName());
        FileUtils.deleteDirectory((File)this.notebookDir);
        this.interpreterDir.mkdirs();
        this.confDir.mkdirs();
        this.notebookDir.mkdirs();
        FileUtils.copyDirectory((File)new File("src/test/resources/interpreter"), (File)this.interpreterDir);
        FileUtils.copyDirectory((File)new File("src/test/resources/conf"), (File)this.confDir);
        System.setProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_HOME.getVarName(), this.zeppelinHome.getAbsolutePath());
        System.setProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_CONF_DIR.getVarName(), this.confDir.getAbsolutePath());
        System.setProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_INTERPRETER_DIR.getVarName(), this.interpreterDir.getAbsolutePath());
        System.setProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_NOTEBOOK_DIR.getVarName(), this.notebookDir.getAbsolutePath());
        System.setProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_INTERPRETER_GROUP_DEFAULT.getVarName(), "test");
        this.conf = ZeppelinConfiguration.create();
        InMemoryNotebookRepo notebookRepo = new InMemoryNotebookRepo();
        NoteManager noteManager = new NoteManager((NotebookRepo)notebookRepo, this.conf);
        AuthorizationService authorizationService = new AuthorizationService(noteManager, this.conf);
        this.interpreterSettingManager = new InterpreterSettingManager(this.conf, (AngularObjectRegistryListener)Mockito.mock(AngularObjectRegistryListener.class), (RemoteInterpreterProcessListener)Mockito.mock(RemoteInterpreterProcessListener.class), (ApplicationEventListener)Mockito.mock(ApplicationEventListener.class));
        this.interpreterFactory = new InterpreterFactory(this.interpreterSettingManager);
        Credentials credentials = new Credentials(this.conf);
        this.notebook = new Notebook(this.conf, authorizationService, (NotebookRepo)notebookRepo, noteManager, this.interpreterFactory, this.interpreterSettingManager, credentials);
        this.interpreterSettingManager.setNotebook(this.notebook);
    }

    @AfterEach
    public void tearDown() throws Exception {
        if (this.interpreterSettingManager != null) {
            this.interpreterSettingManager.close();
        }
        if (this.interpreterDir != null) {
            LOGGER.info("Delete interpreterDir: {}", (Object)this.interpreterDir);
            FileUtils.deleteDirectory((File)this.interpreterDir);
        }
        if (this.confDir != null) {
            LOGGER.info("Delete confDir: {}", (Object)this.confDir);
            FileUtils.deleteDirectory((File)this.confDir);
        }
        if (this.notebookDir != null) {
            LOGGER.info("Delete notebookDir: {}", (Object)this.notebookDir);
            FileUtils.deleteDirectory((File)this.notebookDir);
        }
    }

    protected Note createNote() {
        return new Note("test", "test", this.interpreterFactory, this.interpreterSettingManager, null, null, null);
    }

    protected InterpreterContext createDummyInterpreterContext() {
        return InterpreterContext.builder().setNoteId("noteId").setParagraphId("paragraphId").build();
    }
}

