/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter;

import java.util.Properties;
import org.apache.zeppelin.interpreter.AbstractInterpreterTest;
import org.apache.zeppelin.interpreter.ConfInterpreter;
import org.apache.zeppelin.interpreter.ExecutionContext;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ConfInterpreterTest
extends AbstractInterpreterTest {
    private ExecutionContext executionContext = new ExecutionContext("user1", "note1", "test");

    @Test
    public void testCorrectConf() throws InterpreterException {
        Assertions.assertTrue((boolean)(this.interpreterFactory.getInterpreter("test.conf", this.executionContext) instanceof ConfInterpreter));
        ConfInterpreter confInterpreter = (ConfInterpreter)this.interpreterFactory.getInterpreter("test.conf", this.executionContext);
        InterpreterContext context = InterpreterContext.builder().setNoteId("noteId").setParagraphId("paragraphId").build();
        InterpreterResult result = confInterpreter.interpret("property_1\tnew_value\nnew_property\tdummy_value", context);
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code);
        Assertions.assertTrue((boolean)(this.interpreterFactory.getInterpreter("test", this.executionContext) instanceof RemoteInterpreter));
        RemoteInterpreter remoteInterpreter = (RemoteInterpreter)this.interpreterFactory.getInterpreter("test", this.executionContext);
        remoteInterpreter.interpret("hello world", context);
        Assertions.assertEquals((int)7, (int)remoteInterpreter.getProperties().size());
        Assertions.assertEquals((Object)"new_value", (Object)remoteInterpreter.getProperty("property_1"));
        Assertions.assertEquals((Object)"dummy_value", (Object)remoteInterpreter.getProperty("new_property"));
        Assertions.assertEquals((Object)"value_3", (Object)remoteInterpreter.getProperty("property_3"));
        result = confInterpreter.interpret("property_1\tnew_value\nnew_property\tdummy_value", context);
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code);
        result = confInterpreter.interpret("property_1\tnew_value_2\nnew_property\tdummy_value", context);
        Assertions.assertEquals((Object)InterpreterResult.Code.ERROR, (Object)result.code);
    }

    @Test
    public void testPropertyTrim() throws InterpreterException {
        Assertions.assertTrue((boolean)(this.interpreterFactory.getInterpreter("test.conf", this.executionContext) instanceof ConfInterpreter));
        ConfInterpreter confInterpreter = (ConfInterpreter)this.interpreterFactory.getInterpreter("test.conf", this.executionContext);
        InterpreterContext context = InterpreterContext.builder().setNoteId("noteId").setParagraphId("paragraphId").build();
        InterpreterResult result = confInterpreter.interpret(" property_1 \tnew_value \n new_property  \t dummy_value \n", context);
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code);
        Assertions.assertTrue((boolean)(this.interpreterFactory.getInterpreter("test", this.executionContext) instanceof RemoteInterpreter));
        RemoteInterpreter remoteInterpreter = (RemoteInterpreter)this.interpreterFactory.getInterpreter("test", this.executionContext);
        remoteInterpreter.interpret("hello world", context);
        Properties intpProperties = remoteInterpreter.getProperties();
        Assertions.assertEquals((int)7, (int)intpProperties.size());
        Assertions.assertNotNull((Object)intpProperties.getProperty("zeppelin.interpreter.output.limit"));
        Assertions.assertNotNull((Object)intpProperties.getProperty("zeppelin.interpreter.localRepo"));
        Assertions.assertNotNull((Object)intpProperties.getProperty("zeppelin.interpreter.connection.poolsize"));
        Assertions.assertEquals((Object)"new_value", (Object)intpProperties.getProperty("property_1"));
        Assertions.assertEquals((Object)"new_value_2", (Object)intpProperties.getProperty("property_2"));
        Assertions.assertEquals((Object)"value_3", (Object)intpProperties.getProperty("property_3"));
        Assertions.assertEquals((Object)"dummy_value", (Object)intpProperties.getProperty("new_property"));
    }

    @Test
    public void testEmptyValue() throws InterpreterException {
        ConfInterpreter confInterpreter = (ConfInterpreter)this.interpreterFactory.getInterpreter("test.conf", this.executionContext);
        InterpreterContext context = InterpreterContext.builder().setNoteId("noteId").setParagraphId("paragraphId").build();
        InterpreterResult result = confInterpreter.interpret(" property_1\t \n new_property\t  \n", context);
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code, (String)result.toString());
        Assertions.assertTrue((boolean)(this.interpreterFactory.getInterpreter("test", this.executionContext) instanceof RemoteInterpreter));
        RemoteInterpreter remoteInterpreter = (RemoteInterpreter)this.interpreterFactory.getInterpreter("test", this.executionContext);
        remoteInterpreter.interpret("hello world", context);
        Assertions.assertEquals((int)7, (int)remoteInterpreter.getProperties().size());
        Assertions.assertEquals((Object)"", (Object)remoteInterpreter.getProperty("property_1"));
        Assertions.assertEquals((Object)"", (Object)remoteInterpreter.getProperty("new_property"));
        Assertions.assertEquals((Object)"value_3", (Object)remoteInterpreter.getProperty("property_3"));
    }

    @Test
    public void testEmptyConf() throws InterpreterException {
        Assertions.assertTrue((boolean)(this.interpreterFactory.getInterpreter("test.conf", this.executionContext) instanceof ConfInterpreter));
        ConfInterpreter confInterpreter = (ConfInterpreter)this.interpreterFactory.getInterpreter("test.conf", this.executionContext);
        InterpreterContext context = InterpreterContext.builder().setNoteId("noteId").setParagraphId("paragraphId").build();
        InterpreterResult result = confInterpreter.interpret("", context);
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code);
        Assertions.assertTrue((boolean)(this.interpreterFactory.getInterpreter("test", this.executionContext) instanceof RemoteInterpreter));
        RemoteInterpreter remoteInterpreter = (RemoteInterpreter)this.interpreterFactory.getInterpreter("test", this.executionContext);
        Assertions.assertEquals((int)6, (int)remoteInterpreter.getProperties().size());
        Assertions.assertEquals((Object)"value_1", (Object)remoteInterpreter.getProperty("property_1"));
        Assertions.assertEquals((Object)"value_3", (Object)remoteInterpreter.getProperty("property_3"));
    }

    @Test
    public void testRunningAfterOtherInterpreter() throws InterpreterException {
        Assertions.assertTrue((boolean)(this.interpreterFactory.getInterpreter("test.conf", this.executionContext) instanceof ConfInterpreter));
        ConfInterpreter confInterpreter = (ConfInterpreter)this.interpreterFactory.getInterpreter("test.conf", this.executionContext);
        InterpreterContext context = InterpreterContext.builder().setNoteId("noteId").setParagraphId("paragraphId").build();
        RemoteInterpreter remoteInterpreter = (RemoteInterpreter)this.interpreterFactory.getInterpreter("test", this.executionContext);
        InterpreterResult result = remoteInterpreter.interpret("hello world", context);
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code);
        result = confInterpreter.interpret("property_1\tnew_value\nnew_property\tdummy_value", context);
        Assertions.assertEquals((Object)InterpreterResult.Code.ERROR, (Object)result.code);
    }
}

