/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter;

import org.apache.zeppelin.interpreter.AbstractInterpreterTest;
import org.apache.zeppelin.interpreter.DoubleEchoInterpreter;
import org.apache.zeppelin.interpreter.EchoInterpreter;
import org.apache.zeppelin.interpreter.ExecutionContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterNotFoundException;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class InterpreterFactoryTest
extends AbstractInterpreterTest {
    @Test
    public void testGetFactory() throws InterpreterException {
        Assertions.assertTrue((boolean)(this.interpreterFactory.getInterpreter("", new ExecutionContext("user1", "note1", "test")) instanceof RemoteInterpreter));
        RemoteInterpreter remoteInterpreter = (RemoteInterpreter)this.interpreterFactory.getInterpreter("", new ExecutionContext("user1", "note1", "test"));
        Assertions.assertEquals((Object)EchoInterpreter.class.getName(), (Object)remoteInterpreter.getClassName());
        Assertions.assertTrue((boolean)(this.interpreterFactory.getInterpreter("double_echo", new ExecutionContext("user1", "note1", "test")) instanceof RemoteInterpreter));
        remoteInterpreter = (RemoteInterpreter)this.interpreterFactory.getInterpreter("double_echo", new ExecutionContext("user1", "note1", "test"));
        Assertions.assertEquals((Object)DoubleEchoInterpreter.class.getName(), (Object)remoteInterpreter.getClassName());
        Assertions.assertTrue((boolean)(this.interpreterFactory.getInterpreter("test", new ExecutionContext("user1", "note1", "test")) instanceof RemoteInterpreter));
        remoteInterpreter = (RemoteInterpreter)this.interpreterFactory.getInterpreter("test", new ExecutionContext("user1", "note1", "test"));
        Assertions.assertEquals((Object)EchoInterpreter.class.getName(), (Object)remoteInterpreter.getClassName());
        Assertions.assertTrue((boolean)(this.interpreterFactory.getInterpreter("test2", new ExecutionContext("user1", "note1", "test")) instanceof RemoteInterpreter));
        remoteInterpreter = (RemoteInterpreter)this.interpreterFactory.getInterpreter("test2", new ExecutionContext("user1", "note1", "test"));
        Assertions.assertEquals((Object)EchoInterpreter.class.getName(), (Object)remoteInterpreter.getClassName());
        Assertions.assertTrue((boolean)(this.interpreterFactory.getInterpreter("test2.double_echo", new ExecutionContext("user1", "note1", "test")) instanceof RemoteInterpreter));
        remoteInterpreter = (RemoteInterpreter)this.interpreterFactory.getInterpreter("test2.double_echo", new ExecutionContext("user1", "note1", "test"));
        Assertions.assertEquals((Object)DoubleEchoInterpreter.class.getName(), (Object)remoteInterpreter.getClassName());
    }

    @Test
    public void testUnknownRepl1() {
        try {
            this.interpreterFactory.getInterpreter("test.unknown_repl", new ExecutionContext("user1", "note1", "test"));
            Assertions.fail((String)"should fail due to no such interpreter");
        }
        catch (InterpreterNotFoundException e) {
            Assertions.assertEquals((Object)"No such interpreter: test.unknown_repl", (Object)e.getMessage());
        }
    }

    @Test
    public void testUnknownRepl2() {
        try {
            this.interpreterFactory.getInterpreter("unknown_repl", new ExecutionContext("user1", "note1", "test"));
            Assertions.fail((String)"should fail due to no such interpreter");
        }
        catch (InterpreterNotFoundException e) {
            Assertions.assertEquals((Object)"No such interpreter: unknown_repl", (Object)e.getMessage());
        }
    }
}

