/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.dep.Dependency;
import org.apache.zeppelin.display.AngularObjectRegistryListener;
import org.apache.zeppelin.helium.ApplicationEventListener;
import org.apache.zeppelin.interpreter.AbstractInterpreterTest;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterOption;
import org.apache.zeppelin.interpreter.InterpreterProperty;
import org.apache.zeppelin.interpreter.InterpreterSetting;
import org.apache.zeppelin.interpreter.InterpreterSettingManager;
import org.apache.zeppelin.interpreter.ManagedInterpreterGroup;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterProcessListener;
import org.apache.zeppelin.user.AuthenticationInfo;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.repository.RemoteRepository;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class InterpreterSettingManagerTest
extends AbstractInterpreterTest {
    private String note1Id;
    private String note2Id;
    private String note3Id;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.note1Id = this.notebook.createNote("/note_1", AuthenticationInfo.ANONYMOUS);
        this.note2Id = this.notebook.createNote("/note_2", AuthenticationInfo.ANONYMOUS);
        this.note3Id = this.notebook.createNote("/note_3", AuthenticationInfo.ANONYMOUS);
    }

    @Test
    public void testInitInterpreterSettingManager() throws IOException, RepositoryException {
        Assertions.assertEquals((int)6, (int)this.interpreterSettingManager.get().size());
        InterpreterSetting interpreterSetting = this.interpreterSettingManager.getByName("test");
        Assertions.assertEquals((Object)"test", (Object)interpreterSetting.getName());
        Assertions.assertEquals((Object)"test", (Object)interpreterSetting.getGroup());
        Assertions.assertEquals((int)8, (int)interpreterSetting.getInterpreterInfos().size());
        Assertions.assertEquals((int)6, (int)interpreterSetting.getJavaProperties().size());
        Assertions.assertEquals((Object)"value_1", (Object)interpreterSetting.getJavaProperties().getProperty("property_1"));
        Assertions.assertEquals((Object)"new_value_2", (Object)interpreterSetting.getJavaProperties().getProperty("property_2"));
        Assertions.assertEquals((Object)"value_3", (Object)interpreterSetting.getJavaProperties().getProperty("property_3"));
        Assertions.assertEquals((Object)"shared", (Object)interpreterSetting.getOption().perNote);
        Assertions.assertEquals((Object)"shared", (Object)interpreterSetting.getOption().perUser);
        Assertions.assertEquals((int)0, (int)interpreterSetting.getDependencies().size());
        Assertions.assertNotNull((Object)interpreterSetting.getAngularObjectRegistryListener());
        Assertions.assertNotNull((Object)interpreterSetting.getRemoteInterpreterProcessListener());
        Assertions.assertNotNull((Object)interpreterSetting.getAppEventListener());
        Assertions.assertNotNull((Object)interpreterSetting.getDependencyResolver());
        Assertions.assertNotNull((Object)interpreterSetting.getInterpreterSettingManager());
        List repositories = this.interpreterSettingManager.getRepositories();
        Assertions.assertEquals((int)2, (int)repositories.size());
        Assertions.assertEquals((Object)"central", (Object)((RemoteRepository)repositories.get(0)).getId());
        InterpreterSettingManager interpreterSettingManager2 = new InterpreterSettingManager(this.conf, (AngularObjectRegistryListener)Mockito.mock(AngularObjectRegistryListener.class), (RemoteInterpreterProcessListener)Mockito.mock(RemoteInterpreterProcessListener.class), (ApplicationEventListener)Mockito.mock(ApplicationEventListener.class));
        Assertions.assertEquals((int)6, (int)interpreterSettingManager2.get().size());
        interpreterSetting = interpreterSettingManager2.getByName("test");
        Assertions.assertEquals((Object)"test", (Object)interpreterSetting.getName());
        Assertions.assertEquals((Object)"test", (Object)interpreterSetting.getGroup());
        Assertions.assertEquals((int)8, (int)interpreterSetting.getInterpreterInfos().size());
        Assertions.assertEquals((int)6, (int)interpreterSetting.getJavaProperties().size());
        Assertions.assertEquals((Object)"value_1", (Object)interpreterSetting.getJavaProperties().getProperty("property_1"));
        Assertions.assertEquals((Object)"new_value_2", (Object)interpreterSetting.getJavaProperties().getProperty("property_2"));
        Assertions.assertEquals((Object)"value_3", (Object)interpreterSetting.getJavaProperties().getProperty("property_3"));
        Assertions.assertEquals((Object)"shared", (Object)interpreterSetting.getOption().perNote);
        Assertions.assertEquals((Object)"shared", (Object)interpreterSetting.getOption().perUser);
        Assertions.assertEquals((int)0, (int)interpreterSetting.getDependencies().size());
        repositories = interpreterSettingManager2.getRepositories();
        Assertions.assertEquals((int)2, (int)repositories.size());
        Assertions.assertEquals((Object)"central", (Object)((RemoteRepository)repositories.get(0)).getId());
    }

    @Test
    public void testCreateUpdateRemoveSetting() throws IOException, InterpreterException {
        InterpreterOption option = new InterpreterOption();
        option.setPerNote("scoped");
        option.setPerUser("scoped");
        HashMap<String, InterpreterProperty> properties = new HashMap<String, InterpreterProperty>();
        properties.put("property_4", new InterpreterProperty("property_4", (Object)"value_4"));
        try {
            this.interpreterSettingManager.createNewSetting("test2", "test", new ArrayList(), option, properties);
            Assertions.fail((String)"Should fail due to interpreter already existed");
        }
        catch (IOException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("already existed"));
        }
        this.interpreterSettingManager.createNewSetting("test3", "test", new ArrayList(), option, properties);
        Assertions.assertEquals((int)7, (int)this.interpreterSettingManager.get().size());
        InterpreterSetting interpreterSetting = this.interpreterSettingManager.getByName("test3");
        Assertions.assertEquals((Object)"test3", (Object)interpreterSetting.getName());
        Assertions.assertEquals((Object)"test", (Object)interpreterSetting.getGroup());
        Assertions.assertEquals((int)4, (int)interpreterSetting.getJavaProperties().size());
        Assertions.assertEquals((Object)"value_4", (Object)interpreterSetting.getJavaProperties().getProperty("property_4"));
        Assertions.assertEquals((Object)"scoped", (Object)interpreterSetting.getOption().perNote);
        Assertions.assertEquals((Object)"scoped", (Object)interpreterSetting.getOption().perUser);
        Assertions.assertEquals((int)0, (int)interpreterSetting.getDependencies().size());
        Assertions.assertNotNull((Object)interpreterSetting.getAngularObjectRegistryListener());
        Assertions.assertNotNull((Object)interpreterSetting.getRemoteInterpreterProcessListener());
        Assertions.assertNotNull((Object)interpreterSetting.getAppEventListener());
        Assertions.assertNotNull((Object)interpreterSetting.getDependencyResolver());
        Assertions.assertNotNull((Object)interpreterSetting.getInterpreterSettingManager());
        InterpreterSettingManager interpreterSettingManager2 = new InterpreterSettingManager(this.conf, (AngularObjectRegistryListener)Mockito.mock(AngularObjectRegistryListener.class), (RemoteInterpreterProcessListener)Mockito.mock(RemoteInterpreterProcessListener.class), (ApplicationEventListener)Mockito.mock(ApplicationEventListener.class));
        Assertions.assertEquals((int)7, (int)interpreterSettingManager2.get().size());
        interpreterSetting = interpreterSettingManager2.getByName("test3");
        Assertions.assertEquals((Object)"test3", (Object)interpreterSetting.getName());
        Assertions.assertEquals((Object)"test", (Object)interpreterSetting.getGroup());
        Assertions.assertEquals((int)4, (int)interpreterSetting.getJavaProperties().size());
        Assertions.assertEquals((Object)"value_4", (Object)interpreterSetting.getJavaProperties().getProperty("property_4"));
        Assertions.assertEquals((Object)"scoped", (Object)interpreterSetting.getOption().perNote);
        Assertions.assertEquals((Object)"scoped", (Object)interpreterSetting.getOption().perUser);
        Assertions.assertEquals((int)0, (int)interpreterSetting.getDependencies().size());
        InterpreterOption newOption = new InterpreterOption();
        newOption.setPerNote("scoped");
        newOption.setPerUser("isolated");
        HashMap<String, InterpreterProperty> newProperties = new HashMap<String, InterpreterProperty>(properties);
        newProperties.put("property_4", new InterpreterProperty("property_4", (Object)"new_value_4"));
        ArrayList<Dependency> newDependencies = new ArrayList<Dependency>();
        newDependencies.add(new Dependency("com.databricks:spark-avro_2.11:3.1.0"));
        this.interpreterSettingManager.setPropertyAndRestart(interpreterSetting.getId(), newOption, newProperties, newDependencies);
        interpreterSetting = this.interpreterSettingManager.get(interpreterSetting.getId());
        Assertions.assertEquals((Object)"test3", (Object)interpreterSetting.getName());
        Assertions.assertEquals((Object)"test", (Object)interpreterSetting.getGroup());
        Assertions.assertEquals((int)4, (int)interpreterSetting.getJavaProperties().size());
        Assertions.assertEquals((Object)"new_value_4", (Object)interpreterSetting.getJavaProperties().getProperty("property_4"));
        Assertions.assertEquals((Object)"scoped", (Object)interpreterSetting.getOption().perNote);
        Assertions.assertEquals((Object)"isolated", (Object)interpreterSetting.getOption().perUser);
        Assertions.assertEquals((int)1, (int)interpreterSetting.getDependencies().size());
        Assertions.assertNotNull((Object)interpreterSetting.getAngularObjectRegistryListener());
        Assertions.assertNotNull((Object)interpreterSetting.getRemoteInterpreterProcessListener());
        Assertions.assertNotNull((Object)interpreterSetting.getAppEventListener());
        Assertions.assertNotNull((Object)interpreterSetting.getDependencyResolver());
        Assertions.assertNotNull((Object)interpreterSetting.getInterpreterSettingManager());
        interpreterSetting.getOption().setPerUser("scoped");
        interpreterSetting.getDefaultInterpreter("user1", this.note1Id);
        interpreterSetting.getDefaultInterpreter("user2", this.note2Id);
        interpreterSetting.getDefaultInterpreter("user3", this.note3Id);
        ManagedInterpreterGroup interpreterGroup = interpreterSetting.getInterpreterGroup("user1", this.note1Id);
        Assertions.assertEquals((int)3, (int)interpreterGroup.getSessionNum());
        this.interpreterSettingManager.restart(interpreterSetting.getId(), "user1", this.note1Id);
        Assertions.assertEquals((int)2, (int)interpreterGroup.getSessionNum());
        this.interpreterSettingManager.remove(interpreterSetting.getId());
        Assertions.assertEquals((int)6, (int)this.interpreterSettingManager.get().size());
        InterpreterSettingManager interpreterSettingManager3 = new InterpreterSettingManager(ZeppelinConfiguration.create(), (AngularObjectRegistryListener)Mockito.mock(AngularObjectRegistryListener.class), (RemoteInterpreterProcessListener)Mockito.mock(RemoteInterpreterProcessListener.class), (ApplicationEventListener)Mockito.mock(ApplicationEventListener.class));
        Assertions.assertEquals((int)6, (int)interpreterSettingManager3.get().size());
    }

    @Test
    public void testGetEditor() {
        Map editor = this.interpreterSettingManager.getEditorSetting("%test.echo", this.note1Id);
        Assertions.assertEquals((Object)"java", editor.get("language"));
        editor = this.interpreterSettingManager.getEditorSetting("%mock1", this.note1Id);
        Assertions.assertEquals((Object)"python", editor.get("language"));
    }

    @Test
    public void testRestartShared() throws InterpreterException {
        InterpreterSetting interpreterSetting = this.interpreterSettingManager.getByName("test");
        interpreterSetting.getOption().setPerUser("shared");
        interpreterSetting.getOption().setPerNote("shared");
        interpreterSetting.getOrCreateSession("user1", this.note1Id);
        interpreterSetting.getOrCreateInterpreterGroup("user2", this.note2Id);
        Assertions.assertEquals((int)1, (int)interpreterSetting.getAllInterpreterGroups().size());
        this.interpreterSettingManager.restart(interpreterSetting.getId(), "user1", this.note1Id);
        Assertions.assertEquals((int)0, (int)interpreterSetting.getAllInterpreterGroups().size());
    }

    @Test
    public void testRestartPerUserIsolated() throws InterpreterException {
        InterpreterSetting interpreterSetting = this.interpreterSettingManager.getByName("test");
        interpreterSetting.getOption().setPerUser("isolated");
        interpreterSetting.getOption().setPerNote("shared");
        interpreterSetting.getOrCreateSession("user1", this.note1Id);
        interpreterSetting.getOrCreateSession("user2", this.note2Id);
        Assertions.assertEquals((int)2, (int)interpreterSetting.getAllInterpreterGroups().size());
        this.interpreterSettingManager.restart(interpreterSetting.getId(), "user1", this.note1Id);
        Assertions.assertEquals((int)1, (int)interpreterSetting.getAllInterpreterGroups().size());
    }

    @Test
    public void testRestartPerNoteIsolated() throws InterpreterException {
        InterpreterSetting interpreterSetting = this.interpreterSettingManager.getByName("test");
        interpreterSetting.getOption().setPerUser("shared");
        interpreterSetting.getOption().setPerNote("isolated");
        interpreterSetting.getOrCreateSession("user1", this.note1Id);
        interpreterSetting.getOrCreateSession("user2", this.note2Id);
        Assertions.assertEquals((int)2, (int)interpreterSetting.getAllInterpreterGroups().size());
        this.interpreterSettingManager.restart(interpreterSetting.getId(), "user1", this.note1Id);
        Assertions.assertEquals((int)1, (int)interpreterSetting.getAllInterpreterGroups().size());
    }

    @Test
    public void testRestartPerUserScoped() throws InterpreterException {
        InterpreterSetting interpreterSetting = this.interpreterSettingManager.getByName("test");
        interpreterSetting.getOption().setPerUser("scoped");
        interpreterSetting.getOption().setPerNote("shared");
        interpreterSetting.getOrCreateSession("user1", this.note1Id);
        interpreterSetting.getOrCreateSession("user2", this.note2Id);
        Assertions.assertEquals((int)1, (int)interpreterSetting.getAllInterpreterGroups().size());
        Assertions.assertEquals((int)2, (int)((ManagedInterpreterGroup)interpreterSetting.getAllInterpreterGroups().get(0)).getSessionNum());
        this.interpreterSettingManager.restart(interpreterSetting.getId(), "user1", this.note1Id);
        Assertions.assertEquals((int)1, (int)interpreterSetting.getAllInterpreterGroups().size());
        Assertions.assertEquals((int)1, (int)((ManagedInterpreterGroup)interpreterSetting.getAllInterpreterGroups().get(0)).getSessionNum());
    }

    @Test
    public void testRestartPerNoteScoped() throws InterpreterException {
        InterpreterSetting interpreterSetting = this.interpreterSettingManager.getByName("test");
        interpreterSetting.getOption().setPerUser("shared");
        interpreterSetting.getOption().setPerNote("scoped");
        interpreterSetting.getOrCreateSession("user1", this.note1Id);
        interpreterSetting.getOrCreateSession("user2", this.note2Id);
        Assertions.assertEquals((int)1, (int)interpreterSetting.getAllInterpreterGroups().size());
        Assertions.assertEquals((int)2, (int)((ManagedInterpreterGroup)interpreterSetting.getAllInterpreterGroups().get(0)).getSessionNum());
        this.interpreterSettingManager.restart(interpreterSetting.getId(), "user1", this.note1Id);
        Assertions.assertEquals((int)1, (int)interpreterSetting.getAllInterpreterGroups().size());
        Assertions.assertEquals((int)1, (int)((ManagedInterpreterGroup)interpreterSetting.getAllInterpreterGroups().get(0)).getSessionNum());
    }

    @Test
    public void testInterpreterInclude() throws Exception {
        try {
            System.setProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_INTERPRETER_INCLUDES.getVarName(), "mock1");
            this.setUp();
            Assertions.assertEquals((int)1, (int)this.interpreterSettingManager.get().size());
            Assertions.assertEquals((Object)"mock1", (Object)((InterpreterSetting)this.interpreterSettingManager.get().get(0)).getGroup());
        }
        finally {
            System.clearProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_INTERPRETER_INCLUDES.getVarName());
        }
    }

    @Test
    public void testInterpreterExclude() throws Exception {
        try {
            System.setProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_INTERPRETER_EXCLUDES.getVarName(), "test,config_test,mock_resource_pool");
            this.setUp();
            Assertions.assertEquals((int)2, (int)this.interpreterSettingManager.get().size());
            Assertions.assertNotNull((Object)this.interpreterSettingManager.getByName("mock1"));
            Assertions.assertNotNull((Object)this.interpreterSettingManager.getByName("mock2"));
        }
        finally {
            System.clearProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_INTERPRETER_EXCLUDES.getVarName());
        }
    }

    @Test
    public void testInterpreterIncludeExcludeTogether() throws Exception {
        try {
            System.setProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_INTERPRETER_INCLUDES.getVarName(), "test,");
            System.setProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_INTERPRETER_EXCLUDES.getVarName(), "config_test,mock_resource_pool");
            try {
                this.setUp();
                Assertions.fail((String)"Should not able to create InterpreterSettingManager");
            }
            catch (Exception e) {
                e.printStackTrace();
                Assertions.assertEquals((Object)"zeppelin.interpreter.include and zeppelin.interpreter.exclude can not be specified together, only one can be set.", (Object)e.getMessage());
            }
        }
        finally {
            System.clearProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_INTERPRETER_INCLUDES.getVarName());
            System.clearProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_INTERPRETER_EXCLUDES.getVarName());
        }
    }
}

