/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.zeppelin.dep.Dependency;
import org.apache.zeppelin.dep.DependencyResolver;
import org.apache.zeppelin.interpreter.AbstractInterpreterTest;
import org.apache.zeppelin.interpreter.DoubleEchoInterpreter;
import org.apache.zeppelin.interpreter.EchoInterpreter;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterGroup;
import org.apache.zeppelin.interpreter.InterpreterInfo;
import org.apache.zeppelin.interpreter.InterpreterOption;
import org.apache.zeppelin.interpreter.InterpreterSetting;
import org.apache.zeppelin.interpreter.InterpreterSettingManager;
import org.apache.zeppelin.interpreter.ManagedInterpreterGroup;
import org.apache.zeppelin.user.AuthenticationInfo;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterpreterSettingTest
extends AbstractInterpreterTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(InterpreterSettingTest.class);
    private InterpreterSettingManager interpreterSettingManager;
    private String note1Id;
    private String note2Id;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.interpreterSettingManager = (InterpreterSettingManager)Mockito.mock(InterpreterSettingManager.class);
        Mockito.when((Object)this.interpreterSettingManager.getNotebook()).thenReturn((Object)this.notebook);
        this.note1Id = this.notebook.createNote("/note_1", AuthenticationInfo.ANONYMOUS);
        this.note2Id = this.notebook.createNote("/note_2", AuthenticationInfo.ANONYMOUS);
    }

    @Test
    public void testCreateInterpreters() {
        InterpreterOption interpreterOption = new InterpreterOption();
        interpreterOption.setPerUser("shared");
        InterpreterInfo interpreterInfo1 = new InterpreterInfo(EchoInterpreter.class.getName(), "echo", true, new HashMap(), new HashMap());
        InterpreterInfo interpreterInfo2 = new InterpreterInfo(DoubleEchoInterpreter.class.getName(), "double_echo", false, new HashMap(), new HashMap());
        ArrayList<InterpreterInfo> interpreterInfos = new ArrayList<InterpreterInfo>();
        interpreterInfos.add(interpreterInfo1);
        interpreterInfos.add(interpreterInfo2);
        InterpreterSetting interpreterSetting = new InterpreterSetting.Builder().setId("id").setName("test").setGroup("test").setInterpreterInfos(interpreterInfos).setOption(interpreterOption).setIntepreterSettingManager(this.interpreterSettingManager).create();
        Assertions.assertEquals((Object)EchoInterpreter.class.getName(), (Object)interpreterSetting.getDefaultInterpreter("user1", this.note1Id).getClassName());
        Assertions.assertEquals((Object)EchoInterpreter.class.getName(), (Object)interpreterSetting.getInterpreter("user1", this.note1Id, "echo").getClassName());
        Assertions.assertEquals((Object)interpreterSetting.getDefaultInterpreter("user1", this.note1Id), (Object)interpreterSetting.getInterpreter("user1", this.note1Id, "echo"));
        Assertions.assertEquals((Object)DoubleEchoInterpreter.class.getName(), (Object)interpreterSetting.getInterpreter("user1", this.note1Id, "double_echo").getClassName());
        Assertions.assertNull((Object)interpreterSetting.getInterpreter("user1", this.note1Id, "invalid_echo"));
    }

    @Test
    public void testSharedMode() {
        InterpreterOption interpreterOption = new InterpreterOption();
        interpreterOption.setPerUser("shared");
        InterpreterInfo interpreterInfo1 = new InterpreterInfo(EchoInterpreter.class.getName(), "echo", true, new HashMap(), new HashMap());
        InterpreterInfo interpreterInfo2 = new InterpreterInfo(DoubleEchoInterpreter.class.getName(), "double_echo", false, new HashMap(), new HashMap());
        ArrayList<InterpreterInfo> interpreterInfos = new ArrayList<InterpreterInfo>();
        interpreterInfos.add(interpreterInfo1);
        interpreterInfos.add(interpreterInfo2);
        InterpreterSetting interpreterSetting = new InterpreterSetting.Builder().setId("id").setName("test").setGroup("test").setInterpreterInfos(interpreterInfos).setOption(interpreterOption).setIntepreterSettingManager(this.interpreterSettingManager).create();
        Interpreter interpreter = interpreterSetting.getDefaultInterpreter("user1", this.note1Id);
        Assertions.assertEquals((int)1, (int)interpreterSetting.getAllInterpreterGroups().size());
        Assertions.assertEquals((Object)"test-shared_process", (Object)interpreter.getInterpreterGroup().getId());
        interpreterSetting.getDefaultInterpreter("user2", this.note1Id);
        Assertions.assertEquals((int)1, (int)interpreterSetting.getAllInterpreterGroups().size());
        interpreterSetting.getDefaultInterpreter("user1", this.note2Id);
        Assertions.assertEquals((int)1, (int)interpreterSetting.getAllInterpreterGroups().size());
        Assertions.assertEquals((int)1, (int)((ManagedInterpreterGroup)interpreterSetting.getAllInterpreterGroups().get(0)).getSessionNum());
        interpreterSetting.closeInterpreters("user1", this.note1Id);
        Assertions.assertEquals((int)0, (int)interpreterSetting.getAllInterpreterGroups().size());
    }

    @Test
    public void testPerUserScopedMode() {
        InterpreterOption interpreterOption = new InterpreterOption();
        interpreterOption.setPerUser("scoped");
        InterpreterInfo interpreterInfo1 = new InterpreterInfo(EchoInterpreter.class.getName(), "echo", true, new HashMap(), new HashMap());
        InterpreterInfo interpreterInfo2 = new InterpreterInfo(DoubleEchoInterpreter.class.getName(), "double_echo", false, new HashMap(), new HashMap());
        ArrayList<InterpreterInfo> interpreterInfos = new ArrayList<InterpreterInfo>();
        interpreterInfos.add(interpreterInfo1);
        interpreterInfos.add(interpreterInfo2);
        InterpreterSetting interpreterSetting = new InterpreterSetting.Builder().setId("id").setName("test").setGroup("test").setInterpreterInfos(interpreterInfos).setOption(interpreterOption).setIntepreterSettingManager(this.interpreterSettingManager).create();
        Interpreter interpreter = interpreterSetting.getDefaultInterpreter("user1", this.note1Id);
        Assertions.assertEquals((int)1, (int)interpreterSetting.getAllInterpreterGroups().size());
        Assertions.assertEquals((int)1, (int)((ManagedInterpreterGroup)interpreterSetting.getAllInterpreterGroups().get(0)).getSessionNum());
        Assertions.assertEquals((Object)"test-shared_process", (Object)interpreter.getInterpreterGroup().getId());
        interpreterSetting.getDefaultInterpreter("user2", this.note1Id);
        Assertions.assertEquals((int)1, (int)interpreterSetting.getAllInterpreterGroups().size());
        Assertions.assertEquals((int)2, (int)((ManagedInterpreterGroup)interpreterSetting.getAllInterpreterGroups().get(0)).getSessionNum());
        interpreterSetting.closeInterpreters("user1", this.note1Id);
        Assertions.assertEquals((int)1, (int)interpreterSetting.getAllInterpreterGroups().size());
        Assertions.assertEquals((int)1, (int)((ManagedInterpreterGroup)interpreterSetting.getAllInterpreterGroups().get(0)).getSessionNum());
        interpreterSetting.closeInterpreters("user2", this.note1Id);
        Assertions.assertEquals((int)0, (int)interpreterSetting.getAllInterpreterGroups().size());
    }

    @Test
    public void testPerNoteScopedMode() {
        InterpreterOption interpreterOption = new InterpreterOption();
        interpreterOption.setPerNote("scoped");
        InterpreterInfo interpreterInfo1 = new InterpreterInfo(EchoInterpreter.class.getName(), "echo", true, new HashMap(), new HashMap());
        InterpreterInfo interpreterInfo2 = new InterpreterInfo(DoubleEchoInterpreter.class.getName(), "double_echo", false, new HashMap(), new HashMap());
        ArrayList<InterpreterInfo> interpreterInfos = new ArrayList<InterpreterInfo>();
        interpreterInfos.add(interpreterInfo1);
        interpreterInfos.add(interpreterInfo2);
        InterpreterSetting interpreterSetting = new InterpreterSetting.Builder().setId("id").setName("test").setGroup("test").setInterpreterInfos(interpreterInfos).setOption(interpreterOption).setIntepreterSettingManager(this.interpreterSettingManager).create();
        Interpreter interpreter = interpreterSetting.getDefaultInterpreter("user1", this.note1Id);
        Assertions.assertEquals((int)1, (int)interpreterSetting.getAllInterpreterGroups().size());
        Assertions.assertEquals((int)1, (int)((ManagedInterpreterGroup)interpreterSetting.getAllInterpreterGroups().get(0)).getSessionNum());
        Assertions.assertEquals((Object)"test-shared_process", (Object)interpreter.getInterpreterGroup().getId());
        interpreterSetting.getDefaultInterpreter("user1", this.note2Id);
        Assertions.assertEquals((int)1, (int)interpreterSetting.getAllInterpreterGroups().size());
        Assertions.assertEquals((int)2, (int)((ManagedInterpreterGroup)interpreterSetting.getAllInterpreterGroups().get(0)).getSessionNum());
        interpreterSetting.closeInterpreters("user1", this.note1Id);
        Assertions.assertEquals((int)1, (int)interpreterSetting.getAllInterpreterGroups().size());
        Assertions.assertEquals((int)1, (int)((ManagedInterpreterGroup)interpreterSetting.getAllInterpreterGroups().get(0)).getSessionNum());
        interpreterSetting.closeInterpreters("user1", this.note2Id);
        Assertions.assertEquals((int)0, (int)interpreterSetting.getAllInterpreterGroups().size());
    }

    @Test
    public void testPerUserIsolatedMode() {
        InterpreterOption interpreterOption = new InterpreterOption();
        interpreterOption.setPerUser("isolated");
        InterpreterInfo interpreterInfo1 = new InterpreterInfo(EchoInterpreter.class.getName(), "echo", true, new HashMap(), new HashMap());
        InterpreterInfo interpreterInfo2 = new InterpreterInfo(DoubleEchoInterpreter.class.getName(), "double_echo", false, new HashMap(), new HashMap());
        ArrayList<InterpreterInfo> interpreterInfos = new ArrayList<InterpreterInfo>();
        interpreterInfos.add(interpreterInfo1);
        interpreterInfos.add(interpreterInfo2);
        InterpreterSetting interpreterSetting = new InterpreterSetting.Builder().setId("id").setName("test").setGroup("test").setInterpreterInfos(interpreterInfos).setOption(interpreterOption).setIntepreterSettingManager(this.interpreterSettingManager).create();
        Interpreter interpreter1 = interpreterSetting.getDefaultInterpreter("user1", this.note1Id);
        Assertions.assertEquals((int)1, (int)interpreterSetting.getAllInterpreterGroups().size());
        Assertions.assertEquals((int)1, (int)((ManagedInterpreterGroup)interpreterSetting.getAllInterpreterGroups().get(0)).getSessionNum());
        Assertions.assertEquals((Object)"test-user1", (Object)interpreter1.getInterpreterGroup().getId());
        Interpreter interpreter2 = interpreterSetting.getDefaultInterpreter("user2", this.note1Id);
        Assertions.assertEquals((int)2, (int)interpreterSetting.getAllInterpreterGroups().size());
        Assertions.assertEquals((Object)"test-user2", (Object)interpreter2.getInterpreterGroup().getId());
        Assertions.assertEquals((int)1, (int)((ManagedInterpreterGroup)interpreterSetting.getAllInterpreterGroups().get(0)).getSessionNum());
        Assertions.assertEquals((int)1, (int)((ManagedInterpreterGroup)interpreterSetting.getAllInterpreterGroups().get(1)).getSessionNum());
        interpreterSetting.closeInterpreters("user1", this.note1Id);
        Assertions.assertEquals((int)1, (int)interpreterSetting.getAllInterpreterGroups().size());
        interpreterSetting.closeInterpreters("user2", this.note1Id);
        Assertions.assertEquals((int)0, (int)interpreterSetting.getAllInterpreterGroups().size());
    }

    @Test
    public void testPerNoteIsolatedMode() {
        InterpreterOption interpreterOption = new InterpreterOption();
        interpreterOption.setPerNote("isolated");
        InterpreterInfo interpreterInfo1 = new InterpreterInfo(EchoInterpreter.class.getName(), "echo", true, new HashMap(), new HashMap());
        InterpreterInfo interpreterInfo2 = new InterpreterInfo(DoubleEchoInterpreter.class.getName(), "double_echo", false, new HashMap(), new HashMap());
        ArrayList<InterpreterInfo> interpreterInfos = new ArrayList<InterpreterInfo>();
        interpreterInfos.add(interpreterInfo1);
        interpreterInfos.add(interpreterInfo2);
        InterpreterSetting interpreterSetting = new InterpreterSetting.Builder().setId("id").setName("test").setGroup("test").setInterpreterInfos(interpreterInfos).setOption(interpreterOption).setIntepreterSettingManager(this.interpreterSettingManager).create();
        Interpreter interpreter1 = interpreterSetting.getDefaultInterpreter("user1", this.note1Id);
        Assertions.assertEquals((int)1, (int)interpreterSetting.getAllInterpreterGroups().size());
        Assertions.assertEquals((int)1, (int)((ManagedInterpreterGroup)interpreterSetting.getAllInterpreterGroups().get(0)).getSessionNum());
        Assertions.assertEquals((Object)("test-" + this.note1Id), (Object)interpreter1.getInterpreterGroup().getId());
        Interpreter interpreter2 = interpreterSetting.getDefaultInterpreter("user1", this.note2Id);
        Assertions.assertEquals((int)2, (int)interpreterSetting.getAllInterpreterGroups().size());
        Assertions.assertEquals((Object)("test-" + this.note2Id), (Object)interpreter2.getInterpreterGroup().getId());
        Assertions.assertEquals((int)1, (int)((ManagedInterpreterGroup)interpreterSetting.getAllInterpreterGroups().get(0)).getSessionNum());
        Assertions.assertEquals((int)1, (int)((ManagedInterpreterGroup)interpreterSetting.getAllInterpreterGroups().get(1)).getSessionNum());
        interpreterSetting.closeInterpreters("user1", this.note1Id);
        Assertions.assertEquals((int)1, (int)interpreterSetting.getAllInterpreterGroups().size());
        interpreterSetting.closeInterpreters("user1", this.note2Id);
        Assertions.assertEquals((int)0, (int)interpreterSetting.getAllInterpreterGroups().size());
    }

    @Test
    public void testPerUserIsolatedPerNoteScopedMode() {
        InterpreterOption interpreterOption = new InterpreterOption();
        interpreterOption.setPerUser("isolated");
        interpreterOption.setPerNote("scoped");
        InterpreterInfo interpreterInfo1 = new InterpreterInfo(EchoInterpreter.class.getName(), "echo", true, new HashMap(), new HashMap());
        InterpreterInfo interpreterInfo2 = new InterpreterInfo(DoubleEchoInterpreter.class.getName(), "double_echo", false, new HashMap(), new HashMap());
        ArrayList<InterpreterInfo> interpreterInfos = new ArrayList<InterpreterInfo>();
        interpreterInfos.add(interpreterInfo1);
        interpreterInfos.add(interpreterInfo2);
        InterpreterSetting interpreterSetting = new InterpreterSetting.Builder().setId("id").setName("test").setGroup("test").setInterpreterInfos(interpreterInfos).setOption(interpreterOption).setIntepreterSettingManager(this.interpreterSettingManager).create();
        Interpreter interpreter1 = interpreterSetting.getDefaultInterpreter("user1", this.note1Id);
        Assertions.assertEquals((int)1, (int)interpreterSetting.getAllInterpreterGroups().size());
        Assertions.assertEquals((int)1, (int)((ManagedInterpreterGroup)interpreterSetting.getAllInterpreterGroups().get(0)).getSessionNum());
        Assertions.assertEquals((Object)"test-user1", (Object)interpreter1.getInterpreterGroup().getId());
        interpreterSetting.getDefaultInterpreter("user1", this.note2Id);
        Assertions.assertEquals((int)1, (int)interpreterSetting.getAllInterpreterGroups().size());
        Assertions.assertEquals((int)2, (int)((ManagedInterpreterGroup)interpreterSetting.getAllInterpreterGroups().get(0)).getSessionNum());
        Interpreter interpreter2 = interpreterSetting.getDefaultInterpreter("user2", this.note1Id);
        Assertions.assertEquals((int)2, (int)interpreterSetting.getAllInterpreterGroups().size());
        Assertions.assertEquals((Object)"test-user2", (Object)interpreter2.getInterpreterGroup().getId());
        Assertions.assertEquals((Object)interpreterSetting.getInterpreterGroup("user1", this.note1Id), (Object)interpreterSetting.getInterpreterGroup("user1", this.note2Id));
        Assertions.assertEquals((int)2, (int)interpreterSetting.getInterpreterGroup("user1", this.note1Id).getSessionNum());
        Assertions.assertEquals((int)2, (int)interpreterSetting.getInterpreterGroup("user1", this.note2Id).getSessionNum());
        Assertions.assertEquals((int)1, (int)interpreterSetting.getInterpreterGroup("user2", this.note1Id).getSessionNum());
        interpreterSetting.closeInterpreters("user1", this.note1Id);
        Assertions.assertEquals((int)2, (int)interpreterSetting.getAllInterpreterGroups().size());
        Assertions.assertEquals((int)1, (int)interpreterSetting.getInterpreterGroup("user1", this.note1Id).getSessionNum());
        interpreterSetting.closeInterpreters("user1", this.note2Id);
        Assertions.assertEquals((int)1, (int)interpreterSetting.getAllInterpreterGroups().size());
        interpreterSetting.closeInterpreters("user2", this.note1Id);
        Assertions.assertEquals((int)0, (int)interpreterSetting.getAllInterpreterGroups().size());
    }

    @Test
    public void testPerUserIsolatedPerNoteIsolatedMode() {
        InterpreterOption interpreterOption = new InterpreterOption();
        interpreterOption.setPerUser("isolated");
        interpreterOption.setPerNote("isolated");
        InterpreterInfo interpreterInfo1 = new InterpreterInfo(EchoInterpreter.class.getName(), "echo", true, new HashMap(), new HashMap());
        InterpreterInfo interpreterInfo2 = new InterpreterInfo(DoubleEchoInterpreter.class.getName(), "double_echo", false, new HashMap(), new HashMap());
        ArrayList<InterpreterInfo> interpreterInfos = new ArrayList<InterpreterInfo>();
        interpreterInfos.add(interpreterInfo1);
        interpreterInfos.add(interpreterInfo2);
        InterpreterSetting interpreterSetting = new InterpreterSetting.Builder().setId("id").setName("test").setGroup("test").setInterpreterInfos(interpreterInfos).setOption(interpreterOption).setIntepreterSettingManager(this.interpreterSettingManager).create();
        Interpreter interpreter1 = interpreterSetting.getDefaultInterpreter("user1", this.note1Id);
        Assertions.assertEquals((int)1, (int)interpreterSetting.getAllInterpreterGroups().size());
        Assertions.assertEquals((Object)("test-user1-" + this.note1Id), (Object)interpreter1.getInterpreterGroup().getId());
        Interpreter interpreter2 = interpreterSetting.getDefaultInterpreter("user1", this.note2Id);
        Assertions.assertEquals((int)2, (int)interpreterSetting.getAllInterpreterGroups().size());
        Assertions.assertEquals((Object)("test-user1-" + this.note2Id), (Object)interpreter2.getInterpreterGroup().getId());
        Interpreter interpreter3 = interpreterSetting.getDefaultInterpreter("user2", this.note1Id);
        Assertions.assertEquals((Object)("test-user2-" + this.note1Id), (Object)interpreter3.getInterpreterGroup().getId());
        Interpreter interpreter4 = interpreterSetting.getDefaultInterpreter("user2", this.note2Id);
        Assertions.assertEquals((int)4, (int)interpreterSetting.getAllInterpreterGroups().size());
        Assertions.assertEquals((Object)("test-user2-" + this.note2Id), (Object)interpreter4.getInterpreterGroup().getId());
        for (InterpreterGroup interpreterGroup : interpreterSetting.getAllInterpreterGroups()) {
            Assertions.assertEquals((int)1, (int)interpreterGroup.getSessionNum());
        }
        interpreterSetting.closeInterpreters("user1", this.note1Id);
        Assertions.assertEquals((int)3, (int)interpreterSetting.getAllInterpreterGroups().size());
        interpreterSetting.closeInterpreters("user1", this.note2Id);
        Assertions.assertEquals((int)2, (int)interpreterSetting.getAllInterpreterGroups().size());
        interpreterSetting.closeInterpreters("user2", this.note1Id);
        Assertions.assertEquals((int)1, (int)interpreterSetting.getAllInterpreterGroups().size());
        interpreterSetting.closeInterpreters("user2", this.note2Id);
        Assertions.assertEquals((int)0, (int)interpreterSetting.getAllInterpreterGroups().size());
    }

    @Test
    public void testPerUserScopedPerNoteScopedMode() {
        InterpreterOption interpreterOption = new InterpreterOption();
        interpreterOption.setPerUser("scoped");
        interpreterOption.setPerNote("scoped");
        InterpreterInfo interpreterInfo1 = new InterpreterInfo(EchoInterpreter.class.getName(), "echo", true, new HashMap(), new HashMap());
        InterpreterInfo interpreterInfo2 = new InterpreterInfo(DoubleEchoInterpreter.class.getName(), "double_echo", false, new HashMap(), new HashMap());
        ArrayList<InterpreterInfo> interpreterInfos = new ArrayList<InterpreterInfo>();
        interpreterInfos.add(interpreterInfo1);
        interpreterInfos.add(interpreterInfo2);
        InterpreterSetting interpreterSetting = new InterpreterSetting.Builder().setId("id").setName("test").setGroup("test").setInterpreterInfos(interpreterInfos).setOption(interpreterOption).setIntepreterSettingManager(this.interpreterSettingManager).create();
        Interpreter interpreter1 = interpreterSetting.getDefaultInterpreter("user1", this.note1Id);
        Assertions.assertEquals((int)1, (int)interpreterSetting.getAllInterpreterGroups().size());
        Assertions.assertEquals((int)1, (int)((ManagedInterpreterGroup)interpreterSetting.getAllInterpreterGroups().get(0)).getSessionNum());
        Assertions.assertEquals((Object)"test-shared_process", (Object)interpreter1.getInterpreterGroup().getId());
        interpreterSetting.getDefaultInterpreter("user1", this.note2Id);
        Assertions.assertEquals((int)1, (int)interpreterSetting.getAllInterpreterGroups().size());
        Assertions.assertEquals((int)2, (int)((ManagedInterpreterGroup)interpreterSetting.getAllInterpreterGroups().get(0)).getSessionNum());
        interpreterSetting.getDefaultInterpreter("user2", this.note1Id);
        Assertions.assertEquals((int)1, (int)interpreterSetting.getAllInterpreterGroups().size());
        Assertions.assertEquals((int)3, (int)((ManagedInterpreterGroup)interpreterSetting.getAllInterpreterGroups().get(0)).getSessionNum());
        interpreterSetting.getDefaultInterpreter("user2", this.note2Id);
        Assertions.assertEquals((int)1, (int)interpreterSetting.getAllInterpreterGroups().size());
        Assertions.assertEquals((int)4, (int)((ManagedInterpreterGroup)interpreterSetting.getAllInterpreterGroups().get(0)).getSessionNum());
        interpreterSetting.closeInterpreters("user1", this.note1Id);
        Assertions.assertEquals((int)3, (int)((ManagedInterpreterGroup)interpreterSetting.getAllInterpreterGroups().get(0)).getSessionNum());
        interpreterSetting.closeInterpreters("user1", this.note2Id);
        Assertions.assertEquals((int)2, (int)((ManagedInterpreterGroup)interpreterSetting.getAllInterpreterGroups().get(0)).getSessionNum());
        interpreterSetting.closeInterpreters("user2", this.note1Id);
        Assertions.assertEquals((int)1, (int)((ManagedInterpreterGroup)interpreterSetting.getAllInterpreterGroups().get(0)).getSessionNum());
        interpreterSetting.closeInterpreters("user2", this.note2Id);
        Assertions.assertEquals((int)0, (int)interpreterSetting.getAllInterpreterGroups().size());
    }

    @Test
    public void testInterpreterJsonSerializable() {
        InterpreterOption interpreterOption = new InterpreterOption();
        interpreterOption.setPerUser("shared");
        InterpreterInfo interpreterInfo1 = new InterpreterInfo(EchoInterpreter.class.getName(), "echo", true, new HashMap(), new HashMap());
        InterpreterInfo interpreterInfo2 = new InterpreterInfo(DoubleEchoInterpreter.class.getName(), "double_echo", false, new HashMap(), new HashMap());
        ArrayList<InterpreterInfo> interpreterInfos = new ArrayList<InterpreterInfo>();
        interpreterInfos.add(interpreterInfo1);
        interpreterInfos.add(interpreterInfo2);
        InterpreterSetting interpreterSetting = new InterpreterSetting.Builder().setId("id").setName("id").setGroup("group").setInterpreterInfos(interpreterInfos).setOption(interpreterOption).create();
        String json = InterpreterSetting.toJson((InterpreterSetting)interpreterSetting);
        InterpreterSetting checkIntpSetting = InterpreterSetting.fromJson((String)json);
        Assertions.assertEquals((Object)checkIntpSetting.getId(), (Object)"id");
        Assertions.assertEquals((Object)checkIntpSetting.getName(), (Object)"id");
        Assertions.assertEquals((Object)checkIntpSetting.getGroup(), (Object)"group");
        Assertions.assertTrue((boolean)checkIntpSetting.getOption().perUserShared());
        Assertions.assertNotNull((Object)checkIntpSetting.getInterpreterInfo("echo"));
        Assertions.assertNotNull((Object)checkIntpSetting.getInterpreterInfo("double_echo"));
    }

    @Test
    public void testIsUserAuthorized() {
        ArrayList<String> userAndRoles = new ArrayList<String>();
        userAndRoles.add("User1");
        userAndRoles.add("Role1");
        userAndRoles.add("Role2");
        ArrayList<String> owners = new ArrayList<String>();
        owners.add("Role1");
        InterpreterOption interpreterOption = new InterpreterOption();
        interpreterOption.setUserPermission(true);
        interpreterOption.owners = owners;
        InterpreterSetting interpreterSetting = new InterpreterSetting.Builder().setId("id").setName("id").setGroup("group").setOption(interpreterOption).create();
        Assertions.assertTrue((boolean)interpreterSetting.isUserAuthorized(userAndRoles));
        owners = new ArrayList();
        owners.add("Role88");
        interpreterOption = new InterpreterOption();
        interpreterOption.setUserPermission(true);
        interpreterOption.owners = owners;
        interpreterSetting = new InterpreterSetting.Builder().setId("id").setName("id").setGroup("group").setOption(interpreterOption).create();
        Assertions.assertFalse((boolean)interpreterSetting.isUserAuthorized(userAndRoles));
        owners = new ArrayList();
        interpreterOption = new InterpreterOption();
        interpreterOption.setUserPermission(false);
        interpreterOption.owners = owners;
        interpreterSetting = new InterpreterSetting.Builder().setId("id").setName("id").setGroup("group").setOption(interpreterOption).create();
        Assertions.assertTrue((boolean)interpreterSetting.isUserAuthorized(userAndRoles));
    }

    @Test
    public void testLoadDependency() throws InterruptedException {
        InterpreterOption interpreterOption = new InterpreterOption();
        interpreterOption.setUserPermission(true);
        InterpreterSetting interpreterSetting = new InterpreterSetting.Builder().setId("id").setName("id").setGroup("group").setOption(interpreterOption).setIntepreterSettingManager(this.interpreterSettingManager).setDependencyResolver(new DependencyResolver("/tmp")).create();
        interpreterSetting.setDependencies((List)Lists.newArrayList((Object[])new Dependency[]{new Dependency("a:b:0.1")}));
        long start = System.currentTimeMillis();
        long threshold = 60000L;
        while (interpreterSetting.getStatus() != InterpreterSetting.Status.ERROR && System.currentTimeMillis() - start < threshold) {
            Thread.sleep(1000L);
            LOGGER.warn("Downloading dependency");
        }
        Assertions.assertTrue((boolean)interpreterSetting.getErrorReason().contains("Cannot fetch dependencies"), (String)interpreterSetting.getErrorReason());
        interpreterSetting.setDependencies(new ArrayList());
        Assertions.assertEquals((Object)InterpreterSetting.Status.READY, (Object)interpreterSetting.getStatus());
        Assertions.assertNull((Object)interpreterSetting.getErrorReason());
    }
}

