/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.zeppelin.interpreter.DoubleEchoInterpreter;
import org.apache.zeppelin.interpreter.EchoInterpreter;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterInfo;
import org.apache.zeppelin.interpreter.InterpreterOption;
import org.apache.zeppelin.interpreter.InterpreterSetting;
import org.apache.zeppelin.interpreter.ManagedInterpreterGroup;
import org.eclipse.aether.RepositoryException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ManagedInterpreterGroupTest {
    private InterpreterSetting interpreterSetting;

    @BeforeEach
    public void setUp() throws IOException, RepositoryException {
        InterpreterOption interpreterOption = new InterpreterOption();
        interpreterOption.setPerUser("scoped");
        InterpreterInfo interpreterInfo1 = new InterpreterInfo(EchoInterpreter.class.getName(), "echo", true, new HashMap(), new HashMap());
        InterpreterInfo interpreterInfo2 = new InterpreterInfo(DoubleEchoInterpreter.class.getName(), "double_echo", false, new HashMap(), new HashMap());
        ArrayList<InterpreterInfo> interpreterInfos = new ArrayList<InterpreterInfo>();
        interpreterInfos.add(interpreterInfo1);
        interpreterInfos.add(interpreterInfo2);
        this.interpreterSetting = new InterpreterSetting.Builder().setId("id").setName("test").setGroup("test").setInterpreterInfos(interpreterInfos).setOption(interpreterOption).create();
    }

    @Test
    public void testInterpreterGroup() {
        ManagedInterpreterGroup interpreterGroup = new ManagedInterpreterGroup("group_1", this.interpreterSetting);
        Assertions.assertEquals((int)0, (int)interpreterGroup.getSessionNum());
        List interpreters = interpreterGroup.getOrCreateSession("user1", "session_1");
        Assertions.assertEquals((int)3, (int)interpreters.size());
        Assertions.assertEquals((Object)EchoInterpreter.class.getName(), (Object)((Interpreter)interpreters.get(0)).getClassName());
        Assertions.assertEquals((Object)DoubleEchoInterpreter.class.getName(), (Object)((Interpreter)interpreters.get(1)).getClassName());
        Assertions.assertEquals((int)1, (int)interpreterGroup.getSessionNum());
        Assertions.assertEquals((Object)interpreters, (Object)interpreterGroup.getOrCreateSession("user1", "session_1"));
        Assertions.assertEquals((int)1, (int)interpreterGroup.getSessionNum());
        List interpreters2 = interpreterGroup.getOrCreateSession("user1", "session_2");
        Assertions.assertEquals((int)3, (int)interpreters2.size());
        Assertions.assertEquals((Object)EchoInterpreter.class.getName(), (Object)((Interpreter)interpreters2.get(0)).getClassName());
        Assertions.assertEquals((Object)DoubleEchoInterpreter.class.getName(), (Object)((Interpreter)interpreters2.get(1)).getClassName());
        Assertions.assertEquals((int)2, (int)interpreterGroup.getSessionNum());
        interpreterGroup.close("session_1");
        Assertions.assertEquals((int)1, (int)interpreterGroup.getSessionNum());
        interpreterGroup.close();
        Assertions.assertEquals((int)0, (int)interpreterGroup.getSessionNum());
    }
}

