/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter;

import java.util.ArrayList;
import java.util.Properties;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.InterpreterSetting;
import org.apache.zeppelin.interpreter.ManagedInterpreterGroup;
import org.apache.zeppelin.interpreter.SessionConfInterpreter;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class SessionConfInterpreterTest {
    @Test
    public void testUserSessionConfInterpreter() throws InterpreterException {
        InterpreterSetting mockInterpreterSetting = (InterpreterSetting)Mockito.mock(InterpreterSetting.class);
        ManagedInterpreterGroup mockInterpreterGroup = (ManagedInterpreterGroup)Mockito.mock(ManagedInterpreterGroup.class);
        Mockito.when((Object)mockInterpreterSetting.getInterpreterGroup("group_1")).thenReturn((Object)mockInterpreterGroup);
        Properties properties = new Properties();
        properties.setProperty("property_1", "value_1");
        properties.setProperty("property_2", "value_2");
        SessionConfInterpreter confInterpreter = new SessionConfInterpreter(properties, "session_1", "group_1", mockInterpreterSetting);
        RemoteInterpreter remoteInterpreter = new RemoteInterpreter(properties, "session_1", "clasName", "user1");
        ArrayList<Object> interpreters = new ArrayList<Object>();
        interpreters.add(confInterpreter);
        interpreters.add(remoteInterpreter);
        Mockito.when((Object)mockInterpreterGroup.get("session_1")).thenReturn(interpreters);
        InterpreterResult result = confInterpreter.interpret("property_1\tupdated_value_1\nproperty_3\tvalue_3", (InterpreterContext)Mockito.mock(InterpreterContext.class));
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code);
        Assertions.assertEquals((int)3, (int)remoteInterpreter.getProperties().size());
        Assertions.assertEquals((Object)"updated_value_1", (Object)remoteInterpreter.getProperty("property_1"));
        Assertions.assertEquals((Object)"value_2", (Object)remoteInterpreter.getProperty("property_2"));
        Assertions.assertEquals((Object)"value_3", (Object)remoteInterpreter.getProperty("property_3"));
        remoteInterpreter.setOpened(true);
        result = confInterpreter.interpret("property_1\tupdated_value_1\nproperty_3\tvalue_3", (InterpreterContext)Mockito.mock(InterpreterContext.class));
        Assertions.assertEquals((Object)InterpreterResult.Code.ERROR, (Object)result.code);
    }
}

