/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter;

import java.util.Properties;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.scheduler.Scheduler;
import org.apache.zeppelin.scheduler.SchedulerFactory;

public class SleepInterpreter
extends Interpreter {
    public SleepInterpreter(Properties property) {
        super(property);
    }

    public void open() {
    }

    public void close() {
    }

    public InterpreterResult interpret(String st, InterpreterContext context) {
        try {
            Thread.sleep(Long.parseLong(st));
            return new InterpreterResult(InterpreterResult.Code.SUCCESS);
        }
        catch (Exception e) {
            return new InterpreterResult(InterpreterResult.Code.ERROR, e.getMessage());
        }
    }

    public void cancel(InterpreterContext context) {
    }

    public Interpreter.FormType getFormType() {
        return Interpreter.FormType.NATIVE;
    }

    public Scheduler getScheduler() {
        if (Boolean.parseBoolean(this.getProperty("zeppelin.SleepInterpreter.parallel", "false"))) {
            return SchedulerFactory.singleton().createOrGetParallelScheduler("Parallel-" + SleepInterpreter.class.getName(), 10);
        }
        return super.getScheduler();
    }

    public int getProgress(InterpreterContext context) {
        return 0;
    }
}

