/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.install;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.interpreter.install.InstallInterpreter;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class InstallInterpreterTest {
    private File tmpDir;
    private InstallInterpreter installer;
    private File interpreterBaseDir;

    @BeforeEach
    public void setUp() throws IOException {
        this.tmpDir = new File(System.getProperty("java.io.tmpdir") + "/ZeppelinLTest_" + System.currentTimeMillis());
        new File(this.tmpDir, "conf").mkdirs();
        this.interpreterBaseDir = new File(this.tmpDir, "interpreter");
        File localRepoDir = new File(this.tmpDir, "local-repo");
        this.interpreterBaseDir.mkdir();
        localRepoDir.mkdir();
        File interpreterListFile = new File(this.tmpDir, "conf/interpreter-list");
        System.setProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_HOME.getVarName(), this.tmpDir.getAbsolutePath());
        String interpreterList = "";
        interpreterList = interpreterList + "intp1   org.apache.commons:commons-csv:1.1   test interpreter 1\n";
        interpreterList = interpreterList + "intp2   org.apache.commons:commons-math3:3.6.1 test interpreter 2\n";
        FileUtils.writeStringToFile((File)new File(this.tmpDir, "conf/interpreter-list"), (String)interpreterList, (Charset)StandardCharsets.UTF_8);
        this.installer = new InstallInterpreter(interpreterListFile, this.interpreterBaseDir, localRepoDir.getAbsolutePath());
    }

    @AfterEach
    public void tearDown() throws IOException {
        FileUtils.deleteDirectory((File)this.tmpDir);
    }

    @Test
    public void testList() {
        Assertions.assertEquals((int)2, (int)this.installer.list().size());
    }

    @Test
    public void install() {
        Assertions.assertEquals((int)0, (int)this.interpreterBaseDir.listFiles().length);
        this.installer.install("intp1");
        Assertions.assertTrue((boolean)new File(this.interpreterBaseDir, "intp1").isDirectory());
    }

    @Test
    public void installAll() {
        this.installer.installAll();
        Assertions.assertTrue((boolean)new File(this.interpreterBaseDir, "intp1").isDirectory());
        Assertions.assertTrue((boolean)new File(this.interpreterBaseDir, "intp2").isDirectory());
    }
}

