/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.integration;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.interpreter.integration.SemanticVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadUtils {
    private static Logger LOGGER = LoggerFactory.getLogger(DownloadUtils.class);
    private static String downloadFolder = System.getProperty("user.home") + "/.cache";

    public static String downloadSpark(String sparkVersion, String hadoopVersion) {
        String sparkDownloadFolder = downloadFolder + "/spark";
        File targetSparkHomeFolder = new File(sparkDownloadFolder + "/spark-" + sparkVersion + "-bin-hadoop" + hadoopVersion);
        if (targetSparkHomeFolder.exists()) {
            LOGGER.info("Skip to download spark as it is already downloaded.");
            return targetSparkHomeFolder.getAbsolutePath();
        }
        DownloadUtils.download("spark", sparkVersion, "-bin-hadoop" + hadoopVersion + ".tgz");
        return targetSparkHomeFolder.getAbsolutePath();
    }

    public static String downloadFlink(String flinkVersion, String scalaVersion) {
        String flinkDownloadFolder = downloadFolder + "/flink";
        File targetFlinkHomeFolder = new File(flinkDownloadFolder + "/flink-" + flinkVersion);
        if (targetFlinkHomeFolder.exists()) {
            LOGGER.info("Skip to download flink as it is already downloaded.");
            return targetFlinkHomeFolder.getAbsolutePath();
        }
        DownloadUtils.download("flink", flinkVersion, "-bin-scala_" + scalaVersion + ".tgz");
        try {
            DownloadUtils.runShellCommand(new String[]{"wget", "https://repo1.maven.org/maven2/org/apache/flink/flink-connector-hive_" + scalaVersion + "/" + flinkVersion + "/flink-connector-hive_" + scalaVersion + "-" + flinkVersion + ".jar", "-P", targetFlinkHomeFolder + "/lib"});
            DownloadUtils.runShellCommand(new String[]{"wget", "https://repo1.maven.org/maven2/org/apache/flink/flink-hadoop-compatibility_" + scalaVersion + "/" + flinkVersion + "/flink-hadoop-compatibility_" + scalaVersion + "-" + flinkVersion + ".jar", "-P", targetFlinkHomeFolder + "/lib"});
            DownloadUtils.runShellCommand(new String[]{"wget", "https://repo1.maven.org/maven2/org/apache/hive/hive-exec/2.3.4/hive-exec-2.3.4.jar", "-P", targetFlinkHomeFolder + "/lib"});
            DownloadUtils.runShellCommand(new String[]{"wget", "https://repo1.maven.org/maven2/org/apache/flink/flink-shaded-hadoop2-uber/2.7.5-1.8.1/flink-shaded-hadoop2-uber-2.7.5-1.8.1.jar", "-P", targetFlinkHomeFolder + "/lib"});
            DownloadUtils.runShellCommand(new String[]{"wget", "https://repo1.maven.org/maven2/org/apache/flink/flink-table-api-scala_" + scalaVersion + "/" + flinkVersion + "/flink-table-api-scala_" + scalaVersion + "-" + flinkVersion + ".jar", "-P", targetFlinkHomeFolder + "/lib"});
            DownloadUtils.runShellCommand(new String[]{"wget", "https://repo1.maven.org/maven2/org/apache/flink/flink-table-api-scala-bridge_" + scalaVersion + "/" + flinkVersion + "/flink-table-api-scala-bridge_" + scalaVersion + "-" + flinkVersion + ".jar", "-P", targetFlinkHomeFolder + "/lib"});
            DownloadUtils.runShellCommand(new String[]{"mv", targetFlinkHomeFolder + "/opt/flink-table-planner_" + scalaVersion + "-" + flinkVersion + ".jar", targetFlinkHomeFolder + "/lib"});
            DownloadUtils.runShellCommand(new String[]{"mv", targetFlinkHomeFolder + "/lib/flink-table-planner-loader-" + flinkVersion + ".jar", targetFlinkHomeFolder + "/opt"});
            if (SemanticVersion.of(flinkVersion).equalsOrNewerThan(SemanticVersion.of("1.16.0"))) {
                DownloadUtils.runShellCommand(new String[]{"mv", targetFlinkHomeFolder + "/opt/flink-sql-client-" + flinkVersion + ".jar", targetFlinkHomeFolder + "/lib"});
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Fail to download jar", e);
        }
        return targetFlinkHomeFolder.getAbsolutePath();
    }

    public static String downloadHadoop(String version) {
        String hadoopDownloadFolder = downloadFolder + "/hadoop";
        File targetHadoopHomeFolder = new File(hadoopDownloadFolder + "/hadoop-" + version);
        if (targetHadoopHomeFolder.exists()) {
            LOGGER.info("Skip to download hadoop as it is already downloaded.");
            return targetHadoopHomeFolder.getAbsolutePath();
        }
        DownloadUtils.download("hadoop", version, ".tar.gz", "hadoop/core");
        return targetHadoopHomeFolder.getAbsolutePath();
    }

    private static void download(String project, String version, String postFix, String projectPath) {
        String projectDownloadFolder = downloadFolder + "/" + project;
        try {
            String preferredMirror = IOUtils.toString((URL)new URL("https://www.apache.org/dyn/closer.lua?preferred=true"), (Charset)StandardCharsets.UTF_8);
            File downloadFile = new File(projectDownloadFolder + "/" + project + "-" + version + postFix);
            String downloadURL = preferredMirror + "/" + projectPath + "/" + project + "-" + version + "/" + project + "-" + version + postFix;
            DownloadUtils.runShellCommand(new String[]{"wget", downloadURL, "-P", projectDownloadFolder});
            DownloadUtils.runShellCommand(new String[]{"tar", "-xvf", downloadFile.getAbsolutePath(), "-C", projectDownloadFolder});
        }
        catch (Exception e) {
            LOGGER.warn("Failed to download " + project + " from mirror site, fallback to use apache archive", (Throwable)e);
            File downloadFile = new File(projectDownloadFolder + "/" + project + "-" + version + postFix);
            String downloadURL = "https://archive.apache.org/dist/" + projectPath + "/" + project + "-" + version + "/" + project + "-" + version + postFix;
            try {
                DownloadUtils.runShellCommand(new String[]{"wget", downloadURL, "-P", projectDownloadFolder});
                DownloadUtils.runShellCommand(new String[]{"tar", "-xvf", downloadFile.getAbsolutePath(), "-C", projectDownloadFolder});
            }
            catch (Exception ex) {
                throw new RuntimeException("Fail to download " + project + " " + version, ex);
            }
        }
    }

    private static void download(String project, String version, String postFix) {
        DownloadUtils.download(project, version, postFix, project);
    }

    private static void runShellCommand(String[] commands) throws IOException, InterruptedException {
        LOGGER.info("Starting shell commands: " + StringUtils.join((Object[])commands, (String)" "));
        Process process = Runtime.getRuntime().exec(commands);
        StreamGobbler errorGobbler = new StreamGobbler(process.getErrorStream());
        StreamGobbler outputGobbler = new StreamGobbler(process.getInputStream());
        errorGobbler.start();
        outputGobbler.start();
        if (process.waitFor() != 0) {
            throw new IOException("Fail to run shell commands: " + StringUtils.join((Object[])commands, (String)" "));
        }
        LOGGER.info("Complete shell commands: " + StringUtils.join((Object[])commands, (String)" "));
    }

    static {
        try {
            FileUtils.forceMkdir((File)new File(downloadFolder));
        }
        catch (IOException e) {
            throw new RuntimeException("Fail to create download folder: " + downloadFolder, e);
        }
    }

    private static class StreamGobbler
    extends Thread {
        InputStream is;

        StreamGobbler(InputStream is) {
            this.is = is;
        }

        @Override
        public void run() {
            try {
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                long startTime = System.currentTimeMillis();
                while ((line = br.readLine()) != null) {
                    if (System.currentTimeMillis() - startTime <= 5000L) continue;
                    LOGGER.info(line);
                    startTime = System.currentTimeMillis();
                }
            }
            catch (IOException ioe) {
                LOGGER.warn("Fail to print shell output", (Throwable)ioe);
            }
        }
    }
}

