/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.integration;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SemanticVersion {
    private static final Logger LOG = LoggerFactory.getLogger(SemanticVersion.class);
    private final String versionString;
    private int version;
    private int majorVersion;
    private int minorVersion;
    private int patchVersion;

    public static SemanticVersion of(String versionString) {
        return new SemanticVersion(versionString);
    }

    private SemanticVersion(String versionString) {
        this.versionString = versionString;
        try {
            int pos = versionString.indexOf(45);
            String numberPart = versionString;
            if (pos > 0) {
                numberPart = versionString.substring(0, pos);
            }
            String[] versions = numberPart.split("\\.");
            this.majorVersion = Integer.parseInt(versions[0]);
            this.minorVersion = Integer.parseInt(versions[1]);
            this.patchVersion = Integer.parseInt(versions[2]);
            this.version = Integer.parseInt(String.format("%d%02d%02d", this.majorVersion, this.minorVersion, this.patchVersion));
        }
        catch (Exception e) {
            LOG.error("Can not recognize Spark version {}. Assume it's a future release", (Object)versionString, (Object)e);
            this.version = 99999;
        }
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int getPatchVersion() {
        return this.patchVersion;
    }

    public String toString() {
        return this.versionString;
    }

    public int hashCode() {
        return this.version;
    }

    public boolean equals(Object versionToCompare) {
        return versionToCompare instanceof SemanticVersion && this.version == ((SemanticVersion)versionToCompare).version;
    }

    public boolean newerThan(SemanticVersion versionToCompare) {
        return this.version > versionToCompare.version;
    }

    public boolean equalsOrNewerThan(SemanticVersion versionToCompare) {
        return this.version >= versionToCompare.version;
    }

    public boolean olderThan(SemanticVersion versionToCompare) {
        return this.version < versionToCompare.version;
    }

    public boolean equalsOrOlderThan(SemanticVersion versionToCompare) {
        return this.version <= versionToCompare.version;
    }
}

