/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.launcher;

import java.io.IOException;
import java.util.Properties;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.interpreter.InterpreterOption;
import org.apache.zeppelin.interpreter.launcher.InterpreterClient;
import org.apache.zeppelin.interpreter.launcher.InterpreterLaunchContext;
import org.apache.zeppelin.interpreter.launcher.StandardInterpreterLauncher;
import org.apache.zeppelin.interpreter.remote.ExecRemoteInterpreterProcess;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class StandardInterpreterLauncherTest {
    @BeforeEach
    public void setUp() {
        for (ZeppelinConfiguration.ConfVars confVar : ZeppelinConfiguration.ConfVars.values()) {
            System.clearProperty(confVar.getVarName());
        }
    }

    @Test
    public void testLauncher() throws IOException {
        ZeppelinConfiguration zConf = ZeppelinConfiguration.create();
        StandardInterpreterLauncher launcher = new StandardInterpreterLauncher(zConf, null);
        Properties properties = new Properties();
        properties.setProperty("ENV_1", "VALUE_1");
        properties.setProperty("property_1", "value_1");
        InterpreterOption option = new InterpreterOption();
        option.setUserImpersonate(true);
        InterpreterLaunchContext context = new InterpreterLaunchContext(properties, option, null, "user1", "intpGroupId", "groupId", "groupName", "name", 0, "host");
        InterpreterClient client = launcher.launch(context);
        Assertions.assertTrue((boolean)(client instanceof ExecRemoteInterpreterProcess));
        ExecRemoteInterpreterProcess interpreterProcess = (ExecRemoteInterpreterProcess)client;
        Assertions.assertEquals((Object)"name", (Object)interpreterProcess.getInterpreterSettingName());
        Assertions.assertEquals((Object)".//interpreter/groupName", (Object)interpreterProcess.getInterpreterDir());
        Assertions.assertEquals((Object)".//local-repo/groupId", (Object)interpreterProcess.getLocalRepoDir());
        Assertions.assertEquals((long)ZeppelinConfiguration.ConfVars.ZEPPELIN_INTERPRETER_CONNECT_TIMEOUT.getLongValue(), (long)interpreterProcess.getConnectTimeout());
        Assertions.assertEquals((Object)zConf.getInterpreterRemoteRunnerPath(), (Object)interpreterProcess.getInterpreterRunner());
        Assertions.assertTrue((interpreterProcess.getEnv().size() >= 2 ? 1 : 0) != 0);
        Assertions.assertEquals((Object)"VALUE_1", interpreterProcess.getEnv().get("ENV_1"));
        Assertions.assertTrue((boolean)interpreterProcess.getEnv().containsKey("INTERPRETER_GROUP_ID"));
        Assertions.assertEquals((Object)true, (Object)interpreterProcess.isUserImpersonated());
    }

    @Test
    public void testConnectTimeOut() throws IOException {
        ZeppelinConfiguration zConf = ZeppelinConfiguration.create();
        StandardInterpreterLauncher launcher = new StandardInterpreterLauncher(zConf, null);
        Properties properties = new Properties();
        properties.setProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_INTERPRETER_CONNECT_TIMEOUT.getVarName(), "10000");
        InterpreterOption option = new InterpreterOption();
        option.setUserImpersonate(true);
        InterpreterLaunchContext context = new InterpreterLaunchContext(properties, option, null, "user1", "intpGroupId", "groupId", "groupName", "name", 0, "host");
        InterpreterClient client = launcher.launch(context);
        Assertions.assertTrue((boolean)(client instanceof ExecRemoteInterpreterProcess));
        ExecRemoteInterpreterProcess interpreterProcess = (ExecRemoteInterpreterProcess)client;
        Assertions.assertEquals((Object)"name", (Object)interpreterProcess.getInterpreterSettingName());
        Assertions.assertEquals((Object)".//interpreter/groupName", (Object)interpreterProcess.getInterpreterDir());
        Assertions.assertEquals((Object)".//local-repo/groupId", (Object)interpreterProcess.getLocalRepoDir());
        Assertions.assertEquals((int)10000, (int)interpreterProcess.getConnectTimeout());
        Assertions.assertEquals((Object)zConf.getInterpreterRemoteRunnerPath(), (Object)interpreterProcess.getInterpreterRunner());
        Assertions.assertTrue((interpreterProcess.getEnv().size() >= 1 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)interpreterProcess.getEnv().containsKey("INTERPRETER_GROUP_ID"));
        Assertions.assertEquals((Object)true, (Object)interpreterProcess.isUserImpersonated());
    }
}

