/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.lifecycle;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.interpreter.AbstractInterpreterTest;
import org.apache.zeppelin.interpreter.ExecutionContext;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterSetting;
import org.apache.zeppelin.interpreter.lifecycle.TimeoutLifecycleManager;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreter;
import org.apache.zeppelin.scheduler.Job;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class TimeoutLifecycleManagerTest
extends AbstractInterpreterTest {
    private File zeppelinSiteFile = new File("zeppelin-site.xml");

    TimeoutLifecycleManagerTest() {
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        ZeppelinConfiguration zConf = ZeppelinConfiguration.create();
        zConf.setProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_INTERPRETER_LIFECYCLE_MANAGER_CLASS.getVarName(), TimeoutLifecycleManager.class.getName());
        zConf.setProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_INTERPRETER_LIFECYCLE_MANAGER_TIMEOUT_CHECK_INTERVAL.getVarName(), "1000");
        zConf.setProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_INTERPRETER_LIFECYCLE_MANAGER_TIMEOUT_THRESHOLD.getVarName(), "10s");
        super.setUp();
    }

    @Override
    @AfterEach
    public void tearDown() {
        this.zeppelinSiteFile.delete();
    }

    @Test
    void testTimeout_1() throws InterpreterException, InterruptedException, IOException {
        Assertions.assertTrue((boolean)(this.interpreterFactory.getInterpreter("test.echo", new ExecutionContext("user1", "note1", "test")) instanceof RemoteInterpreter));
        RemoteInterpreter remoteInterpreter = (RemoteInterpreter)this.interpreterFactory.getInterpreter("test.echo", new ExecutionContext("user1", "note1", "test"));
        Assertions.assertFalse((boolean)remoteInterpreter.isOpened());
        InterpreterSetting interpreterSetting = this.interpreterSettingManager.getInterpreterSettingByName("test");
        Assertions.assertEquals((int)1, (int)interpreterSetting.getAllInterpreterGroups().size());
        Thread.sleep(15000L);
        Assertions.assertEquals((int)1, (int)interpreterSetting.getAllInterpreterGroups().size());
        InterpreterContext context = InterpreterContext.builder().setNoteId("noteId").setParagraphId("paragraphId").build();
        remoteInterpreter.interpret("hello world", context);
        Assertions.assertTrue((boolean)remoteInterpreter.isOpened());
        Thread.sleep(15000L);
        Assertions.assertEquals((int)0, (int)interpreterSetting.getAllInterpreterGroups().size());
    }

    @Test
    void testTimeout_2() throws InterpreterException, InterruptedException, IOException {
        Assertions.assertTrue((boolean)(this.interpreterFactory.getInterpreter("test.sleep", new ExecutionContext("user1", "note1", "test")) instanceof RemoteInterpreter));
        final RemoteInterpreter remoteInterpreter = (RemoteInterpreter)this.interpreterFactory.getInterpreter("test.sleep", new ExecutionContext("user1", "note1", "test"));
        remoteInterpreter.getScheduler().submit((Job)new Job<Object>("test-job", null){

            public Object getReturn() {
                return null;
            }

            public int progress() {
                return 0;
            }

            public Map<String, Object> info() {
                return null;
            }

            protected Object jobRun() throws Throwable {
                InterpreterContext context = InterpreterContext.builder().setNoteId("noteId").setParagraphId("paragraphId").build();
                return remoteInterpreter.interpret("100000", context);
            }

            protected boolean jobAbort() {
                return false;
            }

            public void setResult(Object results) {
            }
        });
        while (!remoteInterpreter.isOpened()) {
            Thread.sleep(1000L);
            if (!remoteInterpreter.getOrCreateInterpreterProcess().isAlive()) {
                LOGGER.error("Interpreter already shut down");
                break;
            }
            LOGGER.info("Wait for interpreter to be started");
        }
        InterpreterSetting interpreterSetting = this.interpreterSettingManager.getInterpreterSettingByName("test");
        Assertions.assertEquals((int)1, (int)interpreterSetting.getAllInterpreterGroups().size());
        Thread.sleep(15000L);
        Assertions.assertEquals((int)1, (int)interpreterSetting.getAllInterpreterGroups().size());
        Assertions.assertTrue((boolean)remoteInterpreter.isOpened());
    }
}

