/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.recovery;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.interpreter.AbstractInterpreterTest;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterSetting;
import org.apache.zeppelin.interpreter.recovery.LocalRecoveryStorage;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreter;
import org.apache.zeppelin.user.AuthenticationInfo;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class LocalRecoveryStorageTest
extends AbstractInterpreterTest {
    private File recoveryDir = null;
    private String note1Id;
    private String note2Id;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        System.setProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_RECOVERY_STORAGE_CLASS.getVarName(), LocalRecoveryStorage.class.getName());
        this.recoveryDir = Files.createTempDir();
        System.setProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_RECOVERY_DIR.getVarName(), this.recoveryDir.getAbsolutePath());
        super.setUp();
        this.note1Id = this.notebook.createNote("/note_1", AuthenticationInfo.ANONYMOUS);
        this.note2Id = this.notebook.createNote("/note_2", AuthenticationInfo.ANONYMOUS);
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        super.tearDown();
        FileUtils.deleteDirectory((File)this.recoveryDir);
        System.clearProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_RECOVERY_STORAGE_CLASS.getVarName());
    }

    @Test
    public void testSingleInterpreterProcess() throws InterpreterException, IOException {
        InterpreterSetting interpreterSetting = this.interpreterSettingManager.getByName("test");
        interpreterSetting.getOption().setPerUser("shared");
        Interpreter interpreter1 = interpreterSetting.getDefaultInterpreter("user1", this.note1Id);
        RemoteInterpreter remoteInterpreter1 = (RemoteInterpreter)interpreter1;
        InterpreterContext context1 = InterpreterContext.builder().setNoteId("noteId").setParagraphId("paragraphId").build();
        remoteInterpreter1.interpret("hello", context1);
        Assertions.assertEquals((int)1, (int)this.interpreterSettingManager.getRecoveryStorage().restore().size());
        interpreterSetting.close();
        Assertions.assertEquals((int)0, (int)this.interpreterSettingManager.getRecoveryStorage().restore().size());
    }

    @Test
    public void testMultipleInterpreterProcess() throws InterpreterException, IOException {
        InterpreterSetting interpreterSetting = this.interpreterSettingManager.getByName("test");
        interpreterSetting.getOption().setPerUser("isolated");
        Interpreter interpreter1 = interpreterSetting.getDefaultInterpreter("user1", this.note1Id);
        RemoteInterpreter remoteInterpreter1 = (RemoteInterpreter)interpreter1;
        InterpreterContext context1 = InterpreterContext.builder().setNoteId("noteId").setParagraphId("paragraphId").build();
        remoteInterpreter1.interpret("hello", context1);
        Assertions.assertEquals((int)1, (int)this.interpreterSettingManager.getRecoveryStorage().restore().size());
        Interpreter interpreter2 = interpreterSetting.getDefaultInterpreter("user2", this.note2Id);
        RemoteInterpreter remoteInterpreter2 = (RemoteInterpreter)interpreter2;
        InterpreterContext context2 = InterpreterContext.builder().setNoteId("noteId").setParagraphId("paragraphId").build();
        remoteInterpreter2.interpret("hello", context2);
        Assertions.assertEquals((int)2, (int)this.interpreterSettingManager.getRecoveryStorage().restore().size());
        this.interpreterSettingManager.restart(interpreterSetting.getId(), "user1", this.note1Id);
        Assertions.assertEquals((int)1, (int)this.interpreterSettingManager.getRecoveryStorage().restore().size());
        interpreterSetting.close();
        Assertions.assertEquals((int)0, (int)this.interpreterSettingManager.getRecoveryStorage().restore().size());
    }
}

