/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.remote;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.zeppelin.display.AngularObject;
import org.apache.zeppelin.display.AngularObjectRegistry;
import org.apache.zeppelin.display.AngularObjectRegistryListener;
import org.apache.zeppelin.interpreter.AbstractInterpreterTest;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.InterpreterResultMessage;
import org.apache.zeppelin.interpreter.InterpreterSetting;
import org.apache.zeppelin.interpreter.remote.RemoteAngularObjectRegistry;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreter;
import org.apache.zeppelin.resource.LocalResourcePool;
import org.apache.zeppelin.resource.ResourcePool;
import org.apache.zeppelin.user.AuthenticationInfo;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class RemoteAngularObjectTest
extends AbstractInterpreterTest
implements AngularObjectRegistryListener {
    private RemoteInterpreter intp;
    private InterpreterContext context;
    private RemoteAngularObjectRegistry localRegistry;
    private InterpreterSetting interpreterSetting;
    private AtomicInteger onAdd;
    private AtomicInteger onUpdate;
    private AtomicInteger onRemove;
    private String note1Id;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.note1Id = this.notebook.createNote("/note_1", AuthenticationInfo.ANONYMOUS);
        this.onAdd = new AtomicInteger(0);
        this.onUpdate = new AtomicInteger(0);
        this.onRemove = new AtomicInteger(0);
        this.interpreterSetting = this.interpreterSettingManager.getInterpreterSettingByName("test");
        this.intp = (RemoteInterpreter)this.interpreterSetting.getInterpreter("user1", this.note1Id, "mock_ao");
        this.localRegistry = (RemoteAngularObjectRegistry)this.intp.getInterpreterGroup().getAngularObjectRegistry();
        this.context = InterpreterContext.builder().setNoteId("note").setParagraphId("id").setAngularObjectRegistry(new AngularObjectRegistry(this.intp.getInterpreterGroup().getId(), null)).setResourcePool((ResourcePool)new LocalResourcePool("pool1")).build();
        this.intp.open();
    }

    @Test
    public void testAngularObjectInterpreterSideCRUD() throws InterruptedException, InterpreterException {
        InterpreterResult ret = this.intp.interpret("get", this.context);
        Thread.sleep(500L);
        String[] result = ((InterpreterResultMessage)ret.message().get(0)).getData().split(" ");
        Assertions.assertEquals((Object)"0", (Object)result[0]);
        Assertions.assertEquals((Object)"0", (Object)result[1]);
        ret = this.intp.interpret("add n1 v1", this.context);
        Thread.sleep(500L);
        result = ((InterpreterResultMessage)ret.message().get(0)).getData().split(" ");
        Assertions.assertEquals((Object)"1", (Object)result[0]);
        Assertions.assertEquals((Object)"0", (Object)result[1]);
        Assertions.assertEquals((Object)"v1", (Object)this.localRegistry.get("n1", "note", null).get());
        ret = this.intp.interpret("update n1 v11", this.context);
        result = ((InterpreterResultMessage)ret.message().get(0)).getData().split(" ");
        Thread.sleep(500L);
        Assertions.assertEquals((Object)"1", (Object)result[0]);
        Assertions.assertEquals((Object)"1", (Object)result[1]);
        Assertions.assertEquals((Object)"v11", (Object)this.localRegistry.get("n1", "note", null).get());
        ret = this.intp.interpret("remove n1", this.context);
        result = ((InterpreterResultMessage)ret.message().get(0)).getData().split(" ");
        Thread.sleep(500L);
        Assertions.assertEquals((Object)"0", (Object)result[0]);
        Assertions.assertEquals((Object)"1", (Object)result[1]);
        Assertions.assertEquals(null, (Object)this.localRegistry.get("n1", "note", null));
    }

    @Test
    public void testAngularObjectRemovalOnZeppelinServerSide() throws InterruptedException, InterpreterException {
        InterpreterResult ret = this.intp.interpret("get", this.context);
        Thread.sleep(500L);
        String[] result = ((InterpreterResultMessage)ret.message().get(0)).getData().split(" ");
        Assertions.assertEquals((Object)"0", (Object)result[0]);
        ret = this.intp.interpret("add n1 v1", this.context);
        Thread.sleep(500L);
        result = ((InterpreterResultMessage)ret.message().get(0)).getData().split(" ");
        Assertions.assertEquals((Object)"1", (Object)result[0]);
        Assertions.assertEquals((Object)"v1", (Object)this.localRegistry.get("n1", "note", null).get());
        this.localRegistry.removeAndNotifyRemoteProcess("n1", "note", null);
        ret = this.intp.interpret("get", this.context);
        Thread.sleep(500L);
        result = ((InterpreterResultMessage)ret.message().get(0)).getData().split(" ");
        Assertions.assertEquals((Object)"0", (Object)result[0]);
    }

    @Test
    public void testAngularObjectAddOnZeppelinServerSide() throws InterruptedException, InterpreterException {
        InterpreterResult ret = this.intp.interpret("get", this.context);
        Thread.sleep(500L);
        String[] result = ((InterpreterResultMessage)ret.message().get(0)).getData().split(" ");
        Assertions.assertEquals((Object)"0", (Object)result[0]);
        this.localRegistry.addAndNotifyRemoteProcess("n1", (Object)"v1", "note", null);
        ret = this.intp.interpret("get", this.context);
        Thread.sleep(500L);
        result = ((InterpreterResultMessage)ret.message().get(0)).getData().split(" ");
        Assertions.assertEquals((Object)"1", (Object)result[0]);
    }

    public void onAddAngularObject(String interpreterGroupId, AngularObject angularObject) {
        this.onAdd.incrementAndGet();
    }

    public void onUpdateAngularObject(String interpreterGroupId, AngularObject angularObject) {
        this.onUpdate.incrementAndGet();
    }

    public void onRemoveAngularObject(String interpreterGroupId, AngularObject angularObject) {
        this.onRemove.incrementAndGet();
    }
}

