/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.remote;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.zeppelin.interpreter.AbstractInterpreterTest;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.InterpreterResultMessage;
import org.apache.zeppelin.interpreter.InterpreterSetting;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreter;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterProcessListener;
import org.apache.zeppelin.interpreter.thrift.ParagraphInfo;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class RemoteInterpreterOutputTestStream
extends AbstractInterpreterTest
implements RemoteInterpreterProcessListener {
    private InterpreterSetting interpreterSetting;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.interpreterSetting = this.interpreterSettingManager.get("test");
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        this.interpreterSetting.close();
    }

    private InterpreterContext createInterpreterContext() {
        return InterpreterContext.builder().setNoteId("noteId").setParagraphId("id").build();
    }

    @Test
    public void testInterpreterResultOnly() throws InterpreterException {
        RemoteInterpreter intp = (RemoteInterpreter)this.interpreterSetting.getInterpreter("user1", "note1", "mock_stream");
        InterpreterResult ret = intp.interpret("SUCCESS::staticresult", this.createInterpreterContext());
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)ret.code());
        Assertions.assertEquals((Object)"staticresult", (Object)((InterpreterResultMessage)ret.message().get(0)).getData());
        ret = intp.interpret("SUCCESS::staticresult2", this.createInterpreterContext());
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)ret.code());
        Assertions.assertEquals((Object)"staticresult2", (Object)((InterpreterResultMessage)ret.message().get(0)).getData());
        ret = intp.interpret("ERROR::staticresult3", this.createInterpreterContext());
        Assertions.assertEquals((Object)InterpreterResult.Code.ERROR, (Object)ret.code());
        Assertions.assertEquals((Object)"staticresult3", (Object)((InterpreterResultMessage)ret.message().get(0)).getData());
    }

    @Test
    public void testInterpreterOutputStreamOnly() throws InterpreterException {
        RemoteInterpreter intp = (RemoteInterpreter)this.interpreterSetting.getInterpreter("user1", "note1", "mock_stream");
        InterpreterResult ret = intp.interpret("SUCCESS:streamresult:", this.createInterpreterContext());
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)ret.code());
        Assertions.assertEquals((Object)"streamresult", (Object)((InterpreterResultMessage)ret.message().get(0)).getData());
        ret = intp.interpret("ERROR:streamresult2:", this.createInterpreterContext());
        Assertions.assertEquals((Object)InterpreterResult.Code.ERROR, (Object)ret.code());
        Assertions.assertEquals((Object)"streamresult2", (Object)((InterpreterResultMessage)ret.message().get(0)).getData());
    }

    @Test
    public void testInterpreterResultOutputStreamMixed() throws InterpreterException {
        RemoteInterpreter intp = (RemoteInterpreter)this.interpreterSetting.getInterpreter("user1", "note1", "mock_stream");
        InterpreterResult ret = intp.interpret("SUCCESS:stream:static", this.createInterpreterContext());
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)ret.code());
        Assertions.assertEquals((Object)"stream", (Object)((InterpreterResultMessage)ret.message().get(0)).getData());
        Assertions.assertEquals((Object)"static", (Object)((InterpreterResultMessage)ret.message().get(1)).getData());
    }

    @Test
    public void testOutputType() throws InterpreterException {
        RemoteInterpreter intp = (RemoteInterpreter)this.interpreterSetting.getInterpreter("user1", "note1", "mock_stream");
        InterpreterResult ret = intp.interpret("SUCCESS:%html hello:", this.createInterpreterContext());
        Assertions.assertEquals((Object)InterpreterResult.Type.HTML, (Object)((InterpreterResultMessage)ret.message().get(0)).getType());
        Assertions.assertEquals((Object)"hello", (Object)((InterpreterResultMessage)ret.message().get(0)).getData());
        ret = intp.interpret("SUCCESS:%html\nhello:", this.createInterpreterContext());
        Assertions.assertEquals((Object)InterpreterResult.Type.HTML, (Object)((InterpreterResultMessage)ret.message().get(0)).getType());
        Assertions.assertEquals((Object)"hello", (Object)((InterpreterResultMessage)ret.message().get(0)).getData());
        ret = intp.interpret("SUCCESS:%html hello:%angular world", this.createInterpreterContext());
        Assertions.assertEquals((Object)InterpreterResult.Type.HTML, (Object)((InterpreterResultMessage)ret.message().get(0)).getType());
        Assertions.assertEquals((Object)"hello", (Object)((InterpreterResultMessage)ret.message().get(0)).getData());
        Assertions.assertEquals((Object)InterpreterResult.Type.ANGULAR, (Object)((InterpreterResultMessage)ret.message().get(1)).getType());
        Assertions.assertEquals((Object)"world", (Object)((InterpreterResultMessage)ret.message().get(1)).getData());
    }

    public void onOutputAppend(String noteId, String paragraphId, int index, String output) {
    }

    public void onOutputUpdated(String noteId, String paragraphId, int index, InterpreterResult.Type type, String output) {
    }

    public void onOutputClear(String noteId, String paragraphId) {
    }

    public void runParagraphs(String noteId, List<Integer> paragraphIndices, List<String> paragraphIds, String curParagraphId) throws IOException {
    }

    public void onParaInfosReceived(String noteId, String paragraphId, String interpreterSettingId, Map<String, String> metaInfos) {
    }

    public List<ParagraphInfo> getParagraphList(String user, String noteId) {
        return null;
    }

    public void checkpointOutput(String noteId, String paragraphId) {
    }
}

